/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eModuleOp;
import cerent.cms.idl.Equipment.eProtectionState;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AlreadyLocked;
import cerent.cms.model.DuplexLocked;
import cerent.cms.model.DuplexUnlocked;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.InvalidState;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.ProtectActive;
import cerent.cms.model.ProtectFailedOrMissing;
import cerent.cms.model.ProtectLocked;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WorkingFailedOrMissing;
import cerent.cms.model.WorkingLocked;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.ObserverPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfMaintenancePane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.GridBagPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SmpXcCardPane
extends ObserverPane
implements ActionListener {
    protected JPanel cardPanel;
    protected JLabel xcAStateLB;
    protected JLabel xcBStateLB;
    protected JButton switchPB;
    protected JButton lockPB;
    protected JButton unlockPB;
    protected ModuleModel xcAModel;
    protected ModuleModel xcBModel;
    protected boolean userAuthorized;
    protected eProtectionState protState;
    protected IEntityTableModel entityTableModel = null;
    String SWITCH_FAILED = "Switch Failed";
    String LOCK_FAILED = "Lock Failed";
    String UNLOCK_FAILED = "Unlock Failed";
    private IPlatform pci = ((NodeModelDelegate)this.getUiModel().getNodeModel()).getPlatform();
    public static final SDebug db = new SDebug((KDebug)AbstractShelfMaintenancePane.db, "SmpXcCardPane");

    public SmpXcCardPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDataSourceControl(new InnerDsc());
        this.setDefaultPrivilegeLevel(SecurityLevel.MAINTENANCE);
        this.userAuthorized = this.isUserAuthorized();
    }

    private JPanel createCardPanel() {
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.setBorder(BorderFactory.createTitledBorder(this.pci.getXconCardName() + " Cards"));
        gridBagPanel.inset(5, 5);
        gridBagPanel.anchorEast();
        gridBagPanel.add(this.pci.getXconAName() + " State: ", 0, 0);
        gridBagPanel.anchorWest();
        this.xcAStateLB = new JLabel();
        gridBagPanel.addRemainder(this.xcAStateLB, 1, 0);
        gridBagPanel.anchorEast();
        gridBagPanel.add((Component)new JLabel(this.pci.getXconBName() + " State: ", 4), 0, 1);
        gridBagPanel.anchorWest();
        this.xcBStateLB = new JLabel();
        gridBagPanel.addRemainder(this.xcBStateLB, 1, 1);
        gridBagPanel.anchorCenter();
        this.switchPB = this.makeActionButton("Switch");
        gridBagPanel.add((Component)this.switchPB, 0, 2);
        gridBagPanel.add((Component)new JLabel(" "), 1, 2);
        this.lockPB = this.makeActionButton("Lock");
        gridBagPanel.add((Component)this.lockPB, 2, 2);
        this.unlockPB = this.makeActionButton("Unlock");
        gridBagPanel.add((Component)this.unlockPB, 3, 2);
        return gridBagPanel;
    }

    public void init() {
        if (db.on()) {
            db.println("init");
        }
        if (this.cardPanel == null) {
            this.setLayout(new BorderLayout());
            this.cardPanel = this.createCardPanel();
            JPanel jPanel = new JPanel(new FlowLayout(1, 5, 5));
            jPanel.add(this.cardPanel);
            this.add(jPanel, "North");
            this.add(Box.createVerticalGlue(), "Center");
            JPanel jPanel2 = new JPanel(new FlowLayout(2, 5, 5));
            jPanel2.add(new CSHelpButton(CSHelpConst.SmpXcCardPane));
            this.add(jPanel2, "South");
        }
        this.refresh();
        this.registerWithModels();
    }

    public void enteringPage() throws Exception {
        this.init();
        super.enteringPage();
    }

    public void leavingPage() throws Exception {
        this.unRegisterWithModels();
        super.leavingPage();
    }

    private JButton makeActionButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(this);
        jButton.setEnabled(this.userAuthorized);
        return jButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        eModuleOp eModuleOp2 = null;
        ModuleModel moduleModel = null;
        if (this.xcAModel != null && this.xcAModel.getState() == eEqState.ACTIVE) {
            moduleModel = this.xcAModel;
        } else if (this.xcBModel != null && this.xcBModel.getState() == eEqState.ACTIVE) {
            moduleModel = this.xcBModel;
        }
        if (!this.pci.hasXcProtection()) {
            return;
        }
        if (moduleModel == null) {
            if (this.xcAModel.getState() == eEqState.NOT_PRESENT && this.xcBModel.getState() == eEqState.NOT_PRESENT) {
                if (object == this.switchPB) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_XC_SWITCH_PARAM_1, (Object)this.pci.getXconCardName());
                } else if (object == this.lockPB) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_XC_PROVISION, (Object)this.pci.getXconCardName());
                } else if (object == this.unlockPB) {
                    moduleModel = this.xcAModel != null ? this.xcAModel : this.xcBModel;
                    eModuleOp2 = eModuleOp.UNLOCK_DUPLEX;
                }
            } else {
                moduleModel = this.xcAModel.getState() == eEqState.NOT_PRESENT || this.xcAModel.getState() == eEqState.DELETED ? this.xcAModel : this.xcBModel;
                eModuleOp2 = eModuleOp.UNLOCK_DUPLEX;
            }
        } else if (object == this.switchPB) {
            if (CerentDialog.yesNoDialog((Component)((Object)this), (String)"Are you sure?", (String)"Confirm Switch")) {
                eModuleOp2 = this.protState == eProtectionState.NORMAL ? eModuleOp.SWITCH_NORMAL : eModuleOp.CLEAR;
            }
        } else if (object == this.lockPB) {
            if (CerentDialog.yesNoDialog((Component)((Object)this), (String)("Locking the " + this.pci.getXconCardName() + " cards will lead to loss of traffic" + " if the active card fails or is" + " removed\n\nOK to continue?"), (String)"Confirm Lock")) {
                eModuleOp2 = eModuleOp.LOCK_DUPLEX;
            }
        } else if (object == this.unlockPB) {
            eModuleOp2 = eModuleOp.UNLOCK_DUPLEX;
        }
        if (eModuleOp2 != null) {
            try {
                moduleModel.doCommand(eModuleOp2);
            }
            catch (ProtectFailedOrMissing protectFailedOrMissing) {
                ErrorMsg.displayError((Component)((Object)this), EMC.EID_XC_FAIL_OR_MISSING_PARAM_2, "protect", this.pci.getXconCardName());
            }
            catch (WorkingFailedOrMissing workingFailedOrMissing) {
                ErrorMsg.displayError((Component)((Object)this), EMC.EID_XC_FAIL_OR_MISSING_PARAM_2, "working", this.pci.getXconCardName());
            }
            catch (AlreadyLocked alreadyLocked) {
                ErrorMsg.displayError((Component)((Object)this), EMC.EID_XC_LOCKED_PARAM_2, "module", "already ");
            }
            catch (ProtectLocked protectLocked) {
                ErrorMsg.displayError((Component)((Object)this), EMC.EID_XC_LOCKED_PARAM_2, "protect", "");
            }
            catch (WorkingLocked workingLocked) {
                ErrorMsg.displayError((Component)((Object)this), EMC.EID_XC_LOCKED_PARAM_2, "working", "");
            }
            catch (ProtectActive protectActive) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_XC_PROT_ACTIVE);
            }
            catch (InvalidState invalidState) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_XC_INVALID_STATE);
            }
            catch (DuplexLocked duplexLocked) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_XC_DUPLEX_STATE_PARAM_1, (Object)"");
            }
            catch (DuplexUnlocked duplexUnlocked) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_XC_DUPLEX_STATE_PARAM_1, (Object)"already un");
            }
            catch (ProvisionError provisionError) {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_XC_PROVISION);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_XC_INVALID_STATE);
            }
        }
    }

    void updateXcState(ModuleModel moduleModel, JLabel jLabel) {
        String string;
        if (moduleModel == null) {
            string = "(empty)";
        } else {
            TDMTerminology tDMTerminology = moduleModel.getNodeModel().getTDMTerminology();
            int n = moduleModel.getNodeModel().getFramingType();
            String string2 = ElementDefaults.eqStateToString(moduleModel.getState());
            if (this.protState == null) {
                this.protState = moduleModel.getProtectionState();
            }
            if (moduleModel instanceof OpticsModuleModel) {
                this.protState = eProtectionState.UPGRADING;
            }
            string = this.protState == eProtectionState.NORMAL ? string2 : (moduleModel instanceof OpticsModuleModel ? string2 : string2 + " [" + ElementDefaults.getAttributeMap(n, tDMTerminology).getAttributeForVal("protectionState", this.protState.value()).toString() + "]");
        }
        jLabel.setText(string);
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("Doing a refresh.");
        }
        this.requestRefresh(this, null);
    }

    public void destroy() {
        super.destroy();
    }

    protected void registerWithModels() {
        this.observeEntityModel(this.pci.getXconASlotIndex());
        this.observeEntityModel(this.pci.getXconBSlotIndex());
        this.xcAModel = (ModuleModel)this.observeEntityModel(this.pci.getXconAIndex());
        this.xcBModel = (ModuleModel)this.observeEntityModel(this.pci.getXconBIndex());
    }

    private IEntityModel observeEntityModel(int n) {
        IEntityModel iEntityModel;
        block4: {
            iEntityModel = null;
            if (this.entityTableModel == null) {
                this.entityTableModel = ((NodeModelDelegate)this.getUiModel()).getEntityTableModel();
            }
            try {
                iEntityModel = this.entityTableModel.getEntityModelByIndex(n);
                if (iEntityModel != null) {
                    this.getObservableManager().addObservable((Observable)iEntityModel);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block4;
                db.println("failed to find entity with index " + Integer.toHexString(n));
            }
        }
        return iEntityModel;
    }

    protected void unRegisterWithModels() {
        this.removeEMObservable(this.pci.getXconASlotIndex());
        this.removeEMObservable(this.pci.getXconBSlotIndex());
        this.removeEMObservable(this.pci.getXconAIndex());
        this.removeEMObservable(this.pci.getXconBIndex());
    }

    private void removeEMObservable(int n) {
        block4: {
            IEntityModel iEntityModel = null;
            if (this.entityTableModel == null) {
                return;
            }
            try {
                iEntityModel = this.entityTableModel.getEntityModelByIndex(n);
                if (iEntityModel != null) {
                    this.getObservableManager().removeObservable((Observable)iEntityModel);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block4;
                db.println("failed to find entity with index " + n);
            }
        }
    }

    private void resetObservableManager() {
        this.getObservableManager().reset();
    }

    private void setObservableManagerActive() {
        this.getObservableManager().setActive(true);
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        public void refreshFromModel() throws Exception {
            if (db.on()) {
                db.println("refreshFromModel");
            }
            SmpXcCardPane.this.resetObservableManager();
            SmpXcCardPane.this.registerWithModels();
            SmpXcCardPane.this.setObservableManagerActive();
            if (SmpXcCardPane.this.pci.hasXcProtection()) {
                SmpXcCardPane.this.protState = null;
                SmpXcCardPane.this.updateXcState(SmpXcCardPane.this.xcAModel, SmpXcCardPane.this.xcAStateLB);
                SmpXcCardPane.this.updateXcState(SmpXcCardPane.this.xcBModel, SmpXcCardPane.this.xcBStateLB);
                SmpXcCardPane.this.switchPB.setText("Switch");
                SmpXcCardPane.this.switchPB.setEnabled(false);
                SmpXcCardPane.this.lockPB.setEnabled(false);
                SmpXcCardPane.this.unlockPB.setEnabled(false);
                if (SmpXcCardPane.this.protState == eProtectionState.NORMAL) {
                    SmpXcCardPane.this.switchPB.setEnabled(SmpXcCardPane.this.userAuthorized);
                    SmpXcCardPane.this.lockPB.setEnabled(SmpXcCardPane.this.userAuthorized);
                } else if (SmpXcCardPane.this.protState == eProtectionState.LOCKED_DUPLEX) {
                    SmpXcCardPane.this.unlockPB.setEnabled(SmpXcCardPane.this.userAuthorized);
                } else if (SmpXcCardPane.this.protState == eProtectionState.SWITCHED) {
                    SmpXcCardPane.this.switchPB.setText("Clear");
                    SmpXcCardPane.this.switchPB.setEnabled(SmpXcCardPane.this.userAuthorized);
                }
            }
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)SmpXcCardPane.this), true);
            }
            return this.dscObservableManager;
        }
    }
}

