/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.model.InvalidData;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.shelf.SppSnmpPane;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.GridBagPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class SnmpAttrsPane
extends JPanel
implements ActionListener,
DocumentListener {
    private static final short IP_ADDR_LENGTH = 15;
    private static final short COMM_NAME_LENGTH = 15;
    private static final int SNMP_PORT_MIN = 1024;
    private static final int SNMP_PORT_MAX = 65535;
    private static final int SNMP_PORT_DEF = 162;
    private static final int SNMP_PORT_RELAY = 391;
    static final String DEFAULT_UDP_PORT = Integer.toString(162);
    static final String[] VERSION_STRINGS = new String[]{"SNMPv1", "SNMPv2"};
    static final String DEFAULT_TRAP_RATE = "0";
    private static final int MAX_PROXIES = 3;
    protected Proxy[] proxies;
    protected JTextField udpPortTF;
    protected JTextField trapRateTF;
    protected JComboBox versionCB;
    protected sIpAddr ipAddr;
    protected sIpAddr relayIpAddr;
    protected String commName;
    protected String relayCommName;
    protected int udpPort;
    protected short version;
    protected short trapRate;
    protected SppSnmpPane parent;
    protected SDebug db;
    protected IPlatform pci;

    protected SnmpAttrsPane(SDebug sDebug, String string, SppSnmpPane sppSnmpPane) {
        this.db = sDebug;
        if (sDebug.on()) {
            sDebug.println("<init>: start");
        }
        this.parent = sppSnmpPane;
        this.pci = sppSnmpPane.getNMD().getPlatform();
        this.add(this.createAttrsPanel());
        if (sDebug.on()) {
            sDebug.println("<init>: finish");
        }
    }

    public void destroy() {
        this.parent = null;
    }

    private Component createAttrsPanel() {
        GridBagPanel gridBagPanel = new GridBagPanel();
        int n = 0;
        gridBagPanel.fillHorizontal();
        gridBagPanel.inset(2, 0);
        gridBagPanel.add("IP Address", 1, n);
        gridBagPanel.add("Community", 2, n);
        ++n;
        if (this.hasProxyPanel()) {
            this.proxies = new Proxy[4];
            n = this.addProxyPanel(gridBagPanel, n);
        } else {
            this.proxies = new Proxy[1];
        }
        n = this.addDestPanel(gridBagPanel, n);
        return gridBagPanel;
    }

    private String proxyName(int n) {
        if (this.proxies.length > 1 && n != 3) {
            return "Relay " + (char)(65 + n);
        }
        return " the SNMP Trap Destination";
    }

    private Proxy createProxy(GridBagPanel gridBagPanel, String string, int n) {
        Proxy proxy = new Proxy();
        proxy.ipAddr = new FixedLengthField(15);
        proxy.ipAddr.setColumns(15);
        proxy.ipAddr.getDocument().addDocumentListener(this);
        proxy.commName = new FixedLengthField(32);
        proxy.commName.setColumns(15);
        proxy.commName.getDocument().addDocumentListener(this);
        gridBagPanel.add(string, 0, n);
        gridBagPanel.add((Component)proxy.ipAddr, 1, n);
        gridBagPanel.add((Component)proxy.commName, 2, n);
        return proxy;
    }

    private int addProxyPanel(GridBagPanel gridBagPanel, int n) {
        for (int i = 0; i < this.proxies.length - 1; ++i) {
            Proxy proxy;
            this.proxies[i] = proxy = this.createProxy(gridBagPanel, this.proxyName(i), n);
            ++n;
        }
        return n;
    }

    private int addDestPanel(GridBagPanel gridBagPanel, int n) {
        Proxy proxy = this.createProxy(gridBagPanel, "Destination", n);
        this.setDestination(proxy);
        gridBagPanel.inset(2, 6);
        gridBagPanel.add(new JSeparator(), 0, ++n, 3, 1);
        gridBagPanel.inset(2, 0);
        this.udpPortTF = new JTextField(DEFAULT_UDP_PORT, 5);
        this.udpPortTF.getDocument().addDocumentListener(this);
        this.versionCB = new JComboBox<String>(VERSION_STRINGS);
        this.versionCB.addActionListener(this);
        gridBagPanel.add("UDP Port", 0, ++n);
        gridBagPanel.add((Component)this.udpPortTF, 1, n);
        gridBagPanel.add((Component)this.versionCB, 2, n);
        ++n;
        if (this.pci.supportsMaxTrapsperSecond()) {
            this.trapRateTF = new JTextField(DEFAULT_TRAP_RATE, 5);
            this.trapRateTF.getDocument().addDocumentListener(this);
            gridBagPanel.add("Max Traps Per Second", 0, n);
            gridBagPanel.add((Component)this.trapRateTF, 1, n);
            ++n;
        }
        return n;
    }

    private void setDestination(Proxy proxy) {
        this.proxies[this.proxies.length - 1] = proxy;
    }

    protected Proxy getDestination() {
        return this.proxies[this.proxies.length - 1];
    }

    protected boolean isUserAuthorized(SecurityLevel securityLevel) {
        return AbstractPane.isUserAuthorized(this.parent.getNMD(), securityLevel);
    }

    protected void setComponentsEnabled(boolean bl) {
        boolean bl2 = this.isUserAuthorized(SecurityLevel.PROVISIONING);
        boolean bl3 = this.isUserAuthorized(SecurityLevel.SUPERUSER);
        Proxy proxy = this.getDestination();
        proxy.ipAddr.setEnabled(bl && bl2);
        proxy.commName.setEnabled(bl && bl2);
        this.udpPortTF.setEnabled(bl && bl2);
        this.versionCB.setEnabled(bl && bl2);
        if (this.pci.supportsMaxTrapsperSecond()) {
            this.trapRateTF.setEnabled(bl && bl2);
        }
        if (this.hasProxyPanel()) {
            boolean bl4 = this.parent.getNMD().allowSnmpProxy();
            for (int i = 0; i < this.proxies.length - 1; ++i) {
                proxy = this.proxies[i];
                proxy.ipAddr.setEnabled(bl && bl3 && bl4);
                proxy.commName.setEnabled(bl && bl3 && bl4);
            }
        }
    }

    public void validateFields() throws InvalidData {
        int n = this.proxies.length - 1;
        sIpAddr[] sIpAddrArray = new sIpAddr[this.proxies.length];
        int[] nArray = new int[this.proxies.length];
        int[] nArray2 = new int[this.proxies.length];
        String[] stringArray = new String[this.proxies.length];
        this.udpPort = Integer.parseInt(this.udpPortTF.getText());
        if (this.udpPort != 162 && this.udpPort != 391 && (this.udpPort < 1024 || this.udpPort > 65535)) {
            throw new InvalidData("The UDP Port must be 162, 391, or between 1024 and 65535.");
        }
        this.version = (short)(this.versionCB.getSelectedIndex() + 1);
        for (int i = 0; i < this.proxies.length; ++i) {
            Proxy proxy = this.proxies[i];
            sIpAddrArray[i] = this.validateIpAddr(i, proxy.ipAddr);
            if (i == n) {
                if (sIpAddrArray[i] == null) {
                    throw new InvalidData("The destination IP address must be provided.");
                }
                nArray[i] = this.udpPort;
                nArray2[i] = -1;
            } else {
                nArray[i] = -1;
                nArray2[i] = -1;
            }
            stringArray[i] = this.validateCommName(i, proxy.commName);
        }
        this.ipAddr = sIpAddrArray[n];
        this.commName = stringArray[n];
        this.trapRate = Short.parseShort(this.pci.supportsMaxTrapsperSecond() ? this.trapRateTF.getText() : DEFAULT_TRAP_RATE);
        this.relayIpAddr = this.makeRelayIpAddr(sIpAddrArray);
        this.relayCommName = this.makeRelayCommName(sIpAddrArray, nArray, nArray2, stringArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
    }

    public void removeUpdate(DocumentEvent documentEvent) {
    }

    protected void refresh() {
        this.parent.refresh();
    }

    private sIpAddr makeRelayIpAddr(sIpAddr[] sIpAddrArray) throws InvalidData {
        boolean bl = false;
        for (int i = 0; i < sIpAddrArray.length - 1; ++i) {
            if (sIpAddrArray[i] != null && bl) {
                throw new InvalidData("Relays must be provided in the order listed. \n Enter data for " + this.proxyName(i - 1) + " before entering data for " + this.proxyName(i) + ".");
            }
            if (sIpAddrArray[i] != null) continue;
            bl = true;
        }
        if (sIpAddrArray[0] != null) {
            return sIpAddrArray[0];
        }
        return sIpAddrArray[sIpAddrArray.length - 1];
    }

    protected String toString(sIpAddr sIpAddr2) {
        return InetUtil.makeDottedString(IpAddrFactory.getIIpAddr(sIpAddr2));
    }

    private String makeRelayCommName(sIpAddr[] sIpAddrArray, int[] nArray, int[] nArray2, String[] stringArray) throws InvalidData {
        int n = sIpAddrArray.length - 1;
        if (stringArray[n].equals("")) {
            throw new InvalidData("Destination requires a community name.");
        }
        String string = stringArray[n];
        sIpAddr sIpAddr2 = sIpAddrArray[n];
        int n2 = nArray[n];
        int n3 = nArray2[n];
        for (int i = n - 1; i >= 0; --i) {
            if (sIpAddrArray[i] == null) continue;
            if (stringArray[i].equals("")) {
                throw new InvalidData(this.proxyName(i) + " requires a community name.");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(stringArray[i]);
            stringBuffer.append('{');
            stringBuffer.append(this.toString(sIpAddr2));
            stringBuffer.append(',');
            if (n2 != -1) {
                stringBuffer.append(n2);
            }
            stringBuffer.append(',');
            if (n3 != -1) {
                stringBuffer.append(n3);
            }
            stringBuffer.append(',');
            stringBuffer.append(string);
            stringBuffer.append('}');
            string = stringBuffer.toString();
            sIpAddr2 = sIpAddrArray[i];
            n2 = nArray[i];
            n3 = nArray2[i];
        }
        if (this.db.on()) {
            this.db.println("RelayCommName = " + string);
        }
        return string;
    }

    private sIpAddr validateIpAddr(int n, JTextField jTextField) throws InvalidData {
        try {
            String string;
            sIpAddr sIpAddr2 = null;
            if (jTextField != null && !(string = jTextField.getText()).equals("")) {
                sIpAddr2 = IpAddrFactory.getIpAddr(InetUtil.makeIpAddr(jTextField.getText()));
            }
            return sIpAddr2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidData(" The IP address for " + this.proxyName(n) + " contains invalid characters.");
        }
    }

    private String validateCommName(int n, FixedLengthField fixedLengthField) throws InvalidData {
        String string = null;
        if (fixedLengthField != null) {
            string = fixedLengthField.getText();
            if (string.length() > 32) {
                throw new InvalidData("The community name  for " + this.proxyName(n) + " exceeds maximum length of " + 32 + " characters.");
            }
            if (string.indexOf(",") != -1 || string.indexOf("{") != -1 || string.indexOf("}") != -1) {
                throw new InvalidData("The community name for " + this.proxyName(n) + " cannot contain the" + " characters ',' , '{'  or '}'");
            }
        }
        return string;
    }

    private void parse(String string, Integer n, Integer n2, String string2, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4) {
        Locations locations = new Locations(string2);
        Integer n3 = n;
        n = new Integer(-1);
        while (locations.isValid()) {
            arrayList.add(string);
            arrayList2.add(n);
            arrayList3.add(n2);
            arrayList4.add(locations.getCommunity());
            string = locations.getIp();
            n = locations.getPort();
            n2 = locations.getVersion();
            string2 = locations.getRest();
            locations.reset(string2);
        }
        arrayList.add(string);
        arrayList2.add(n3);
        arrayList3.add(n2);
        arrayList4.add(string2);
    }

    protected void setProxyFields(String string, Integer n, Integer n2, String string2) {
        if (this.db.on()) {
            this.db.println("proxyIpAddress is " + string);
            this.db.println("proxyCommunity is " + string2);
        }
        this.clearProxyFields();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        this.parse(string, n, n2, string2, arrayList, arrayList2, arrayList3, arrayList4);
        if (this.db.on()) {
            this.db.println("ip(" + arrayList.size() + ")=" + arrayList);
            this.db.println("port(" + arrayList2.size() + ")=" + arrayList2);
            this.db.println("ver(" + arrayList3.size() + ")=" + arrayList3);
            this.db.println("comm(" + arrayList4.size() + ")=" + arrayList4);
        }
        int n3 = Math.min(arrayList.size(), this.proxies.length) - 1;
        for (int i = 0; i < n3; ++i) {
            Proxy proxy = this.proxies[i];
            proxy.ipAddr.setText((String)arrayList.get(i));
            proxy.commName.setText((String)arrayList4.get(i));
        }
    }

    protected void clearProxyFields() {
        for (int i = 0; i < this.proxies.length - 1; ++i) {
            Proxy proxy = this.proxies[i];
            proxy.ipAddr.setText("");
            proxy.commName.setText("");
        }
    }

    protected abstract boolean hasProxyPanel();

    private final class Locations {
        private boolean _valid;
        private String _community;
        private String _ip;
        private Integer _port;
        private Integer _version;
        private String _rest;

        Locations(String string) {
            this.reset(string);
        }

        private Integer parseInt(String string, int n, int n2, int n3) throws NumberFormatException {
            if (n2 > n + 1) {
                return Integer.valueOf(string.substring(n, n2));
            }
            return new Integer(n3);
        }

        private Integer parsePort(String string, int n, int n2) throws NumberFormatException {
            return this.parseInt(string, n, n2, -1);
        }

        private Integer parseVersion(String string, int n, int n2) throws NumberFormatException {
            return this.parseInt(string, n, n2, -1);
        }

        private void reset() {
            this._valid = false;
            this._community = null;
            this._ip = null;
            this._port = null;
            this._version = null;
            this._rest = null;
        }

        void reset(String string) {
            int n = string.indexOf(123);
            int n2 = string.indexOf(44, n + 1);
            int n3 = string.indexOf(44, n2 + 1);
            int n4 = string.indexOf(44, n3 + 1);
            int n5 = string.lastIndexOf(125);
            if (n5 <= n4 + 1) {
                n5 = -1;
            }
            this.reset();
            if (SnmpAttrsPane.this.db.on()) {
                this.dumpState(string, n, n2, n3, n4, n5);
            }
            if (n != -1 && n2 != -1 && n3 != -1 && n4 != -1 && n5 != -1) {
                try {
                    this._port = this.parsePort(string, n2 + 1, n3);
                    this._version = this.parseVersion(string, n3 + 1, n4);
                    this._community = string.substring(0, n);
                    this._ip = string.substring(n + 1, n2);
                    this._rest = string.substring(n4 + 1, n5);
                    this._valid = true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (SnmpAttrsPane.this.db.on()) {
                SnmpAttrsPane.this.db.println(this.toString());
            }
        }

        private void dumpState(String string, int n, int n2, int n3, int n4, int n5) {
            StringBuffer stringBuffer = new StringBuffer();
            int n6 = 0;
            SnmpAttrsPane.this.db.println(string);
            while (n6++ < n) {
                stringBuffer.append(' ');
            }
            stringBuffer.append('^');
            while (n6++ < n2) {
                stringBuffer.append(' ');
            }
            stringBuffer.append('^');
            while (n6++ < n3) {
                stringBuffer.append(' ');
            }
            stringBuffer.append('^');
            while (n6++ < n4) {
                stringBuffer.append(' ');
            }
            stringBuffer.append('^');
            while (n6++ < n5) {
                stringBuffer.append(' ');
            }
            stringBuffer.append('^');
            SnmpAttrsPane.this.db.println(stringBuffer.toString());
            SnmpAttrsPane.this.db.println("open=" + n + " ip=" + n2 + " port=" + n3 + " vers=" + n4 + " close=" + n5);
        }

        public String toString() {
            return "valid=" + this._valid + " community=" + this._community + " ip=" + this._ip + " port=" + this._port + " version=" + this._version + " rest=" + this._rest;
        }

        boolean isValid() {
            return this._valid;
        }

        String getCommunity() {
            return this._community;
        }

        String getIp() {
            return this._ip;
        }

        Integer getPort() {
            return this._port;
        }

        Integer getVersion() {
            return this._version;
        }

        String getRest() {
            return this._rest;
        }
    }

    protected static final class Proxy {
        FixedLengthField ipAddr;
        FixedLengthField commName;

        protected Proxy() {
        }
    }
}

