/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Common.sRevertiveBehavior;
import cerent.cms.idl.Synchronization.eRef;
import cerent.cms.idl.Synchronization.eResQualityLevel;
import cerent.cms.idl.Synchronization.eSsmGen;
import cerent.cms.idl.Synchronization.eTimingMode;
import cerent.cms.idl.Synchronization.sSyncConfig;
import cerent.cms.model.Attribute;
import cerent.cms.model.CmsCommFailException;
import cerent.cms.model.IModel;
import cerent.cms.model.RevertiveBehaviorFactory;
import cerent.cms.model.SyncProvBusy;
import cerent.cms.ui.RevertiveBehaviorPanel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractSppTimingPane;
import cerent.util.SDebug;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SonetSppTimingPane
extends AbstractSppTimingPane
implements ActionListener {
    public SonetSppTimingPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    protected void init() {
        this.neRef = this.getSyncRef();
        super.init();
    }

    protected AbstractSppTimingPane.SyncRefs getSyncRef() {
        return new AbstractSppTimingPane.SyncRefs(eRef.NE);
    }

    private void updateFromConfig(sSyncConfig sSyncConfig2) throws Exception {
        if (db.on()) {
            db.println("\nconfig.timingMode = " + sSyncConfig2.timingMode.value() + "\nconfig.reversion.reversionMode = " + sSyncConfig2.reversion.reversionMode.value() + "\nconfig.reversion.reversionTime = " + sSyncConfig2.reversion.reversionTime + "\nconfig.ssmGeneration = " + sSyncConfig2.ssmGeneration.value() + "\nconfig.interpretResAs = " + sSyncConfig2.interpretResAs.value());
        }
        IModel iModel = this.getUiModel();
        this.modeCB.setSelectedItem(this.timingModeAttributeMap.get(new Integer(sSyncConfig2.timingMode.value())));
        this.syncRBP.setRevertiveBehavior(RevertiveBehaviorFactory.getIRevertiveBehavior(sSyncConfig2.reversion));
        if (this.generationCB != null) {
            int n = sSyncConfig2.interpretResAs.value();
            if (sSyncConfig2.ssmGeneration == eSsmGen.GENERATION_1) {
                this.generationCB.setSelectedIndex(0);
                generation = 1;
                if (n <= eResQualityLevel.aboveST2.value()) {
                    this.resAsCB.setSelectedIndex(sSyncConfig2.interpretResAs.value());
                } else if (n == eResQualityLevel.aboveTNC.value() || n == eResQualityLevel.aboveST3E.value()) {
                    this.resAsCB.setSelectedIndex(eResQualityLevel.aboveST3.value());
                } else {
                    this.resAsCB.setSelectedIndex(n - 2);
                }
            } else {
                this.generationCB.setSelectedIndex(1);
                generation = 2;
                this.resAsCB.setSelectedIndex(n);
            }
        }
        this.neRef.refreshFromModel();
        if (this.pci.getNumberOfTimingOutRef() > 1) {
            this.ext1Ref.refreshFromModel();
        }
        if (this.pci.getNumberOfTimingOutRef() > 2) {
            this.ext2Ref.refreshFromModel();
        }
    }

    public void refreshFromModel() throws Exception {
        if (this.applyingChanges()) {
            if (db.on()) {
                db.println("ASSTP skipped refresh while applying changes");
            }
        } else {
            block7: {
                if (db.on()) {
                    db.println("enter ASSTP.refreshFromModel");
                }
                try {
                    this.updateFromConfig(this.syncModel.getConfig());
                }
                catch (CmsCommFailException cmsCommFailException) {
                    if (!db.on()) break block7;
                    db.println("CommFailure refreshing pane: " + (Object)((Object)cmsCommFailException));
                    SDebug.printStackTrace((Throwable)((Object)cmsCommFailException));
                }
            }
            if (db.on()) {
                db.println("leave ASSTP.refreshFromModel");
            }
        }
    }

    public JPanel createGeneralTimingBox() {
        IModel iModel = this.getUiModel();
        JPanel jPanel = SonetSppTimingPane.createVerticalPanel("General Timing");
        JPanel jPanel2 = new JPanel(null);
        jPanel2.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel2.add(new JLabel("Timing Mode: "));
        Attribute[] attributeArray = this.timingModeAttributeMap.values().toArray(new Attribute[0]);
        this.modeCB = new JComboBox<Attribute>(attributeArray);
        jPanel2.add(this.modeCB);
        this.modeCB.setName("Mode");
        this.enableComponent(this.modeCB);
        this.modeCB.addActionListener(this);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(null);
        jPanel2.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel2.add(new JLabel("SSM Message Set: "));
        this.generationCB = new JComboBox<String>(generationChoices);
        jPanel2.add(this.generationCB);
        this.generationCB.setName("Generation");
        this.enableComponent(this.generationCB);
        this.generationCB.addActionListener(this);
        jPanel2.add(new JLabel("Quality of RES: "));
        this.resAsCB = new JComboBox<String>(g1ResAsChoices);
        jPanel2.add(this.resAsCB);
        this.resAsCB.setName("RES");
        this.enableComponent(this.resAsCB);
        this.resAsCB.addActionListener(this);
        jPanel.add(jPanel2);
        if (this.pci.is600()) {
            this.syncRBP = new RevertiveBehaviorPanel(this, true);
            jPanel.add(this.syncRBP);
        } else {
            this.syncRBP = new RevertiveBehaviorPanel(this);
            jPanel.add(this.syncRBP);
        }
        this.enableComponent(this.syncRBP);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.modeCB) {
            this.timingMode = eTimingMode.from_int(((Attribute)this.modeCB.getSelectedItem()).getIntValue());
            this.neRef.updateRefCBs();
            if (this.pci.getNumberOfTimingOutRef() > 1) {
                this.ext1Ref.updateRefCBs();
            }
            if (this.pci.getNumberOfTimingOutRef() > 2) {
                this.ext2Ref.updateRefCBs();
            }
        } else if (object == this.generationCB) {
            if (this.generationCB.getSelectedIndex() == 0) {
                generation = 1;
                this.resAsCB.removeAllItems();
                for (int i = 0; i < g1ResAsChoices.length; ++i) {
                    this.resAsCB.addItem(g1ResAsChoices[i]);
                }
                this.resAsCB.setSelectedIndex(g1ResAsChoices.length - 1);
            } else {
                generation = 2;
                this.resAsCB.removeAllItems();
                for (int i = 0; i < g2ResAsChoices.length; ++i) {
                    this.resAsCB.addItem(g2ResAsChoices[i]);
                }
                this.resAsCB.setSelectedIndex(g2ResAsChoices.length - 1);
            }
        }
        this.setDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void applyChangesToModel() throws Exception {
        if (db.on()) {
            db.println("enter ASSTP.applyChangesToModel");
        }
        this.startApplyingChanges();
        sSyncConfig sSyncConfig2 = new sSyncConfig();
        sSyncConfig sSyncConfig3 = new sSyncConfig();
        sSyncConfig2.timingMode = this.timingMode;
        if (sSyncConfig2.reversion == null) {
            sSyncConfig2.reversion = new sRevertiveBehavior();
        }
        sSyncConfig3 = this.syncModel.getConfig();
        if (sSyncConfig3.reversion.reversionTime == 0 && this.syncRBP.getRevertiveBehavior().getReversionTime() != 0 && !this.syncRBP.RevertiveDialog()) {
            throw new Exception("Apply canceled by user");
        }
        sSyncConfig2.reversion = RevertiveBehaviorFactory.getRevertiveBehavior(this.syncRBP.getRevertiveBehavior());
        if (this.generationCB != null) {
            int n = this.resAsCB.getSelectedIndex();
            if (this.generationCB.getSelectedIndex() == 0) {
                generation = 1;
                sSyncConfig2.ssmGeneration = eSsmGen.GENERATION_1;
                sSyncConfig2.interpretResAs = g1ResAsQuality[n];
            } else {
                generation = 2;
                sSyncConfig2.ssmGeneration = eSsmGen.GENERATION_2;
                sSyncConfig2.interpretResAs = g2ResAsQuality[n];
            }
        }
        if (db.on()) {
            db.println("config.timingMode = " + sSyncConfig2.timingMode.value() + "\n" + "config.reversion.reversionMode = " + sSyncConfig2.reversion.reversionMode.value() + "\n" + "config.reversion.reversionTime = " + sSyncConfig2.reversion.reversionTime + "\n" + "config.ssmGeneration = " + sSyncConfig2.ssmGeneration.value() + "\n" + "config.interpretResAs = " + sSyncConfig2.interpretResAs.value());
        }
        try {
            block15: {
                try {
                    this.syncModel.setConfig(sSyncConfig2);
                    this.neRef.setRefSources();
                    if (this.pci.getNumberOfTimingOutRef() > 1) {
                        this.ext1Ref.setRefSources();
                    }
                    if (this.pci.getNumberOfTimingOutRef() <= 2) break block15;
                    this.ext2Ref.setRefSources();
                }
                catch (SyncProvBusy syncProvBusy) {
                    this.displayErrorDialog();
                    this.refreshFromModel();
                    Object var5_6 = null;
                    if (this.stopApplyingChanges()) {
                        this.refreshFromModel();
                    }
                    if (!db.on()) return;
                    db.println("leave applyChangesToModel");
                    return;
                }
            }
            Object var5_5 = null;
            if (this.stopApplyingChanges()) {
                this.refreshFromModel();
            }
            if (!db.on()) return;
            db.println("leave applyChangesToModel");
            return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (this.stopApplyingChanges()) {
                this.refreshFromModel();
            }
            if (!db.on()) throw throwable;
            db.println("leave applyChangesToModel");
            throw throwable;
        }
    }

    public void destroy() {
        if (this.syncRBP != null) {
            this.syncRBP.removeActionListener();
            this.syncRBP = null;
        }
        super.destroy();
    }
}

