/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.Attribute;
import cerent.cms.model.DhcpProvisioned;
import cerent.cms.model.Feature;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IIpConfig;
import cerent.cms.model.ISecureIpConfig;
import cerent.cms.model.InvalidMask;
import cerent.cms.model.IpConfigError;
import cerent.cms.model.LanOSPFProvisioned;
import cerent.cms.model.LcdIpSetting;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.ProxyPortError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.StandbyTccNotReady;
import cerent.cms.model.SubnetsDifferent;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.IGuestPaneFactory;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.cms.ui.shelf.IpAddrPanel;
import cerent.cms.ui.shelf.ProxySettingsPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IntegerDocument;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SppNetworkGeneralPane
extends NodeProvPane
implements ActionListener,
PropertyChangeListener,
DocumentListener {
    protected static final int IIOP_DEFAULT_PORT = 57790;
    private static final Dimension ROW_SIZE = new Dimension(TabbedView.TABBED_VIEW_DIM.width - 200, 25);
    private JTextField dhcpTF = null;
    private int iiopPortVal;
    private JCheckBox useDhcpCB = null;
    private boolean mustReboot = false;
    private IpAddrPanel ipAddrPanel;
    private ProxySettingsPane proxyPanel;
    private int proxyPortVal = 0;
    private JLabel proxyStatusLabel;
    private boolean proxyIsDirty = false;
    private JRadioButton tccPortRB;
    private JRadioButton omgPortRB;
    private JRadioButton customPortRB;
    private JTextField customPortTF;
    private static final Attribute[] LCD_IP_SETTING_ATTRS = new Attribute[LcdIpSetting.LCD_IP_SETTING.length];
    protected static final SDebug db;

    public SppNetworkGeneralPane(String string, TabbedView tabbedView, IGuestPaneFactory iGuestPaneFactory) {
        super(string, tabbedView);
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SppNetworkGeneralPane;
    }

    private void init() {
        if (db.on()) {
            db.println("init: start");
        }
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
        JPanel jPanel = new JPanel();
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        uScrollPane.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
        this.add((Component)uScrollPane);
        Dimension dimension = new Dimension(SppNetworkGeneralPane.ROW_SIZE.width, 280);
        jPanel.setPreferredSize(dimension);
        jPanel.setMaximumSize(dimension);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = SppNetworkGeneralPane.createHorizontalPanel(null);
        this.ipAddrPanel = new IpAddrPanel(this, true);
        this.ipAddrPanel.setAlignmentX(0.0f);
        jPanel2.add(this.ipAddrPanel);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel2 = SppNetworkGeneralPane.createHorizontalPanel(null);
        this.getDhcpPanel(jPanel2);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel2 = SppNetworkGeneralPane.createHorizontalPanel(null);
        jPanel2.add(this.createIiopPanel(this.pci.getControlCardName()));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.createProxyPanel());
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        this.registerWithModel();
        if (db.on()) {
            db.println("init: finish");
        }
    }

    private ProxySettingsPane createProxyPanel() {
        if (db.on()) {
            db.println("Adding Proxy Panel");
        }
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        this.proxyPanel = new ProxySettingsPane(this, this.isUserAuthorized());
        this.proxyPanel.init(nodeModelDelegate);
        return this.proxyPanel;
    }

    private JPanel getDhcpPanel(JPanel jPanel) {
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        this.useDhcpCB = new JCheckBox("Forward DHCP Requests to:");
        jPanel.add(this.useDhcpCB);
        this.useDhcpCB.addActionListener(this);
        this.useDhcpCB.setEnabled(this.isUserAuthorized());
        this.dhcpTF = this.addTextPanel(jPanel, null, 13, new DhcpDocListener());
        return jPanel;
    }

    private JPanel createIiopPanel(String string) {
        if (db.on()) {
            db.println("Adding " + string + " IIOP listener port pane");
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new TitledBorder(string + " CORBA (IIOP) Listener Port"));
        jPanel.setPreferredSize(new Dimension(SppNetworkGeneralPane.ROW_SIZE.width / 2 - 40, 80));
        ButtonGroup buttonGroup = new ButtonGroup();
        boolean bl = this.isUserAuthorized();
        this.tccPortRB = this.addRadioButton(jPanel, buttonGroup, "Default - " + string + " Fixed", bl, this);
        this.omgPortRB = this.addRadioButton(jPanel, buttonGroup, "Standard Constant (683)", bl, this);
        this.customPortRB = this.addRadioButton(jPanel, buttonGroup, "Other Constant:", bl, this);
        this.customPortTF = new JTextField(6);
        this.customPortTF.setEnabled(bl);
        this.customPortTF.setDocument(new IntegerDocument(0, 65535, 5));
        this.customPortTF.getDocument().addDocumentListener(this);
        int n = jPanel.getComponentCount() - 1;
        JPanel jPanel2 = (JPanel)jPanel.getComponent(n);
        jPanel2.add(this.customPortTF);
        return jPanel;
    }

    private JTextField addTextPanel(JPanel jPanel, String string, int n, DocumentListener documentListener) {
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 0));
        if (string != null) {
            jPanel2.add(this.createLabel(string));
        }
        JTextField jTextField = new JTextField(n);
        jTextField.setMaximumSize(jTextField.getPreferredSize());
        jPanel2.add(jTextField);
        jPanel.add(jPanel2);
        if (this.isUserAuthorized()) {
            jTextField.getDocument().addDocumentListener(documentListener);
        } else {
            jTextField.setEditable(false);
        }
        return jTextField;
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(100, 20));
        return jLabel;
    }

    private JCheckBox addCheckBox(JPanel jPanel, String string, boolean bl, ActionListener actionListener) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setAlignmentX(0.0f);
        jCheckBox.setEnabled(bl);
        jCheckBox.addActionListener(actionListener);
        jPanel.add(jCheckBox);
        return jCheckBox;
    }

    private JRadioButton addRadioButton(JPanel jPanel, ButtonGroup buttonGroup, String string, boolean bl, ActionListener actionListener) {
        JRadioButton jRadioButton = new JRadioButton(string);
        jRadioButton.setAlignmentX(0.0f);
        jRadioButton.setEnabled(bl);
        jRadioButton.addActionListener(actionListener);
        jRadioButton.setSize(new Dimension(80, 20));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 0));
        jPanel2.add(jRadioButton);
        jPanel.add(jPanel2);
        buttonGroup.add(jRadioButton);
        return jRadioButton;
    }

    protected void setDhcpWidgets(boolean bl) {
        if (db.on()) {
            db.println("called setDhcpWidgets with state " + bl);
        }
        this.dhcpTF.setEnabled(bl);
        this.useDhcpCB.setSelected(bl);
        if (!bl) {
            this.dhcpTF.setText("");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.useDhcpCB) {
            boolean bl = this.useDhcpCB.isSelected();
            if (db.on()) {
                db.println("itemStateChanged: DHCP=" + bl);
            }
            this.setDhcpWidgets(bl);
        } else if (object == this.tccPortRB || object == this.omgPortRB) {
            this.customPortTF.setEnabled(false);
            this.mustReboot = true;
        } else if (object == this.customPortRB) {
            this.customPortTF.setEnabled(true);
            this.mustReboot = true;
        }
        this.setDirty();
    }

    private void generalChanges(DocumentEvent documentEvent) {
        this.setDirty();
        if (this.customPortTF != null && documentEvent.getDocument() == this.customPortTF.getDocument()) {
            if (documentEvent.getType() != DocumentEvent.EventType.REMOVE) {
                this.customPortRB.setSelected(true);
            }
            this.mustReboot = true;
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.generalChanges(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.generalChanges(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.generalChanges(documentEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteringPage() throws Exception {
        try {
            this.setCursor(3);
            if (this.ipAddrPanel == null) {
                this.init();
            }
            super.enteringPage();
        }
        finally {
            this.setCursor(0);
        }
    }

    protected void validateIiopPort() throws Exception {
        if (this.tccPortRB.isSelected()) {
            this.iiopPortVal = 57790;
            return;
        }
        if (this.omgPortRB.isSelected()) {
            this.iiopPortVal = 683;
            return;
        }
        try {
            this.iiopPortVal = Integer.parseInt(this.customPortTF.getText());
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Invalid IIOP Port");
            }
            throw new IpConfigError("IIOP Listener Port must be in the range  [1 - 65535].");
        }
    }

    protected void setIiopPort() {
        if (this.iiopPortVal == 57790) {
            this.customPortTF.setText("");
            this.customPortTF.setEnabled(false);
            this.tccPortRB.setSelected(true);
        } else if (this.iiopPortVal == 683) {
            this.customPortTF.setText("");
            this.customPortTF.setEnabled(false);
            this.omgPortRB.setSelected(true);
        } else {
            this.customPortTF.setEnabled(true);
            this.customPortTF.setText(String.valueOf(this.iiopPortVal));
            this.customPortRB.setSelected(true);
        }
    }

    public boolean onValidate() {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        IIpConfig iIpConfig = nodeModelDelegate.getIpConfig();
        ISecureIpConfig iSecureIpConfig = nodeModelDelegate.getSecureIpConfig();
        if (this.ipAddrPanel.mustReboot()) {
            this.mustReboot = true;
        }
        try {
            if (this.mustReboot) {
                if (!nodeModelDelegate.isRestAllowed()) {
                    ErrorMsg.displayWarning((Component)((Object)this), (EID)EMC.WID_SOFTWARE_UPGRADE_DENIED);
                    return false;
                }
                if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)("Changing the network configuration will cause a reboot or\nprotection switch of the active " + this.pci.getControlCardName() + " and may lead to loss\n" + "of communication with the node.\n\n" + "Make the change anyway?"), (String)"Change Network Configuration?")) {
                    return false;
                }
            }
            this.ipAddrPanel.validatePanel();
            iIpConfig.setIpAddress(this.ipAddrPanel.getIpAddr());
            iIpConfig.setDefaultRouter(this.ipAddrPanel.getDefaultRouterAddr());
            iIpConfig.setNetMaskPrefixLength(this.ipAddrPanel.getNetmaskPrefixLength());
            if (this.tccPortRB != null) {
                this.validateIiopPort();
                iIpConfig.setIiopPort((short)this.iiopPortVal);
            }
            if (nodeModelDelegate.isSecureMode()) {
                InetUtil.validateIpConfig(iSecureIpConfig, iIpConfig, "Backplane LAN port ");
            } else {
                InetUtil.validateIpConfig(iIpConfig, "Host ");
            }
            if (!this.proxyPanel.validateProxySettings(nodeModelDelegate)) {
                return false;
            }
        }
        catch (IpConfigError ipConfigError) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_CONFIG_PARAM_1, (Object)ipConfigError.getMessage());
            return false;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_VALIDATION_ERROR);
            return false;
        }
        return true;
    }

    public void applyChangesToModel() throws IpConfigError, ProxyPortError, InvalidMask, SubnetsDifferent, DhcpProvisioned, LanOSPFProvisioned, StandbyTccNotReady, Exception {
        if (db.on()) {
            db.println("applyChangesToModel: start");
        }
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        IIpConfig iIpConfig = nodeModelDelegate.getIpConfig();
        ISecureIpConfig iSecureIpConfig = nodeModelDelegate.getSecureIpConfig();
        boolean bl = true;
        if (this.useDhcpCB != null) {
            if (this.useDhcpCB.isSelected()) {
                IIpAddr iIpAddr = InetUtil.makeIpAddr(this.dhcpTF.getText());
                nodeModelDelegate.setDhcpServerAddr(iIpAddr);
                if (db.on()) {
                    db.println("Setting DHCP to non-zero.");
                }
            } else {
                if (InetUtil.makeIpV4(nodeModelDelegate.getDhcpServerAddr()) != 0) {
                    if (db.on()) {
                        db.println("applyChangesToModel: clearing DHCP host");
                    }
                    nodeModelDelegate.setDhcpServerAddr(InetUtil.makeIpAddr(0));
                }
                if (db.on()) {
                    db.println("Setting DHCP zero value.");
                }
            }
        }
        if (nodeModelDelegate.provides(Feature.IDL_LCDIp)) {
            nodeModelDelegate.setLcdIpSetting(this.ipAddrPanel.getLcdIpSetting(), bl);
        }
        boolean bl2 = this.ipAddrPanel.getCtcIpSuppressed();
        if (nodeModelDelegate.getCtcIpDisplaySuppression(bl) != bl2) {
            nodeModelDelegate.setCtcIpDisplaySuppression(bl, bl2);
        }
        this.proxyPanel.applyChanges(nodeModelDelegate);
        iIpConfig.setDefaultRouter(this.ipAddrPanel.getDefaultRouterAddr());
        if (this.mustReboot) {
            iIpConfig.setIpAddress(this.ipAddrPanel.getIpAddr());
            try {
                iIpConfig.setNetMaskPrefixLength(this.ipAddrPanel.getNetmaskPrefixLength());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.tccPortRB != null) {
                iIpConfig.setIiopPort((short)this.iiopPortVal);
            }
        }
        try {
            if (nodeModelDelegate.getPlatform().isSecureModeSupported() && nodeModelDelegate.isSecureMode()) {
                nodeModelDelegate.setSecureIpConfig(iIpConfig, iSecureIpConfig);
            } else {
                nodeModelDelegate.setIpConfig(iIpConfig);
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("applyChangesToModel: Error setting IP address");
            }
            super.setDirty(false);
            throw new Exception(exception.getMessage());
        }
        if (db.on()) {
            db.println("applyChangesToModel: finish");
        }
    }

    public void refreshFromModel() {
        if (db.on()) {
            db.println("refreshFromModel: start");
        }
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        IIpConfig iIpConfig = nodeModelDelegate.getIpConfig();
        boolean bl = true;
        this.ipAddrPanel.setIpConfig(nodeModelDelegate, iIpConfig.getIpAddress(), iIpConfig.getDefaultRouter(), iIpConfig.getNetMaskPrefixLength());
        if (this.useDhcpCB != null) {
            int n = InetUtil.makeIpV4(nodeModelDelegate.getDhcpServerAddr());
            boolean bl2 = n != 0;
            this.useDhcpCB.setSelected(bl2);
            this.dhcpTF.setText(bl2 ? InetUtil.makeDottedString(n) : "");
            this.setDhcpWidgets(bl2);
        }
        if (this.tccPortRB != null) {
            this.iiopPortVal = iIpConfig.getIiopPort() & 0xFFFF;
            this.setIiopPort();
        }
        this.proxyPanel.refresh(nodeModelDelegate, true);
        this.mustReboot = false;
        if (db.on()) {
            db.println("refreshFromModel: finish");
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
        this.mustReboot = true;
    }

    static {
        for (int i = 0; i < LCD_IP_SETTING_ATTRS.length; ++i) {
            SppNetworkGeneralPane.LCD_IP_SETTING_ATTRS[i] = new Attribute(LcdIpSetting.LCD_IP_SETTING[i], i);
        }
        db = new SDebug((KDebug)AbstractShelfProvPane.db, "SppNetworkGeneralPane");
    }

    private class DhcpDocListener
    implements DocumentListener {
        private DhcpDocListener() {
        }

        protected void generalChanges(DocumentEvent documentEvent) {
            SppNetworkGeneralPane.this.setDirty();
            try {
                String string = documentEvent.getDocument().getText(0, documentEvent.getDocument().getEndPosition().getOffset()).trim();
                if (string.equals("0.0.0.0")) {
                    CerentDialog.infoDialog((Component)((Object)SppNetworkGeneralPane.this), (String)"Setting the DHCP forwarding address to 0.0.0.0 effectively disables DHCP forwarding.", (String)"DHCP Forwarding Will Be Disabled");
                    SppNetworkGeneralPane.this.setDhcpWidgets(false);
                }
            }
            catch (Exception exception) {
                db.println("Caught exception in generalChanges");
                SDebug.printStackTrace((Throwable)exception);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.generalChanges(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.generalChanges(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.generalChanges(documentEvent);
        }
    }
}

