/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractProvTablePane;
import cerent.cms.ui.AlarmProfileListCellRenderer;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.cms.ui.shelf.ShelfAlarmProfileTableCellRenderer;
import cerent.cms.ui.shelf.ShelfProvAlarmsTableModel;
import cerent.util.SDebug;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class SppProvAlarmsPane
extends AbstractProvTablePane {
    private static SDebug db = new SDebug("SppProvAlarmsPane");
    protected String[] profileNames;
    protected JComboBox profileComboBox = new JComboBox();
    protected JComboBox shelfProfileComboBox = new JComboBox();
    protected JCheckBox shelfSuppressBox = new JCheckBox("Suppress Alarms");
    protected ShelfProfileItemListener shelfListener;
    protected ShelfProfileItemListener suppressListener;
    protected ShelfComboBoxListener comboBoxListener;
    private boolean inited = false;

    protected synchronized void initializeCombobox() {
        if (this.dataModel == null || this.table == null || this.profileComboBox == null || this.shelfProfileComboBox == null) {
            db.println("NPE/s in initializeCombobox; the following are null:");
            db.println("\tdataModel? " + (this.dataModel == null) + "\t" + "table? " + (this.dataModel == null));
            db.println("\tprofileCB? " + (this.profileComboBox == null) + "\t" + "shelfProfileCB? " + (this.shelfProfileComboBox == null));
            return;
        }
        this.profileNames = ((ShelfProvAlarmsTableModel)this.dataModel).getProfileNames();
        this.table.editingCanceled(new ChangeEvent(this.table));
        this.profileComboBox.removeAllItems();
        this.removeListeners();
        this.shelfProfileComboBox.removeAllItems();
        for (int i = 0; i < this.profileNames.length; ++i) {
            this.profileComboBox.addItem(this.profileNames[i]);
            if (this.profileNames[i].equals("None") || this.profileNames[i].equals("Inherited")) continue;
            this.shelfProfileComboBox.addItem(this.profileNames[i]);
        }
        AlarmProfileListCellRenderer alarmProfileListCellRenderer = new AlarmProfileListCellRenderer("Node");
        this.profileComboBox.setRenderer(alarmProfileListCellRenderer);
        String string = ((ShelfProvAlarmsTableModel)this.dataModel).getShelfProfileName();
        if (db.on()) {
            db.println("setting selected profile to " + string);
        }
        if (string != null) {
            this.shelfProfileComboBox.setSelectedItem(string);
        }
        this.updateSuppressFlag();
        this.initializeListeners();
    }

    protected void removeListeners() {
        if (this.shelfListener != null) {
            this.shelfProfileComboBox.removeItemListener(this.shelfListener);
        }
        if (this.suppressListener != null) {
            this.shelfSuppressBox.removeItemListener(this.suppressListener);
        }
    }

    protected void initializeListeners() {
        this.shelfListener = new ShelfProfileItemListener();
        this.suppressListener = new ShelfProfileItemListener();
        this.shelfProfileComboBox.addItemListener(this.shelfListener);
        this.shelfSuppressBox.addItemListener(this.suppressListener);
    }

    public void updateSuppressFlag() {
        Boolean bl = ((ShelfProvAlarmsTableModel)this.dataModel).getShelfSuppressFlag();
        if (db.on()) {
            db.println("updateSuppressFlag: " + bl);
        }
        if (bl != null) {
            this.shelfSuppressBox.setSelected(bl);
        }
    }

    protected Attribute[] getAttributes(String string) {
        IModel iModel = this.getUiModel();
        return ElementDefaults.getAttributeMap(iModel).getAttributeArray(string);
    }

    protected void initShelfProfileEditor() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
        jPanel.add(new JLabel("Node Profile:"));
        jPanel.add(this.shelfProfileComboBox);
        jPanel.add(this.shelfSuppressBox);
        this.add(jPanel, "South");
    }

    SppProvAlarmsPane(String string, TabbedView tabbedView, INodeModel iNodeModel) {
        super(string, tabbedView, new ShelfProvAlarmsTableModel(true, iNodeModel), true);
    }

    private void init() {
        ((ShelfProvAlarmsTableModel)this.dataModel).init();
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
        this.enableComponent(this.shelfProfileComboBox);
        this.enableComponent(this.shelfSuppressBox);
        this.initializeCombobox();
        for (int i = 0; i < this.dataModel.getColumnCount(); ++i) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(i);
            if (i == 3) {
                tableColumn.setPreferredWidth(120);
                continue;
            }
            if (i != 2) continue;
            ShelfAlarmProfileTableCellRenderer shelfAlarmProfileTableCellRenderer = new ShelfAlarmProfileTableCellRenderer("Node");
            tableColumn.setCellRenderer(shelfAlarmProfileTableCellRenderer);
            tableColumn.setCellEditor(new DefaultCellEditor(this.profileComboBox));
            tableColumn.setPreferredWidth(175);
        }
        this.initShelfProfileEditor();
        this.comboBoxListener = new ShelfComboBoxListener();
        this.dataModel.addTableModelListener(this.comboBoxListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enteringPage() throws Exception {
        try {
            TableCellEditor tableCellEditor;
            String string;
            int n;
            if (this.uiToolkit != null) {
                this.uiToolkit.setCursor(3);
            }
            if (!this.inited) {
                if (db.on()) {
                    db.println("enteringPage for the first time, calling init");
                }
                this.init();
                this.inited = true;
            }
            super.enteringPage();
            if (db.on()) {
                for (n = 0; n < this.table.getColumnCount(); ++n) {
                    string = this.table.getColumnName(n);
                    tableCellEditor = this.table.getCellEditor(0, n);
                    db.println("before " + n + "\t" + string + "\t" + tableCellEditor.getClass().getName());
                }
            }
            TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
            if (db.on()) {
                for (n = 0; n < this.table.getColumnCount(); ++n) {
                    string = this.table.getColumnName(n);
                    tableCellEditor = this.table.getCellEditor(0, n);
                    db.println("after " + n + "\t" + string + "\t" + tableCellEditor.getClass().getName());
                }
            }
            Object var5_4 = null;
            if (this.uiToolkit == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.uiToolkit == null) throw throwable;
            this.uiToolkit.setCursor(0);
            throw throwable;
        }
        this.uiToolkit.setCursor(0);
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    public void destroy() {
        this.removeListeners();
        if (this.dataModel != null) {
            this.dataModel.removeTableModelListener(this.comboBoxListener);
        }
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SppProvAlarmsPane;
    }

    class ShelfProfileItemListener
    implements ItemListener {
        ShelfProfileItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Boolean bl;
            if (db.on()) {
                db.println("ShelfProfileItemListener.itemStateChanged");
            }
            String string = ((ShelfProvAlarmsTableModel)SppProvAlarmsPane.this.dataModel).getShelfProfileName();
            Boolean bl2 = ((ShelfProvAlarmsTableModel)SppProvAlarmsPane.this.dataModel).getShelfSuppressFlag();
            if (itemEvent.getSource() == SppProvAlarmsPane.this.shelfProfileComboBox) {
                String string2 = (String)SppProvAlarmsPane.this.shelfProfileComboBox.getSelectedItem();
                if (!string2.equals(string)) {
                    SppProvAlarmsPane.this.setDirty(true);
                    ((ShelfProvAlarmsTableModel)SppProvAlarmsPane.this.dataModel).triggerShelfProfileChanged(SppProvAlarmsPane.this.shelfProfileComboBox.getSelectedItem());
                }
            } else if (itemEvent.getSource() == SppProvAlarmsPane.this.shelfSuppressBox && !(bl = new Boolean(SppProvAlarmsPane.this.shelfSuppressBox.isSelected())).equals(bl2)) {
                SppProvAlarmsPane.this.setDirty(true);
                ((ShelfProvAlarmsTableModel)SppProvAlarmsPane.this.dataModel).triggerSuppressChanged(bl);
            }
        }
    }

    class ShelfComboBoxListener
    implements TableModelListener {
        ShelfComboBoxListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (db.on()) {
                db.println("ShelfComboBoxListener.tableChanged");
            }
            SppProvAlarmsPane.this.shelfProfileComboBox.setSelectedItem(((ShelfProvAlarmsTableModel)SppProvAlarmsPane.this.dataModel).getShelfProfileName());
            SppProvAlarmsPane.this.initializeCombobox();
            SppProvAlarmsPane.this.updateSuppressFlag();
        }
    }
}

