/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Security.NotAuthenticated;
import cerent.cms.idl.Security.eSecurityLevel;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.InvalidRange;
import cerent.cms.model.LANAccessMode;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SecurityModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.IntegerDocument;
import cerent.util.gui.SpinPropertyEditor;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SppSecurityAccessPane
extends NodeProvPane
implements ActionListener,
PropertyChangeListener,
DocumentListener {
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "SppSecurityAccessPane");
    private static final int PORT_LENGTH = 5;
    private boolean bInit;
    private JComboBox lanAccessCB;
    private SpinPropertyEditor restoreLanAccess;
    private JRadioButton enableTelnetRB;
    private JTextField telnetPortTF;
    private JButton useStandardTelnetB;
    private JRadioButton enableSshRB;
    private JCheckBox enforceShellPasswordCB;
    private JTextField sshPortTF;
    private ButtonGroup shellAccessBG;
    private JComboBox pmClearingCB;
    private SecurityModel secModel;
    private boolean lanAccessDirty = false;

    public SppSecurityAccessPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
    }

    public void destroy() {
        if (this.secModel != null) {
            this.secModel.deleteObserver((Observer)((Object)this));
            this.secModel = null;
        }
        super.destroy();
    }

    public boolean hasSubTabs() {
        return false;
    }

    public boolean onValidate() {
        boolean bl = true;
        if (this.lanAccessDirty && this.secModel.getLANAccess().transitionMayDisconnect((LANAccessMode)this.lanAccessCB.getSelectedItem()) && !CerentDialog.yesNoDialog((Component)((Object)this), (String)"Changing the LAN Access may lead to loss of communication with the node.\nMake the change anyway?", (String)"Change LAN Access Mode?")) {
            bl = false;
        }
        return bl;
    }

    public void applyChangesToModel() throws Exception {
        Object object;
        if (db.on()) {
            db.println("applyChangesToModel: start");
        }
        boolean bl = false;
        int n = this.getIntValue("LAN Access Restore", (String)this.restoreLanAccess.getValue());
        if (n != this.secModel.getLANAccessTimeout()) {
            this.secModel.setLANAccessTimeout(n);
        }
        if ((n = this.getIntValue("Telnet port", this.telnetPortTF.getText())) != this.secModel.getTelnetPort()) {
            this.secModel.setTelnetPort(n);
        }
        if (this.enableSshRB.isSelected() != this.secModel.isSshEnabled()) {
            this.secModel.setSshEnabled(this.enableSshRB.isSelected());
        }
        if (this.enforceShellPasswordCB.isSelected() != this.secModel.isEnforceShellPassword()) {
            if (this.enforceShellPasswordCB.isSelected()) {
                this.secModel.setEnforceShellPasswordOn();
            } else {
                object = CerentDialog.inputPasswordDialog((Component)((Object)this), (String)"Turn off enforce shell password, please enter the current shell password.", (String)"Disable Shell Password");
                if (object != null) {
                    try {
                        this.secModel.setEnforceShellPasswordOff((String)object);
                    }
                    catch (NotAuthenticated notAuthenticated) {
                        this.enforceShellPasswordCB.setSelected(true);
                        ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_AUTH_ERROR, notAuthenticated.toString());
                    }
                } else {
                    this.enforceShellPasswordCB.setSelected(true);
                }
            }
        }
        if ((object = eSecurityLevel.from_int(((Attribute)this.pmClearingCB.getSelectedItem()).getValue())) != this.secModel.getPmClearingPrivilege()) {
            this.secModel.setPmClearingPrivilege((eSecurityLevel)object);
        }
        LANAccessMode lANAccessMode = (LANAccessMode)this.lanAccessCB.getSelectedItem();
        if (!this.secModel.getLANAccess().equals(lANAccessMode)) {
            this.secModel.setLANAccess(lANAccessMode);
        }
        if (db.on()) {
            db.println("applyChangesToModel: end");
        }
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshFromModel: start");
        }
        this.lanAccessCB.setSelectedItem(this.secModel.getLANAccess());
        this.restoreLanAccess.setValue(Integer.toString(this.secModel.getLANAccessTimeout()));
        this.telnetPortTF.setText(Integer.toString(this.secModel.getTelnetPort()));
        this.sshPortTF.setText(Integer.toString(this.secModel.getSshPort()));
        boolean bl = this.secModel.isSshEnabled();
        if (bl) {
            this.enableSshRB.setSelected(true);
        } else {
            this.enableTelnetRB.setSelected(true);
        }
        this.enableTelnetOption(!bl);
        boolean bl2 = this.secModel.isEnforceShellPassword();
        if (bl2) {
            this.enforceShellPasswordCB.setSelected(true);
        } else {
            this.enforceShellPasswordCB.setSelected(false);
        }
        this.pmClearingCB.setSelectedItem(ElementDefaults.getAttributeMap((NodeModelDelegate)this.getUiModel()).getAttributeForVal("securityPmClearingSecurityLevels", this.secModel.getPmClearingPrivilege().value()));
        this.lanAccessDirty = false;
        if (db.on()) {
            db.println("refreshFromModel: finish");
        }
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update: start");
        }
        this.requestRefresh(this, null);
    }

    public void enteringPage() throws Exception {
        this.secModel = (SecurityModel)((NodeModelDelegate)this.getUiModel()).getSecurityModel();
        if (!this.bInit) {
            this.init();
        }
        if (this.secModel != null) {
            this.secModel.addObserver((Observer)((Object)this));
        }
        super.enteringPage();
    }

    public void leavingPage() throws Exception {
        super.leavingPage();
        if (this.secModel != null) {
            this.secModel.deleteObserver((Observer)((Object)this));
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SppSecurityAccessPane;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.useStandardTelnetB)) {
            this.telnetPortTF.setText(Integer.toString(this.secModel.getStandardTelnetPort()));
        } else if (object.equals(this.enableSshRB) || object.equals(this.enableTelnetRB)) {
            this.enableTelnetOption(object == this.enableTelnetRB);
        } else if (object.equals(this.lanAccessCB)) {
            this.lanAccessDirty = true;
        }
        this.setDirty();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    private void updateLANAccessCB(boolean bl) {
        if (bl) {
            this.lanAccessCB.addItem(LANAccessMode.FRONT_ONLY);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    private void enableTelnetOption(boolean bl) {
        if (!bl || this.isUserAuthorized()) {
            this.telnetPortTF.setEditable(bl);
            this.useStandardTelnetB.setEnabled(bl);
        }
    }

    private void init() {
        JPanel jPanel = SppSecurityAccessPane.createVerticalPanel(null);
        this.add((Component)new UScrollPane((Component)jPanel));
        jPanel.setLayout(new GridLayout(2, 1));
        JPanel jPanel2 = this.getLANAccessPanel();
        jPanel.add(jPanel2);
        jPanel2 = this.getShellAccessPanel();
        jPanel.add(jPanel2);
        if (!this.isUserAuthorized()) {
            this.lanAccessCB.setEnabled(false);
            this.restoreLanAccess.setEnabled(false);
            this.enableTelnetRB.setEnabled(false);
            this.enableSshRB.setEnabled(false);
            this.enforceShellPasswordCB.setEnabled(false);
            this.useStandardTelnetB.setEnabled(false);
            this.telnetPortTF.setEnabled(false);
            this.pmClearingCB.setEnabled(false);
        }
        this.bInit = true;
    }

    private JPanel getLANAccessPanel() {
        JPanel jPanel = SppSecurityAccessPane.createVerticalPanel("Access");
        Dimension dimension = new Dimension(130, 20);
        this.lanAccessCB = new JComboBox<LANAccessMode>(this.pci.getSupportedLanAccessModes());
        jPanel.add(SppSecurityAccessPane.createAttributePanel("LAN Access:", null, dimension, this.lanAccessCB));
        this.lanAccessCB.addActionListener(this);
        jPanel.add(Box.createHorizontalStrut(5));
        this.restoreLanAccess = new SpinPropertyEditor("", 1, 0, 60);
        jPanel.add(SppSecurityAccessPane.createAttributePanel("Restore Timeout:", " minute(s)", dimension, this.restoreLanAccess));
        this.restoreLanAccess.addPropertyChangeListener(this);
        return jPanel;
    }

    private JPanel getShellAccessPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        JPanel jPanel2 = SppSecurityAccessPane.createVerticalPanel("Shell Access");
        boolean bl = this.secModel.isSshEnabled();
        Dimension dimension = new Dimension(90, 20);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.enableTelnetRB = new JRadioButton("Telnet", !bl);
        this.enableTelnetRB.setPreferredSize(dimension);
        buttonGroup.add(this.enableTelnetRB);
        this.enableTelnetRB.addActionListener(this);
        this.enableSshRB = new JRadioButton("SSH", bl);
        this.enableSshRB.setPreferredSize(dimension);
        buttonGroup.add(this.enableSshRB);
        this.enableSshRB.addActionListener(this);
        this.useStandardTelnetB = new JButton("Use Standard Port");
        this.useStandardTelnetB.addActionListener(this);
        this.useStandardTelnetB.setActionCommand("useStandardTelnet");
        dimension = new Dimension(40, 20);
        this.telnetPortTF = new JTextField(6);
        jPanel2.add(SppSecurityAccessPane.createPortPanel("Port:", this.enableTelnetRB, this.useStandardTelnetB, dimension, this.telnetPortTF));
        this.telnetPortTF.setDocument(new IntegerDocument(0, 65535, 5));
        this.telnetPortTF.getDocument().addDocumentListener(this);
        this.sshPortTF = new JTextField(6);
        JPanel jPanel3 = SppSecurityAccessPane.createPortPanel("Port:", this.enableSshRB, null, dimension, this.sshPortTF);
        jPanel2.add(jPanel3);
        this.sshPortTF.setEnabled(false);
        this.sshPortTF.setBackground(jPanel2.getBackground());
        this.enforceShellPasswordCB = new JCheckBox("Enable Shell Password");
        jPanel2.add(this.enforceShellPasswordCB);
        this.enforceShellPasswordCB.addActionListener(this);
        jPanel.add(jPanel2);
        jPanel.add(this.getOtherInfoPanel());
        return jPanel;
    }

    private JPanel getOtherInfoPanel() {
        JPanel jPanel = SppSecurityAccessPane.createVerticalPanel("Other");
        Dimension dimension = new Dimension(130, 20);
        this.pmClearingCB = new JComboBox<Attribute>(ElementDefaults.getAttributeMap((NodeModelDelegate)this.getUiModel()).getAttributeArray("securityPmClearingSecurityLevels"));
        jPanel.add(SppSecurityAccessPane.createAttributePanel("PM Clearing Privilege:", null, dimension, this.pmClearingCB));
        this.pmClearingCB.addActionListener(this);
        return jPanel;
    }

    private static JPanel createAttributePanel(String string, String string2, Dimension dimension, JComponent jComponent) {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        if (string != null) {
            JLabel jLabel = new JLabel(string);
            jLabel.setPreferredSize(dimension);
            jPanel.add(jLabel);
        }
        jPanel.add(jComponent);
        if (string2 != null) {
            jPanel.add(new JLabel(string2));
        }
        return jPanel;
    }

    private static JPanel createPortPanel(String string, JRadioButton jRadioButton, JButton jButton, Dimension dimension, JComponent jComponent) {
        Object object;
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        if (jRadioButton != null) {
            jPanel.add(jRadioButton);
        }
        if (string != null) {
            object = new JLabel(string);
            ((JComponent)object).setPreferredSize(dimension);
            jPanel.add((Component)object);
        }
        jPanel.add(jComponent);
        if (jButton != null) {
            object = jButton.getBorder();
            EmptyBorder emptyBorder = new EmptyBorder(0, 20, 0, 0);
            jButton.setBorder(new CompoundBorder(emptyBorder, (Border)object));
            jPanel.add(jButton);
        }
        jPanel.setAlignmentX(0.0f);
        return jPanel;
    }

    private int getIntValue(String string, String string2) throws Exception {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRange("Invalid range for " + string);
        }
    }
}

