/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.SonetTopology.eVtMode;
import cerent.cms.model.EntityModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.Preferences;
import cerent.util.TDMTerminology;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class SppXcPane
extends NodeProvPane
implements ActionListener {
    private boolean initialized = false;
    private JPanel xcModePanel;
    private JComboBox xcModeCB;
    private eVtMode[] xcModeArray = null;
    private eVtMode selectedXcMode;
    private boolean showAll = false;
    private static Preferences prefs = Preferences.instance();
    private static final String PREF_PATH = "ctc.xcmode";
    private static final String PREF_VC12ONLY = "showAll";

    public SppXcPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    public void enteringPage() throws Exception {
        if (!this.initialized) {
            this.init();
            this.initialized = true;
        }
        super.enteringPage();
    }

    private void init() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        UScrollPane uScrollPane = new UScrollPane((Component)jPanel);
        uScrollPane.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
        this.add((Component)uScrollPane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.createLopXcModePanel(), gridBagConstraints);
    }

    private JPanel createLopXcModePanel() {
        this.xcModePanel = new JPanel(new FlowLayout(0));
        String string = "Low Order Payload Capacity Type";
        this.xcModePanel.setBorder(BorderFactory.createTitledBorder(string));
        this.xcModeArray = new eVtMode[3];
        this.xcModeArray[0] = eVtMode.VT1_MODE;
        this.xcModeArray[1] = eVtMode.VT2_MODE;
        this.xcModeArray[2] = eVtMode.VT1_VT2_MODE;
        this.xcModeCB = new JComboBox(this.createXcModeVector(this.xcModeArray));
        this.showAll = prefs.getBoolean(PREF_PATH, PREF_VC12ONLY, false);
        this.initCB();
        this.xcModeCB.addActionListener(this);
        this.xcModePanel.add(this.xcModeCB);
        return this.xcModePanel;
    }

    private Vector createXcModeVector(eVtMode[] eVtModeArray) {
        Vector<XCMode> vector = new Vector<XCMode>(eVtModeArray.length);
        for (int i = 0; i < eVtModeArray.length; ++i) {
            vector.add(new XCMode(eVtModeArray[i]));
        }
        return vector;
    }

    private void initCB() {
        Model model;
        if (!this.showAll) {
            if (((NodeModelDelegate)this.getUiModel()).getFramingType() == 1) {
                this.xcModeCB.setSelectedIndex(eVtMode.VT2_MODE.value());
            } else {
                this.xcModeCB.setSelectedIndex(eVtMode.VT1_MODE.value());
            }
            this.xcModeCB.setEnabled(false);
        } else {
            model = (NodeModelDelegate)this.getUiModel();
            this.selectedXcMode = ((NodeModelDelegate)model).getLopXcMode();
            for (int i = 0; i < this.xcModeCB.getItemCount(); ++i) {
                XCMode xCMode = (XCMode)this.xcModeCB.getItemAt(i);
                if (this.selectedXcMode.value() != xCMode.value()) continue;
                this.xcModeCB.setSelectedIndex(i);
                break;
            }
        }
        model = (EntityModel)((NodeModelDelegate)this.getUiModel()).getEntityTableModel().getChassis();
        if (((EntityModel)model).getDescendantsOfType(eEqType.XCVXL_CARD).size() > 0 || ((EntityModel)model).getDescendantsOfType(eEqType.XCVXL25G_CARD).size() > 0) {
            this.xcModePanel.setVisible(true);
        } else {
            this.xcModePanel.setVisible(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setDirty();
        this.selectedXcMode = ((XCMode)this.xcModeCB.getSelectedItem()).eVtModeValue();
    }

    public void applyChangesToModel() throws Exception {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        nodeModelDelegate.setLopXcMode(this.selectedXcMode);
    }

    public void refreshFromModel() throws Exception {
        this.initCB();
    }

    private class XCMode {
        private eVtMode xcMode;

        public XCMode(eVtMode eVtMode2) {
            this.xcMode = eVtMode2;
        }

        public int value() {
            return this.xcMode.value();
        }

        public eVtMode eVtModeValue() {
            return this.xcMode;
        }

        public String toString() {
            String string;
            TDMTerminology tDMTerminology = ((NodeModelDelegate)SppXcPane.this.getUiModel()).getTDMTerminology();
            try {
                switch (this.xcMode.value()) {
                    case 0: {
                        string = tDMTerminology.getVirtualContainerTerm(4);
                        break;
                    }
                    case 1: {
                        string = tDMTerminology.getVirtualContainerTerm(3);
                        break;
                    }
                    case 2: {
                        string = tDMTerminology.getVirtualContainerTerm(4) + "/" + tDMTerminology.getVirtualContainerTerm(3) + " Mixed Mode";
                        break;
                    }
                    default: {
                        string = "";
                        break;
                    }
                }
            }
            catch (Exception exception) {
                string = "";
            }
            return string;
        }
    }
}

