/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IIpConfig;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IStaticRoute;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.StaticRoute;
import cerent.cms.ui.NetMaskHelper;
import cerent.cms.ui.NodeProvPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.IpSubnet;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class StaticRouteAttributesPane
extends NodeProvPane
implements ActionListener,
DocumentListener {
    static final String DEFAULT_IP_ADDRESS = "";
    static final String DEFAULT_NET_MASK = "255.255.255.0";
    static final String DEFAULT_COST = "2";
    protected INodeModel nodeModel;
    protected IStaticRoute myStaticRoute = new StaticRoute();
    protected JTextField destTF;
    protected JTextField maskTF;
    protected JTextField nextHopTF;
    protected JTextField costTF;
    JLabel destination;
    JLabel mask;
    JLabel hop;
    JLabel cost;
    private static final SDebug db = new SDebug("StaticRouteAttributesPane");

    public void setStaticRoute(IStaticRoute iStaticRoute) {
        this.myStaticRoute = iStaticRoute;
        this.refresh();
    }

    public IStaticRoute getStaticRoute() {
        return this.myStaticRoute;
    }

    protected StaticRouteAttributesPane(String string, INodeModel iNodeModel) {
        super(string, (IModel)iNodeModel, null);
        this.setNodeModel(iNodeModel);
        if (db.on()) {
            db.println("<init>: start");
        }
        this.add(this.createAttributesPanel(), "Center");
        this.setNodeModel(iNodeModel);
        if (db.on()) {
            db.println("<init>: finish");
        }
    }

    public boolean hasSubTabs() {
        return true;
    }

    public void destroy() {
        this.nodeModel = null;
        super.destroy();
    }

    protected void customInit() {
        this.destination = new JLabel("Destination: ", 4);
        this.mask = new JLabel("Mask: ", 4);
        this.hop = new JLabel("Next Hop: ", 4);
        this.cost = new JLabel("Cost: ", 4);
        this.destTF = new JTextField(DEFAULT_IP_ADDRESS);
        this.destTF.setPreferredSize(new Dimension(105, 21));
        this.maskTF = new JTextField(DEFAULT_NET_MASK);
        try {
            IIpConfig iIpConfig = this.nodeModel.getIpConfig();
            if (db.on()) {
                db.println("got ipConfig");
            }
            String string = InetUtil.makeDottedString(iIpConfig.getIpAddress());
            String string2 = string.substring(0, string.lastIndexOf(".")) + ".1";
            this.nextHopTF = new JTextField(string2);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Caught Exception " + exception);
            }
            this.nextHopTF = new JTextField(DEFAULT_IP_ADDRESS);
        }
        this.costTF = new JTextField(DEFAULT_COST);
    }

    protected JPanel buildAttributesPanel() {
        this.customInit();
        this.destination.setBorder(BorderFactory.createLineBorder(Color.red, 3));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        jPanel.add(this.destination);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        this.destTF.setPreferredSize(new Dimension(105, 21));
        jPanel2.add(this.destTF);
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected JPanel createAttributesPanel() {
        this.customInit();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        this.destination.setSize(100, 21);
        this.destination.setLocation(0, 0);
        this.destTF.setSize(105, 21);
        this.destTF.setLocation(110, 0);
        jPanel.add(this.destination);
        jPanel.add(this.destTF);
        this.mask.setSize(100, 21);
        this.maskTF.setSize(105, 21);
        this.mask.setLocation(0, 30);
        this.maskTF.setLocation(110, 30);
        jPanel.add(this.mask);
        jPanel.add(this.maskTF);
        this.hop.setSize(100, 21);
        this.nextHopTF.setSize(105, 21);
        this.hop.setLocation(0, 60);
        this.nextHopTF.setLocation(110, 60);
        jPanel.add(this.hop);
        jPanel.add(this.nextHopTF);
        this.cost.setSize(100, 21);
        this.costTF.setSize(105, 21);
        this.cost.setLocation(0, 90);
        this.costTF.setLocation(110, 90);
        jPanel.add(this.cost);
        jPanel.add(this.costTF);
        this.destTF.getDocument().addDocumentListener(this);
        this.maskTF.getDocument().addDocumentListener(this);
        this.nextHopTF.getDocument().addDocumentListener(this);
        this.costTF.getDocument().addDocumentListener(this);
        return jPanel;
    }

    protected String formatInternalSubnets() {
        String string;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.nodeModel;
            IpSubnet[] ipSubnetArray = nodeModelDelegate.getPlatform().getInternalSubnets(nodeModelDelegate);
            if (ipSubnetArray != null && ipSubnetArray.length > 0) {
                stringBuffer.append(" (");
                stringBuffer.append(ipSubnetArray[0]);
                for (int i = 1; i < ipSubnetArray.length; ++i) {
                    stringBuffer.append(", ");
                    stringBuffer.append(ipSubnetArray[i]);
                }
                stringBuffer.append(")");
            }
            string = stringBuffer.toString();
        }
        catch (Exception exception) {
            string = DEFAULT_IP_ADDRESS;
        }
        return string;
    }

    public void setNodeModel(INodeModel iNodeModel) {
        this.nodeModel = iNodeModel;
        boolean bl = this.isUserAuthorized((IModel)this.nodeModel);
    }

    public boolean onValidate() {
        try {
            this.validateFields();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_VALIDATION_ERROR);
            return false;
        }
        return true;
    }

    protected void validateFields() throws Exception {
        try {
            this.myStaticRoute.setIpAddress(InetUtil.makeIpAddr(this.destTF.getText()));
        }
        catch (Exception exception) {
            throw new Exception("Improper Destination Address");
        }
        try {
            this.myStaticRoute.setNextHop(InetUtil.makeIpAddr(this.nextHopTF.getText()));
        }
        catch (Exception exception) {
            throw new Exception("Improper NextHop Address");
        }
        int n = 0;
        try {
            n = InetUtil.parseDottedString(this.maskTF.getText());
            this.myStaticRoute.setNetMaskPrefixLength(NetMaskHelper.calculateNetMaskLength(n));
        }
        catch (Exception exception) {
            throw new Exception("Improper NetMask Entry");
        }
        boolean bl = false;
        try {
            short s = (short)Integer.parseInt(this.costTF.getText());
            if (s >= 1 && s <= Short.MAX_VALUE) {
                bl = true;
            }
            if (bl) {
                this.myStaticRoute.setCost(s);
            }
        }
        catch (Exception exception) {
            throw new Exception("Improper Cost Entry");
        }
        if (!bl) {
            throw new Exception("Valid cost is between 1 and 32767");
        }
    }

    public void refreshFromModel() throws Exception {
        String string = InetUtil.makeDottedString(this.myStaticRoute.getIpAddress());
        String string2 = InetUtil.makeDottedString(this.myStaticRoute.getNextHop());
        short s = this.myStaticRoute.getCost();
        int n = InetUtil.makeNetMask(this.myStaticRoute.getNetMaskPrefixLength());
        String string3 = InetUtil.makeDottedString(n);
        this.nextHopTF.setText(string2);
        this.costTF.setText(Integer.toString(s));
        this.maskTF.setText(string3);
        this.destTF.setText(string);
        super.refreshFromModel();
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    protected void documentModified(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.destTF.getDocument()) {
            String string = this.destTF.getText();
            if (string.equals("0.0.0.0")) {
                this.maskTF.setText("0.0.0.0");
                this.maskTF.setEnabled(false);
                try {
                    IIpConfig iIpConfig = this.nodeModel.getIpConfig();
                    String string2 = InetUtil.makeDottedString(iIpConfig.getDefaultRouter());
                    if (!string2.equals("0.0.0.0") && !string2.equals(DEFAULT_IP_ADDRESS)) {
                        this.nextHopTF.setText(string2);
                    }
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
            } else {
                this.maskTF.setEnabled(true);
                this.nextHopTF.setEnabled(true);
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentModified(documentEvent);
    }

    public Dimension getPreferredSize() {
        return new Dimension(250, 150);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("StaticRouteAttributesPane Unit Test");
        jFrame.setSize(300, 200);
        jFrame.getContentPane().add((Component)((Object)new StaticRouteAttributesPane(DEFAULT_IP_ADDRESS, null)));
        jFrame.setVisible(true);
    }
}

