/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.ModuleModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardView;
import cerent.cms.ui.shelf.GenericPortGraphic;
import cerent.util.SDebug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Arrays;
import javax.swing.JLabel;

public class Wss32CardView
extends CardView {
    private static final SDebug db = new SDebug("MuxDmuxCardView");
    private JLabel[] labels;
    private String ADD_RX = "ADD RX :";
    private String PT = "   PT  :";
    private String RX = "RX :";
    private String TX = "TX :";
    private String DROP = "DROP :";
    private String EXP = "EXP  :";
    private String COM = "COM  :";
    private boolean positionPortsVertically = this.pci.positionPortsVertically();

    public Wss32CardView(ModuleModel moduleModel) {
        super(moduleModel);
        if (moduleModel instanceof OpticsModuleModel) {
            this.removeOriginalPorts();
            OpticsModuleModel opticsModuleModel = (OpticsModuleModel)moduleModel;
            this.portModels = Arrays.asList(opticsModuleModel.getOpticsChildren());
            this.numPorts = this.portModels.size();
            this.addPorts();
            this.addLabels();
            this.refreshAlarmInfo();
        }
    }

    protected void removeOriginalPorts() {
        for (int i = 0; i < this.ports.length; ++i) {
            if (this.ports[i] == null) continue;
            this.ports[i].dispose();
        }
        this.removeAll();
        this.portModels.clear();
        this.numPorts = 0;
    }

    protected void addLabels() {
        Insets insets;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets2 = new Insets(4, 3, 20, 2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets2;
        int n = 0;
        while (n < 4) {
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n;
            this.add((Component)AbstractShelfLayout.formatLabel(new JLabel(this.ADD_RX, 2)), gridBagConstraints);
            gridBagConstraints.gridx = 10;
            gridBagConstraints.gridy = n++;
            this.add((Component)AbstractShelfLayout.formatLabel(new JLabel(this.PT, 2)), gridBagConstraints);
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        this.add((Component)AbstractShelfLayout.formatLabel(new JLabel(this.DROP, 2)), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.add((Component)AbstractShelfLayout.formatLabel(new JLabel(this.EXP, 2)), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        this.add((Component)AbstractShelfLayout.formatLabel(new JLabel(this.COM, 2)), gridBagConstraints);
        gridBagConstraints.insets = insets = new Insets(4, 3, 2, 2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        this.add((Component)AbstractShelfLayout.formatLabel(new JLabel(this.RX, 2)), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        this.add((Component)AbstractShelfLayout.formatLabel(new JLabel(this.TX, 2)), gridBagConstraints);
    }

    protected void addPorts() {
        PortModel portModel;
        int n;
        int n2;
        int n3;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(4, 3, 20, 2);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        for (n3 = 0; n3 < 32; ++n3) {
            if (!(this.portModels.get(n3) instanceof PortModel)) continue;
            n2 = n3 % 8;
            n = n3 / 8;
            portModel = (PortModel)this.portModels.get(n3);
            this.ports[n3] = new GenericPortGraphic(this, portModel, portModel.getPort(), portModel.isSpecial());
            gridBagConstraints.gridx = n2 + 2;
            gridBagConstraints.gridy = n;
            this.add((Component)this.ports[n3], gridBagConstraints);
        }
        for (n3 = 32; n3 < 64; ++n3) {
            if (!(this.portModels.get(n3) instanceof PortModel)) continue;
            n2 = (n3 - 32) % 8;
            n = (n3 - 32) / 8;
            portModel = (PortModel)this.portModels.get(n3);
            this.ports[n3] = new GenericPortGraphic(this, portModel, portModel.getPort(), portModel.isSpecial());
            gridBagConstraints.gridx = n2 + 11;
            gridBagConstraints.gridy = n;
            this.add((Component)this.ports[n3], gridBagConstraints);
        }
        for (n3 = 64; n3 < 68; ++n3) {
            if (!(this.portModels.get(n3) instanceof PortModel)) continue;
            n2 = (n3 - 64 + 1) % 2 + 2;
            n = (n3 - 64) / 2 + 6;
            portModel = (PortModel)this.portModels.get(n3);
            this.ports[n3] = new GenericPortGraphic(this, portModel, portModel.getPort(), portModel.isSpecial());
            gridBagConstraints.gridx = n2;
            gridBagConstraints.gridy = n;
            this.add((Component)this.ports[n3], gridBagConstraints);
        }
        n3 = 68;
        n2 = 3;
        n = 5;
        portModel = (PortModel)this.portModels.get(n3);
        this.ports[n3] = new GenericPortGraphic(this, portModel, portModel.getPort(), portModel.isSpecial());
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n;
        this.add((Component)this.ports[n3], gridBagConstraints);
    }
}

