/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.SonetMedia.sPhysicalThresholds;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.sonet.TdmTableModel;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.EnumStrings;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;

public class CxcTdmPhysicalPmThresholdsTableModel
extends TdmTableModel {
    protected boolean[] rowDirty = null;
    protected sPhysicalThresholds[] statsVal;
    protected eIntervalType intervalType;
    protected boolean nearEnd = false;
    protected EntityCellRenderer myPortRenderer;
    protected static String[] columnNames = new String[]{"Port ", "LBC-HIGH", "LBC-LOW", "OPT-HIGH", "OPT-LOW", "OPR-HIGH", "OPR-LOW", "Set OPR"};
    protected static final int LINENUMBER_INDEX = 0;
    protected static final int LBC_HIGH_INDEX = 1;
    protected static final int LBC_LOW_INDEX = 2;
    protected static final int OPT_HIGH_INDEX = 3;
    protected static final int OPT_LOW_INDEX = 4;
    protected static final int OPR_HIGH_INDEX = 5;
    protected static final int OPR_LOW_INDEX = 6;
    protected static final int SET_OPR_INDEX = 7;
    private static final SDebug db = new SDebug("CxcTdmPhysicalPmThresholdsTableModel");
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public CxcTdmPhysicalPmThresholdsTableModel(INodeModel iNodeModel, TdmLineModel[] tdmLineModelArray, eIntervalType eIntervalType2, boolean bl) {
        super(iNodeModel);
        this.model = tdmLineModelArray;
        this.nearEnd = bl;
        this.intervalType = eIntervalType2;
        this.myPortRenderer = new EntityCellRenderer();
        this.init();
    }

    private void init() {
        this.numLines = this.model.length;
        this.rowDirty = new boolean[this.numLines];
        this.statsVal = new sPhysicalThresholds[this.numLines];
    }

    private void refreshPmStats(int n) {
        try {
            if (this.statsVal[n] == null) {
                this.statsVal[n] = new sPhysicalThresholds();
                this.model[n].getPhysicalThresholds(this.nearEnd, this.intervalType, this.statsVal[n]);
                if (db.on()) {
                    db.println("Stats val got for line " + n);
                }
                this.printStats(this.statsVal[n]);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_RTRV_STATS);
        }
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return class$java$lang$String == null ? (class$java$lang$String = CxcTdmPhysicalPmThresholdsTableModel.class$("java.lang.String")) : class$java$lang$String;
        }
        return class$java$lang$Integer == null ? (class$java$lang$Integer = CxcTdmPhysicalPmThresholdsTableModel.class$("java.lang.Integer")) : class$java$lang$Integer;
    }

    public void validate(String string, String string2, String string3) throws ProvisionError {
        this.updateValidationManager();
        try {
            this.validationManager.validate(this.model[0].getModuleModel().getEqTypeEnum(), eEqType.from_int(this.model[0].getPortModel().getEqType()), string, string2, string3);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            db.severe("Edit cannot currently be performed " + (Object)((Object)abstractCmsNoSuchEntityException));
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        block24: {
            try {
                if (db.on()) {
                    db.println("Change in value " + n + " " + n2);
                }
                int n3 = -1;
                if (object instanceof Integer) {
                    n3 = (Integer)object;
                } else if (object instanceof String) {
                    n3 = Integer.parseInt((String)object);
                }
                if (n3 < 0 && n2 != 7) {
                    throw new Exception();
                }
                switch (n2) {
                    case 1: {
                        if (this.statsVal[n].lbcHigh == n3) {
                            return;
                        }
                        db.println(this.model[n].getPhysicalValidationPrefix(this.intervalType) + "HighLaserBias");
                        this.validate(this.model[n].getPhysicalValidationPrefix(this.intervalType) + "HighLaserBias", object.toString(), this.getValueAt(n, 2).toString());
                        this.statsVal[n].lbcHigh = n3;
                        break;
                    }
                    case 2: {
                        if (this.statsVal[n].lbcLow == n3) {
                            return;
                        }
                        this.validate(this.model[n].getPhysicalValidationPrefix(this.intervalType) + "LowLaserBias", object.toString(), this.getValueAt(n, 1).toString());
                        this.statsVal[n].lbcLow = n3;
                        break;
                    }
                    case 3: {
                        if (this.statsVal[n].optHigh == n3) {
                            return;
                        }
                        this.validate(this.model[n].getPhysicalValidationPrefix(this.intervalType) + "HighTxPower", object.toString(), this.getValueAt(n, 4).toString());
                        this.statsVal[n].optHigh = n3;
                        break;
                    }
                    case 4: {
                        if (this.statsVal[n].optLow == n3) {
                            return;
                        }
                        this.validate(this.model[n].getPhysicalValidationPrefix(this.intervalType) + "LowTxPower", object.toString(), this.getValueAt(n, 3).toString());
                        this.statsVal[n].optLow = n3;
                        break;
                    }
                    case 5: {
                        if (this.statsVal[n].oprHigh == n3) {
                            return;
                        }
                        this.validate(this.model[n].getPhysicalValidationPrefix(this.intervalType) + "HighRxPower", object.toString(), this.getValueAt(n, 6).toString());
                        this.statsVal[n].oprHigh = n3;
                        break;
                    }
                    case 6: {
                        if (this.statsVal[n].oprLow == n3) {
                            return;
                        }
                        this.validate(this.model[n].getPhysicalValidationPrefix(this.intervalType) + "LowRxPower", object.toString(), this.getValueAt(n, 5).toString());
                        this.statsVal[n].oprLow = n3;
                        break;
                    }
                }
                this.rowDirty[n] = true;
                this.fireTableCellUpdated(n, n2);
            }
            catch (NumberFormatException numberFormatException) {
                db.println("NumberFormatException caught in CxcTdmPhysicalPmThresholdsTableModel::setValueAt() " + numberFormatException);
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)numberFormatException);
                }
            }
            catch (ProvisionError provisionError) {
                this.presentProvisionError(this.getColumnName(n2), provisionError);
            }
            catch (Exception exception) {
                db.println("Error in setting value " + exception);
                if (!db.on()) break block24;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public sPhysicalThresholds getStatsVal(int n) {
        if (n >= this.numLines) {
            return null;
        }
        return this.statsVal[n];
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.model[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].lbcHigh);
                }
                case 2: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].lbcLow);
                }
                case 3: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].optHigh);
                }
                case 4: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].optLow);
                }
                case 5: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].oprHigh);
                }
                case 6: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].oprLow);
                }
            }
            return null;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in getValueAt " + exception);
            }
            return null;
        }
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0) {
            try {
                if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.model[0].getModuleModel().isProtectModule()) {
                    return n2 > 0 && (!this.model[n].isProtectLine() || n2 == 7);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                return false;
            }
        }
        return false;
    }

    public void refreshMyLines(TdmLineModel[] tdmLineModelArray) {
        this.model = tdmLineModelArray;
        this.init();
        this.fireTableDataChanged();
    }

    public void refreshLineFromModel(int n) {
        this.statsVal[n] = null;
        this.rowDirty[n] = false;
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshFromModel() {
        int n;
        if (db.on()) {
            db.println("refreshing in model");
        }
        for (n = 0; n < this.numLines; ++n) {
            this.statsVal[n] = null;
        }
        for (n = 0; n < this.numLines; ++n) {
            this.rowDirty[n] = false;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
        }
    }

    public void setOpr(int n) {
        try {
            this.model[n].setOpr();
            CerentDialog.infoDialog((Component)this.getFrame(), (String)"OPR nominal has been set successfully.", (String)"Set OPR");
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_FAIL_SET_OPR);
        }
    }

    private void printStats(sPhysicalThresholds sPhysicalThresholds2) {
        if (db.on()) {
            db.println("Near End = " + this.nearEnd + " Interval Type = " + EnumStrings.getString((Object)this.intervalType, (int)this.intervalType.value()));
            db.println("===============================================");
            db.println("LBC-HIGH " + sPhysicalThresholds2.lbcHigh);
            db.println("LBC-LOW" + sPhysicalThresholds2.lbcLow);
            db.println("OPT-HIGH " + sPhysicalThresholds2.optHigh);
            db.println("OPT-LOW" + sPhysicalThresholds2.optLow);
            db.println("OPR-HIGH " + sPhysicalThresholds2.oprHigh);
            db.println("OPR-LOW" + sPhysicalThresholds2.oprLow);
            db.println("===============================================");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

