/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.sonet.CxcTdmSectionPmThresholdsTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class CxcTdmSectionPmThresholdsPane
extends NodeProvPane
implements TableModelListener {
    protected CxcTdmSectionPmThresholdsTableModel dataModel = null;
    protected TdmLineModel[] lineModels = null;
    protected eIntervalType intervalType = null;
    protected boolean nearEnd = false;
    private static final SDebug db = new SDebug("CxcTdmSectionPmThresholdsPane");

    public CxcTdmSectionPmThresholdsPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray, eIntervalType eIntervalType2, boolean bl) {
        super(string, tabbedView);
        TableColumn tableColumn = null;
        this.lineModels = tdmLineModelArray;
        this.intervalType = eIntervalType2;
        this.nearEnd = bl;
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.table = new JTable(this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.add((Component)uScrollPane);
        tableColumn = this.table.getColumn(CxcTdmSectionPmThresholdsTableModel.columnNames[0]);
        tableColumn.setPreferredWidth(150);
        this.registerWithModel();
    }

    protected CxcTdmSectionPmThresholdsTableModel getDataModel() {
        return new CxcTdmSectionPmThresholdsTableModel(this.getUiModel().getNodeModel(), this.lineModels, this.intervalType, this.nearEnd);
    }

    protected void registerWithModel() {
        super.registerWithModel();
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    protected void unregisterWithModel() {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    public void dispose() {
        this.unregisterWithModel();
        super.dispose();
    }

    protected void changeMessage(Observable observable, Object object) {
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                CxcTdmSectionPmThresholdsPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof OcnLineUpdate) {
            this.unregisterWithModel();
            this.lineModels = (TdmLineModel[])((OcnLineUpdate)object).getModels();
            this.registerWithModel();
            this.dataModel.refreshMyLines(this.lineModels);
        }
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In CxcTdmSectionPmThresholdsPane changeMessage cannot find Model " + observable);
        }
    }

    public void applyChangesToModel() throws Exception {
        int n = 0;
        try {
            for (n = 0; n < this.lineModels.length; ++n) {
                if (db.on()) {
                    db.println("setting at iteration " + n);
                }
                if (!this.dataModel.isRowDirty(n)) continue;
                this.lineModels[n].setSectionThresholds(this.nearEnd, this.intervalType, this.dataModel.getStatsVal(n));
            }
            this.dataModel.resetDirtyBits();
        }
        catch (Exception exception) {
            throw new AnnotatedException("Error applying changes to row " + (n + 1), exception);
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        int n;
        if (this.lineModels == null) {
            return;
        }
        int n2 = n = tableModelEvent.getLastRow() > this.lineModels.length - 1 ? this.lineModels.length - 1 : tableModelEvent.getLastRow();
        if (db.on()) {
            db.println("Got a table changed message val = " + n);
        }
        for (int i = tableModelEvent.getFirstRow(); i <= n; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    public void refreshFromModel() {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        this.registerWithModel();
    }

    public void leavingPage() throws Exception {
        if (this.table.isEditing()) {
            TableCellEditor tableCellEditor = this.table.getCellEditor();
            tableCellEditor.stopCellEditing();
            this.setDirty();
        }
        this.unregisterWithModel();
        super.leavingPage();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.TdmSectionPmThresholdsPane;
    }
}

