/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.SonetMedia.sVtThresholds;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.TdmLoModel;
import cerent.cms.model.TdmModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.sonet.LoPathPmThresholdsTableModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class LoPathPmThresholdsPane
extends NodeProvPane
implements TableModelListener {
    protected LoPathPmThresholdsTableModel dataModel = null;
    protected TdmLoModel[] loModel = null;
    protected InterfaceModel[] lineModels = null;
    protected int numLines = 0;
    protected int numVts = 0;
    protected TdmModuleModel eqpmtModel = null;
    protected eIntervalType intervalType = null;
    protected boolean nearEnd = false;
    protected Observer strucChangeObserver = null;
    protected int indexOfVts;
    private static final SDebug db = new SDebug("LoPathPmThresholdsPane");

    public LoPathPmThresholdsPane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray, eIntervalType eIntervalType2, boolean bl, int n) {
        super(string, tabbedView);
        TableColumn tableColumn = null;
        this.intervalType = eIntervalType2;
        this.nearEnd = bl;
        this.indexOfVts = n;
        this.lineModels = interfaceModelArray;
        if (n > 0) {
            this.loModel = this.getVts(this.lineModels, n);
        }
        this.numLines = this.lineModels == null ? 0 : this.lineModels.length;
        this.numVts = this.loModel == null ? 0 : this.loModel.length;
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(0));
        tableColumn.setPreferredWidth(225);
        tableColumn = this.table.getColumn(this.dataModel.getColumnName(4));
        this.table.removeColumn(tableColumn);
        this.table.setAutoCreateColumnsFromModel(false);
        this.strucChangeObserver = new Observer(){

            public void update(Observable observable, Object object) {
                Integer n;
                if (db.on()) {
                    db.println("update( " + observable.getClass().getName() + ", " + (object instanceof Integer ? ((Integer)object).toString() : object.toString()) + " )");
                }
                if (object instanceof Integer && (n = (Integer)object).equals(ModelUpdateType.ADDED)) {
                    LoPathPmThresholdsPane.this.initializeLines();
                }
            }
        };
        this.registerWithModel();
        this.add((Component)uScrollPane);
    }

    protected LoPathPmThresholdsTableModel getDataModel() {
        INodeModel iNodeModel = this.uiModel.getNodeModel();
        return new LoPathPmThresholdsTableModel(iNodeModel, this.loModel, this.intervalType, this.nearEnd);
    }

    protected void registerWithModel() {
        int n;
        for (n = 0; n < this.numVts; ++n) {
            this.loModel[n].addObserver((Observer)((Object)this));
        }
        for (n = 0; n < this.numLines; ++n) {
            this.lineModels[n].addObserver(this.strucChangeObserver);
        }
    }

    public void dispose() {
        int n;
        for (n = 0; n < this.numVts; ++n) {
            this.loModel[n].deleteObserver((Observer)((Object)this));
        }
        for (n = 0; n < this.numLines; ++n) {
            this.lineModels[n].deleteObserver(this.strucChangeObserver);
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer) {
            if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                if (db.on()) {
                    db.println("Got a CHANGED message for " + observable);
                }
                final Observable observable2 = observable;
                this.requestRefresh(observable2, new Runnable(){

                    public void run() {
                        LoPathPmThresholdsPane.this.refreshLine(observable2);
                    }
                });
            } else if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                if (db.on()) {
                    db.println("Got a DELETE message for " + observable);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LoPathPmThresholdsPane.this.initializeLines();
                    }
                });
            }
        }
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.loModel).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In LoPathPmThresholdsPane changeMessage cannot find Model " + observable);
        }
    }

    public void applyChangesToModel() throws Exception {
        int n = 0;
        try {
            if (db.on()) {
                db.println("Applying changes");
            }
            for (n = 0; n < this.numVts; ++n) {
                if (db.on()) {
                    db.println("setting at iteration " + n);
                }
                if (!this.dataModel.isRowDirty(n)) continue;
                this.printStats(this.dataModel.getThresholdsVal(n));
                this.loModel[n].setPmThresholds(this.nearEnd, this.intervalType, this.dataModel.getThresholdsVal(n));
            }
            this.dataModel.resetDirtyBits();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            throw new AnnotatedException("Error applying changes to row " + (n + 1), exception);
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        for (int i = 0; i < this.numVts; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    protected synchronized void initializeLines() {
        this.dispose();
        this.loModel = this.indexOfVts > 0 ? this.getVts(this.lineModels, this.indexOfVts) : null;
        this.numVts = this.loModel == null ? 0 : this.loModel.length;
        this.registerWithModel();
        this.dataModel.setVtModel(this.loModel);
    }

    protected TdmLoModel[] getVts(InterfaceModel[] interfaceModelArray, int n) {
        try {
            Collection collection = InterfaceModel.getHigherLayerModels(interfaceModelArray, n);
            if (collection == null) {
                if (db.on()) {
                    db.println("Error in getting VTs lines");
                }
                return null;
            }
            if (db.on()) {
                db.println("Returning VTs " + collection.size());
            }
            return collection.toArray(new TdmLoModel[0]);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in getting VTs in LoPathPmThresholdsPane:getVts " + exception);
            }
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    protected void printStats(sVtThresholds sVtThresholds2) {
        if (db.on()) {
            db.println("===============================================");
        }
        if (db.on()) {
            db.println("CV " + sVtThresholds2.cv);
        }
        if (db.on()) {
            db.println("ES " + sVtThresholds2.es);
        }
        if (db.on()) {
            db.println("SES " + sVtThresholds2.ses);
        }
        if (db.on()) {
            db.println("FC " + sVtThresholds2.fc);
        }
        if (db.on()) {
            db.println("UAS " + sVtThresholds2.uas);
        }
        if (db.on()) {
            db.println("BBE " + sVtThresholds2.bbe);
        }
        if (db.on()) {
            db.println("===============================================");
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.LoPathPmThresholdsPane;
    }
}

