/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.NoSuchLoopback;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.ui.AbstractHoProvPane;
import cerent.cms.ui.AbstractHoProvTableModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.sonet.TdmHoMaintenanceTableModel;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Observable;

public class TdmHoMaintenancePane
extends AbstractHoProvPane {
    protected static final SDebug dbg = new SDebug("TdmHoMaintenancePane");

    public TdmHoMaintenancePane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray, int n) {
        super(string, tabbedView, interfaceModelArray, n);
    }

    protected AbstractHoProvTableModel getHoProvTableModel() {
        return new TdmHoMaintenanceTableModel(this.getUiModel().getNodeModel(), this.hoModels);
    }

    public void applyChangesToModel() throws Exception {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.hoModels.length; ++i) {
            object = this.dataModel.getLineNumber(i);
            try {
                if (!this.dataModel.isDirty(i, 1) || ((TdmHoMaintenanceTableModel)this.dataModel).getXcLoopBack(i).booleanValue() && this.hoModels[i].hasXcLoopback() || !((TdmHoMaintenanceTableModel)this.dataModel).getXcLoopBack(i).booleanValue() && !this.hoModels[i].hasXcLoopback()) continue;
                this.hoModels[i].setXcLoopback(((TdmHoMaintenanceTableModel)this.dataModel).getXcLoopBack(i));
                continue;
            }
            catch (NoSuchLoopback noSuchLoopback) {
                arrayList.add((String)object + " loopback does not exist.\n");
                continue;
            }
            catch (InvalidState invalidState) {
                arrayList.add((String)object + " connection is not in a maintenance state.\n");
                continue;
            }
            catch (ConnectionInLoopback connectionInLoopback) {
                arrayList.add((String)object + " connection is already in loopback.\n");
                continue;
            }
            catch (ConnectionInRoll connectionInRoll) {
                arrayList.add((String)object + " connection is in the process of a bridge and roll.\n");
                continue;
            }
            catch (ConnectionInTestAccess connectionInTestAccess) {
                arrayList.add((String)object + " connection is in test access.\n");
                continue;
            }
            catch (InvalidPath invalidPath) {
                String string = this.getUiModel().getNodeModel().getTDMTerminology().getGeneralTerms(1);
                arrayList.add((String)object + " invalid path provided.\n" + "XC Loopbacks cannot be provisioned on drops of one way circuits or on " + string + " circuits.\n");
                continue;
            }
            catch (LoopbackActive loopbackActive) {
                arrayList.add((String)object + " connection is already involved in another type of loopback.\n");
            }
        }
        if (arrayList.size() != 0) {
            String string = new String();
            object = arrayList.iterator();
            while (object.hasNext()) {
                string = string + object.next();
            }
            throw new Exception(string);
        }
        this.dataModel.resetDirtyBits();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.TdmHoMaintenancePane;
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof OcnLineUpdate) {
            if (dbg.on()) {
                dbg.println("Received OcnLineUpdate...");
            }
            this.lineModels = (InterfaceModel[])((OcnLineUpdate)object).getModels();
            this.getObsMgr().setObservable((Observable[])this.lineModels);
            this.initializeLines();
        } else if (dbg.on()) {
            dbg.println("refreshMyLines received " + object);
        }
    }
}

