/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml;

import cerent.cms.model.CTCUserException;
import cerent.cms.xml.AbstractMetaData;
import cerent.cms.xml.ISimpleMetaData;
import cerent.cms.xml.TypeInfo;
import cerent.util.KDebug;

public class MetaData
extends AbstractMetaData {
    private static final String GET_ARG_NAMES = "GETArgNames";
    private static final String GET_ARG_TYPES = "GETArgTypes";
    private static final String GET_ARG_HLPRS = "GETArgHelpers";
    private static final String SET_ARG_NAMES = "SETArgNames";
    private static final String SET_ARG_TYPES = "SETArgTypes";
    private static final String SET_ARG_HLPRS = "SETArgHelpers";

    public MetaData() {
        this.returnTypeInfo = new TypeInfo();
    }

    private void initGetTypeInfo(int n) {
        if (this.getTypeInfo == null) {
            this.getTypeInfo = new TypeInfo[n];
            for (int i = 0; i < n; ++i) {
                this.getTypeInfo[i] = new TypeInfo();
            }
        }
    }

    private void initSetTypeInfo(int n) {
        if (this.setTypeInfo == null) {
            this.setTypeInfo = new TypeInfo[n];
            for (int i = 0; i < n; ++i) {
                this.setTypeInfo[i] = new TypeInfo();
            }
        }
    }

    private void initExcludedProducts(int n) {
        if (this.excludedProducts == null) {
            this.excludedProducts = new String[n];
            for (int i = 0; i < n; ++i) {
                this.excludedProducts[i] = "";
            }
        }
    }

    public boolean isForPublicMethod() {
        return false;
    }

    public static boolean canHandle(String string) {
        boolean bl = false;
        if (string.endsWith(GET_ARG_NAMES) || string.endsWith(GET_ARG_TYPES) || string.endsWith(GET_ARG_HLPRS) || string.endsWith(SET_ARG_NAMES) || string.endsWith(SET_ARG_TYPES) || string.endsWith(SET_ARG_HLPRS)) {
            bl = true;
        }
        return bl;
    }

    public boolean setValue(String string, String string2) {
        boolean bl = true;
        if (string.endsWith(GET_ARG_NAMES)) {
            this.setGETArgNames(MetaData.getMetaDataDef(string2));
        } else if (string.endsWith(GET_ARG_TYPES)) {
            this.setGETArgTypes(MetaData.getMetaDataDef(string2));
        } else if (string.endsWith(GET_ARG_HLPRS)) {
            this.setGETArgHelpers(MetaData.getMetaDataDef(string2));
        } else if (string.endsWith(SET_ARG_NAMES)) {
            this.setSETArgNames(MetaData.getMetaDataDef(string2));
        } else if (string.endsWith(SET_ARG_TYPES)) {
            this.setSETArgTypes(MetaData.getMetaDataDef(string2));
        } else if (string.endsWith(SET_ARG_HLPRS)) {
            this.setSETArgHelpers(MetaData.getMetaDataDef(string2));
        } else if (string.endsWith("ExcludedProducts")) {
            this.setExcludedProducts(MetaData.getMetaDataDef(string2));
        } else {
            bl = super.setValue(string, string2);
        }
        return bl;
    }

    public void validate() throws CTCUserException {
        if (this.getGETArgNames() == null) {
            throw new CTCUserException("No GET argument names found for MetaData");
        }
        if (this.getGETArgTypes() == null) {
            throw new CTCUserException("No GET argument types found for MetaData");
        }
        if (this.getGETArgHelpers() == null) {
            throw new CTCUserException("No GET argument helpers found for MetaData");
        }
        if (this.getSETArgNames() == null) {
            throw new CTCUserException("No SET argument names found for MetaData");
        }
        if (this.getSETArgTypes() == null) {
            throw new CTCUserException("No SET argument types found for MetaData");
        }
        if (this.getSETArgHelpers() == null) {
            throw new CTCUserException("No SET argument helpers found for MetaData");
        }
        super.validate();
    }

    public boolean takesGETArguments() {
        boolean bl = false;
        if (this.getTypeInfo != null && this.getTypeInfo[0].getArgName() != "NO_ARGUMENTS") {
            bl = true;
        }
        return bl;
    }

    public boolean takesSETArguments() {
        boolean bl = false;
        if (this.setTypeInfo != null && this.setTypeInfo[0].getArgName() != "NO_ARGUMENTS") {
            bl = true;
        }
        return bl;
    }

    public boolean hasGETPermission() {
        boolean bl = false;
        if (this.getTypeInfo != null && this.getTypeInfo[0].getArgName() != "NO_PERMISSION") {
            bl = true;
        }
        return bl;
    }

    public boolean hasSETPermission() {
        boolean bl = false;
        if (this.setTypeInfo != null && this.setTypeInfo[0].getArgName() != "NO_PERMISSION") {
            bl = true;
        }
        return bl;
    }

    public String getRealReturnType() {
        return MetaData.bestEffortRealType(this.getReturnType(), this.getReturnHelper());
    }

    public String[] getGETArgNames() {
        String[] stringArray = new String[this.getTypeInfo.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.getTypeInfo[i].getArgName();
        }
        return stringArray;
    }

    public void setGETArgNames(String[] stringArray) {
        this.initGetTypeInfo(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.getTypeInfo[i].setArgName(stringArray[i]);
        }
    }

    public String[] getGETArgTypes() {
        String[] stringArray = new String[this.getTypeInfo.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.getTypeInfo[i].getType();
        }
        return stringArray;
    }

    public void setGETArgTypes(String[] stringArray) {
        this.initGetTypeInfo(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.getTypeInfo[i].setType(stringArray[i]);
        }
    }

    public String[] getGETRealArgTypes() {
        return MetaData.bestEffortRealTypes(this.getGETArgTypes(), this.getGETArgHelpers());
    }

    public String[] getGETArgMapValueTypes() {
        String[] stringArray = new String[this.getTypeInfo.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.getTypeInfo[i].getMapValueType();
        }
        return stringArray;
    }

    public void setGETArgMapValueTypes(String[] stringArray) {
        this.initGetTypeInfo(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.getTypeInfo[i].setMapValueType(stringArray[i]);
        }
    }

    public String[] getGETArgHelpers() {
        String[] stringArray = new String[this.getTypeInfo.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.getTypeInfo[i].getHelper();
        }
        return stringArray;
    }

    public void setGETArgHelpers(String[] stringArray) {
        this.initGetTypeInfo(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.getTypeInfo[i].setHelper(stringArray[i]);
        }
    }

    public String[] getSETArgNames() {
        String[] stringArray = new String[this.setTypeInfo.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.setTypeInfo[i].getArgName();
        }
        return stringArray;
    }

    public void setSETArgNames(String[] stringArray) {
        this.initSetTypeInfo(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.setTypeInfo[i].setArgName(stringArray[i]);
        }
    }

    public String[] getSETArgTypes() {
        String[] stringArray = new String[this.setTypeInfo.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.setTypeInfo[i].getType();
        }
        return stringArray;
    }

    public void setSETArgTypes(String[] stringArray) {
        this.initSetTypeInfo(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.setTypeInfo[i].setType(stringArray[i]);
        }
    }

    public String[] getSETRealArgTypes() {
        return MetaData.bestEffortRealTypes(this.getSETArgTypes(), this.getSETArgHelpers());
    }

    public String[] getSETArgMapValueTypes() {
        String[] stringArray = new String[this.setTypeInfo.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.setTypeInfo[i].getMapValueType();
        }
        return stringArray;
    }

    public void setSETArgMapValueTypes(String[] stringArray) {
        this.initSetTypeInfo(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.setTypeInfo[i].setMapValueType(stringArray[i]);
        }
    }

    public String[] getSETArgHelpers() {
        String[] stringArray = new String[this.setTypeInfo.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.setTypeInfo[i].getHelper();
        }
        return stringArray;
    }

    public void setSETArgHelpers(String[] stringArray) {
        this.initSetTypeInfo(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.setTypeInfo[i].setHelper(stringArray[i]);
        }
    }

    public void setExcludedProducts(String[] stringArray) {
        int n = stringArray.length;
        this.initExcludedProducts(n);
        for (int i = 0; i < n; ++i) {
            this.excludedProducts[i] = stringArray[i];
        }
    }

    public void print(KDebug kDebug) {
        int n;
        kDebug.print("GETArgNames = ");
        for (n = 0; n < this.getTypeInfo.length; ++n) {
            kDebug.print("\"" + this.getTypeInfo[n].getArgName() + "\"" + " ");
        }
        kDebug.println(";");
        kDebug.print("GETArgTypes = ");
        for (n = 0; n < this.getTypeInfo.length; ++n) {
            kDebug.print("\"" + this.getTypeInfo[n].getType() + "\"" + " ");
        }
        kDebug.println(";");
        kDebug.print("GETArgHelpers = ");
        for (n = 0; n < this.getTypeInfo.length; ++n) {
            kDebug.print("\"" + this.getTypeInfo[n].getHelper() + "\"" + " ");
        }
        kDebug.println(";");
        kDebug.print("GETArgNames = ");
        for (n = 0; n < this.setTypeInfo.length; ++n) {
            kDebug.print("\"" + this.setTypeInfo[n].getArgName() + "\"" + " ");
        }
        kDebug.println(";");
        kDebug.print("SETArgTypes = ");
        for (n = 0; n < this.setTypeInfo.length; ++n) {
            kDebug.print("\"" + this.setTypeInfo[n].getType() + "\"" + " ");
        }
        kDebug.println(";");
        kDebug.print("SETArgHelpers = ");
        for (n = 0; n < this.setTypeInfo.length; ++n) {
            kDebug.print("\"" + this.setTypeInfo[n].getHelper() + "\"" + " ");
        }
        kDebug.println(";");
        super.print(kDebug);
    }

    private static String[] bestEffortRealTypes(String[] stringArray, String[] stringArray2) {
        String[] stringArray3;
        int n = stringArray.length;
        if (n > 0 && stringArray[0].equals("NO_ARGUMENTS")) {
            stringArray3 = ISimpleMetaData.StringArrayTemplate;
        } else {
            stringArray3 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray3[i] = MetaData.bestEffortRealType(stringArray[i], stringArray2[i]);
            }
        }
        return stringArray3;
    }

    private static String bestEffortRealType(String string, String string2) {
        String string3 = string;
        if (string2 != null) {
            if (string2.endsWith("Array")) {
                string3 = string + "[]";
            } else if (string2.equals("GenericCollection")) {
                string3 = "java.util.Collection";
            } else if (string2.equals("Map")) {
                string3 = "java.util.Map";
            }
        }
        return string3;
    }
}

