/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml;

import cerent.cms.model.NodeAdapter;
import cerent.cms.xml.XmlAdapter;
import cerent.util.xml.DOMSizer;
import cerent.util.xml.DOMUtil;
import cerent.util.xml.XercesDOMParser;
import java.net.URL;
import java.util.Iterator;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestXerces {
    private static String inputFile = "";
    private static boolean details = false;
    private static boolean some_details = false;
    private static boolean size = false;
    private static int LOOP_SIZE = 25;
    private static Element pool;
    private static Element els;
    private static Element tns;

    private static Document setup() {
        System.out.println("setup commencing");
        Document document = null;
        try {
            URL uRL = XmlAdapter.getSchemaUrl();
            XercesDOMParser xercesDOMParser = XercesDOMParser.instance((URL)uRL);
            document = inputFile.length() > 0 ? xercesDOMParser.parse(inputFile) : xercesDOMParser.parseString(TestXerces.buildXmlResponse());
            if (some_details) {
                if (details) {
                    System.out.println(NodeAdapter.prettyXmlString(DOMUtil.nodeToString((Node)document)));
                }
                System.out.println("Number of Nodes = " + TestXerces.getNumNodes(document));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return document;
    }

    private static String buildXmlResponse() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuffer.append("<TdmLineModel index=\"65538\">");
        stringBuffer.append("<getTdmLineModelResponse index=\"65538\">");
        stringBuffer.append("<getPort>");
        stringBuffer.append("<TdmPortModel index=\"65538\"/>");
        stringBuffer.append("</getPort>");
        stringBuffer.append("<getAdminStateEnum>ADMIN_OOS</getAdminStateEnum>");
        stringBuffer.append("<getHigherLayerModels/>");
        stringBuffer.append("<getLowerLayerModels/>");
        stringBuffer.append("<isALSSupported>false</isALSSupported>");
        stringBuffer.append("<getSoakTime>32</getSoakTime>");
        stringBuffer.append("<SonetConfig>");
        stringBuffer.append("<providesSyncFromCard>false</providesSyncFromCard>");
        stringBuffer.append("<syncMessagesEnabled>true</syncMessagesEnabled>");
        stringBuffer.append("<sendDoNotUse>true</sendDoNotUse>");
        stringBuffer.append("</SonetConfig>");
        stringBuffer.append("<Info>");
        stringBuffer.append("<ifType>SONET_LINE</ifType>");
        stringBuffer.append("<name>FAC-16-1                                                        </name>");
        stringBuffer.append("<descr>sonet_16/1</descr>");
        stringBuffer.append("<ifSpeed>51840000</ifSpeed>");
        stringBuffer.append("<connectorPresent>true</connectorPresent>");
        stringBuffer.append("<operStatus>OPER_NOT_PRESENT</operStatus>");
        stringBuffer.append("<adminState>ADMIN_OOS</adminState>");
        stringBuffer.append("<lastChange>0</lastChange>");
        stringBuffer.append("<physAddr>67-68-61-73-64-61-6a-68-73</physAddr>");
        stringBuffer.append("<ifMtu>0</ifMtu>");
        stringBuffer.append("<slotNumber>16</slotNumber>");
        stringBuffer.append("<portNumber>1</portNumber>");
        stringBuffer.append("<muxIndex>0</muxIndex>");
        stringBuffer.append("<ainsSoakTime>32</ainsSoakTime>");
        stringBuffer.append("</Info>");
        stringBuffer.append("<Alias>ghasdajhs</Alias>");
        stringBuffer.append("<SdBerLevel>7</SdBerLevel>");
        stringBuffer.append("<LineBuildout>0</LineBuildout>");
        stringBuffer.append("<SfBerLevel>4</SfBerLevel>");
        stringBuffer.append("<LineLoopback>NO_LOOPBACK</LineLoopback>");
        stringBuffer.append("<UsedForSynchronization>false</UsedForSynchronization>");
        stringBuffer.append("<PointerMonitorStsNumber>0</PointerMonitorStsNumber>");
        stringBuffer.append("<CurrentlyActive>true</CurrentlyActive>");
        stringBuffer.append("<LineInfo>");
        stringBuffer.append("<mediumType>SONET</mediumType>");
        stringBuffer.append("<lineCoding>B3ZS</lineCoding>");
        stringBuffer.append("<lineType>COAX</lineType>");
        stringBuffer.append("<waveLength>0</waveLength>");
        stringBuffer.append("<usableAsTimingSource>false</usableAsTimingSource>");
        stringBuffer.append("</LineInfo>");
        stringBuffer.append("</getTdmLineModelResponse>");
        stringBuffer.append("</TdmLineModel>");
        return stringBuffer.toString();
    }

    private static int getNumNodes(Node node) {
        int n = 0;
        ++n;
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                n += TestXerces.getNumNodes(nodeList.item(i));
            }
        }
        return n;
    }

    private static void testRenameNode(Document document) {
        System.out.println("\ntestRenameNode commencing");
        TestXerces.renameNode(document);
    }

    private static void renameNode(Document document) {
        Node node = document.getFirstChild();
        ((CoreDocumentImpl)document).renameNode(node, null, "MyModel");
    }

    private static void testRearrangeNodes(Document document) {
        System.out.println("\ntestRearrangeNodes commencing");
        TestXerces.mem();
        TestXerces.makeNodePool(document);
        TestXerces.mem();
        System.out.println("New Response commencing");
        TestXerces.mem();
        TestXerces.makeNewTree(document);
        TestXerces.mem();
        if (some_details) {
            try {
                if (details) {
                    System.out.println(NodeAdapter.prettyXmlString(DOMUtil.nodeToString((Node)document)));
                }
                System.out.println("Number of Nodes = " + TestXerces.getNumNodes(document));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void makeNodePool(Document document) {
        Document document2 = document.getOwnerDocument();
        Element element = document.getDocumentElement();
        pool = document.createElement("OutOfBand");
        element.appendChild(pool);
        els = document.createElement("Elements");
        tns = document.createElement("TextNodes");
        pool.appendChild(els);
        pool.appendChild(tns);
        Node node = document.getFirstChild();
        Node node2 = node.getFirstChild();
        long l = TestXerces.time();
        TestXerces.traverseTree(node2);
        long l2 = TestXerces.time();
        TestXerces.diffTime(l, l2);
        if (some_details) {
            try {
                if (details) {
                    System.out.println(NodeAdapter.prettyXmlString(DOMUtil.nodeToString((Node)document)));
                }
                System.out.println("Number of Nodes = " + TestXerces.getNumNodes(document));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void traverseTree(Node node) {
        Node node2;
        int n;
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        for (n = n2 - 1; n >= 0; --n) {
            node2 = nodeList.item(n);
            TestXerces.traverseTree(node2);
        }
        n = node.getNodeType();
        if (n == 3) {
            node2 = node.getParentNode();
            if (node2 != null) {
                node2.removeChild(node);
            }
            tns.appendChild(node);
        } else if (n == 1) {
            node2 = node.getParentNode();
            if (node2 != null) {
                node2.removeChild(node);
            }
            els.appendChild(node);
        } else {
            System.out.println("Another kind of node: " + node.getNodeName());
        }
    }

    private static void makeNewTree(Document document) {
        Node node = document.getFirstChild();
        long l = TestXerces.time();
        for (int i = 0; i < LOOP_SIZE; ++i) {
            Node node2 = TestXerces.retrieveNodeByType((short)1);
            node.appendChild(node2);
            Node node3 = TestXerces.retrieveNodeByType((short)3);
            node2.appendChild(node3);
        }
        long l2 = TestXerces.time();
        TestXerces.diffTime(l, l2);
    }

    private static Node retrieveNodeByType(short s) {
        Node node = null;
        if (s == 3) {
            node = tns.getLastChild();
            tns.removeChild(node);
        } else if (s == 1) {
            node = els.getLastChild();
            els.removeChild(node);
        } else {
            System.out.println("Unknown type");
        }
        return node;
    }

    public static final void mem() {
        long l;
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.totalMemory();
        long l3 = l = runtime.freeMemory();
        boolean bl = false;
        System.out.println("Used= " + (l2 - l) + ". Free= " + l + ". Total= " + l2);
    }

    public static final long time() {
        return System.currentTimeMillis();
    }

    public static final void diffTime(long l, long l2) {
        System.out.println("Time in milliseconds = " + (l2 - l));
        System.out.println("Time in seconds = " + (l2 - l) / 1000L);
    }

    public static void main(String[] stringArray) {
        boolean bl;
        if (stringArray.length > 0 && !(bl = TestXerces.parseArgs(stringArray))) {
            return;
        }
        TestXerces.mem();
        Document document = TestXerces.setup();
        TestXerces.mem();
        if (document != null) {
            int n;
            DOMSizer dOMSizer;
            DOMSizer dOMSizer2;
            if (size) {
                dOMSizer2 = new DOMSizer(4, false, false, false, null);
                System.out.println("'Sum nodes' cnt: " + TestXerces.getNumNodes(document));
                dOMSizer = new DOMSizer(4, false, false, true, null);
                n = dOMSizer.sizeOf((Object)document);
                System.out.println("Doc total in bytes:  " + n);
            }
            TestXerces.testRearrangeNodes(document);
            TestXerces.mem();
            if (size) {
                dOMSizer2 = new DOMSizer(4, false, false, false, null);
                System.out.println("'Sum nodes' cnt: " + TestXerces.getNumNodes(document));
                dOMSizer = new DOMSizer(4, false, false, true, null);
                n = dOMSizer.sizeOf((Object)document);
                System.out.println("Doc total in bytes:  " + n);
            }
        }
    }

    private static boolean parseArgs(String[] stringArray) {
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string.equals("-f")) {
                inputFile = stringArray[++n];
                ++n;
                continue;
            }
            if (string.equals("-v")) {
                some_details = true;
                details = true;
                ++n;
                continue;
            }
            if (string.equals("-n")) {
                some_details = true;
                ++n;
                continue;
            }
            if (string.equals("-s")) {
                size = true;
                ++n;
                continue;
            }
            if (string.equals("-i")) {
                LOOP_SIZE = Integer.decode(stringArray[++n]) / 2;
                ++n;
                continue;
            }
            System.out.println("usage:  TextXerces [-f input-file] [-i node-count] [-n | -v | -s]");
            System.out.println("  -i how many nodes to rename; default is 50");
            System.out.println("  -n is some details; prints number of nodes");
            System.out.println("  -v is verbose; prints details of the tree");
            System.out.println("  -s uses the DOMSizer; prints size of the tree");
            bl = false;
            break;
        }
        return bl;
    }

    private static int getSize(Node node, DOMSizer dOMSizer) {
        int n;
        Iterator iterator = DOMUtil.getChildElementsIterator((Node)node);
        int n2 = 0;
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            n = TestXerces.getSize(node2, dOMSizer);
            n2 += n;
        }
        n = dOMSizer.sizeOf((Object)node);
        return n2 += n;
    }
}

