/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml;

import cerent.cms.model.CTCUserException;
import cerent.cms.xml.AbstractSimpleMetaData;
import cerent.cms.xml.AttributeCmdClassification;
import cerent.cms.xml.IAttributeCmdClassification;
import cerent.cms.xml.ISubstituter;
import cerent.cms.xml.MethodTypeInfo;
import cerent.cms.xml.ReflectionUtil;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.StringIndex;
import cerent.util.matcher.AbstractMatcher;
import cerent.util.xml.AbstractDOMParser;
import cerent.util.xml.XIncludeXercesDOMParser;
import cerent.util.xml.XercesDOMParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.StringSubstitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TypeInfoRepository {
    static final MethodTypeInfo[] MethodTypeInfoArrayTemplate = new MethodTypeInfo[0];
    static final String[] StringArrayTemplate = new String[0];
    static final AttributeCmdClassification[] AttributeCmdClassificationTemplate = new AttributeCmdClassification[0];
    static final String TYPE_INFO_TAG = "typeinfo";
    static final String CLASS_TAG = "class";
    static final String SUPER_TAG = "extends";
    static final String EXCLUDED_PRODUCTS_TAG = "ExcludedProducts".toLowerCase();
    static final String METHOD_TAG = "method";
    static final String TYPE_TAG = "type";
    static final String COMMENT_TAG = "comment";
    static final String NS_ATTR = "xmlns";
    static final String NAME_ATTR = "name";
    static final String NAME_ASSIGN = "name=\"";
    static final String COMMENT_START = "<!-- ";
    static final String COMMENT_END = " -->";
    public static final String FIX_ME = "FIX_ME";
    private static final String EXP_TYPEINFO_RES = "schema/ExpandedCTCTypeInfo.xml";
    private static final String TYPEINFO_RES = "schema/CTCTypeInfo.xml";
    private static URL typeInfoUrl = null;
    private static final String XML_TYPEINFO_FILE_PREF = "xml.typeinfofile";
    private static final String XML_IGNORE_METHOD_EXCEPTION = "xml.ignoremethodexception";
    protected Map methodTypeInfoLists = new HashMap();
    protected Map supers = new HashMap();
    protected Set superMethodsAdded = new HashSet();
    protected Map excludedProducts = new HashMap();
    protected Set fqClasses = new HashSet();
    protected Map nonFqToFqMap = new HashMap();
    protected ISubstituter substituter;
    public static final String LoaderNeType = ReflectionUtil.getNeType();
    public static final boolean IsUnspecified = ReflectionUtil.isNeTypeUnspecified((String)LoaderNeType);
    private static final int Index15 = LoaderNeType.indexOf("15");
    public static final String Non15LoaderNeType = Index15 >= 0 ? LoaderNeType.substring(2) : LoaderNeType;
    private static final PatternCompiler Compiler = new Perl5Compiler();
    private static final Pattern NeTypePattern = TypeInfoRepository.regexCompile(Compiler, "${netype}");
    public static boolean ignoreMethodException = Preferences.instance().getBoolean("ctc", "xml.ignoremethodexception", true);
    protected static RepositoryDebug db = new RepositoryDebug("TypeInfoRepository");
    static /* synthetic */ Class class$cerent$cms$xml$TypeInfoRepository;

    public static IAttributeCmdClassification[] getPublicMethodAttrCmdClassifications() {
        return null;
    }

    public TypeInfoRepository() {
    }

    public TypeInfoRepository(Node node) {
        this();
        if (!node.getNodeName().equals(TYPE_INFO_TAG)) {
            throw new IllegalArgumentException("expected node w/ tag: typeinfo");
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            String string = node2.getNodeName();
            if (string.equals(CLASS_TAG)) {
                this.decodeClassNode((Element)node2);
                continue;
            }
            if (!db.on()) continue;
            db.println("typeinfo - unknown tag: " + string);
        }
        this.addSuperMethodsToSubclasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static TypeInfoRepository createFromXmlFile(String var0, KDebug var1_1) throws CTCUserException {
        block12: {
            var2_2 = null;
            var3_3 = null;
            var4_4 = null;
            var5_5 = null;
            try {
                var6_6 = new File(var0);
                var5_5 = var6_6.toURL();
                var3_3 = new FileInputStream(var6_6);
                var2_2 = TypeInfoRepository.createFromXmlStream(var3_3, var5_5, var1_1);
                var8_8 = null;
                ** if (var3_3 == null) goto lbl-1000
            }
            catch (Throwable var7_14) {
                var8_10 = null;
                if (var3_3 != null) {
                    try {
                        var3_3.close();
                    }
                    catch (IOException var9_13) {
                        // empty catch block
                    }
                }
                throw var7_14;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var3_3.close();
                }
                catch (IOException var9_11) {}
            }
lbl-1000:
            // 2 sources

            {
                break block12;
                catch (IOException var6_7) {
                    var4_4 = var6_7.getMessage();
                    var8_9 = null;
                    if (var3_3 != null) {
                        try {
                            var3_3.close();
                        }
                        catch (IOException var9_12) {}
                    }
                }
            }
        }
        if (var4_4 != null) {
            throw new CTCUserException("createFromXmlFile failed: " + var4_4);
        }
        return var2_2;
    }

    public static TypeInfoRepository createFromXmlStream(InputStream inputStream) throws CTCUserException {
        return TypeInfoRepository.createFromXmlStream(inputStream, null, null);
    }

    public static TypeInfoRepository createFromXmlStream(URL uRL) throws CTCUserException {
        try {
            return TypeInfoRepository.createFromXmlStream(uRL.openStream(), uRL, null);
        }
        catch (IOException iOException) {
            throw new CTCUserException("Unable to create InputStream from URL", (Throwable)iOException);
        }
    }

    public static TypeInfoRepository createFromXmlStream(InputStream inputStream, URL uRL, KDebug kDebug) throws CTCUserException {
        TypeInfoRepository typeInfoRepository = null;
        String string = null;
        Exception exception = null;
        try {
            AbstractDOMParser abstractDOMParser = TypeInfoRepository.getParser(uRL);
            Document document = abstractDOMParser.parse(inputStream);
            Element element = document.getDocumentElement();
            typeInfoRepository = new TypeInfoRepository(element);
            typeInfoRepository.addSuperMethodsToSubclasses();
        }
        catch (SAXException sAXException) {
            string = "*** Please note that if you get an 'file not found' message, this may indicate that a typeinfo/XXX.xml MAY be 0-length. Please double-check ths...";
            string = string + sAXException.getMessage();
            exception = sAXException;
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
            exception = iOException;
        }
        if (string != null) {
            throw new CTCUserException("createFromXmlStream failed: " + string);
        }
        return typeInfoRepository;
    }

    public ISubstituter getSubstituter() {
        return this.substituter;
    }

    public void setSubstituter(ISubstituter iSubstituter) {
        this.substituter = iSubstituter;
    }

    public static AbstractDOMParser getParser() throws CTCUserException {
        return TypeInfoRepository.getParser(null);
    }

    public static AbstractDOMParser getParser(URL uRL) throws CTCUserException {
        URL uRL2;
        XIncludeXercesDOMParser xIncludeXercesDOMParser = null;
        URL uRL3 = uRL2 = uRL != null ? uRL : TypeInfoRepository.getTypeInfoUrl();
        if (TypeInfoRepository.urlNeedsExpanding(uRL2)) {
            xIncludeXercesDOMParser = XIncludeXercesDOMParser.xinclInstance(null, (KDebug)XIncludeXercesDOMParser.getDebug());
            xIncludeXercesDOMParser.setDefaultRoot(TypeInfoRepository.dirname(uRL2));
        } else {
            xIncludeXercesDOMParser = XercesDOMParser.instance(null, (KDebug)XercesDOMParser.getDebug());
        }
        return xIncludeXercesDOMParser;
    }

    protected static String dirname(URL uRL) {
        int n;
        if (uRL == null) {
            return null;
        }
        String string = uRL.toExternalForm();
        int n2 = string.length();
        if (n2 <= 1) {
            return string;
        }
        if (string.charAt(n2 - 1) == '/') {
            --n2;
        }
        for (n = n2 - 1; n >= 0 && string.charAt(n) != '/'; --n) {
        }
        String string2 = string.substring(0, ++n);
        return string2;
    }

    public void addClassName(String string) {
        String string2 = MethodTypeInfo.getLastSegment(string);
        this.fqClasses.add(string);
        this.nonFqToFqMap.put(string2, string);
    }

    protected void decodeClassNode(Element element) {
        if (!element.getNodeName().equals(CLASS_TAG)) {
            throw new IllegalArgumentException("expected node w/ tag: class");
        }
        String string = element.getAttribute(NS_ATTR);
        String string2 = MethodTypeInfo.namespaceToPkg(string);
        String string3 = element.getAttribute(NAME_ATTR);
        String string4 = MethodTypeInfo.createFullyQualifiedClassName(string2, string3);
        string4 = TypeInfoRepository.substitute(string4);
        this.addClassName(string4);
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        String[] stringArray = null;
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            String string5 = node.getNodeName();
            if (string5.equals(METHOD_TAG)) {
                MethodTypeInfo methodTypeInfo;
                try {
                    methodTypeInfo = new MethodTypeInfo(string2, string3, (Element)node);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!ignoreMethodException) {
                        throw illegalArgumentException;
                    }
                    String string6 = ((Element)node).getAttribute(NAME_ATTR);
                    db.println("method import warning '" + illegalArgumentException.getMessage() + "' while importing metadata for: " + string3 + "." + string6 + " ignoreping it...");
                    continue;
                }
                if (!this.isProductExcluded(methodTypeInfo.getFullyQualifiedClassName())) {
                    this.add(methodTypeInfo);
                }
                methodTypeInfo.addExcludedProducts(stringArray);
                continue;
            }
            if (string5.equals(SUPER_TAG)) {
                this.decodeSuperNode(string4, (Element)node);
                continue;
            }
            if (string5.equals(EXCLUDED_PRODUCTS_TAG)) {
                stringArray = MethodTypeInfo.decodeExcludedProductsNode((Element)node);
                this.excludedProducts.put(string4, stringArray);
                continue;
            }
            if (string5.equals(COMMENT_TAG) || !db.on()) continue;
            db.println("class " + string4 + " - unknown tag: " + string5);
        }
    }

    public boolean isProductExcluded(Object object, AbstractSimpleMetaData abstractSimpleMetaData) {
        boolean bl = false;
        String string = ReflectionUtil.getNeType(object);
        if (abstractSimpleMetaData == null) {
            bl = true;
        } else if (!string.equals("unknown")) {
            string = ReflectionUtil.processNeType((String)string);
            bl = this.isProductExcluded(object.getClass().getName(), string);
            if (!bl) {
                String[] stringArray = abstractSimpleMetaData.getProductExclusions();
                bl = ReflectionUtil.isProductExcluded(stringArray, string);
            }
        }
        return bl;
    }

    public boolean isProductExcluded(String string) {
        return IsUnspecified ? false : this.isProductExcluded(string, LoaderNeType);
    }

    public boolean isProductExcluded(String string, String string2) {
        if (string == null) {
            return false;
        }
        String[] stringArray = (String[])this.excludedProducts.get(string);
        return ReflectionUtil.isProductExcluded(stringArray, string2) || this.isProductExcluded((String)this.supers.get(string));
    }

    protected void decodeSuperNode(String string, Element element) {
        if (!element.getNodeName().equals(SUPER_TAG)) {
            throw new IllegalArgumentException("expected node w/ tag: extends");
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2;
            String string2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(string2 = (element2 = (Element)node).getNodeName()).equals(TYPE_TAG)) continue;
            String string3 = element2.getAttribute(NS_ATTR);
            String string4 = MethodTypeInfo.namespaceToPkg(string3);
            String string5 = element2.getAttribute(NAME_ATTR);
            String string6 = MethodTypeInfo.createFullyQualifiedClassName(string4, string5);
            string6 = TypeInfoRepository.substitute(string6);
            this.addSuper(string6, string);
        }
    }

    public void addSuper(String string, String string2) {
        this.supers.put(string2, string);
    }

    public void addSuperMethodsToSubclasses() {
        HashSet hashSet = new HashSet(this.supers.keySet());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.isProductExcluded(string)) continue;
            this.addSuperMethodsToSubclass(string);
        }
    }

    protected void addSuperMethodsToSubclass(String string) {
        if (string != null && !this.superMethodsAdded.contains(string)) {
            String string2 = (String)this.supers.get(string);
            if (string2 == null) {
                return;
            }
            this.addSuperMethodsToSubclass(string2);
            if (string2.equals(string)) {
                throw new IllegalStateException("basetypename: " + string2 + " can't be the same as typename");
            }
            HashSet hashSet = new HashSet(this.getFullyQualifiedMethodNames());
            Iterator iterator = hashSet.iterator();
            int n = 0;
            String string3 = string2 + ".";
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                if (!string4.startsWith(string3)) continue;
                List list = this.getOverloadedMethods(string4);
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    String[] stringArray;
                    MethodTypeInfo methodTypeInfo = (MethodTypeInfo)iterator2.next();
                    MethodTypeInfo methodTypeInfo2 = this.lookupMethodTypeInfo(methodTypeInfo);
                    String string5 = methodTypeInfo.getFullyQualifiedMethodName();
                    string5 = string + "." + MethodTypeInfo.getLastSegment(string5);
                    methodTypeInfo2 = this.lookupMethodTypeInfo(string5, stringArray = methodTypeInfo.getArgNames(), null);
                    if (methodTypeInfo2 != null) continue;
                    try {
                        methodTypeInfo2 = new MethodTypeInfo(string, methodTypeInfo, true);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (!ignoreMethodException) {
                            throw illegalArgumentException;
                        }
                        db.println("method import warning '" + illegalArgumentException.getMessage() + "' while trying to inherit method metadata into " + string + " for: " + methodTypeInfo.getFullyQualifiedMethodName() + " ignoreping it...");
                        continue;
                    }
                    boolean bl = this.add(methodTypeInfo2);
                    n += bl ? 1 : 0;
                }
            }
            this.superMethodsAdded.add(string);
        }
    }

    public Map getSuperTypes() {
        return this.supers;
    }

    public void addMethodTypeInfos(Collection collection) {
        Set set = this.getFullyQualifiedMethodNames();
        Iterator iterator = set.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list = this.getOverloadedMethods(string);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                MethodTypeInfo methodTypeInfo = (MethodTypeInfo)iterator2.next();
                collection.add(methodTypeInfo);
            }
        }
    }

    public String checkForMatchingArgNames() {
        String string = null;
        Set set = this.getFullyQualifiedMethodNames();
        Iterator iterator = set.iterator();
        boolean bl = false;
        while (iterator.hasNext() && string == null) {
            String string2 = (String)iterator.next();
            string = this.checkForMatchingArgNames(string2);
        }
        return string;
    }

    protected String checkForMatchingArgNames(String string) {
        String string2 = null;
        List list = this.getOverloadedMethods(string);
        MethodTypeInfo[] methodTypeInfoArray = list.toArray(MethodTypeInfoArrayTemplate);
        int n = methodTypeInfoArray.length;
        block0: for (int i = 0; i < n && string2 == null; ++i) {
            for (int j = i + 1; j < n && string2 == null; ++j) {
                MethodTypeInfo methodTypeInfo = methodTypeInfoArray[i];
                MethodTypeInfo methodTypeInfo2 = methodTypeInfoArray[j];
                if (!methodTypeInfo.doesMatchByArgNames(methodTypeInfo2)) continue;
                string2 = methodTypeInfo.getFullyQualifiedMethodName();
                continue block0;
            }
        }
        return string2;
    }

    public String checkForMatchingArgNames(String string, String[] stringArray) {
        String string2 = null;
        List list = this.getOverloadedMethods(string);
        MethodTypeInfo[] methodTypeInfoArray = list.toArray(MethodTypeInfoArrayTemplate);
        int n = methodTypeInfoArray.length;
        for (int i = 0; i < n && string2 == null; ++i) {
            MethodTypeInfo methodTypeInfo = methodTypeInfoArray[i];
            if (!methodTypeInfo.doesMatchByArgNames(stringArray)) continue;
            string2 = methodTypeInfo.getFullyQualifiedMethodName();
            break;
        }
        return string2;
    }

    public Collection getMethodTypeInfos() {
        LinkedList linkedList = new LinkedList();
        this.addMethodTypeInfos(linkedList);
        return linkedList;
    }

    public Collection getFixMes() {
        Collection collection = this.getMethodTypeInfos();
        Iterator iterator = collection.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            MethodTypeInfo methodTypeInfo = (MethodTypeInfo)iterator.next();
            if (!methodTypeInfo.hasFixMe()) continue;
            arrayList.add(methodTypeInfo.getFullyQualifiedMethodName());
        }
        return arrayList;
    }

    public Set getFullyQualifiedMethodNames() {
        return this.methodTypeInfoLists.keySet();
    }

    protected Collection getFullyQualifiedMethodNameLists() {
        return this.methodTypeInfoLists.values();
    }

    public Set getFullyQualifiedClassNames() {
        return this.fqClasses;
    }

    public String lookupFullyQualifiedClassName(String string) {
        return (String)this.nonFqToFqMap.get(string);
    }

    public LinkedList getFullyQualifiedMethodNames(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = this.methodTypeInfoLists.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            linkedList.add(string2);
        }
        return linkedList;
    }

    public Set getClassNames(boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        Set set = this.getFullyQualifiedClassNames();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.isProductExcluded(string)) continue;
            if (!bl) {
                string = MethodTypeInfo.getLastSegment(string);
            }
            hashSet.add(string);
        }
        return hashSet;
    }

    public LinkedList getTypeInfosByClass(String string) {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.methodTypeInfoLists.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.startsWith(string)) continue;
            linkedList.addAll((List)this.methodTypeInfoLists.get(string2));
        }
        return linkedList;
    }

    public List getOverloadedMethods(String string) {
        ArrayList arrayList = (ArrayList)this.methodTypeInfoLists.get(string);
        return arrayList;
    }

    public boolean add(MethodTypeInfo methodTypeInfo) {
        int n;
        if (methodTypeInfo == null || methodTypeInfo.isProductExcluded()) {
            return false;
        }
        String string = methodTypeInfo.getFullyQualifiedMethodName();
        String string2 = methodTypeInfo.getFullyQualifiedClassName();
        this.addClassName(string2);
        ArrayList<MethodTypeInfo> arrayList = this.getOverloadedMethods(string);
        if (arrayList == null) {
            arrayList = new ArrayList<MethodTypeInfo>();
            this.methodTypeInfoLists.put(string, arrayList);
        }
        int n2 = -1;
        int n3 = methodTypeInfo.getNumParms();
        int n4 = arrayList.size();
        for (n = 0; n < n4; ++n) {
            MethodTypeInfo methodTypeInfo2 = (MethodTypeInfo)arrayList.get(n);
            int n5 = methodTypeInfo2.getNumParms();
            if (n5 > n3) {
                if (n2 >= 0) break;
                n2 = n;
                break;
            }
            if (n5 == n3) {
                n2 = n;
            }
            if (n2 < 0 || !methodTypeInfo2.equals(methodTypeInfo)) continue;
            return false;
        }
        if (n2 < 0) {
            n2 = n4;
        }
        n = arrayList.size();
        arrayList.add(n2, methodTypeInfo);
        int n6 = arrayList.size();
        return true;
    }

    public void mergeInto(TypeInfoRepository typeInfoRepository, KDebug kDebug, boolean bl) {
        Collection collection = this.getMethodTypeInfos();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            MethodTypeInfo methodTypeInfo = (MethodTypeInfo)iterator.next();
            MethodTypeInfo methodTypeInfo2 = typeInfoRepository.lookupMethodTypeInfo(methodTypeInfo);
            if (methodTypeInfo2 != null) {
                methodTypeInfo.mergeInto(methodTypeInfo2, true);
                continue;
            }
            typeInfoRepository.add(methodTypeInfo);
            if (!bl) continue;
            MethodTypeInfo.println(kDebug, "adding method: " + methodTypeInfo.getFullyQualifiedMethodName());
        }
    }

    public MethodTypeInfo lookupMethodTypeInfo(String string, String string2, String string3, String[] stringArray, StringIndex[] stringIndexArray) {
        String string4 = MethodTypeInfo.createFullyQualifiedClassName(string, string2);
        return this.lookupMethodTypeInfo(string4, stringArray, stringIndexArray);
    }

    public MethodTypeInfo lookupMethodTypeInfo(String string, String string2, String[] stringArray, StringIndex[] stringIndexArray) throws CTCUserException {
        return this.lookupMethodTypeInfo(string, string2, stringArray, stringIndexArray, true);
    }

    public MethodTypeInfo lookupMethodTypeInfo(String string, String string2, String[] stringArray, StringIndex[] stringIndexArray, boolean bl) throws CTCUserException {
        MethodTypeInfo methodTypeInfo = null;
        try {
            if (bl) {
                Class[] classArray = ReflectionUtil.superclasses(string);
                for (int i = 0; methodTypeInfo == null && i < classArray.length; ++i) {
                    String string3 = MethodTypeInfo.createFullyQualifiedMethodName(classArray[i].getName(), string2);
                    methodTypeInfo = this.lookupMethodTypeInfo(string3, stringArray, stringIndexArray);
                }
            } else {
                String string4 = MethodTypeInfo.createFullyQualifiedMethodName(string, string2);
                methodTypeInfo = this.lookupMethodTypeInfo(string4, stringArray, stringIndexArray);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CTCUserException(string + " not found");
        }
        return methodTypeInfo;
    }

    public MethodTypeInfo lookupMethodTypeInfo(MethodTypeInfo methodTypeInfo) {
        String string = methodTypeInfo.getFullyQualifiedMethodName();
        String[] stringArray = methodTypeInfo.getArgNames();
        return this.lookupMethodTypeInfo(string, stringArray, null);
    }

    public MethodTypeInfo lookupMethodTypeInfo(String string, String[] stringArray, StringIndex[] stringIndexArray) {
        MethodTypeInfo methodTypeInfo = null;
        List list = this.getOverloadedMethods(string);
        int n = 0;
        if (list != null) {
            MethodTypeInfo methodTypeInfo2;
            int n2;
            int n3 = stringArray == null ? 0 : stringArray.length;
            n = list.size();
            for (int i = 0; i < n && (n2 = (methodTypeInfo2 = (MethodTypeInfo)list.get(i)).getNumParms()) <= n3; ++i) {
                if (n2 != n3 || !methodTypeInfo2.doesMatchByArgNames(stringArray, stringIndexArray)) continue;
                methodTypeInfo = methodTypeInfo2;
                break;
            }
        }
        return methodTypeInfo;
    }

    public MethodTypeInfo lookupMethodTypeInfoByType(String string, String[] stringArray, boolean bl) {
        MethodTypeInfo methodTypeInfo;
        int n;
        MethodTypeInfo methodTypeInfo2 = null;
        List list = this.getOverloadedMethods(string);
        if (list == null) {
            return methodTypeInfo2;
        }
        int n2 = stringArray == null ? 0 : stringArray.length;
        int n3 = list.size();
        int n4 = -1;
        for (int i = 0; i < n3 && (n = (methodTypeInfo = (MethodTypeInfo)list.get(i)).getNumParms()) <= n2; ++i) {
            if (n != n2 || !methodTypeInfo.doesMatchByMethodName(string) || !methodTypeInfo.doesMatchByArgTypes(stringArray)) continue;
            methodTypeInfo2 = methodTypeInfo;
            n4 = i;
            break;
        }
        if (bl && n4 >= 0) {
            list.remove(n4);
        }
        return methodTypeInfo2;
    }

    public MethodTypeInfo lookupMethodTypeInfoByType(String string, String[] stringArray) {
        return this.lookupMethodTypeInfoByType(string, stringArray, false);
    }

    public MethodTypeInfo lookupMethodTypeInfoByType(String string, String string2, String[] stringArray, boolean bl) {
        String string3 = MethodTypeInfo.createFullyQualifiedMethodName(string, string2);
        return this.lookupMethodTypeInfoByType(string3, stringArray, bl);
    }

    public MethodTypeInfo lookupMethodTypeInfoByType(String string, String string2, String[] stringArray) {
        return this.lookupMethodTypeInfoByType(string, string2, stringArray, false);
    }

    public MethodTypeInfo lookupMethodTypeInfoByType(MethodTypeInfo methodTypeInfo) {
        String string = methodTypeInfo.getFullyQualifiedMethodName();
        String[] stringArray = methodTypeInfo.getRealArgTypes();
        return this.lookupMethodTypeInfoByType(string, stringArray);
    }

    public boolean remove(MethodTypeInfo methodTypeInfo) {
        String[] stringArray;
        String string = methodTypeInfo.getFullyQualifiedMethodName();
        MethodTypeInfo methodTypeInfo2 = this.lookupMethodTypeInfoByType(string, stringArray = methodTypeInfo.getArgTypes(), false);
        return methodTypeInfo2 != null;
    }

    protected MethodTypeInfo lookupCounterpartMethod(MethodTypeInfo methodTypeInfo, AttributeCmdClassification attributeCmdClassification) {
        String string;
        if (attributeCmdClassification == null) {
            return null;
        }
        boolean bl = attributeCmdClassification.isAccessor();
        boolean bl2 = attributeCmdClassification.isMutator();
        if (!bl && !bl2) {
            return null;
        }
        String string2 = methodTypeInfo.getFullyQualifiedClassName();
        String string3 = attributeCmdClassification.getCmdName();
        String string4 = string = attributeCmdClassification.getAttributeName();
        String[] stringArray = methodTypeInfo.getRealArgTypes();
        int n = bl ? 1 : 0;
        String[] stringArray2 = new String[n];
        String string5 = null;
        if (bl) {
            string4 = "set" + string;
            stringArray2[0] = methodTypeInfo.getRealReturnType();
        } else if (bl2) {
            string4 = "get" + string;
            string5 = methodTypeInfo.getRealArgTypes()[0];
        }
        MethodTypeInfo methodTypeInfo2 = this.lookupMethodTypeInfoByType(string2, string4, stringArray2);
        if (methodTypeInfo2 == null && bl2 && string5.equals("boolean")) {
            string4 = "is" + string;
            methodTypeInfo2 = this.lookupMethodTypeInfoByType(string2, string4, stringArray2);
        }
        if (methodTypeInfo2 != null && string5 != null && !methodTypeInfo2.getRealReturnType().equals(string5)) {
            methodTypeInfo2 = null;
        }
        return methodTypeInfo2;
    }

    public IAttributeCmdClassification[] getAttrCmdClassifications() {
        return this.getAttrCmdClassifications(false);
    }

    public IAttributeCmdClassification[] getAttrCmdClassifications(boolean bl) {
        ArrayList arrayList = new ArrayList();
        this.addMethodTypeInfos(arrayList);
        IAttributeCmdClassification[] iAttributeCmdClassificationArray = new AttributeCmdClassification[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            Object object;
            MethodTypeInfo methodTypeInfo;
            MethodTypeInfo methodTypeInfo2 = (MethodTypeInfo)iterator.next();
            AttributeCmdClassification attributeCmdClassification = methodTypeInfo2.createClassification(bl);
            if (attributeCmdClassification == null || attributeCmdClassification.getModelName() == null) {
                attributeCmdClassification = methodTypeInfo2.createClassification();
            }
            if ((methodTypeInfo = this.lookupCounterpartMethod(methodTypeInfo2, attributeCmdClassification)) != null) {
                ++n;
                object = methodTypeInfo.createClassification();
                attributeCmdClassification.setCounterpart((IAttributeCmdClassification)object);
            }
            object = attributeCmdClassification.getModelName();
            iAttributeCmdClassificationArray[n2] = attributeCmdClassification;
            ++n2;
        }
        return iAttributeCmdClassificationArray;
    }

    protected static String getFullyQualifiedClass(String string) {
        int n = string.lastIndexOf(".");
        String string2 = string.substring(0, n);
        return string2;
    }

    static Map createClassMethodMap(Set set) {
        HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = string.lastIndexOf(".");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            HashSet<String> hashSet = (HashSet<String>)hashMap.get(string2);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                hashMap.put(string2, hashSet);
            }
            hashSet.add(string3);
        }
        return hashMap;
    }

    public void print(KDebug kDebug) {
        this.print(kDebug, false, true, null);
    }

    public void print(KDebug kDebug, boolean bl) {
        this.print(kDebug, bl, true, null);
    }

    public void print(KDebug kDebug, boolean bl, AbstractMatcher abstractMatcher) {
        this.print(kDebug, bl, true, abstractMatcher);
    }

    public void print(KDebug kDebug, boolean bl, boolean bl2) {
        this.print(kDebug, bl, bl2, null);
    }

    public void print(KDebug kDebug, boolean bl, boolean bl2, AbstractMatcher abstractMatcher) {
        Iterator<Object> iterator;
        boolean bl3 = abstractMatcher == null;
        int n = 2;
        if (bl3) {
            MethodTypeInfo.println(kDebug, "<?xml version=\"1.0\" ?>");
        }
        int n2 = -1;
        Map map = TypeInfoRepository.createClassMethodMap(this.getFullyQualifiedMethodNames());
        if (map.size() > 0) {
            iterator = map.keySet().iterator();
        } else {
            Set set = this.getFullyQualifiedClassNames();
            iterator = set.iterator();
        }
        while (iterator.hasNext()) {
            if (++n2 > 0 && bl3) {
                MethodTypeInfo.println(kDebug, "");
                MethodTypeInfo.println(kDebug, "");
            }
            String string = (String)iterator.next();
            this.printClassComment(kDebug, n, string);
            this.printClass(kDebug, bl, bl2, abstractMatcher, map, string, n);
        }
    }

    protected void printClassComment(KDebug kDebug, int n, String string) {
        int n2 = n + 2;
        String string2 = MethodTypeInfo.getLastSegment(string);
        MethodTypeInfo.println(kDebug, n, COMMENT_START);
        MethodTypeInfo.println(kDebug, n2, "Be sure that there is a tag with content:");
        this.printClassInclude(kDebug, n2, false, string2);
        MethodTypeInfo.println(kDebug, n2, "in the CTCTypeInfo.xml file");
        String string3 = "/vob/pacwan/CTC/schema/" + TypeInfoRepository.getClassFileName(string2);
        MethodTypeInfo.println(kDebug, n2, "The class element below should go into file: " + string3);
        MethodTypeInfo.println(kDebug, n2, "Also, make sure if needed to cc_mkelem " + string3);
        MethodTypeInfo.println(kDebug, n, COMMENT_END);
    }

    protected void printClassInclude(KDebug kDebug, int n, boolean bl, String string) {
        int n2 = n + 2;
        if (bl) {
            MethodTypeInfo.print(kDebug, n, "<");
        }
        MethodTypeInfo.print(kDebug, n2, "xi:include href=\"" + TypeInfoRepository.getClassFileName(string) + "\"");
        if (bl) {
            MethodTypeInfo.print(kDebug, ">");
        }
        MethodTypeInfo.println(kDebug, "");
    }

    protected static String getClassFileName(String string) {
        return "typeinfo/" + string + ".xml";
    }

    protected void printClass(KDebug kDebug, boolean bl, boolean bl2, AbstractMatcher abstractMatcher, Map map, String string, int n) {
        Set set;
        boolean bl3 = abstractMatcher == null;
        int n2 = n + 2;
        int n3 = n2 + 2;
        String string2 = (String)this.supers.get(string);
        String string3 = string;
        String string4 = string2;
        String[] stringArray = ReflectionUtil.getWhichPlatforms(string);
        if (stringArray != null && stringArray.length > 1 && this.substituter != null) {
            string3 = this.substituter.substitute(string);
            string4 = this.substituter.substitute(string2);
        }
        if (bl3) {
            MethodTypeInfo.printOpenTag(kDebug, n, CLASS_TAG, NAME_ASSIGN + string3 + "\"");
            if (string2 != null) {
                MethodTypeInfo.printOpenTag(kDebug, n2, SUPER_TAG);
                MethodTypeInfo.printOpenCloseTag(kDebug, n3, TYPE_TAG, NAME_ASSIGN + string4 + "\"");
                MethodTypeInfo.printCloseTag(kDebug, n2, SUPER_TAG);
                MethodTypeInfo.println(kDebug, "");
            }
        }
        if ((set = (Set)map.get(string)) != null) {
            Iterator iterator = set.iterator();
            int n4 = -1;
            while (iterator.hasNext()) {
                String string5 = (String)iterator.next();
                String string6 = MethodTypeInfo.createFullyQualifiedMethodName(string, string5);
                List list = this.getOverloadedMethods(string6);
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    ++n4;
                    MethodTypeInfo methodTypeInfo = (MethodTypeInfo)iterator2.next();
                    if (!bl3 && !abstractMatcher.doesMatch((Object)methodTypeInfo) || !bl && methodTypeInfo.isAdded()) continue;
                    if (n4 > 0) {
                        MethodTypeInfo.println(kDebug, "");
                    }
                    methodTypeInfo.print(kDebug, n2, bl2);
                }
            }
        }
        if (bl3) {
            MethodTypeInfo.printCloseTag(kDebug, n, CLASS_TAG);
        }
    }

    public void dump(KDebug kDebug) {
        MethodTypeInfo.println(kDebug, "TypeInfoRepository internal structure:");
        Set set = this.methodTypeInfoLists.keySet();
        Object[] objectArray = set.toArray(StringArrayTemplate);
        Arrays.sort(objectArray);
        int n = objectArray.length;
        MethodTypeInfo.println(kDebug, "# method names: " + n);
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            List list = this.getOverloadedMethods((String)object);
            int n2 = list.size();
            MethodTypeInfo.println(kDebug, "*** # " + i + " overloaded methods: " + (String)object + " has " + n2 + " entries");
            for (int j = 0; j < n2; ++j) {
                MethodTypeInfo methodTypeInfo = (MethodTypeInfo)list.get(j);
                String string = methodTypeInfo.signatureString(true, false);
                MethodTypeInfo.println(kDebug, "    " + j + ": " + string);
            }
        }
    }

    public static URL getTypeInfoUrl() {
        if (typeInfoUrl == null) {
            String string = Preferences.instance().getProperty("ctc", XML_TYPEINFO_FILE_PREF, "");
            try {
                if (string == null || string.length() == 0) {
                    URLClassLoader uRLClassLoader = (URLClassLoader)(class$cerent$cms$xml$TypeInfoRepository == null ? (class$cerent$cms$xml$TypeInfoRepository = TypeInfoRepository.class$("cerent.cms.xml.TypeInfoRepository")) : class$cerent$cms$xml$TypeInfoRepository).getClassLoader();
                    typeInfoUrl = uRLClassLoader.getResource(EXP_TYPEINFO_RES);
                    if (typeInfoUrl == null) {
                        typeInfoUrl = uRLClassLoader.getResource(TYPEINFO_RES);
                    }
                } else {
                    typeInfoUrl = !string.startsWith("file:") && !string.startsWith("http:") ? new URL("file", "", string.replace('\\', '/')) : new URL(string);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return typeInfoUrl;
    }

    public static boolean urlNeedsExpanding(URL uRL) {
        boolean bl = false;
        String string = uRL.getFile();
        if (string.indexOf(EXP_TYPEINFO_RES) < 0) {
            bl = true;
        }
        return bl;
    }

    protected static String substitute(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2 = IsUnspecified ? "xxx" : Non15LoaderNeType;
            StringSubstitution stringSubstitution = new StringSubstitution(string2);
            Perl5Matcher perl5Matcher = new Perl5Matcher();
            int n = Util.substitute((StringBuffer)stringBuffer, (PatternMatcher)perl5Matcher, (Pattern)NeTypePattern, (Substitution)stringSubstitution, (String)string, (int)-1);
        }
        catch (Exception exception) {
            db.println("substitute() error on string: '" + string + "': " + exception);
            RepositoryDebug.printStackTrace((Throwable)exception);
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private static Pattern regexCompile(PatternCompiler patternCompiler, String string) {
        Pattern pattern = null;
        try {
            pattern = patternCompiler.compile(Perl5Compiler.quotemeta((String)string));
        }
        catch (MalformedPatternException malformedPatternException) {
            // empty catch block
        }
        return pattern;
    }

    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("# classes: " + this.fqClasses.size() + "\n");
        Collection collection = this.getFullyQualifiedMethodNameLists();
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            n += list.size();
        }
        stringBuffer.append("# of methods: " + this.getFullyQualifiedMethodNames().size() + " (" + n + ")\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        try {
            URL uRL = new URL(string);
            TypeInfoRepository typeInfoRepository = TypeInfoRepository.createFromXmlStream(uRL.openStream());
            IAttributeCmdClassification[] iAttributeCmdClassificationArray = typeInfoRepository.getAttrCmdClassifications();
            AttributeCmdClassification.Comparator comparator = AttributeCmdClassification.comparator;
            Object[] objectArray = iAttributeCmdClassificationArray;
            Arrays.sort(objectArray, comparator);
            for (int i = 0; i < iAttributeCmdClassificationArray.length; ++i) {
                if (iAttributeCmdClassificationArray[i] == null) {
                    System.out.println("null at " + i);
                    continue;
                }
                System.out.println(iAttributeCmdClassificationArray[i].toString());
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace(System.out);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class RepositoryDebug
    extends SDebug {
        public RepositoryDebug(String string) {
            super(string);
        }

        public final void test(String string) throws MalformedURLException {
            URL uRL = new URL(string);
            try {
                TypeInfoRepository typeInfoRepository = TypeInfoRepository.createFromXmlStream(uRL.openStream());
                typeInfoRepository.print(db);
                IAttributeCmdClassification[] iAttributeCmdClassificationArray = typeInfoRepository.getAttrCmdClassifications();
                AttributeCmdClassification.Comparator comparator = AttributeCmdClassification.comparator;
                Object[] objectArray = iAttributeCmdClassificationArray;
                Arrays.sort(objectArray, comparator);
                for (int i = 0; i < iAttributeCmdClassificationArray.length; ++i) {
                    if (iAttributeCmdClassificationArray[i] == null) {
                        System.out.println("null at " + i);
                        continue;
                    }
                    System.out.println(iAttributeCmdClassificationArray[i].toString());
                }
                StringIndex[] stringIndexArray = new StringIndex[2];
                boolean bl = true;
                String string2 = "cerent.cms.model.SomeModel.getFoo";
                String[] stringArray = new String[]{"someString", "someInt"};
                MethodTypeInfo methodTypeInfo = typeInfoRepository.lookupMethodTypeInfo(string2, stringArray, stringIndexArray);
                if (methodTypeInfo == null) {
                    db.println("test case 1 failed");
                    bl = false;
                } else {
                    db.println("test case 1 found: " + methodTypeInfo.signatureString());
                }
                String[] stringArray2 = new String[]{"someInt", "someString"};
                methodTypeInfo = typeInfoRepository.lookupMethodTypeInfo(string2, stringArray2, stringIndexArray);
                if (methodTypeInfo == null) {
                    db.println("test case 2 failed");
                    bl = false;
                } else {
                    db.println("test case 2 found: " + methodTypeInfo.signatureString());
                }
                String[] stringArray3 = null;
                methodTypeInfo = typeInfoRepository.lookupMethodTypeInfo(string2, stringArray3, stringIndexArray);
                if (methodTypeInfo == null) {
                    db.println("test case 3 failed");
                    bl = false;
                } else {
                    db.println("test case 3 found: " + methodTypeInfo.signatureString());
                }
                String[] stringArray4 = new String[]{"someint", "someString"};
                methodTypeInfo = typeInfoRepository.lookupMethodTypeInfo(string2, stringArray4, stringIndexArray);
                if (methodTypeInfo == null) {
                    db.println("test case 4 passed");
                } else {
                    db.println("failed - test case 4 found: " + methodTypeInfo.signatureString());
                    bl = false;
                }
                db.println("all tests " + (bl ? "passed" : "didn't pass"));
            }
            catch (Exception exception) {
                db.println(exception.getMessage());
                RepositoryDebug.printStackTrace((Throwable)exception);
                String string3 = exception.getMessage();
            }
        }
    }
}

