/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml.helper;

import cerent.cms.model.CTCUserException;
import cerent.cms.xml.SchemaTagFactory;
import cerent.cms.xml.helper.BaseObjectHelper;
import cerent.cms.xml.helper.CDATAHelper;
import cerent.util.xml.DOMUtil;
import java.util.Iterator;
import org.w3c.dom.Node;

public class StringHelper
extends BaseObjectHelper {
    protected static final String LT_SYMBOL = "&lt;";
    protected static final String GT_SYMBOL = "&gt;";
    protected static final String AMP_SYMBOL = "&amp;";
    protected static final String APOS_SYMBOL = "&apos;";
    protected static final String QUOT_SYMBOL = "&quot;";

    public static Node objectToXml(Object object, String string, Node node) throws CTCUserException {
        String string2 = object == null ? "" : StringHelper.normalize(object.toString());
        return BaseObjectHelper.objectToXml(string2, string, node);
    }

    public static Object nodeToObject(Node node, String string) throws CTCUserException {
        Iterator iterator;
        if (db.on()) {
            db.print("[StringHelper] nodeToObject(" + node.getNodeName() + ", " + string + ") ");
            db.print("[StringHelper] node is " + DOMUtil.nodeToString((Node)node));
        }
        if ((iterator = DOMUtil.getChildCDATANodes((Node)node)).hasNext()) {
            return CDATAHelper.nodeToObject(iterator, string);
        }
        String string2 = "";
        if (node.getFirstChild() != null && node.getFirstChild().getNodeValue() != null) {
            string2 = node.getFirstChild().getNodeValue();
            if (db.on()) {
                db.println("[StringHelper] getFirstChild().getNodeValue() : " + string2);
            }
        } else if (db.on()) {
            db.println("[WARNING] arg node value is NULL. Will substitute an empty string instead");
        }
        return string2;
    }

    public static Object toSchema(String string, String string2) throws CTCUserException {
        return SchemaTagFactory.createClosedElementTag(string, "string");
    }

    public static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    stringBuffer.append(c);
                    continue block3;
                }
                default: {
                    if (!(Character.isSpaceChar(c) || c >= ' ' && c <= '~')) {
                        if (db.on()) {
                            db.println("Normalizing " + c + " to a space");
                        }
                        stringBuffer.append(" ");
                        continue block3;
                    }
                    if (db.on()) {
                        db.println("Adding " + c + " to the string");
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String denormalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        boolean bl = false;
        while (n2 < n) {
            if (string.charAt(n2) == '&') {
                if (string.regionMatches(n2, LT_SYMBOL, 0, 4)) {
                    stringBuffer.append('<');
                    n2 += 4;
                    continue;
                }
                if (string.regionMatches(n2, GT_SYMBOL, 0, 4)) {
                    stringBuffer.append('>');
                    n2 += 4;
                    continue;
                }
                if (string.regionMatches(n2, AMP_SYMBOL, 0, 5)) {
                    stringBuffer.append('&');
                    n2 += 5;
                    continue;
                }
                if (string.regionMatches(n2, APOS_SYMBOL, 0, 6)) {
                    stringBuffer.append('\'');
                    n2 += 6;
                    continue;
                }
                if (string.regionMatches(n2, QUOT_SYMBOL, 0, 6)) {
                    stringBuffer.append('\"');
                    n2 += 6;
                    continue;
                }
                stringBuffer.append('&');
                ++n2;
                continue;
            }
            stringBuffer.append(string.charAt(n2));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string;
        StringHelper stringHelper = new StringHelper();
        StringBuffer stringBuffer = new StringBuffer(128);
        System.out.println("Testing Normalize...");
        for (int i = 0; i < 128; ++i) {
            string = StringHelper.normalize(new Character((char)i).toString());
            stringBuffer.append(string);
        }
        String string2 = "          \n  \r                   !&quot;#$%&amp;&apos;()*+,-./0123456789:;&lt;=&gt;?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ ";
        System.out.println("Testing denormalize...");
        string = StringHelper.denormalize(stringBuffer.toString());
        String string3 = "          \n  \r                   !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ ";
        if (string.equals(string3)) {
            System.out.println("PASSED");
        } else {
            System.out.println("FAILED - Output does not match expected output");
        }
    }
}

