/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml.ncvcall;

import cerent.cms.xml.ncvcall.ClassDef;
import java.lang.ref.WeakReference;

public abstract class ClassMember {
    public static final int GLOBAL_CLASS = 0;
    public static final int INNER_CLASS = 1;
    public static final int FIELD = 2;
    public static final int METHOD = 3;
    public static final int PRIVATE_ACCESS = 0;
    public static final int PROTECTED_ACCESS = 1;
    public static final int PACKAGE_ACCESS = 2;
    public static final int PUBLIC_ACCESS = 3;
    private final WeakReference parentClass;
    private final int memtype;
    protected final String fqName;

    public ClassMember(ClassDef classDef, int n, String string) {
        this.parentClass = classDef == null ? null : new WeakReference<ClassDef>(classDef);
        this.memtype = n;
        this.fqName = string;
    }

    public int getMemType() {
        return this.memtype;
    }

    public String getFqName() {
        return this.fqName;
    }

    public String getNonFqName() {
        String string = this.getFqName();
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public ClassDef getParentClass() {
        if (this.parentClass == null) {
            return null;
        }
        return (ClassDef)this.parentClass.get();
    }

    public static int determineAccessControl(String string) {
        int n = 2;
        if (string != null) {
            if (string.equals("private")) {
                n = 0;
            } else if (string.equals("protected")) {
                n = 1;
            } else if (string.equals("public")) {
                n = 3;
            }
        }
        return n;
    }
}

