/*
 * Decompiled with CFR 0.152.
 */
package cerent.util;

import cerent.util.ICoordinateElement;
import cerent.util.SDebug;
import java.text.NumberFormat;

public class CoordinateElement
implements ICoordinateElement {
    private static int LATITUDE_DEGREE_SIZE = 2;
    private static int LONGITUDE_DEGREE_SIZE = 3;
    private static int MINUTE_SIZE = 2;
    private static int SECOND_SIZE = 5;
    private static final SDebug db = new SDebug("CoordinateElement");

    private CoordinateElement() {
    }

    public static double toDoubleValue(String string, int n) {
        int n2;
        int n3 = string.length();
        if (n == 0) {
            if (n3 < 1 + LATITUDE_DEGREE_SIZE + MINUTE_SIZE) {
                return -1.0;
            }
            n2 = LATITUDE_DEGREE_SIZE;
        } else {
            if (n3 < 1 + LONGITUDE_DEGREE_SIZE + MINUTE_SIZE) {
                return -1.0;
            }
            n2 = LONGITUDE_DEGREE_SIZE;
        }
        double d = 0.0;
        int n4 = 1;
        if (string.charAt(0) == 'S' || string.charAt(0) == 'W') {
            n4 = -1;
        }
        String string2 = string.substring(1, 1 + n2);
        String string3 = string.substring(1 + n2, 1 + n2 + MINUTE_SIZE);
        try {
            d += new Double(string2).doubleValue();
            d += new Double(string3) / 60.0;
        }
        catch (Exception exception) {
            db.println("Exception in toDoubleValue(), degStr=" + string2 + ", minStr=" + string3 + " " + exception);
        }
        return d * (double)n4;
    }

    public static String toStringValue(double d, int n) {
        int n2;
        String string = CoordinateElement.getDirectionString(d, n);
        if (n == 0) {
            if (d > 90.0) {
                d = 90.0;
            }
            if (d < -90.0) {
                d = -90.0;
            }
            n2 = LATITUDE_DEGREE_SIZE;
        } else {
            if (d > 180.0) {
                d = 180.0;
            }
            if (d < -180.0) {
                d = -180.0;
            }
            n2 = LONGITUDE_DEGREE_SIZE;
        }
        d = Math.abs(d);
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(n2);
        int n3 = (int)d;
        String string2 = numberFormat.format(n3);
        n3 = (int)((d - (double)n3) * 60.0 + 0.1);
        numberFormat.setMinimumIntegerDigits(MINUTE_SIZE);
        String string3 = numberFormat.format(n3);
        numberFormat.setMinimumIntegerDigits(SECOND_SIZE);
        String string4 = numberFormat.format(0L);
        String string5 = string + string2 + string3 + string4;
        return string5;
    }

    private static String getDirectionString(double d, int n) {
        if (n == 0) {
            return d > 0.0 ? "N" : "S";
        }
        return d > 0.0 ? "E" : "W";
    }
}

