/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.gui.AbstractPropertyEditor;
import cerent.util.gui.SpinButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class SpinPropertyEditor
extends AbstractPropertyEditor
implements DocumentListener,
ActionListener {
    protected JTextField txtInput;
    private JLabel label;
    private SpinButton upButton = new SpinButton(0);
    private SpinButton downButton = new SpinButton(1);
    private boolean fromSetValue = false;
    private Timer incTimer = new Timer(200, this);
    private Timer decTimer = new Timer(200, this);
    private String spinDesc = "";
    private String lblText = "";
    protected int stepSize;
    protected int min;
    protected int max;
    protected static final int STEP = 1;
    protected static final int MIN = 0;
    protected static final int MAX = 10000;

    public SpinPropertyEditor(String string) {
        this.init(string, 1, 0, 10000);
    }

    public SpinPropertyEditor(String string, int n) {
        this.init(string, n, 0, 10000);
    }

    public SpinPropertyEditor(String string, int n, int n2, int n3) {
        this.init(string, n, n2, n3);
    }

    public SpinPropertyEditor(String string, String string2, int n, int n2, int n3) {
        this.spinDesc = string2;
        this.init(string, n, n2, n3);
    }

    private void init(String string, int n, int n2, int n3) {
        this.lblText = string;
        this.label = new JLabel(string);
        this.txtInput = new JTextField(3);
        this.txtInput.setDocument(new IntegerDocument());
        this.txtInput.getDocument().addDocumentListener(this);
        this.stepSize = n;
        this.min = n2;
        this.max = n3;
        this.setLayout(new BorderLayout());
        if (string.length() > 0) {
            this.add((Component)this.label, "West");
        }
        this.add((Component)this.makeSpinControls(), "Center");
    }

    public void setMax(int n) {
        this.max = n;
    }

    public int getMax() {
        return this.max;
    }

    public void setEditorSize(int n) {
        if (n > 0) {
            this.txtInput.setColumns(n);
        }
    }

    public void requestEditorFocus() {
        this.txtInput.requestFocus();
    }

    public boolean onValidate() {
        if (!this.isEnabled()) {
            return true;
        }
        if (this.min != 0) {
            try {
                int n = Integer.parseInt(this.txtInput.getText());
                if (n < this.min) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                ErrorMsg.displayWarning((Component)this.getTopLevelAncestor(), (EID)CEMC.WID_VALUE_TOO_LOW_PARAM_1, Integer.toString(this.min));
                return false;
            }
        }
        if (this.txtInput.getText().length() == 0) {
            ErrorMsg.displayWarning(this.getTopLevelAncestor(), (EID)CEMC.WID_FIELD_ENTRY_REQUIRED);
            return false;
        }
        return true;
    }

    private JPanel makeSpinControls() {
        JPanel jPanel = new JPanel(new BorderLayout(2, 2));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
        this.upButton.setPreferredSize(new Dimension(15, 7));
        this.downButton.setPreferredSize(new Dimension(15, 7));
        this.upButton.setBorder(BorderFactory.createRaisedBevelBorder());
        this.downButton.setBorder(BorderFactory.createRaisedBevelBorder());
        jPanel2.add(this.upButton);
        jPanel2.add(this.downButton);
        this.upButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                SpinPropertyEditor.this.upButton.setBorder(BorderFactory.createLoweredBevelBorder());
                try {
                    SpinPropertyEditor.this.countUp();
                    SpinPropertyEditor.this.incTimer.start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                SpinPropertyEditor.this.incTimer.stop();
                SpinPropertyEditor.this.upButton.setBorder(BorderFactory.createRaisedBevelBorder());
            }
        });
        this.downButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                SpinPropertyEditor.this.downButton.setBorder(BorderFactory.createLoweredBevelBorder());
                try {
                    SpinPropertyEditor.this.countDown();
                    SpinPropertyEditor.this.decTimer.start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                SpinPropertyEditor.this.decTimer.stop();
                SpinPropertyEditor.this.downButton.setBorder(BorderFactory.createRaisedBevelBorder());
            }
        });
        if (this.spinDesc != null && this.spinDesc.length() > 0) {
            jPanel.add((Component)new JLabel(this.spinDesc), "South");
        }
        jPanel.add((Component)this.txtInput, "Center");
        jPanel.add((Component)jPanel2, "East");
        return jPanel;
    }

    private void countDown() {
        int n;
        if (!this.isEnabled()) {
            return;
        }
        this.upButton.transferFocus();
        try {
            n = Integer.parseInt(this.txtInput.getText());
            n = n - this.stepSize < this.min ? this.max : n - this.stepSize;
        }
        catch (Exception exception) {
            n = this.max;
        }
        this.setEditorText(n);
    }

    private void countUp() {
        int n;
        if (!this.isEnabled()) {
            return;
        }
        this.downButton.transferFocus();
        try {
            n = Integer.parseInt(this.txtInput.getText());
            n = n + this.stepSize > this.max ? this.min : n + this.stepSize;
        }
        catch (Exception exception) {
            n = this.min;
        }
        if (this.min != 0 && n < this.min) {
            n = this.min;
        }
        this.setEditorText(n);
    }

    private void setEditorText(int n) {
        this.txtInput.setText(Integer.toString(n));
        this.txtInput.requestFocus();
        this.setDirty();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    private void setDirty() {
        if (!this.fromSetValue) {
            this.setDirty(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.incTimer) {
            this.countUp();
        } else if (object == this.decTimer) {
            this.countDown();
        }
    }

    public Object getValue() {
        return this.txtInput.getText();
    }

    public int getStepSize() {
        return this.stepSize;
    }

    public void setValue(Object object) {
        if (object != null) {
            this.fromSetValue = true;
            try {
                String string = object.toString();
                Integer.parseInt(string);
                this.txtInput.setText(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.fromSetValue = false;
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.txtInput.setEnabled(bl);
        this.upButton.setEnabled(bl);
        this.downButton.setEnabled(bl);
        this.label.setEnabled(bl);
    }

    class IntegerDocument
    extends PlainDocument {
        IntegerDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            boolean bl = false;
            try {
                Integer.parseInt(string);
                String string2 = SpinPropertyEditor.this.txtInput.getText();
                StringBuffer stringBuffer = new StringBuffer(string2);
                stringBuffer.insert(n, string);
                int n2 = Integer.parseInt(stringBuffer.toString());
                if (n2 <= SpinPropertyEditor.this.max) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (bl) {
                super.insertString(n, string, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

