/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.gui.AbstractPropertyEditor;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StringArrayPropertyEditor
extends AbstractPropertyEditor
implements DocumentListener {
    private static final String ADD = "Add";
    private static final String REMOVE = "Remove";
    private JButton addButton = new JButton("Add");
    private JButton removeButton = new JButton("Remove");
    private JList listProperty = new JList(new DefaultListModel());
    private JTextField txtProperty = new JTextField();
    private boolean unique = true;

    public StringArrayPropertyEditor(String string) {
        JPanel jPanel = this.makeListPane();
        JPanel jPanel2 = this.makeButtonPane();
        this.setLayout(new BorderLayout());
        if (string.length() > 0) {
            this.add((Component)new JLabel(string), "North");
        }
        this.add(jPanel);
        this.add((Component)jPanel2, "East");
    }

    private JPanel makeEditPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.txtProperty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StringArrayPropertyEditor.this.addButton.doClick(1);
            }
        });
        this.txtProperty.getDocument().addDocumentListener(this);
        jPanel.add((Component)this.txtProperty, "South");
        return jPanel;
    }

    private JPanel makeListPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.makeEditPane(), "North");
        this.listProperty.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                StringArrayPropertyEditor.this.removeButton.setEnabled(true);
            }
        });
        jPanel.add((Component)new UScrollPane((Component)this.listProperty));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        return jPanel;
    }

    public void setUnique(boolean bl) {
        this.unique = bl;
    }

    private JPanel makeButtonPane() {
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultListModel defaultListModel = (DefaultListModel)StringArrayPropertyEditor.this.listProperty.getModel();
                if (StringArrayPropertyEditor.this.txtProperty.getText().equals("")) {
                    return;
                }
                if (StringArrayPropertyEditor.this.unique && this.alreadyInList(StringArrayPropertyEditor.this.txtProperty.getText())) {
                    ErrorMsg.displayWarning((Component)StringArrayPropertyEditor.this.getParent(), (EID)CEMC.WID_DUPLICATE_LIST_ENTRY_PARAM_1, StringArrayPropertyEditor.this.txtProperty.getText());
                    StringArrayPropertyEditor.this.txtProperty.requestFocus();
                    return;
                }
                if (StringArrayPropertyEditor.this.listProperty.getSelectedIndex() != -1) {
                    defaultListModel.add(StringArrayPropertyEditor.this.listProperty.getSelectedIndex(), StringArrayPropertyEditor.this.txtProperty.getText());
                } else {
                    defaultListModel.addElement(StringArrayPropertyEditor.this.txtProperty.getText());
                }
                StringArrayPropertyEditor.this.txtProperty.setText("");
                StringArrayPropertyEditor.this.txtProperty.requestFocus();
                StringArrayPropertyEditor.this.setDirty(true);
            }

            private boolean alreadyInList(String string) {
                for (int i = 0; i < StringArrayPropertyEditor.this.listProperty.getModel().getSize(); ++i) {
                    String string2 = (String)StringArrayPropertyEditor.this.listProperty.getModel().getElementAt(i);
                    if (!string.equals(string2)) continue;
                    return true;
                }
                return false;
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = StringArrayPropertyEditor.this.listProperty.getSelectedIndices();
                DefaultListModel defaultListModel = (DefaultListModel)StringArrayPropertyEditor.this.listProperty.getModel();
                for (int i = 0; i < nArray.length; ++i) {
                    defaultListModel.removeElementAt(nArray[i] - i);
                }
                if (nArray.length > 0) {
                    StringArrayPropertyEditor.this.removeButton.setEnabled(false);
                    StringArrayPropertyEditor.this.setDirty(true);
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 5, 10));
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        jPanel2.add(this.addButton);
        jPanel2.add(this.removeButton);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 5));
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.toggleAddButton();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.toggleAddButton();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.toggleAddButton();
    }

    private void toggleAddButton() {
        if (this.txtProperty.getText().length() > 0) {
            this.addButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(false);
        }
    }

    public void setVisibleRowCount(int n) {
        this.listProperty.setVisibleRowCount(n);
    }

    public Object getValue() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.listProperty.getModel().getSize(); ++i) {
            arrayList.add((String)this.listProperty.getModel().getElementAt(i));
        }
        return arrayList.toArray(new String[0]);
    }

    public void setValue(Object object) {
        String[] stringArray = (String[])object;
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            defaultListModel.addElement(stringArray[i]);
        }
        this.listProperty.setModel(defaultListModel);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.txtProperty.setEnabled(bl);
        this.listProperty.setEnabled(bl);
        this.addButton.setEnabled(bl);
        this.removeButton.setEnabled(bl);
    }
}

