/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.gui;

import cerent.util.SDebug;
import cerent.util.gui.AbstractPropertyEditor;
import cerent.util.gui.SpinPropertyEditor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JLabel;

public class TimePeriodPropertyEditor
extends AbstractPropertyEditor
implements PropertyChangeListener {
    private SpinPropertyEditor dayEdit;
    private SpinPropertyEditor hourEdit;
    private SpinPropertyEditor minEdit;
    private SpinPropertyEditor secEdit;
    private int maxTimePeriodInSeconds;
    private int minTimePeriodInSeconds;
    private String formatString;
    private ArrayList spinners;
    private int maxForSeconds = 0;
    private int maxForMinutes = 0;
    private int maxForHours = 0;
    private int maxForDays = 0;
    protected static final NumberFormat nf = NumberFormat.getInstance();
    public static int DEFAULT_HIGH_ORDER;
    public static int MINUTES_HIGH_ORDER;
    public static int SECONDS_HIGH_ORDER;
    public static int HOURS_HIGH_ORDER;
    public static int DAYS_HIGH_ORDER;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int SECONDS_PER_HOUR = 3600;
    public static final int SECONDS_PER_DAY = 86400;
    protected static final SDebug db;

    public TimePeriodPropertyEditor() {
        this(null, null, DEFAULT_HIGH_ORDER, 1, 0, 356400, null);
    }

    public TimePeriodPropertyEditor(String string, Dimension dimension, int n, int n2, int n3, int n4) {
        this(string, dimension, n, n2, n3, n4, null);
    }

    public TimePeriodPropertyEditor(String string, Dimension dimension, int n, int n2, int n3, int n4, Dimension dimension2) {
        if (n4 > 8553600 || n4 % n2 != 0 || n3 % n2 != 0 || n4 <= n3 || n2 >= n4 || n4 <= 0 || n2 <= 0) {
            db.severe("Reverting to defaults: cannot handle step of " + n2 + " and max of " + n4);
            n2 = 1;
            n3 = 0;
            n4 = 356400;
            n = DEFAULT_HIGH_ORDER;
        }
        db.info("Time period step of " + n2 + ",  max of " + n4);
        this.maxTimePeriodInSeconds = n4;
        this.minTimePeriodInSeconds = 0;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (n2 >= 1 && n2 < 60) {
            bl = true;
            n7 = n2;
            n5 = 1;
            n6 = 1;
            n8 = 1;
            db.info("Low order is seconds (step of " + n2 + ")");
        } else if (n2 >= 60 && n2 < 3600) {
            bl2 = true;
            n8 = n2 / 60;
            n5 = 1;
            n6 = 1;
            db.info("Low order is minutes (step of " + n2 + ")");
        } else if (n2 >= 3600 && n2 < 86400) {
            bl3 = true;
            n6 = n2 / 3600;
            n5 = 1;
            db.info("Low order is hours (step of " + n2 + ")");
        } else if (n2 >= 86400 && n2 <= 8553600) {
            bl4 = true;
            n5 = n2 / 86400;
            db.info("Low order is days (step of " + n2 + ")");
        } else {
            db.severe("Low order is invalid (step of " + n2 + ")");
            bl = true;
            n5 = 1;
            n6 = 1;
            n8 = 1;
            n7 = 1;
        }
        if (n4 >= 86400) {
            bl4 = true;
            this.maxForDays = n4 / 86400;
            db.info("High order is days (max of " + n4 + ")");
        } else if (n4 >= 3600) {
            bl3 = true;
            this.maxForHours = n4 / 3600;
            db.info("High order is hours (max of " + n4 + ")");
        } else if (n4 >= 60) {
            bl2 = true;
            this.maxForMinutes = n4 / 60;
            db.info("High order is minutes (max of " + n4 + ")");
        } else if (n4 > 0) {
            bl = true;
            this.maxForSeconds = n4;
            db.info("High order is seconds (max of " + n4 + ")");
        } else {
            db.severe("High order is invalid (max of " + n4 + ")");
            bl = true;
            this.maxForSeconds = 60;
        }
        if (n != DEFAULT_HIGH_ORDER) {
            if (bl4 && n < DAYS_HIGH_ORDER) {
                bl4 = false;
                bl3 = true;
                this.maxForHours += this.maxForDays * 24;
            }
            if (bl3 && n < HOURS_HIGH_ORDER) {
                db.info("Shifting to non-default high order of minutes");
                bl3 = false;
                bl2 = true;
                this.maxForMinutes += this.maxForHours * 60;
            }
            if (bl2 && n < MINUTES_HIGH_ORDER) {
                db.info("Shifting to non-default high order of minutes");
                bl2 = false;
                bl = true;
                this.maxForSeconds += this.maxForMinutes * 60;
            }
        }
        this.formatString = "";
        if (bl4 && bl) {
            bl3 = true;
            bl2 = true;
            this.maxForHours = 24 - n6;
            this.maxForMinutes = 60 - n8;
            this.maxForSeconds = 60 - n7;
            this.formatString = "(D:H:M:S)";
        } else if (bl4 && bl2) {
            bl3 = true;
            this.maxForHours = 24 - n6;
            this.maxForMinutes = 60 - n8;
            this.formatString = "(D:H:M)";
        } else if (bl4 && bl3) {
            this.maxForHours = 24 - n6;
            this.formatString = "(D:H)";
        } else if (bl3 && bl) {
            bl2 = true;
            this.maxForMinutes = 60 - n8;
            this.maxForSeconds = 60 - n7;
            this.formatString = "(H:M:S)";
        } else if (bl3 && bl2) {
            this.maxForMinutes = 60 - n8;
            this.formatString = "(H:M)";
        } else if (bl2 && bl) {
            this.formatString = "(M:S)";
            this.maxForSeconds = 60 - n7;
        } else if (bl) {
            this.formatString = "(S)";
        } else if (bl2) {
            this.formatString = "(M)";
        } else if (bl3) {
            this.formatString = "(H)";
        } else if (bl4) {
            this.formatString = "(D)";
        }
        int n9 = 0;
        if (bl4) {
            ++n9;
        }
        if (bl3) {
            ++n9;
        }
        if (bl2) {
            ++n9;
        }
        if (bl) {
            ++n9;
        }
        this.spinners = new ArrayList(n9);
        this.setLayout(new FlowLayout(0, 0, 0));
        if (string != null && string.length() > 0) {
            JLabel jLabel = new JLabel(string);
            if (dimension != null) {
                jLabel.setPreferredSize(dimension);
            }
            this.add(jLabel);
        }
        if (bl4) {
            this.dayEdit = this.makeNewSpinner(n5, 0, this.maxForDays, n9, dimension2);
        }
        if (bl3) {
            this.hourEdit = this.makeNewSpinner(n6, 0, this.maxForHours, n9, dimension2);
        }
        if (bl2) {
            this.minEdit = this.makeNewSpinner(n8, 0, this.maxForMinutes, n9, dimension2);
        }
        if (bl) {
            this.secEdit = this.makeNewSpinner(n7, 0, this.maxForSeconds, n9, dimension2);
        }
        if (string != null && string.length() > 0) {
            this.add(new JLabel(" " + this.formatString));
        }
        db.info("<init> " + this.formatString + " days: " + bl4 + " hours:" + bl3 + " minutes:" + bl2 + " seconds:" + bl + " spinners: " + n9);
    }

    private SpinPropertyEditor makeNewSpinner(int n, int n2, int n3, int n4, Dimension dimension) {
        db.fine("Making spinner " + n + " " + n2 + " " + n3);
        SpinPropertyEditor spinPropertyEditor = new SpinPropertyEditor("", n, n2, n3);
        spinPropertyEditor.setEditorSize(2);
        if (dimension != null) {
            spinPropertyEditor.setPreferredSize(dimension);
        }
        this.spinners.add(spinPropertyEditor);
        this.add(spinPropertyEditor);
        if (this.spinners.size() < n4) {
            this.add(new JLabel(" : "));
        }
        return spinPropertyEditor;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        for (int i = 0; i < this.spinners.size(); ++i) {
            SpinPropertyEditor spinPropertyEditor = (SpinPropertyEditor)this.spinners.get(i);
            spinPropertyEditor.addPropertyChangeListener(this);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        for (int i = 0; i < this.spinners.size(); ++i) {
            SpinPropertyEditor spinPropertyEditor = (SpinPropertyEditor)this.spinners.get(i);
            spinPropertyEditor.removePropertyChangeListener(this);
        }
        super.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean onValidate() {
        SpinPropertyEditor spinPropertyEditor;
        boolean bl = false;
        for (int i = 0; i < this.spinners.size() && !(bl |= (spinPropertyEditor = (SpinPropertyEditor)this.spinners.get(i)).onValidate()); ++i) {
        }
        return bl;
    }

    private String presto(SpinPropertyEditor spinPropertyEditor) {
        String string = (String)spinPropertyEditor.getValue();
        db.info("Spe string length of >" + string + "< is " + string.length());
        if (string != null && string.length() > 0) {
            try {
                return nf.format(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                db.severe(">" + string + "<=>" + numberFormatException.toString());
                SDebug.printStackTrace((Throwable)numberFormatException);
            }
        } else {
            db.info("blank spe encountered!Seems harmless, but causes NumberFormatException");
        }
        return "00";
    }

    public Object getValue() {
        StringBuffer stringBuffer = new StringBuffer();
        SpinPropertyEditor spinPropertyEditor = (SpinPropertyEditor)this.spinners.get(0);
        stringBuffer.append(this.presto(spinPropertyEditor));
        for (int i = 1; i < this.spinners.size(); ++i) {
            spinPropertyEditor = (SpinPropertyEditor)this.spinners.get(i);
            stringBuffer.append(":").append(this.presto(spinPropertyEditor));
        }
        stringBuffer.append(" ").append(this.formatString);
        db.info("getValue()=>" + stringBuffer.toString());
        return stringBuffer.toString();
    }

    public void setValue(int n) {
        db.info("setValue(" + n + ")");
        if (n > this.maxTimePeriodInSeconds) {
            db.info("changing " + n + " to min " + this.minTimePeriodInSeconds);
            n = this.minTimePeriodInSeconds;
        }
        int n2 = n / 86400;
        int n3 = (n %= 86400) / 3600;
        int n4 = (n %= 3600) / 60;
        int n5 = n % 60;
        db.info("setValue => " + n2 + "d " + n3 + "h " + n4 + "m " + n5 + "s");
        if (this.dayEdit != null) {
            this.dayEdit.setValue(String.valueOf(n2));
        }
        if (this.hourEdit != null) {
            if (n3 > this.hourEdit.getMax()) {
                this.hourEdit.setMax(this.maxForHours);
            }
            this.hourEdit.setValue(String.valueOf(n3));
        }
        if (this.minEdit != null) {
            if (n4 > this.minEdit.getMax()) {
                this.minEdit.setMax(this.maxForMinutes);
            }
            this.minEdit.setValue(String.valueOf(n4));
        }
        if (this.secEdit != null) {
            if (n5 > this.secEdit.getMax()) {
                this.secEdit.setMax(this.maxForSeconds);
            }
            this.secEdit.setValue(String.valueOf(n5));
        }
    }

    public void setValue(Object object) {
        try {
            if (object instanceof String) {
                this.setValue(TimePeriodPropertyEditor.toIntValue((String)object));
            } else if (object instanceof Integer) {
                this.setValue((Integer)object);
            } else {
                db.severe("Unexpected class " + object.getClass().getName());
            }
        }
        catch (NumberFormatException numberFormatException) {
            db.severe(object.toString() + "=>" + numberFormatException.toString());
            SDebug.printStackTrace((Throwable)numberFormatException);
        }
    }

    public boolean isDirty() {
        boolean bl = super.isDirty();
        for (int i = 0; !bl && i < this.spinners.size(); ++i) {
            SpinPropertyEditor spinPropertyEditor = (SpinPropertyEditor)this.spinners.get(i);
            bl = spinPropertyEditor.isDirty();
        }
        return bl;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (int i = 0; i < this.spinners.size(); ++i) {
            SpinPropertyEditor spinPropertyEditor = (SpinPropertyEditor)this.spinners.get(i);
            spinPropertyEditor.setEnabled(bl);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        SpinPropertyEditor spinPropertyEditor = null;
        if (object instanceof SpinPropertyEditor) {
            int n = TimePeriodPropertyEditor.toIntValue((String)this.getValue());
            if (n > this.maxTimePeriodInSeconds) {
                int n2;
                for (n2 = this.spinners.size() - 1; n2 >= 0; --n2) {
                    spinPropertyEditor = (SpinPropertyEditor)this.spinners.get(n2);
                    if (object.equals(spinPropertyEditor)) continue;
                    spinPropertyEditor.setValue("00");
                }
                n = TimePeriodPropertyEditor.toIntValue((String)this.getValue());
                for (n2 = this.spinners.size() - 1; n2 > 0; --n2) {
                    spinPropertyEditor = (SpinPropertyEditor)this.spinners.get(n2);
                    if (object.equals(spinPropertyEditor)) continue;
                    if (spinPropertyEditor == this.hourEdit) {
                        if (n + spinPropertyEditor.getMax() * 3600 <= this.maxTimePeriodInSeconds) continue;
                        spinPropertyEditor.setMax((this.maxTimePeriodInSeconds - n) / 3600);
                        continue;
                    }
                    if (spinPropertyEditor == this.minEdit) {
                        if (n + spinPropertyEditor.getMax() * 60 <= this.maxTimePeriodInSeconds) continue;
                        spinPropertyEditor.setMax((this.maxTimePeriodInSeconds - n) / 60);
                        continue;
                    }
                    if (spinPropertyEditor != this.secEdit || n + spinPropertyEditor.getMax() <= this.maxTimePeriodInSeconds) continue;
                    spinPropertyEditor.setMax(this.maxTimePeriodInSeconds - n);
                }
            } else {
                for (int i = this.spinners.size() - 1; i >= 0; --i) {
                    spinPropertyEditor = (SpinPropertyEditor)this.spinners.get(i);
                    if (spinPropertyEditor == this.hourEdit) {
                        if (n + this.maxForHours * 3600 >= this.maxTimePeriodInSeconds) continue;
                        spinPropertyEditor.setMax(this.maxForHours);
                        continue;
                    }
                    if (spinPropertyEditor == this.minEdit) {
                        if (n + this.maxForMinutes * 60 >= this.maxTimePeriodInSeconds) continue;
                        spinPropertyEditor.setMax(this.maxForMinutes);
                        continue;
                    }
                    if (spinPropertyEditor != this.secEdit || n + this.maxForSeconds >= this.maxTimePeriodInSeconds) continue;
                    spinPropertyEditor.setMax(this.maxForSeconds);
                }
            }
            this.firePropertyChange();
        }
    }

    private static int getTimePeriodInSeconds(int n, int n2, int n3, int n4) {
        return n * 86400 + n2 * 3600 + n3 * 60 + n4;
    }

    public static int toIntValue(String string) throws NumberFormatException {
        int n = string.indexOf(40) - 1;
        String string2 = "";
        if (n > 0) {
            string2 = string.substring(n);
            string = string.substring(0, n);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "(:)");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("D")) {
                bl = true;
                continue;
            }
            if (string3.equals("H")) {
                bl2 = true;
                continue;
            }
            if (string3.equals("M")) {
                bl3 = true;
                continue;
            }
            if (!string3.equals("S")) continue;
            bl4 = true;
        }
        stringTokenizer = new StringTokenizer("0" + string, ":");
        if (!(bl || bl2 || bl3 || bl4)) {
            int n2 = stringTokenizer.countTokens();
            switch (n2) {
                case 3: {
                    bl = true;
                }
                case 2: {
                    bl2 = true;
                }
                case 1: {
                    bl3 = true;
                }
                case 0: {
                    bl4 = true;
                    break;
                }
                default: {
                    bl4 = true;
                    bl3 = true;
                    bl2 = true;
                    bl = true;
                }
            }
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        try {
            if (bl) {
                n3 = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (bl2) {
                n4 = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (bl3) {
                n5 = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (bl4) {
                n6 = Integer.parseInt(stringTokenizer.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            db.severe(noSuchElementException.toString());
        }
        return TimePeriodPropertyEditor.getTimePeriodInSeconds(n3, n4, n5, n6);
    }

    public static int getDays(int n) {
        return n / 86400;
    }

    public static int getHours(int n) {
        return n / 3600;
    }

    public static int getHoursInDay(int n) {
        return n % 86400 / 3600;
    }

    public static int getMinutes(int n) {
        return n / 60;
    }

    public static int getMinutesInHour(int n) {
        return n % 3600 / 60;
    }

    public static int getSecondsInMinute(int n) {
        return n % 60;
    }

    public static String toStringDDHHMMSS(int n) {
        return nf.format(TimePeriodPropertyEditor.getDays(n)) + ':' + nf.format(TimePeriodPropertyEditor.getHoursInDay(n)) + ':' + nf.format(TimePeriodPropertyEditor.getMinutesInHour(n)) + ':' + nf.format(TimePeriodPropertyEditor.getSecondsInMinute(n)) + " (D:H:M:S)";
    }

    public static String toStringHHMM(int n) {
        int n2 = n * 60;
        return nf.format(TimePeriodPropertyEditor.getHours(n2)) + ':' + nf.format(TimePeriodPropertyEditor.getMinutesInHour(n2)) + " (H:M)";
    }

    public static String toStringMMSS(int n) {
        return nf.format(TimePeriodPropertyEditor.getMinutes(n)) + ':' + nf.format(TimePeriodPropertyEditor.getSecondsInMinute(n)) + " (M:S)";
    }

    public String toString() {
        return (String)this.getValue();
    }

    static {
        nf.setMinimumIntegerDigits(2);
        nf.setMaximumIntegerDigits(2);
        DEFAULT_HIGH_ORDER = 0;
        MINUTES_HIGH_ORDER = 1;
        SECONDS_HIGH_ORDER = 2;
        HOURS_HIGH_ORDER = 3;
        DAYS_HIGH_ORDER = 4;
        db = new SDebug("TimePeriodPropertyEditor");
    }
}

