/*
 * Decompiled with CFR 0.152.
 */
package cerent.version;

import cerent.launcher.CmsClassLoader;
import cerent.util.SDebug;
import cerent.version.AbstractInterfaceVersion;
import cerent.version.AbstractJarBuildInformation;
import cerent.version.Compatibility;
import cerent.version.IBuildInformation;
import cerent.version.InternalLayerVersion;
import cerent.version.InvalidScopeException;

public class EleInterfaceVersion
extends AbstractInterfaceVersion {
    private static SDebug db = new SDebug("EleInterfaceVersion");
    IBuildInformation buildInformation;
    InternalLayerVersion version;
    boolean forceIncompat = false;

    public EleInterfaceVersion() {
        try {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            Class<?> clazz = classLoader.loadClass("cerent.version.AbstractJarBuildInformation");
            this.buildInformation = new EleBuildInformation();
            this.version = new InternalLayerVersion("ele", this.buildInformation);
            this.forceIncompat = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.buildInformation = null;
            this.version = new InternalLayerVersion("ele", Integer.MIN_VALUE);
            this.forceIncompat = true;
        }
    }

    public Object getVersion() {
        return this.version;
    }

    public IBuildInformation getBuildInformation() {
        return this.buildInformation;
    }

    public boolean isNewerThan(AbstractInterfaceVersion abstractInterfaceVersion) throws InvalidScopeException {
        InternalLayerVersion internalLayerVersion = (InternalLayerVersion)abstractInterfaceVersion.getVersion();
        return this.version.getLayerVersion() > internalLayerVersion.getLayerVersion();
    }

    public boolean isSameVersionAs(AbstractInterfaceVersion abstractInterfaceVersion) throws InvalidScopeException {
        InternalLayerVersion internalLayerVersion = (InternalLayerVersion)abstractInterfaceVersion.getVersion();
        return this.version.getLayerVersion() == internalLayerVersion.getLayerVersion();
    }

    public Compatibility getCompatibilityWith(AbstractInterfaceVersion abstractInterfaceVersion) {
        if (this.forceIncompat) {
            return Compatibility.FORCE_INCOMPATIBLE;
        }
        InternalLayerVersion internalLayerVersion = (InternalLayerVersion)abstractInterfaceVersion.getVersion();
        Compatibility compatibility = Compatibility.UNKNOWN;
        if (internalLayerVersion.isCoreJarFile()) {
            if (this.version.getLayerVersion() <= internalLayerVersion.getLayerVersion()) {
                compatibility = Compatibility.COMPATIBLE;
            }
        } else if (this.version.getLayerVersion() == internalLayerVersion.getLayerVersion()) {
            compatibility = Compatibility.COMPATIBLE;
        }
        db.fine("this -- " + this.version.getLayerName() + ", " + this.version.getLayerVersion());
        db.fine("other -- " + internalLayerVersion.getLayerName() + ", " + internalLayerVersion.getLayerVersion());
        return compatibility;
    }

    public String getSwVersion() {
        return ((CmsClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getSwVersion();
    }

    private final class EleBuildInformation
    extends AbstractJarBuildInformation {
        public EleBuildInformation() {
            super("element");
        }
    }
}

