/*
 * Decompiled with CFR 0.152.
 */
package cerent.version;

import cerent.launcher.CtcHttpRetriever;
import cerent.util.SDebug;
import cerent.version.AbstractInterfaceVersion;
import cerent.version.Compatibility;
import cerent.version.IBuildInformation;
import cerent.version.InternalLayerVersion;
import cerent.version.InvalidScopeException;
import cerent.version.Ngrp;
import java.io.IOException;
import java.util.Date;

public final class NeProxyInterfaceVersion
extends AbstractInterfaceVersion {
    private static SDebug db = new SDebug("NeInterfaceVersion");
    private String host = null;
    private IBuildInformation buildInformation = new NeProxyBuildInformation();

    public NeProxyInterfaceVersion() {
    }

    public NeProxyInterfaceVersion(String string) {
        this();
        this.setHost(string);
    }

    public void setHost(String string) {
        this.host = string;
    }

    public String getHost() {
        return this.host;
    }

    public IBuildInformation getBuildInformation() {
        return this.buildInformation;
    }

    public String retrieveNetworkElementType() throws IllegalArgumentException, IOException {
        if (this.host == null) {
            throw new IllegalArgumentException("Host name is not set.");
        }
        return CtcHttpRetriever.getNeType((String)this.host);
    }

    private String retrieveSwVersion() throws IllegalArgumentException, IOException {
        if (this.host == null) {
            throw new IllegalArgumentException("Host name is not set.");
        }
        return CtcHttpRetriever.getSwVersion((String)this.host);
    }

    private String retrieveApiVersion() throws IllegalArgumentException, IOException {
        if (this.host == null) {
            throw new IllegalArgumentException("Host name is not set.");
        }
        return CtcHttpRetriever.getApiVersion((String)this.host);
    }

    public String getApiVersion() {
        String string;
        try {
            string = this.retrieveApiVersion();
        }
        catch (Exception exception) {
            string = null;
        }
        if (string == null) {
            try {
                string = this.retrieveSwVersion();
            }
            catch (Exception exception) {
                string = null;
            }
        }
        return string;
    }

    public String getSwVersion() {
        String string;
        try {
            string = this.retrieveSwVersion();
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public Object getVersion() {
        int n;
        if (this.host == null) {
            return new InternalLayerVersion("ne", -1);
        }
        String string = this.getApiVersion();
        if (string != null) {
            String string2 = string.substring(0, 2) + string.substring(3, 5);
            n = Integer.valueOf(string2);
        } else {
            n = -1;
        }
        return new InternalLayerVersion("ne", n);
    }

    public Compatibility getCompatibilityWith(AbstractInterfaceVersion abstractInterfaceVersion) {
        InternalLayerVersion internalLayerVersion = (InternalLayerVersion)abstractInterfaceVersion.getVersion();
        InternalLayerVersion internalLayerVersion2 = (InternalLayerVersion)this.getVersion();
        Compatibility compatibility = Compatibility.INCOMPATIBLE;
        if (internalLayerVersion2.getLayerVersion() == -1) {
            compatibility = this.host == null ? Compatibility.UNKNOWN : Compatibility.COMPATIBLE;
        } else if (internalLayerVersion2.getLayerVersion() == internalLayerVersion.getLayerVersion()) {
            compatibility = Compatibility.COMPATIBLE;
        }
        db.fine("this -- " + internalLayerVersion2.getLayerName() + ", " + internalLayerVersion2.getLayerVersion());
        db.fine("other -- " + internalLayerVersion.getLayerName() + ", " + internalLayerVersion.getLayerVersion());
        return compatibility;
    }

    public boolean isNewerThan(AbstractInterfaceVersion abstractInterfaceVersion) throws InvalidScopeException {
        boolean bl = true;
        if (abstractInterfaceVersion != null) {
            if (!this.getBuildInformation().getBranchPath().equals(abstractInterfaceVersion.getBuildInformation().getBranchPath())) {
                throw new InvalidScopeException(this.getBuildInformation().getBranchPath());
            }
            bl = this.getBuildInformation().getTimeStamp() > abstractInterfaceVersion.getBuildInformation().getTimeStamp();
        }
        return bl;
    }

    public boolean isSameVersionAs(AbstractInterfaceVersion abstractInterfaceVersion) throws InvalidScopeException {
        boolean bl = false;
        if (abstractInterfaceVersion != null) {
            if (!this.getBuildInformation().getBranchPath().equals(abstractInterfaceVersion.getBuildInformation().getBranchPath())) {
                throw new InvalidScopeException(this.getBuildInformation().getBranchPath());
            }
            bl = this.getVersion().equals(abstractInterfaceVersion.getVersion());
        }
        return bl;
    }

    public int hashCode() {
        int n = 13;
        if (this.host != null) {
            n *= this.host.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof NeProxyInterfaceVersion) {
            NeProxyInterfaceVersion neProxyInterfaceVersion = (NeProxyInterfaceVersion)((Object)object);
            bl = this.getBuildInformation().equals(neProxyInterfaceVersion.getBuildInformation()) && (this.host == null ? this.host == neProxyInterfaceVersion.getHost() : this.host.equals(neProxyInterfaceVersion.getHost()));
        }
        return bl;
    }

    private class NeProxyBuildInformation
    implements IBuildInformation {
        private NeProxyBuildInformation() {
        }

        public String getSourceType() {
            return null;
        }

        public long getTimeStamp() {
            return Long.MIN_VALUE;
        }

        public Date getDate() {
            return null;
        }

        public String getBranchPath() {
            return null;
        }

        public Ngrp getNgrp() {
            return null;
        }
    }
}

