/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc454.model;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.AbstractSlotPolicy;
import cerent.cms.model.EntityModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SlotModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SlotPolicy
extends AbstractSlotPolicy {
    private NodeModelDelegate _node;

    public SlotPolicy(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate);
        this._node = nodeModelDelegate;
    }

    protected void initSlotMap() {
        this.addCardToMap(this.DSN_GROUP, eEqType.DS1_LINE_CARD);
        this.addCardToMap(this.DSN_GROUP, eEqType.DS3_LINE_CARD);
        this.addCardToMap(this.DSN_GROUP, eEqType.DS3E_LINE_CARD);
        this.addCardToMap(this.DSN_GROUP, eEqType.DS3I_LINE_CARD);
        this.addCardToMap(this.DSN_GROUP, eEqType.DS3XM_LINE_CARD);
        this.addCardToMap(this.DSN_GROUP, eEqType.DS3XM12_LINE_CARD);
        this.addCardToMap(TOP_LEVEL, eEqType.EC1_LINE_CARD);
        this.addCardToMap(this.ETH_GROUP, eEqType.EPOS_100_LINE_CARD);
        this.addCardToMap(this.ETH_GROUP, eEqType.EPOS_1000_LINE_CARD);
        this.addCardToMap(this.ETH_GROUP, eEqType.G1000_LINE_CARD);
        this.addCardToMap(this.ETH_GROUP, eEqType.ML2_EXIGE_MAPPER_CARD);
        this.addCardToMap(this.OCN_GROUP, eEqType.OC3_LINE_CARD);
        this.addCardToMap(this.OCN_GROUP, eEqType.OC12_LINE_CARD);
        this.addMenuToMap(this.DWDM_FAMILY, this.WDM_GROUP);
        this.addCardToMap(this.DWDM_FAMILY, this.WDM_GROUP, eEqType.TXP_MR_2_5G_LINE_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.WDM_GROUP, eEqType.TXPP_MR_2_5G_LINE_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.WDM_GROUP, eEqType.TXP_MR_10G_LINE_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.WDM_GROUP, eEqType.TXP_MR_10E_LINE_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.WDM_GROUP, eEqType.MXP_2_5G_10G_LINE_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.WDM_GROUP, eEqType.MXP_2_5G_10E_LINE_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.WDM_GROUP, eEqType.MXP_MR_2_5G_LINE_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.WDM_GROUP, eEqType.MXPP_MR_2_5G_LINE_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.OADM_GROUP, eEqType.AD_1C_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.OADM_GROUP, eEqType.AD_2C_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.OADM_GROUP, eEqType.AD_4C_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.OADM_GROUP, eEqType.AD_1B_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.OADM_GROUP, eEqType.AD_4B_CARD);
        this.addCardToMap(this.DWDM_FAMILY, "TOP_LEVEL", eEqType.OSC_CSM_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.AMPLI_GROUP, eEqType.OPT_PRE);
        this.addCardToMap(this.DWDM_FAMILY, this.AMPLI_GROUP, eEqType.OPT_BST);
        this.addCardToMap(this.DWDM_FAMILY, this.AMPLI_GROUP, eEqType.OPT_BST_E);
        this.addMenuToMap(this.DWDM_FAMILY, this.MD_GROUP);
        this.addCardToMap(this.DWDM_FAMILY, this.MD_GROUP, eEqType.MUX32_O_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.MD_GROUP, eEqType.DMX32_O_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.MD_GROUP, eEqType.MUX_DMX4_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.MD_GROUP, eEqType.DMX32_R_CARD);
        this.addCardToMap(this.DWDM_FAMILY, this.MD_GROUP, eEqType.WSS_32_CARD);
    }

    public Map getMapOfValidModules(SlotModel slotModel) {
        HashMap hashMap = new HashMap();
        switch (slotModel.getEqType()) {
            case 24: {
                hashMap.put(eEqType.AIC_CARD, null);
                hashMap.put(eEqType.AICI_CARD, null);
                break;
            }
            case 22: {
                hashMap.put(eEqType.TCC_CARD, null);
                break;
            }
            case 21: {
                hashMap.putAll(this.getIoSlotEqMap(slotModel));
                break;
            }
            case 23: {
                if (this.hasEqType(slotModel, eEqType.XC_CARD)) {
                    hashMap.put(eEqType.XC_CARD, null);
                    hashMap.put(eEqType.OSCM_CARD, null);
                    break;
                }
                if (this.hasEqType(slotModel, eEqType.XCVT_CARD)) {
                    hashMap.put(eEqType.XCVT_CARD, null);
                    break;
                }
                if (this.hasEqType(slotModel, eEqType.XC192_CARD)) {
                    hashMap.put(eEqType.XC192_CARD, null);
                    break;
                }
                if (this.hasEqType(slotModel, eEqType.OC3_8_LINE_CARD) || this.hasEqType(slotModel, eEqType.STM1E_12_LINE_CARD) || this.hasEqType(slotModel, eEqType.L2SC_100_LINE_CARD) || this.hasEqType(slotModel, eEqType.L2SC_GIG_LINE_CARD) || this.hasOc48As(slotModel)) {
                    hashMap.put(eEqType.XC192_CARD, null);
                    break;
                }
                if (this.hasEqType(slotModel, eEqType.OC12_LINE_CARD) || this.hasEqType(slotModel, eEqType.OC48_LINE_CARD) || this.hasEqType(slotModel, eEqType.EPOS_100_LINE_CARD) || this.hasEqType(slotModel, eEqType.EPOS_1000_LINE_CARD) || this.hasEqType(slotModel, eEqType.DS1_LINE_CARD) || this.hasEqType(slotModel, eEqType.DS1N_LINE_CARD) || this.hasEqType(slotModel, eEqType.DS3_LINE_CARD) || this.hasEqType(slotModel, eEqType.DS3E_LINE_CARD) || this.hasEqType(slotModel, eEqType.DS3_EC1_48_LINE_CARD) || this.hasEqType(slotModel, eEqType.DS3I_LINE_CARD) || this.hasEqType(slotModel, eEqType.DS3IN_LINE_CARD) || this.hasEqType(slotModel, eEqType.DS3N_LINE_CARD) || this.hasEqType(slotModel, eEqType.DS3NE_LINE_CARD) || this.hasEqType(slotModel, eEqType.DS3XM_LINE_CARD) || this.hasEqType(slotModel, eEqType.EC1_LINE_CARD) || this.hasEqType(slotModel, eEqType.EC1N_LINE_CARD) || this.hasEqType(slotModel, eEqType.L2SC_100_LINE_CARD)) {
                    hashMap.put(eEqType.XC_CARD, null);
                    hashMap.put(eEqType.XCVT_CARD, null);
                    hashMap.put(eEqType.XC192_CARD, null);
                    break;
                }
                hashMap.put(eEqType.XC_CARD, null);
                hashMap.put(eEqType.XCVT_CARD, null);
                hashMap.put(eEqType.XC192_CARD, null);
                hashMap.put(eEqType.OSCM_CARD, null);
                break;
            }
            default: {
                hashMap.put(eEqType.INVALID, null);
            }
        }
        return hashMap;
    }

    private Map getIoSlotEqMap(SlotModel slotModel) {
        int n = slotModel.getSlot();
        if (this.isLowSpeedSlot(n)) {
            return this.getLowSpeedSlotModuleMap(slotModel);
        }
        if (this.isLowSpeedProtectSlot(n)) {
            return this.getLowSpeedProtectSlotModuleMap(slotModel);
        }
        if (this.isHighSpeedSlot(n)) {
            return this.getHighSpeedSlotModuleMap(slotModel);
        }
        HashMap<eEqType, Object> hashMap = new HashMap<eEqType, Object>();
        hashMap.put(eEqType.INVALID, null);
        return hashMap;
    }

    private Map getLowSpeedSlotModuleMap(SlotModel slotModel) {
        Map map = this.deepCopyMap(this.slotMap);
        int n = slotModel.getSlot();
        if (this.isXc10gCapable(slotModel)) {
            String string;
            Set set = null;
            if (n == 1 || n == 2 || n == 16 || n == 17) {
                set = this.getSetForMenu(this.DSN_GROUP, map);
                if (set != null) {
                    if (this.hasEqType(slotModel, eEqType.BACKPLANE_454_HD)) {
                        set.add(eEqType.DS3_EC1_48_LINE_CARD);
                    }
                } else {
                    string = this.getFamilyMenu(this.DSN_GROUP, map);
                    if (this.hasEqType(slotModel, eEqType.BACKPLANE_454_HD)) {
                        this.addCard(string, this.DSN_GROUP, eEqType.DS3_EC1_48_LINE_CARD, map);
                    }
                }
            }
            if ((set = this.getSetForMenu(this.OCN_GROUP, map)) != null) {
                set.add(eEqType.OC3_8_LINE_CARD);
                set.add(eEqType.OC12_4_LINE_CARD);
                set.add(eEqType.OC48_LINE_CARD);
            } else {
                string = this.getFamilyMenu(this.OCN_GROUP, map);
                this.addCard(string, this.OCN_GROUP, eEqType.OC3_8_LINE_CARD, map);
                this.addCard(string, this.OCN_GROUP, eEqType.OC12_4_LINE_CARD, map);
                this.addCard(string, this.OCN_GROUP, eEqType.OC48_LINE_CARD, map);
                this.addCard(string, this.OCN_GROUP, eEqType.OC3_LINE_CARD, map);
                this.addCard(string, this.OCN_GROUP, eEqType.OC12_LINE_CARD, map);
            }
            set = this.getSetForMenu(this.ETH_GROUP, map);
            if (set != null) {
                set.add(eEqType.L2SC_100_LINE_CARD);
                set.add(eEqType.L2SC_GIG_LINE_CARD);
            } else {
                string = this.getFamilyMenu(this.ETH_GROUP, map);
                this.addCard(string, this.ETH_GROUP, eEqType.L2SC_100_LINE_CARD, map);
                this.addCard(string, this.ETH_GROUP, eEqType.L2SC_GIG_LINE_CARD, map);
                this.addCard(string, this.ETH_GROUP, eEqType.EPOS_100_LINE_CARD, map);
                this.addCard(string, this.ETH_GROUP, eEqType.EPOS_1000_LINE_CARD, map);
                this.addCard(string, this.ETH_GROUP, eEqType.G1000_LINE_CARD, map);
                this.addCardToMap(this.ETH_GROUP, eEqType.ML2_EXIGE_MAPPER_CARD);
            }
            map.put(eEqType.FCMR_LINE_CARD, null);
        }
        return map;
    }

    private Map getLowSpeedProtectSlotModuleMap(SlotModel slotModel) {
        Map map = this.deepCopyMap(this.getLowSpeedSlotModuleMap(slotModel));
        Set set = this.getSetForMenu(this.DSN_GROUP, map);
        if (set != null) {
            set.remove(eEqType.DS3I_LINE_CARD);
            set.add(eEqType.DS1N_LINE_CARD);
            set.add(eEqType.DS3IN_LINE_CARD);
            set.add(eEqType.DS3N_LINE_CARD);
            set.add(eEqType.DS3NE_LINE_CARD);
            if (this.isXc10gCapable(slotModel) && this.hasEqType(slotModel, eEqType.BACKPLANE_454_HD)) {
                set.add(eEqType.DS3_EC1_48_LINE_CARD);
            }
        } else {
            String string = this.getFamilyMenu(this.DSN_GROUP, map);
            this.addCard(string, this.DSN_GROUP, eEqType.DS1N_LINE_CARD, map);
            this.addCard(string, this.DSN_GROUP, eEqType.DS3N_LINE_CARD, map);
            this.addCard(string, this.DSN_GROUP, eEqType.DS3NE_LINE_CARD, map);
            this.addCard(string, this.DSN_GROUP, eEqType.DS1_LINE_CARD, map);
            this.addCard(string, this.DSN_GROUP, eEqType.DS3_LINE_CARD, map);
            this.addCard(string, this.DSN_GROUP, eEqType.DS3E_LINE_CARD, map);
            this.addCard(string, this.DSN_GROUP, eEqType.DS3XM_LINE_CARD, map);
            this.addCard(string, this.DSN_GROUP, eEqType.DS3XM12_LINE_CARD, map);
            if (this.isXc10gCapable(slotModel) && this.hasEqType(slotModel, eEqType.BACKPLANE_454_HD)) {
                this.addCard(string, this.DSN_GROUP, eEqType.DS3_EC1_48_LINE_CARD, map);
            }
        }
        return map;
    }

    private Map getHighSpeedSlotModuleMap(SlotModel slotModel) {
        Map map = this.deepCopyMap(this.slotMap);
        String string = null;
        Set set = this.getSetForMenu(this.OCN_GROUP, map);
        if (set != null) {
            set.add(eEqType.OC48_LINE_CARD);
        } else {
            string = this.getFamilyMenu(this.OCN_GROUP, map);
            this.addCard(string, this.OCN_GROUP, eEqType.OC48_LINE_CARD, map);
            this.addCard(string, this.OCN_GROUP, eEqType.OC3_LINE_CARD, map);
            this.addCard(string, this.OCN_GROUP, eEqType.OC12_LINE_CARD, map);
        }
        if (this.isXc10gCapable(slotModel)) {
            if (set != null) {
                set.add(eEqType.OC192_LINE_CARD);
            } else {
                string = this.getFamilyMenu(this.OCN_GROUP, map);
                this.addCard(string, this.OCN_GROUP, eEqType.OC192_LINE_CARD, map);
                this.addCard(string, this.OCN_GROUP, eEqType.OC48_LINE_CARD, map);
                this.addCard(string, this.OCN_GROUP, eEqType.OC3_LINE_CARD, map);
                this.addCard(string, this.OCN_GROUP, eEqType.OC12_LINE_CARD, map);
            }
        }
        if ((set = this.getSetForMenu(this.ETH_GROUP, map)) != null) {
            set.add(eEqType.L2SC_100_LINE_CARD);
            set.add(eEqType.L2SC_GIG_LINE_CARD);
        } else {
            string = this.getFamilyMenu(this.ETH_GROUP, map);
            this.addCard(string, this.ETH_GROUP, eEqType.L2SC_100_LINE_CARD, map);
            this.addCard(string, this.ETH_GROUP, eEqType.L2SC_GIG_LINE_CARD, map);
            this.addCard(string, this.ETH_GROUP, eEqType.EPOS_100_LINE_CARD, map);
            this.addCard(string, this.ETH_GROUP, eEqType.EPOS_1000_LINE_CARD, map);
            this.addCard(string, this.ETH_GROUP, eEqType.G1000_LINE_CARD, map);
            this.addCardToMap(this.ETH_GROUP, eEqType.ML2_EXIGE_MAPPER_CARD);
        }
        map.put(eEqType.FCMR_LINE_CARD, null);
        return map;
    }

    private boolean isOkToCheckOC192() {
        EntityModel entityModel = (EntityModel)this._node.getEntityTableModel().getChassis();
        if (entityModel == null) {
            return false;
        }
        return entityModel.getDescendantsOfType(eEqType.XCVXL25G_CARD).size() <= 0;
    }

    public List getListOfValidUpgradeType(SlotModel slotModel, int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Map map = this.getMapOfValidModules(slotModel);
        if (n == 10) {
            if (this.eqTypeInMap(map, eEqType.OC12_4_LINE_CARD)) {
                arrayList.add(new Integer(85));
            }
            if (this.eqTypeInMap(map, eEqType.OC48_LINE_CARD)) {
                arrayList.add(new Integer(11));
            }
            if (this.isOkToCheckOC192() && this.eqTypeInMap(map, eEqType.OC192_LINE_CARD)) {
                arrayList.add(new Integer(60));
            }
        } else if (n == 11 && this.isOkToCheckOC192() && this.eqTypeInMap(map, eEqType.OC192_LINE_CARD)) {
            arrayList.add(new Integer(60));
        }
        return arrayList;
    }

    public List getListOfValidChangeType(SlotModel slotModel, eEqType eEqType2) {
        ArrayList arrayList = new ArrayList();
        if (eEqType2 == eEqType.OC12_LINE_CARD || eEqType2 == eEqType.OC12_4_LINE_CARD || eEqType2 == eEqType.OC3_8_LINE_CARD || eEqType2 == eEqType.OC3_LINE_CARD || eEqType2 == eEqType.OC48_LINE_CARD || eEqType2 == eEqType.OC192_LINE_CARD || eEqType2 == eEqType.DS3NE_LINE_CARD || eEqType2 == eEqType.DS3E_LINE_CARD || eEqType2 == eEqType.DS3N_LINE_CARD || eEqType2 == eEqType.DS3_LINE_CARD || eEqType2 == eEqType.DS3_EC1_48_LINE_CARD || eEqType2 == eEqType.DS3XM_LINE_CARD || eEqType2 == eEqType.DS3XM12_LINE_CARD) {
            Map map = this.getMapOfValidModules(slotModel);
            if (eEqType2 == eEqType.OC3_8_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.OC3_LINE_CARD, eEqType2, arrayList);
            } else if (eEqType2 == eEqType.OC3_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.OC3_8_LINE_CARD, eEqType2, arrayList);
            } else if (eEqType2 == eEqType.OC12_4_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.OC12_LINE_CARD, eEqType2, arrayList);
            } else if (eEqType2 == eEqType.OC12_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.OC12_4_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.OC48_LINE_CARD, eEqType2, arrayList);
                if (this.isOkToCheckOC192()) {
                    this.addToChangeTypeList(map, eEqType.OC192_LINE_CARD, eEqType2, arrayList);
                }
            } else if (eEqType2 == eEqType.DS3_LINE_CARD || eEqType2 == eEqType.DS3E_LINE_CARD || eEqType2 == eEqType.DS3N_LINE_CARD || eEqType2 == eEqType.DS3NE_LINE_CARD || eEqType2 == eEqType.DS3_EC1_48_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.DS3_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.DS3E_LINE_CARD, eEqType2, arrayList);
                if (this.hasEqType(slotModel, eEqType.BACKPLANE_454_HD)) {
                    this.addToChangeTypeList(map, eEqType.DS3_EC1_48_LINE_CARD, eEqType2, arrayList);
                }
                this.addToChangeTypeList(map, eEqType.DS3N_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.DS3NE_LINE_CARD, eEqType2, arrayList);
            } else if (eEqType2 == eEqType.DS3N_LINE_CARD || eEqType2 == eEqType.DS3NE_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.DS3N_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.DS3NE_LINE_CARD, eEqType2, arrayList);
            } else if (eEqType2 == eEqType.DS3XM_LINE_CARD || eEqType2 == eEqType.DS3XM12_LINE_CARD) {
                this.addToChangeTypeList(map, eEqType.DS3XM_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.DS3XM12_LINE_CARD, eEqType2, arrayList);
            } else {
                this.addToChangeTypeList(map, eEqType.OC12_LINE_CARD, eEqType2, arrayList);
                this.addToChangeTypeList(map, eEqType.OC48_LINE_CARD, eEqType2, arrayList);
                if (this.isOkToCheckOC192()) {
                    this.addToChangeTypeList(map, eEqType.OC192_LINE_CARD, eEqType2, arrayList);
                }
            }
        }
        return arrayList;
    }

    public boolean needDs1Ifs(int n) {
        return n == 4 || n == 5;
    }

    private boolean isXc10gCapable(SlotModel slotModel) {
        return this.hasEqType(slotModel, eEqType.XC192_CARD) || !this.hasEqType(slotModel, eEqType.XCVT_CARD) && !this.hasEqType(slotModel, eEqType.XC_CARD);
    }

    public static boolean isComboPort(int n) {
        return false;
    }
}

