/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc454.ui.ds3xm12;

import cerent.cms.model.Ds123ModuleModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UScrollPane;
import com.cisco.ctc454.ui.ds3xm12.Ds3xm12CardMtcTableModel;
import java.awt.Component;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class Ds3xm12CardMtcPane
extends NodeProvPane
implements TableModelListener {
    protected ModuleModel model = null;
    protected Ds3xm12CardMtcTableModel dataModel;
    protected int numLines;
    protected int thresholdLayer;
    protected static final SDebug db = new SDebug("Ds3xm12CardMtcPane");

    public Ds3xm12CardMtcPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.model = (Ds123ModuleModel)tabbedView.getUiModel();
        this.init();
    }

    protected void init() {
        this.dataModel = this.getDataModel(this.thresholdLayer);
        this.dataModel.addTableModelListener(this);
        this.table = new JTable(this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        TableColumn tableColumn = this.table.getColumn(Ds3xm12CardMtcTableModel.columnNames[0]);
        tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxForBackplane()));
        tableColumn.setPreferredWidth(90);
        this.registerWithModel();
        this.add((Component)uScrollPane, "Center");
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
        this.table.setAutoResizeMode(0);
    }

    protected void registerWithModel() {
        if (this.model != null) {
            this.model.addObserver((Observer)((Object)this));
        }
    }

    protected JComboBox getComboBoxForBackplane() {
        JComboBox<String> jComboBox = new JComboBox<String>(this.dataModel.getBackplaneStrings());
        jComboBox.setEditable(false);
        return jComboBox;
    }

    public void dispose() {
        if (this.model != null) {
            this.model.deleteObserver((Observer)((Object)this));
        }
    }

    public void leavingPage() throws Exception {
        if (this.table != null) {
            TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        }
        super.leavingPage();
    }

    public void enteringPage() throws Exception {
        this.dataModel.refreshFromModel();
    }

    public void refreshFromModel() throws Exception {
        this.dataModel.refreshFromReset();
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.destroy();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer && ((Integer)object).equals(ModelUpdateType.CHANGED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.dataModel.fireTableDataChanged();
            this.requestRefresh(observable, this.getRefreshThread(observable));
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                Ds3xm12CardMtcPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        block2: {
            try {
                this.dataModel.refreshLineFromModel(0);
            }
            catch (Exception exception) {
                ErrorMsg.displayDetailed((Component)((Object)this), EMC.EID_FAIL_REFRESH_ROW_PARAM_1, "1", exception.toString());
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void applyChangesToModel() throws Exception {
        String string = "WARNING:  Backplane upgrades may cause\ntraffic hits of greater than 50ms.\n\nDo you want to Continue?";
        String string2 = "Backplane Rate Change";
        if (CerentDialog.yesNoDialog((Component)((Object)this), (String)string, (String)string2)) {
            this.dataModel.applyToModel();
            this.resetDirty();
        } else {
            this.refresh();
        }
    }

    protected Ds3xm12CardMtcTableModel getDataModel(int n) {
        return new Ds3xm12CardMtcTableModel(this.model, n);
    }

    public String getHelpIDString() {
        return "Ds3xm12CardMtcPane";
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.Ds3xm12CardMtcPane;
    }
}

