/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc454.ui.ds3xm12;

import cerent.cms.idl.Equipment.eBackPlaneRate;
import cerent.cms.model.Attribute;
import cerent.cms.model.Ds3xmModuleModel;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.ModuleModel;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class Ds3xm12CardMtcTableModel
extends AbstractTableModel {
    public static final String[] columnNames = new String[]{"Backplane Throughput"};
    public static final String LOW_SPEED = "STS12";
    public static final String HIGH_SPEED = "STS48";
    protected String[] backplaneRateStrings;
    public static final int BACKPLANE_INDEX = 0;
    private int backplaneRate = 0;
    private int newBackplaneRate = 0;
    private boolean isDirty;
    protected int numLines = 1;
    protected Ds3xmModuleModel eqpmtModel;
    protected Ds3xmModuleModel model;
    private static final SDebug db = new SDebug("Ds3xm12CardMtcTableModel");
    static /* synthetic */ Class class$java$lang$Object;

    public Ds3xm12CardMtcTableModel(ModuleModel moduleModel, int n) {
        this.model = (Ds3xmModuleModel)moduleModel;
        this.eqpmtModel = (Ds3xmModuleModel)moduleModel;
        this.backplaneRate = 0;
        this.isDirty = false;
    }

    public int getRowCount() {
        return 1;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            default: 
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = Ds3xm12CardMtcTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty;
    }

    public boolean isRowDirty(int n) {
        return this.isDirty;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            try {
                int n3 = this.getBackplaneRate();
                if (this.backplaneRate >= 0) {
                    n3 = this.backplaneRate;
                }
                return this.getBackplaneStrings()[n3];
            }
            catch (Exception exception) {
                db.println("Caught exception in getValueAt");
                SDebug.printStackTrace((Throwable)exception);
                return null;
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (db.on()) {
            db.println("Change in value " + n + " " + n2);
        }
        try {
            switch (n2) {
                case 0: {
                    this.backplaneRate = this.newBackplaneRate = this.getIndexOf((String)object, this.getBackplaneStrings());
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (ClassCastException classCastException) {
            SDebug.printStackTrace((Throwable)classCastException);
            return;
        }
        this.isDirty = true;
        this.fireTableCellUpdated(n, n2);
    }

    public int getBackplaneRate() {
        eBackPlaneRate eBackPlaneRate2 = this.model.getBackplaneRate();
        if (eBackPlaneRate2 == eBackPlaneRate.STS48) {
            return 1;
        }
        return 0;
    }

    public String[] getBackplaneStrings() {
        if (this.backplaneRateStrings == null) {
            boolean bl = this.model.supportsHighSpeedBackplaneRate();
            int n = bl ? 2 : 1;
            this.backplaneRateStrings = new String[n];
            this.backplaneRateStrings[0] = LOW_SPEED;
            if (bl) {
                this.backplaneRateStrings[1] = HIGH_SPEED;
            }
        }
        return this.backplaneRateStrings;
    }

    public void setBackplaneRate(eBackPlaneRate eBackPlaneRate2) {
        try {
            this.model.setBackplaneRate(eBackPlaneRate2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getIndexOf(Object object, Object[] objectArray) {
        List<Object> list = Arrays.asList(objectArray);
        return list.indexOf(object);
    }

    private int unsignedShortToInt(short s) {
        int n = s & 0xFFFF;
        return n;
    }

    public void refreshFromModel() throws Exception {
        this.refreshLineFromModel(0);
        this.fireTableRowsUpdated(0, 0);
    }

    public void refreshFromReset() {
        this.refreshLineFromModel(0);
    }

    public void refreshLineFromModel(int n) {
        this.resetLineCache(n);
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.backplaneRate = -1;
        this.isDirty = false;
    }

    public void applyToModel() throws Exception {
        if (db.on()) {
            db.println("applyToModel");
        }
        try {
            if (this.backplaneRate == 1) {
                this.model.setBackplaneRate(eBackPlaneRate.STS48);
            } else {
                this.model.setBackplaneRate(eBackPlaneRate.STS12);
            }
            this.isDirty = false;
            this.refreshLineFromModel(0);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            throw new AnnotatedException("Error applying changes to row 1 ", exception);
        }
    }

    protected Attribute getAttributeFor(String string, int n) {
        return ElementDefaults.getAttributeMap(this.eqpmtModel).getAttributeForVal(string, n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

