/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.shelf;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsMultiplexSectionModel;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.ICardPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class CardPainter
implements ICardPainter {
    static final float CARD_H_TO_CARD_W_RATIO = 8.461538f;
    static final float PORT_H_TO_PORT_W_RATIO = 1.8f;
    static final float PORT_W_TO_CARD_W_RATIO = 0.3846154f;
    static final float OPTICON_Y_OFFSET_TO_CARD_H_RATIO = 0.27272728f;
    static final float OPTICON_Y_SPACING_TO_CARD_H_RATIO = 0.11363637f;
    static final float FONT_TO_CARD_W_RATIO = 0.30769232f;
    static final int CARD_WIDTH = 26;
    static final int CARD_HEIGHT = Math.round(220.0f);
    static final int PORT_WIDTH = Math.round(10.0f);
    static final int PORT_HEIGHT = Math.round((float)PORT_WIDTH * 1.8f);
    static final int SMALL_PORT_HEIGHT = PORT_WIDTH;
    static final int PORT_LOOPBACK_DIST = 3;
    static final int PORT_CONN1_X;
    static final int PORT_CONN2_X;
    static final int PORT_CONN1_Y;
    static final int PORT_CONN2_Y;
    static final int SMALL_PORT_CONN1_Y;
    static final int SMALL_PORT_CONN2_Y;
    static final int OPTICON_X_OFFSET;
    static final int MULTIPORT_OPTICON_X_OFFSET;
    static final int OPTICON_Y_OFFSET;
    static final int OPTICON_X_SPACING = 0;
    static final int OPTICON_Y_SPACING;
    static final int SMALL_OPTICON_Y_SPACING;
    static final int MINI_PORT_WIDTH;
    static final int MINI_PORT_HEIGHT;
    static final int MINI_MULTIPORT_OPTICON_X_OFFSET;
    static final int MINI_OPTICON_Y_OFFSET;
    static final int MINI_OPTICON_X_SPACING = 0;
    static final int MINI_OPTICON_Y_SPACING;
    public static final double FACTOR_454 = 1.0;
    public static final double FACTOR_454SDH = 0.86;
    public static double SCALE_FACTOR;
    public int WIDTH;
    public static int HEIGHT;
    public static final int SLOT_WIDTH = 26;
    public static final int SLOT_HEIGHT;
    private static final int SM_WIDTH = 13;
    private static int SM_HEIGHT;
    public Dimension SLOT_DIM;
    public static Dimension SMALL_SLOT_DIM;
    private static final float ACTIVE_Y_LIGHT_OFFSET_TO_CARD_H_RATIO = 0.27272728f;
    private static final float ACTIVE_LIGHT_W_TO_CARD_W_RATIO = 0.23076923f;
    private static final float ACTIVE_LIGHT_H_TO_CARD_H_RATIO = 0.018181818f;
    public static int RECT_HEIGHT;
    public static int RECT_OFFSET;
    public static int TOP_RECT_OFFSET;
    public static int TOP_RECT_HEIGHT;
    public static int BOTTOM_RECT_OFFSET;
    public static int BOTTOM_RECT_HEIGHT;
    public static int EXTRACTOR_HEIGHT;
    public static int EXTRACTOR_WIDTH;
    public static final int TAB_MARGIN = 2;
    public static int TAB_RADIUS;
    public static int TAB_DIAMETER;
    public static int TAB_ARC_WIDTH;
    public static int TAB_ARC_HEIGHT;
    public static int BOTTOM_EXTRACTOR_OFFSET;
    public static int BOTTOM_EXTRACTOR_HEIGHT;
    public static final int TOP_EXTRACTOR_OFFSET = 0;
    public static int TOP_EXTRACTOR_HEIGHT;
    public static final int NAME_X_OFFSET = 2;
    public static int NAME_Y_OFFSET;
    public static final int ACTIVE_LIGHT_Y_OFFSET;
    public static final int ACTIVE_LIGHT_WIDTH;
    public static final int ACTIVE_LIGHT_HEIGHT;
    protected Rectangle mainRectangle;
    private static final float[] dash1;
    private static Rectangle topExtractorRectangle;
    private static Rectangle bottomExtractorRectangle;
    private static Arc2D.Double topExtractorMain;
    private static Arc2D.Double topExtractorSmall;
    private static Line2D.Double topExtractorLine;
    private static Arc2D.Double bottomExtractorMain;
    private static Arc2D.Double bottomExtractorSmall;
    private static Line2D.Double bottomExtractorLine;
    private static Rectangle topRectangle;
    private static Rectangle bottomRectangle;
    protected CardGraphic cg;
    protected OpticsModuleModel model;
    protected OpticsMultiplexSectionModel[] bandmodels;
    protected OpticsChannelModel[] models;
    public static final String[] ChnWavelengthStrings;
    public static final String[] BandWavelengthStrings;

    public CardPainter(CardGraphic cardGraphic) {
        OpticsModuleModel opticsModuleModel;
        this.cg = cardGraphic;
        this.updateWidth();
        if (this.cg.getModel() instanceof OpticsModuleModel && (opticsModuleModel = (OpticsModuleModel)this.cg.getModel()).getState() != eEqState.DELETED) {
            this.models = opticsModuleModel.getOpticsChannelModels();
            this.bandmodels = opticsModuleModel.getOpticsOMSModels();
        }
    }

    public void updateWidth() {
        this.WIDTH = this.cg.getSlotsOccupied() * 26;
        this.SLOT_DIM = new Dimension(this.WIDTH, HEIGHT);
        topRectangle = new Rectangle(0, TOP_RECT_OFFSET, this.WIDTH, TOP_RECT_HEIGHT);
        bottomRectangle = new Rectangle(0, BOTTOM_RECT_OFFSET, this.WIDTH, BOTTOM_RECT_HEIGHT);
        this.mainRectangle = new Rectangle(0, 0, this.WIDTH, HEIGHT);
    }

    protected int getRectHeight() {
        return RECT_HEIGHT;
    }

    protected int getRectOffset() {
        return RECT_OFFSET;
    }

    protected int getExtractorHeight() {
        return EXTRACTOR_HEIGHT;
    }

    protected int getExtractorWidth() {
        return EXTRACTOR_WIDTH;
    }

    protected int getTabMargin() {
        return 2;
    }

    protected int getExtractorOffset() {
        return 0;
    }

    protected int getNameXOffset() {
        return 2;
    }

    protected int getNameYOffset() {
        return NAME_Y_OFFSET;
    }

    public int getOpticonXOffset() {
        return OPTICON_X_OFFSET;
    }

    public int getOpticonYOffset() {
        return OPTICON_Y_OFFSET;
    }

    public int getMultiPortOpticonXOffset() {
        return MULTIPORT_OPTICON_X_OFFSET;
    }

    public int getOpticonXSpacing() {
        return 0;
    }

    public int getOpticonYSpacing() {
        return OPTICON_Y_SPACING;
    }

    public int getMiniMultiPortOticonXOffset() {
        return MINI_MULTIPORT_OPTICON_X_OFFSET;
    }

    public int getCardWidth() {
        return 26;
    }

    public int getCardHeight() {
        return CARD_HEIGHT;
    }

    public Rectangle getMainRectangle() {
        return this.mainRectangle;
    }

    public int getPortWidth() {
        return PORT_WIDTH;
    }

    public int getPortHeight() {
        return PORT_HEIGHT;
    }

    public int getMiniPortWidth() {
        return MINI_PORT_WIDTH;
    }

    public int getMiniPortHeight() {
        return MINI_PORT_HEIGHT;
    }

    public int getMiniOpticonXSpacing() {
        return 0;
    }

    public int getMiniOpticonYSpacing() {
        return MINI_OPTICON_Y_SPACING;
    }

    public int getMiniOpticonYOffset() {
        return MINI_OPTICON_Y_OFFSET;
    }

    public int getPortX(int n, int n2) {
        return MULTIPORT_OPTICON_X_OFFSET + 0 * n2;
    }

    public int getPortY(int n, int n2) {
        if (n == 0) {
            return OPTICON_Y_OFFSET + OPTICON_Y_SPACING * n2;
        }
        return OPTICON_Y_OFFSET + SMALL_OPTICON_Y_SPACING * n2;
    }

    public int getSmallPortWidth() {
        return 0;
    }

    public int getSmallPortHeight() {
        return SMALL_PORT_HEIGHT;
    }

    public int getPortConn1X() {
        return PORT_CONN1_X;
    }

    public int getPortConn2X() {
        return PORT_CONN2_X;
    }

    public int getPortConn1Y() {
        return PORT_CONN1_Y;
    }

    public int getPortConn2Y() {
        return PORT_CONN2_Y;
    }

    public int getSmallPortConn1Y() {
        return SMALL_PORT_CONN1_Y;
    }

    public int getSmallPortConn2Y() {
        return SMALL_PORT_CONN2_Y;
    }

    public int getSmallPortConn1X() {
        return 0;
    }

    public int getSmallPortConn2X() {
        return 0;
    }

    public int getPortLoopbackDist() {
        return 3;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(graphics2D.getFont().deriveFont(1));
        graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        Font font = graphics2D.getFont();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(this.cg.getCurrentColor());
        graphics2D.fill(this.mainRectangle);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.draw(this.mainRectangle);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.setColor(Color.gray);
        graphics2D.draw(topExtractorRectangle);
        graphics2D.draw(bottomExtractorRectangle);
        graphics2D.setColor(Color.black);
        graphics2D.draw(topExtractorMain);
        graphics2D.draw(topExtractorSmall);
        graphics2D.draw(topExtractorLine);
        graphics2D.draw(bottomExtractorMain);
        graphics2D.draw(bottomExtractorSmall);
        graphics2D.draw(bottomExtractorLine);
        int n5 = this.cg.getState();
        String string = "";
        Color color = graphics2D.getColor();
        Color color2 = this.cg.getCurrentColor();
        switch (n5) {
            case 5: {
                string = "Act";
                color2 = Color.green;
                break;
            }
            case 4: {
                string = "Sby";
                color2 = Color.yellow;
                break;
            }
            case 2: {
                string = "Ldg";
                color2 = Color.white;
                break;
            }
            case 3: {
                string = "Fail";
                break;
            }
            case 1: {
                string = "Mis";
                break;
            }
            case 0: {
                string = "NP";
                break;
            }
            case 6: {
                string = "Del";
                break;
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, 2, ACTIVE_LIGHT_Y_OFFSET + ACTIVE_LIGHT_HEIGHT);
        graphics2D.setColor(color2);
        graphics2D.fillRect(26 - ACTIVE_LIGHT_WIDTH - 2, ACTIVE_LIGHT_Y_OFFSET, ACTIVE_LIGHT_WIDTH, ACTIVE_LIGHT_HEIGHT);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(26 - ACTIVE_LIGHT_WIDTH - 2, ACTIVE_LIGHT_Y_OFFSET, ACTIVE_LIGHT_WIDTH, ACTIVE_LIGHT_HEIGHT);
        graphics2D.setColor(color);
        BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 3.0f, dash1, 0.0f);
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(topRectangle);
        graphics2D.draw(bottomRectangle);
        graphics2D.setColor(Color.black);
        int n6 = 0;
        String string2 = this.cg.getEqLabel();
        Font font2 = graphics.getFont();
        FontMetrics fontMetrics = component.getFontMetrics(font2);
        int n7 = fontMetrics.getAscent() - 1;
        if (SCALE_FACTOR == 1.0) {
            n4 = 3;
            n3 = 7;
        } else {
            n4 = 0;
            n3 = 9;
        }
        if (string2.startsWith("STM") || string2.startsWith("E1_") || string2.startsWith("ML100") || string2.startsWith("DS3") && string2.length() > 3 || string2.startsWith("ETH") && string2.length() > 3) {
            int n8 = 3;
            if (string2.startsWith("ML100")) {
                n8 = 2;
            }
            String string3 = string2.substring(0, n8);
            String string4 = string2.substring(n8);
            graphics2D.drawString(string3, n + 2, n2 + NAME_Y_OFFSET - n4);
            int n9 = string4.length() == 1 ? n + 2 + 7 : (string4.length() == 2 ? n + 2 + 4 : n + 2);
            graphics2D.drawString(string4, n9, n2 + NAME_Y_OFFSET + n3);
        } else if (string2.startsWith("XC")) {
            String string5 = string2.substring(0, 2);
            String string6 = string2.substring(2);
            if (string6.length() > 3) {
                string6 = string6.substring(0, string6.indexOf(32));
            }
            graphics2D.drawString(string5, n + 2, n2 + NAME_Y_OFFSET - n4);
            graphics2D.drawString(string6, n + 2 + 2, n2 + NAME_Y_OFFSET + n3);
        } else if (string2.startsWith("UNK")) {
            String string7 = string2.substring(0, 4);
            graphics2D.drawString(string7, n + 2 - 1, n2 + NAME_Y_OFFSET - n4);
        } else if (string2.startsWith("TXP") || string2.startsWith("MXP")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "_");
            String string8 = "";
            String string9 = "";
            String string10 = "";
            int n10 = n2 + NAME_Y_OFFSET - 1;
            try {
                string8 = stringTokenizer.nextToken();
                string9 = stringTokenizer.nextToken();
                string10 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            graphics2D.drawString(string8, n + 2, n10);
            graphics2D.drawString(string9, n + 2, n10 += n7);
            graphics2D.drawString(string10, n + 2, n10 += n7);
        } else if (string2.startsWith("OADM 1 b")) {
            String string11 = "AD1B";
            String string12 = "x.xx";
            n6 = this.getBandWave();
            if (n6 != 0) {
                string12 = BandWavelengthStrings[n6].substring(2, 6);
            }
            int n11 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string11, n + 2, n11);
            graphics2D.drawString(string12, n + 2, n11 += n7);
        } else if (string2.startsWith("OADM 4 b")) {
            String string13 = "AD4B";
            String string14 = "x.xx";
            n6 = this.getBandWave();
            if (n6 != 0) {
                string14 = BandWavelengthStrings[n6].substring(2, 6);
            }
            int n12 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string13, n + 2, n12);
            graphics2D.drawString(string14, n + 2, n12 += n7);
        } else if (string2.startsWith("OADM 1 c")) {
            String string15 = "AD1C";
            String string16 = "x.xx";
            n6 = this.getWave();
            if (n6 != 0) {
                string16 = ChnWavelengthStrings[n6].substring(2, 6);
            }
            int n13 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string15, n + 2, n13);
            graphics2D.drawString(string16, n + 2, n13 += n7);
        } else if (string2.startsWith("OADM 2 c")) {
            String string17 = "AD2C";
            String string18 = "x.xx";
            n6 = this.getWave();
            if (n6 != 0) {
                string18 = ChnWavelengthStrings[n6].substring(2, 6);
            }
            int n14 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string17, n + 2, n14);
            graphics2D.drawString(string18, n + 2, n14 += n7);
        } else if (string2.startsWith("OADM 4 c")) {
            String string19 = "AD4C";
            String string20 = "x.xx";
            n6 = this.getWave();
            if (n6 != 0) {
                string20 = ChnWavelengthStrings[n6].substring(2, 6);
            }
            int n15 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string19, n + 2, n15);
            graphics2D.drawString(string20, n + 2, n15 += n7);
        } else if (string2.equals("Optical booster")) {
            String string21 = "OPT";
            String string22 = "BST";
            int n16 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string21, n + 2, n16);
            graphics2D.drawString(string22, n + 2, n16 += n7);
        } else if (string2.equals("Optical booster ENH")) {
            String string23 = "OPT";
            String string24 = "BST";
            String string25 = "ENH";
            int n17 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string23, n + 2, n17);
            graphics2D.drawString(string24, n + 2, n17 += n7);
            graphics2D.drawString(string25, n + 2, n17 += n7);
        } else if (string2.startsWith("Optical pre")) {
            String string26 = "OPT";
            String string27 = "PRE";
            int n18 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string26, n + 2, n18);
            graphics2D.drawString(string27, n + 2, n18 += n7);
        } else if (string2.startsWith("OSC M")) {
            String string28 = "OSCM";
            String string29 = "";
            int n19 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string28, n + 2, n19);
            graphics2D.drawString(string29, n + 2, n19 += n7);
        } else if (string2.startsWith("OSC ")) {
            String string30 = "OSC";
            String string31 = "CSM";
            int n20 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string30, n + 2, n20);
            graphics2D.drawString(string31, n + 2, n20 += n7);
        } else if (string2.startsWith("CE-100T")) {
            String string32 = "CE";
            String string33 = "100T";
            int n21 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string32, n + 2, n21);
            graphics2D.drawString(string33, n + 2, n21 += n7);
        } else if (string2.startsWith("32 WSS")) {
            String string34 = "       32 WSS";
            String string35 = "";
            int n22 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string34, n + 2, n22);
            graphics2D.drawString(string35, n + 2, n22 += n7);
        } else if (string2.equals("32 DMX")) {
            String string36 = "32";
            String string37 = "DMX";
            int n23 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string36, n + 2, n23);
            graphics2D.drawString(string37, n + 2, n23 += n7);
        } else if (string2.startsWith("4MD")) {
            String string38 = "4MD";
            String string39 = "x.xx";
            n6 = this.getWave();
            if (n6 != 0) {
                string39 = ChnWavelengthStrings[n6].substring(2, 6);
            }
            int n24 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string38, n + 2, n24);
            graphics2D.drawString(string39, n + 2, n24 += n7);
        } else if (string2.startsWith("32 MUXO")) {
            String string40 = "       32 MUXO";
            String string41 = "";
            int n25 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string40, n + 2, n25);
            graphics2D.drawString(string41, n + 2, n25 += n7);
        } else if (string2.equals("32 DMXO")) {
            String string42 = "       32 DMXO";
            String string43 = "";
            int n26 = n2 + NAME_Y_OFFSET - 1;
            graphics2D.drawString(string42, n + 2, n26);
            graphics2D.drawString(string43, n + 2, n26 += n7);
        } else if (string2.startsWith("FC-MR")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "-");
            String string44 = "";
            String string45 = "";
            int n27 = n2 + NAME_Y_OFFSET - 1;
            try {
                string44 = stringTokenizer.nextToken();
                string45 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            graphics2D.drawString(string44, n + 2, n27);
            graphics2D.drawString(string45, n + 2, n27 += n7);
        } else if (string2.startsWith("TCC2P")) {
            int n28 = n2 + NAME_Y_OFFSET - n4;
            String string46 = string2.substring(0, 4);
            String string47 = string2.substring(4, string2.length());
            int n29 = fontMetrics.stringWidth(string46);
            graphics2D.drawString(string46, (n + 26 - n29) / 2, n28);
            n29 = fontMetrics.stringWidth(string47);
            graphics2D.drawString(string47, (n + 26 - n29) / 2, n2 + NAME_Y_OFFSET + n3);
        } else {
            if (string2.startsWith("G1000")) {
                graphics2D.setFont(new Font(font2.getFontName(), font2.getStyle(), font2.getSize() - 1));
            }
            graphics2D.drawString(string2, n + 2, n2 + NAME_Y_OFFSET);
            if (string2.endsWith("(TXP)")) {
                graphics2D.drawString("(TXP)", n + 2, n2 + n7 + NAME_Y_OFFSET);
            }
            graphics2D.setFont(font2);
        }
        graphics2D.setStroke(stroke);
    }

    public static void setScaleFactor(double d) {
        if (SCALE_FACTOR == d) {
            return;
        }
        SCALE_FACTOR = d;
        HEIGHT = 220;
        SM_HEIGHT = HEIGHT / 2;
        SMALL_SLOT_DIM = new Dimension(13, SM_HEIGHT);
        RECT_HEIGHT = 6;
        TOP_RECT_OFFSET = RECT_OFFSET = 49;
        TOP_RECT_HEIGHT = RECT_HEIGHT;
        BOTTOM_RECT_OFFSET = 179;
        BOTTOM_RECT_HEIGHT = RECT_HEIGHT;
        EXTRACTOR_HEIGHT = 26;
        EXTRACTOR_WIDTH = 12;
        TAB_RADIUS = (26 - EXTRACTOR_WIDTH) / 2;
        TAB_DIAMETER = TAB_RADIUS * 2;
        TAB_ARC_WIDTH = 26 - EXTRACTOR_WIDTH - TAB_RADIUS;
        TAB_ARC_HEIGHT = EXTRACTOR_HEIGHT - TAB_DIAMETER;
        BOTTOM_EXTRACTOR_OFFSET = HEIGHT - EXTRACTOR_HEIGHT - 1;
        BOTTOM_EXTRACTOR_HEIGHT = EXTRACTOR_HEIGHT;
        TOP_EXTRACTOR_HEIGHT = EXTRACTOR_HEIGHT;
        NAME_Y_OFFSET = 40;
        topExtractorRectangle = new Rectangle(2, 2, EXTRACTOR_WIDTH - 4, TOP_EXTRACTOR_HEIGHT - 4);
        bottomExtractorRectangle = new Rectangle(2, BOTTOM_EXTRACTOR_OFFSET + 2, EXTRACTOR_WIDTH - 4, BOTTOM_EXTRACTOR_HEIGHT - 4);
        topExtractorMain = new Arc2D.Double(EXTRACTOR_WIDTH, 0 - TAB_ARC_HEIGHT, 2 * TAB_ARC_WIDTH, 2 * TAB_ARC_HEIGHT, 180.0, 90.0, 0);
        topExtractorSmall = new Arc2D.Double(EXTRACTOR_WIDTH, 0 + TAB_ARC_HEIGHT, TAB_DIAMETER, TAB_DIAMETER, 90.0, -180.0, 0);
        topExtractorLine = new Line2D.Double(0.0, EXTRACTOR_HEIGHT, EXTRACTOR_WIDTH + TAB_ARC_WIDTH, EXTRACTOR_HEIGHT);
        bottomExtractorMain = new Arc2D.Double(EXTRACTOR_WIDTH, BOTTOM_EXTRACTOR_OFFSET + TAB_DIAMETER, 2 * TAB_ARC_WIDTH, 2 * TAB_ARC_HEIGHT, 180.0, -90.0, 0);
        bottomExtractorSmall = new Arc2D.Double(EXTRACTOR_WIDTH, BOTTOM_EXTRACTOR_OFFSET, TAB_DIAMETER, TAB_DIAMETER, -90.0, 180.0, 0);
        bottomExtractorLine = new Line2D.Double(0.0, BOTTOM_EXTRACTOR_OFFSET, EXTRACTOR_WIDTH + TAB_ARC_WIDTH, BOTTOM_EXTRACTOR_OFFSET);
        topRectangle = new Rectangle(0, TOP_RECT_OFFSET, 26, TOP_RECT_HEIGHT);
        bottomRectangle = new Rectangle(0, BOTTOM_RECT_OFFSET, 26, BOTTOM_RECT_HEIGHT);
    }

    public int getWave() {
        int n = 0;
        try {
            n = this.models[0].getExpectedWaveLenght().value();
        }
        catch (Exception exception) {
            return 0;
        }
        return n;
    }

    public int getBandWave() {
        int n = 0;
        try {
            n = this.bandmodels[0].getExpectedBand().value();
        }
        catch (Exception exception) {
            return 0;
        }
        return n;
    }

    static {
        PORT_CONN2_X = PORT_CONN1_X = PORT_WIDTH / 2;
        PORT_CONN1_Y = PORT_HEIGHT / 3;
        PORT_CONN2_Y = PORT_CONN1_Y * 2;
        SMALL_PORT_CONN1_Y = SMALL_PORT_HEIGHT / 3;
        SMALL_PORT_CONN2_Y = SMALL_PORT_CONN1_Y * 2;
        OPTICON_X_OFFSET = (26 - PORT_WIDTH) / 2;
        MULTIPORT_OPTICON_X_OFFSET = (26 - PORT_WIDTH) / 2;
        OPTICON_Y_OFFSET = Math.round((float)CARD_HEIGHT * 0.27272728f);
        OPTICON_Y_SPACING = Math.round((float)CARD_HEIGHT * 0.11363637f);
        SMALL_OPTICON_Y_SPACING = Math.round((float)((double)((float)CARD_HEIGHT * 0.11363637f) * 0.75));
        MINI_PORT_WIDTH = PORT_WIDTH;
        MINI_PORT_HEIGHT = Math.round((float)PORT_HEIGHT * 0.6f);
        MINI_MULTIPORT_OPTICON_X_OFFSET = Math.round((float)(26 - MINI_PORT_WIDTH) / 2.0f);
        MINI_OPTICON_Y_OFFSET = OPTICON_Y_OFFSET - 4;
        MINI_OPTICON_Y_SPACING = MINI_PORT_HEIGHT + 1;
        SCALE_FACTOR = 0.86;
        SLOT_HEIGHT = HEIGHT = (int)(220.0 * SCALE_FACTOR);
        SM_HEIGHT = HEIGHT / 2;
        SMALL_SLOT_DIM = new Dimension(13, SM_HEIGHT);
        RECT_HEIGHT = (int)(4.0 * SCALE_FACTOR);
        RECT_OFFSET = (int)(49.0 * SCALE_FACTOR);
        TOP_RECT_OFFSET = 40;
        TOP_RECT_HEIGHT = RECT_HEIGHT;
        BOTTOM_RECT_OFFSET = (int)(179.0 * SCALE_FACTOR);
        BOTTOM_RECT_HEIGHT = RECT_HEIGHT;
        EXTRACTOR_HEIGHT = (int)(22.0 * SCALE_FACTOR);
        EXTRACTOR_WIDTH = 10;
        TAB_RADIUS = (int)((double)((26 - EXTRACTOR_WIDTH - 2) / 2) * SCALE_FACTOR);
        TAB_DIAMETER = TAB_RADIUS * 2;
        TAB_ARC_WIDTH = 26 - EXTRACTOR_WIDTH - TAB_RADIUS - 2;
        TAB_ARC_HEIGHT = EXTRACTOR_HEIGHT - TAB_DIAMETER;
        BOTTOM_EXTRACTOR_OFFSET = HEIGHT - EXTRACTOR_HEIGHT - 1;
        BOTTOM_EXTRACTOR_HEIGHT = EXTRACTOR_HEIGHT;
        TOP_EXTRACTOR_HEIGHT = EXTRACTOR_HEIGHT;
        NAME_Y_OFFSET = (int)(32.0 * SCALE_FACTOR);
        ACTIVE_LIGHT_Y_OFFSET = (int)(Math.round((double)((float)CARD_HEIGHT * 0.27272728f) * SCALE_FACTOR) - 4L);
        ACTIVE_LIGHT_WIDTH = Math.round(6.0f) - 1;
        ACTIVE_LIGHT_HEIGHT = (int)Math.round((double)((float)CARD_HEIGHT * 0.018181818f) * SCALE_FACTOR + 2.0);
        dash1 = new float[]{1.5f};
        topExtractorRectangle = new Rectangle(2, 2, EXTRACTOR_WIDTH - 4, TOP_EXTRACTOR_HEIGHT - 4);
        bottomExtractorRectangle = new Rectangle(2, BOTTOM_EXTRACTOR_OFFSET + 2, EXTRACTOR_WIDTH - 4, BOTTOM_EXTRACTOR_HEIGHT - 4);
        topExtractorMain = new Arc2D.Double(EXTRACTOR_WIDTH, 0 - TAB_ARC_HEIGHT, 2 * TAB_ARC_WIDTH, 2 * TAB_ARC_HEIGHT, 180.0, 90.0, 0);
        topExtractorSmall = new Arc2D.Double(EXTRACTOR_WIDTH + 2, 0 + TAB_ARC_HEIGHT, TAB_DIAMETER, TAB_DIAMETER, 90.0, -180.0, 0);
        topExtractorLine = new Line2D.Double(0.0, EXTRACTOR_HEIGHT, EXTRACTOR_WIDTH + TAB_ARC_WIDTH, EXTRACTOR_HEIGHT);
        bottomExtractorMain = new Arc2D.Double(EXTRACTOR_WIDTH, BOTTOM_EXTRACTOR_OFFSET + TAB_DIAMETER, 2 * TAB_ARC_WIDTH, 2 * TAB_ARC_HEIGHT, 180.0, -90.0, 0);
        bottomExtractorSmall = new Arc2D.Double(EXTRACTOR_WIDTH + 2, BOTTOM_EXTRACTOR_OFFSET, TAB_DIAMETER, TAB_DIAMETER, -90.0, 180.0, 0);
        bottomExtractorLine = new Line2D.Double(0.0, BOTTOM_EXTRACTOR_OFFSET, EXTRACTOR_WIDTH + TAB_ARC_WIDTH, BOTTOM_EXTRACTOR_OFFSET);
        ChnWavelengthStrings = new String[]{"UNKNOWN", "1530.3", "1531.1", "1531.9", "1532.6", "1534.2", "1535.0", "1535.8", "1536.6", "1538.1", "1538.9", "1539.7", "1540.5", "1542.1", "1542.9", "1543.7", "1544.5", "1546.1", "1546.9", "1547.7", "1548.5", "1550.1", "1550.9", "1551.7", "1552.5", "1554.1", "1554.9", "1555.7", "1556.5", "1558.1", "1558.9", "1559.7", "1560.6"};
        BandWavelengthStrings = new String[]{"UNKNOWN", "1530.3", "1534.2", "1538.1", "1542.1", "1546.1", "1550.1", "1554.1", "1558.1"};
    }
}

