/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.stm1e;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.SonetMedia.sLineThresholds;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.EnumStrings;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.table.AbstractTableModel;

public class STM1E12MSPmThresholdsTableModel
extends AbstractTableModel {
    private Frame _frame;
    protected INodeModel node;
    protected TdmLineModel[] model = null;
    protected boolean[] rowDirty = null;
    protected sLineThresholds[] thresholdsVal;
    protected eIntervalType intervalType;
    protected int numLines = 0;
    protected boolean nearEnd = false;
    protected EntityCellRenderer myPortRenderer;
    public static final int LINENUMBER_INDEX = 0;
    public static final int CV_INDEX = 1;
    public static final int BBE_INDEX = 2;
    public static final int ES_INDEX = 3;
    public static final int SES_INDEX = 4;
    public static final int UAS_INDEX = 5;
    public static final int LAST_INDEX = 5;
    protected static String[] columnNames;
    private static final SDebug db;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public STM1E12MSPmThresholdsTableModel(INodeModel iNodeModel, TdmLineModel[] tdmLineModelArray, eIntervalType eIntervalType2, boolean bl) {
        this._frame = iNodeModel.getUiToolkit().getApplicationFrame();
        this.node = iNodeModel;
        this.model = tdmLineModelArray;
        this.nearEnd = bl;
        this.intervalType = eIntervalType2;
        this.initColumnNames();
        if (this.model == null) {
            if (db.on()) {
                db.println("Model null");
            }
            this.numLines = 0;
        } else {
            this.numLines = this.model.length;
        }
        this.init();
    }

    private void init() {
        this.myPortRenderer = new EntityCellRenderer();
        this.rowDirty = new boolean[this.numLines];
        this.thresholdsVal = new sLineThresholds[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
            this.thresholdsVal[i] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(TdmLineModel[] tdmLineModelArray) {
        STM1E12MSPmThresholdsTableModel sTM1E12MSPmThresholdsTableModel = this;
        synchronized (sTM1E12MSPmThresholdsTableModel) {
            this.model = tdmLineModelArray;
            this.numLines = this.model.length;
            this.thresholdsVal = new sLineThresholds[this.numLines];
            this.rowDirty = new boolean[this.numLines];
            for (int i = 0; i < this.numLines; ++i) {
                this.thresholdsVal[i] = null;
                this.rowDirty[i] = false;
            }
        }
        this.fireTableDataChanged();
    }

    protected void refreshPmThresholds(int n) {
        if (this.thresholdsVal[n] == null) {
            try {
                this.thresholdsVal[n] = this.model[n].getLinePmThresholds(this.intervalType, this.nearEnd);
                if (db.on()) {
                    db.println("Thresholds val got for line " + n);
                }
                this.printThresholds(this.thresholdsVal[n]);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                ErrorMsg.displayError((Component)this.getFrame(), (EID)EMC.EID_RTRV_THRESHOLDS);
            }
        }
    }

    private Frame getFrame() {
        return this._frame;
    }

    protected int getEs(int n) {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].es;
    }

    protected int getCv(int n) {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].cv;
    }

    protected int getSes(int n) {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].ses;
    }

    protected int getBbe(int n) {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].bbe;
    }

    protected int getUas(int n) {
        this.refreshPmThresholds(n);
        return this.thresholdsVal[n].uas;
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return class$java$lang$String == null ? (class$java$lang$String = STM1E12MSPmThresholdsTableModel.class$("java.lang.String")) : class$java$lang$String;
        }
        return class$java$lang$Integer == null ? (class$java$lang$Integer = STM1E12MSPmThresholdsTableModel.class$("java.lang.Integer")) : class$java$lang$Integer;
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            if (db.on()) {
                db.println("Change in value " + n + " " + n2);
            }
            int n3 = -1;
            if (object instanceof Integer) {
                n3 = (Integer)object;
            } else if (object instanceof String) {
                n3 = Integer.parseInt((String)object);
            }
            if (n3 < 0) {
                throw new Exception();
            }
            switch (n2) {
                case 3: {
                    this.thresholdsVal[n].es = n3;
                    break;
                }
                case 4: {
                    this.thresholdsVal[n].ses = n3;
                    break;
                }
                case 2: {
                    this.thresholdsVal[n].bbe = n3;
                    break;
                }
                case 1: {
                    this.thresholdsVal[n].cv = n3;
                    break;
                }
                case 5: {
                    this.thresholdsVal[n].uas = n3;
                    break;
                }
            }
            this.rowDirty[n] = true;
            this.fireTableCellUpdated(n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            if (db.on()) {
                db.println("NumberFormatException caught setValueAt(): " + numberFormatException);
                SDebug.printStackTrace((Throwable)numberFormatException);
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in setValueAt " + exception);
            }
            System.err.println("Error in setValueAt " + exception);
            exception.printStackTrace(System.err);
        }
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public sLineThresholds getThresholdsVal(int n) {
        if (n >= this.numLines) {
            return null;
        }
        return this.thresholdsVal[n];
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0) {
            boolean bl = AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING);
            try {
                if (bl && !this.model[0].getModuleModel().isProtectModule()) {
                    return n2 > 0;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("Caught exception in isCellEditable");
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                return false;
            }
        }
        return false;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.model[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 3: {
                    return new Integer(this.getEs(n));
                }
                case 4: {
                    return new Integer(this.getSes(n));
                }
                case 2: {
                    return new Integer(this.getBbe(n));
                }
                case 1: {
                    return new Integer(this.getCv(n));
                }
                case 5: {
                    return new Integer(this.getUas(n));
                }
            }
            return null;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in getValueAt " + exception);
            }
            System.err.println("Error in getValueAt " + exception);
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public void refreshLineFromModel(int n) {
        this.thresholdsVal[n] = null;
        this.rowDirty[n] = false;
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshFromModel() {
        int n;
        if (db.on()) {
            db.println("refreshing in model");
        }
        for (n = 0; n < this.numLines; ++n) {
            this.thresholdsVal[n] = null;
        }
        for (n = 0; n < this.numLines; ++n) {
            this.rowDirty[n] = false;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
        }
    }

    private void printThresholds(sLineThresholds sLineThresholds2) {
        if (db.on()) {
            db.println("Near End = " + this.nearEnd + " Interval Type = " + EnumStrings.getString((Object)this.intervalType, (int)this.intervalType.value()));
            db.println("===============================================");
            db.println("ES " + sLineThresholds2.es);
            db.println("SES " + sLineThresholds2.ses);
            db.println("EB " + sLineThresholds2.cv);
            db.println("UAS " + sLineThresholds2.uas);
            db.println("BBE " + sLineThresholds2.bbe);
            db.println("===============================================");
        }
    }

    protected void initColumnNames() {
        columnNames = new String[6];
        try {
            TDMTerminology tDMTerminology = this.node.getTDMTerminology();
            STM1E12MSPmThresholdsTableModel.columnNames[0] = "Port ";
            STM1E12MSPmThresholdsTableModel.columnNames[1] = tDMTerminology.getPmStat(1);
            STM1E12MSPmThresholdsTableModel.columnNames[2] = tDMTerminology.getPmStat(5);
            STM1E12MSPmThresholdsTableModel.columnNames[3] = tDMTerminology.getPmStat(2);
            STM1E12MSPmThresholdsTableModel.columnNames[4] = tDMTerminology.getPmStat(3);
            STM1E12MSPmThresholdsTableModel.columnNames[5] = tDMTerminology.getPmStat(9);
        }
        catch (Exception exception) {
            db.finer("Exception in initColumnNames() " + exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        db = new SDebug("STM1E12MSPmThresholdsTableMode");
    }
}

