/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.stm1e;

import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.SDebug;
import com.cisco.ctc455.ui.stm1e.STM1EC2TableModel;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class STM1EC2ProvPane
extends NodeProvPane
implements TableModelListener {
    protected STM1EC2TableModel dataModel = null;
    protected TdmLineModel[] lineModels = null;
    protected TdmHoModel[] stsModels = null;
    protected INodeModel node = null;
    protected int numLines = 0;
    Runnable addDeleteThread = null;
    private static final SDebug db = new SDebug("STM1EC2ProvPane");

    public STM1EC2ProvPane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray) {
        super(string, tabbedView);
        this.node = tabbedView.getUiModel().getNodeModel();
        JScrollPane jScrollPane = null;
        TableColumn tableColumn = null;
        this.lineModels = (TdmLineModel[])interfaceModelArray;
        this.stsModels = this.getSTS(interfaceModelArray, 1);
        this.numLines = interfaceModelArray.length;
        this.dataModel = this.getDataModel();
        this.dataModel.addTableModelListener(this);
        this.table = new JTable(this.dataModel);
        tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(120);
        tableColumn.setResizable(false);
        tableColumn = this.table.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer(new C2CellRenderer());
        tableColumn = this.table.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new C2CellRenderer());
        this.setAttrCellEditor(1, "STM1E_C2");
        jScrollPane = new JScrollPane(this.table);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(false);
        this.registerWithModel();
        this.add(jScrollPane, "Center");
    }

    public boolean hasSubTabs() {
        return false;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.dataModel.isDirty()) {
            this.setDirty();
        } else {
            this.resetDirty();
        }
    }

    public void applyChangesToModel() throws Exception {
        this.dataModel.applyChanges();
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    private STM1EC2TableModel getDataModel() {
        return new STM1EC2TableModel(this.node, this.stsModels);
    }

    protected void registerWithModel() {
        int n;
        for (n = 0; n < this.lineModels.length; ++n) {
            this.lineModels[n].addObserver((Observer)((Object)this));
        }
        if (this.stsModels != null) {
            for (n = 0; n < this.stsModels.length; ++n) {
                this.stsModels[n].addObserver((Observer)((Object)this));
            }
        }
    }

    protected void deregisterFromModel() {
        int n;
        if (this.stsModels != null) {
            for (n = 0; n < this.stsModels.length; ++n) {
                this.stsModels[n].deleteObserver((Observer)((Object)this));
            }
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.lineModels[n].deleteObserver((Observer)((Object)this));
        }
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof TdmHoModel) {
            if (object instanceof Integer) {
                if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                    if (db.on()) {
                        db.println("Got an Update Message for " + observable);
                    }
                    this.requestRefresh(observable, this.getRefreshThread(observable));
                }
                if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                    if (db.on()) {
                        db.println("Got an Update Message for " + observable);
                    }
                    this.initializeLines();
                }
            }
        } else if (observable instanceof TdmLineModel && ((Integer)object).equals(ModelUpdateType.ADDED)) {
            if (db.on()) {
                db.println("Got an Update Message for " + observable);
            }
            this.initializeLines();
        }
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                STM1EC2ProvPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshLine(Observable observable) {
        int n;
        block8: {
            n = -1;
            if (observable instanceof TdmLineModel) {
                n = Arrays.asList(this.lineModels).indexOf(observable);
            } else {
                try {
                    n = ((TdmHoModel)((Object)observable)).getInfo().portNumber - 1;
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (!db.on()) break block8;
                    db.println("refreshLine error in getting changeIndex from stsModel");
                }
            }
        }
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("Error changeMessage cannot find Model " + observable);
        }
    }

    protected synchronized void initializeLines() {
        if (this.addDeleteThread == null) {
            this.addDeleteThread = new Runnable(){

                public void run() {
                    try {
                        STM1EC2ProvPane.this.deregisterFromModel();
                        STM1EC2ProvPane.this.stsModels = STM1EC2ProvPane.this.getSTS(STM1EC2ProvPane.this.lineModels, 1);
                        STM1EC2ProvPane.this.numLines = STM1EC2ProvPane.this.stsModels == null ? 0 : STM1EC2ProvPane.this.stsModels.length;
                        STM1EC2ProvPane.this.dataModel.setStsModel(STM1EC2ProvPane.this.stsModels);
                        STM1EC2ProvPane.this.registerWithModel();
                    }
                    catch (Exception exception) {
                        db.println("Error while refreshing table " + exception);
                    }
                }
            };
        }
        SwingUtilities.invokeLater(this.addDeleteThread);
    }

    private TdmHoModel[] getSTS(InterfaceModel[] interfaceModelArray, int n) {
        Collection collection = InterfaceModel.getHigherLayerModels(interfaceModelArray, n);
        if (collection.size() == 0) {
            return null;
        }
        try {
            return collection.toArray(new TdmHoModel[0]);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in getting STS for STM1E");
            }
            return null;
        }
    }

    protected void setAttrCellEditor(int n, String string) {
        TableColumn tableColumn = this.table.getColumn(this.dataModel.columnNames[n]);
        try {
            Attribute[] attributeArray = this.getAttributeArray(string);
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
            tableColumn.setPreferredWidth(tableColumn.getWidth());
        }
        catch (NoSuchElementException noSuchElementException) {
            if (db.on()) {
                db.println("Warning: cannot find attributes for " + string);
            }
            this.table.removeColumn(tableColumn);
        }
    }

    private JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    public Attribute[] getAttributeArray(String string) throws NoSuchElementException {
        Attribute[] attributeArray = ElementDefaults.getAttributeMap((IModel)this.node).getAttributeArray(string);
        if (attributeArray == null) {
            throw new NoSuchElementException();
        }
        return attributeArray;
    }

    class C2CellRenderer
    extends JLabel
    implements TableCellRenderer {
        public C2CellRenderer() {
            this.setOpaque(true);
            this.setHorizontalTextPosition(0);
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
            this.setBackground(Color.white);
            this.setToolTipText("No mismatch");
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            C2CellRenderer c2CellRenderer = null;
            if (object == null) {
                return null;
            }
            if (object.toString().indexOf("Unknown") != -1) {
                this.setBackground(Color.red);
                this.setText(object.toString());
                this.setToolTipText("Red color indicates an invalid value");
                c2CellRenderer = this;
            } else {
                this.setBackground(Color.white);
                this.setText(object.toString());
                this.setToolTipText("White color indicates a valid value");
                c2CellRenderer = this;
            }
            return c2CellRenderer;
        }
    }
}

