/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.stm1e;

import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.TablePropertyMgr;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import com.cisco.ctc455.ui.stm1e.STM1EHoProvTableModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class STM1EHoProvPane
extends NodeProvPane
implements TableModelListener {
    STM1EHoProvTableModel dataModel = null;
    TdmHoModel[] stsModels = null;
    InterfaceModel[] lineModels = null;
    int indexOfHo = 0;
    int numHo = 0;
    Observer strucChangeObserver = null;
    Runnable addDeleteThread = null;
    protected INodeModel node = null;
    private static final SDebug db = new SDebug("STM1E12HoProvPane");

    public STM1EHoProvPane(String string, TabbedView tabbedView, InterfaceModel[] interfaceModelArray, int n) {
        super(string, tabbedView);
        this.node = tabbedView.getUiModel().getNodeModel();
        this.lineModels = interfaceModelArray;
        this.indexOfHo = n;
        this.stsModels = this.getSTS(interfaceModelArray, n);
        this.initializeTable();
    }

    protected void initializeTable() {
        UScrollPane uScrollPane;
        Attribute[] attributeArray;
        TableColumn tableColumn;
        block6: {
            tableColumn = null;
            attributeArray = null;
            this.numHo = this.stsModels == null ? 0 : this.stsModels.length;
            this.dataModel = new STM1EHoProvTableModel(this.node, this.stsModels);
            this.dataModel.addTableModelListener(this);
            this.table = new UTable((TableModel)this.dataModel);
            uScrollPane = new UScrollPane((Component)this.table);
            tableColumn = this.table.getColumn(STM1EHoProvTableModel.columnNames[0]);
            tableColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
            tableColumn.setPreferredWidth(5);
            tableColumn = this.table.getColumn(STM1EHoProvTableModel.columnNames[3]);
            try {
                attributeArray = this.getAttributeArray("declareSfBerLevel");
            }
            catch (NoSuchElementException noSuchElementException) {
                attributeArray = null;
                this.table.removeColumn(tableColumn);
                if (!db.on()) break block6;
                db.println("Got exception");
            }
        }
        if (attributeArray != null) {
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
        }
        tableColumn = this.table.getColumn(STM1EHoProvTableModel.columnNames[2]);
        try {
            attributeArray = this.getAttributeArray("declareSdBerLevel");
        }
        catch (NoSuchElementException noSuchElementException) {
            attributeArray = null;
            this.table.removeColumn(tableColumn);
        }
        if (attributeArray != null) {
            tableColumn.setCellEditor(new DefaultCellEditor(this.getComboBoxFor(attributeArray)));
            tableColumn.sizeWidthToFit();
        }
        this.strucChangeObserver = new Observer(){

            public void update(Observable observable, Object object) {
                if (db.on()) {
                    db.println("Got an update from linemodel");
                }
                if (object instanceof Integer) {
                    Integer n = (Integer)object;
                    if (n.equals(ModelUpdateType.ADDED)) {
                        STM1EHoProvPane.this.initializeLines();
                    } else if (n.equals(ModelUpdateType.CHANGED)) {
                        int n2 = Arrays.asList(STM1EHoProvPane.this.lineModels).indexOf(observable);
                        STM1EHoProvPane.this.lineModels[n2].forceHoLoRefresh();
                    }
                }
            }
        };
        this.table.setAutoCreateColumnsFromModel(false);
        this.add((Component)uScrollPane, "Center");
        this.registerWithModel();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    private JComboBox getComboBoxFor(Attribute[] attributeArray) {
        JComboBox<Attribute> jComboBox = new JComboBox<Attribute>(attributeArray);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    public void update(Observable observable, Object object) {
        if (object instanceof Integer) {
            if (object.equals(ModelUpdateType.CHANGED)) {
                this.changeMessage(observable, object);
            } else if (object.equals(ModelUpdateType.DELETED)) {
                this.deleteMessage(observable, object);
            }
        }
    }

    public Attribute[] getAttributeArray(String string) {
        return ElementDefaults.getAttributeMap((IModel)this.node, true).getAttributeArray(string);
    }

    public void applyChangesToModel() throws Exception {
        int n = 0;
        try {
            for (n = 0; n < this.numHo; ++n) {
                if (db.on()) {
                    db.println("Setting Enable IPPM");
                }
                if (this.dataModel.isDirty(n, 3)) {
                    this.stsModels[n].getHoSfSdModel().setSfBerLevel(this.dataModel.getSfBerLevelIndex(n).getValue().shortValue());
                }
                if (this.dataModel.isDirty(n, 2)) {
                    this.stsModels[n].getHoSfSdModel().setSdBerLevel(this.dataModel.getSdBerLevelIndex(n).getValue().shortValue());
                }
                if (!this.dataModel.isDirty(n, 1)) continue;
                this.stsModels[n].setIPPMEnabled(this.dataModel.getEnableIPPM(n));
            }
        }
        catch (Exception exception) {
            throw new AnnotatedException("Error applying changes to row " + (n + 1), exception);
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        for (int i = 0; i < this.numHo; ++i) {
            for (int j = 0; j < this.dataModel.getColumnCount(); ++j) {
                if (!this.dataModel.isDirty(i, j)) continue;
                if (db.on()) {
                    db.println("setting dirty");
                }
                this.setDirty();
                return;
            }
        }
        this.resetDirty();
    }

    protected void changeMessage(Observable observable, Object object) {
        final int n = Arrays.asList(this.stsModels).indexOf(observable);
        if (n != -1) {
            this.requestRefresh(observable, new Runnable(){

                public void run() {
                    STM1EHoProvPane.this.dataModel.refreshLineFromModel(n);
                }
            });
        } else if (db.on()) {
            db.println("Error in finding the changed line in response to update");
        }
    }

    protected void deleteMessage(Observable observable, Object object) {
        if (db.on()) {
            db.println("got a delete message");
        }
        this.initializeLines();
    }

    protected void registerWithModel() {
        int n;
        if (this.stsModels != null) {
            for (n = 0; n < this.stsModels.length; ++n) {
                this.stsModels[n].addObserver((Observer)((Object)this));
            }
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.lineModels[n].addObserver(this.strucChangeObserver);
        }
    }

    protected synchronized void initializeLines() {
        if (this.addDeleteThread == null) {
            this.addDeleteThread = new Runnable(){

                public void run() {
                    block2: {
                        try {
                            STM1EHoProvPane.this.deregisterForUpdates();
                            STM1EHoProvPane.this.stsModels = STM1EHoProvPane.this.getSTS(STM1EHoProvPane.this.lineModels, STM1EHoProvPane.this.indexOfHo);
                            STM1EHoProvPane.this.numHo = STM1EHoProvPane.this.stsModels == null ? 0 : STM1EHoProvPane.this.stsModels.length;
                            STM1EHoProvPane.this.dataModel.setHoModel(STM1EHoProvPane.this.stsModels);
                            STM1EHoProvPane.this.registerWithModel();
                        }
                        catch (Exception exception) {
                            if (!db.on()) break block2;
                            db.println("Error while refreshing table in SonetHoProvPane" + exception);
                        }
                    }
                }
            };
        }
        SwingUtilities.invokeLater(this.addDeleteThread);
    }

    private TdmHoModel[] getSTS(InterfaceModel[] interfaceModelArray, int n) {
        Collection collection = InterfaceModel.getHigherLayerModels(this.getStmLineModels(interfaceModelArray), n);
        if (collection.size() == 0) {
            return null;
        }
        try {
            return collection.toArray(new TdmHoModel[0]);
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in getting VTS for DS1");
            }
            return null;
        }
    }

    private InterfaceModel[] getStmLineModels(InterfaceModel[] interfaceModelArray) {
        ArrayList<InterfaceModel> arrayList = new ArrayList<InterfaceModel>();
        for (int i = 0; i < interfaceModelArray.length; ++i) {
            try {
                if (!((TdmLineModel)interfaceModelArray[i]).isStmMode()) continue;
                arrayList.add(interfaceModelArray[i]);
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                SDebug.printStackTrace((Throwable)noSuchInterface);
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                SDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return arrayList.toArray(new InterfaceModel[0]);
    }

    public void destroy() {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        this.deregisterForUpdates();
        super.destroy();
    }

    public void deregisterForUpdates() {
        int n;
        for (n = 0; n < this.numHo; ++n) {
            this.stsModels[n].deleteObserver((Observer)((Object)this));
        }
        for (n = 0; n < this.lineModels.length; ++n) {
            this.lineModels[n].deleteObserver(this.strucChangeObserver);
        }
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    public void enteringPage() throws Exception {
        super.enteringPage();
        TablePropertyMgr.getColumnPrefs(this.table, this.getClass().getName());
    }

    public void leavingPage() throws Exception {
        TablePropertyMgr.setColumnPrefs(this.table, this.getClass().getName());
        super.leavingPage();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.STM1E12HoProvPane;
    }
}

