/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.model;

import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NodeModelDelegate;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.util.ArrayList;
import java.util.Observable;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class DatabaseManagementModel
extends Model {
    private NodeModelDelegate nodeModel = null;
    private static ModelSingletonCollection dmModelSingletons = null;
    private ArrayList userChoice;
    private String configIpAddr;
    private final int HEADER_SIZE = 128;
    static final int BUF_SIZE = 1024;
    private final String DB_SIZE = "DB_SIZE";
    private boolean isOlderDb = false;
    private int firstDbStarts = 0;
    private String dbSwVersion;
    private String dbIpAddress;
    private String dbDbVersion = "1";
    private int[] restoreInfoType = null;
    private int[] restoreInfoSize = null;
    private String tmpFileName;
    static /* synthetic */ Class class$com$cisco$ctc600$model$DatabaseManagementModel;

    private DatabaseManagementModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(class$com$cisco$ctc600$model$DatabaseManagementModel == null ? (class$com$cisco$ctc600$model$DatabaseManagementModel = DatabaseManagementModel.class$("com.cisco.ctc600.model.DatabaseManagementModel")) : class$com$cisco$ctc600$model$DatabaseManagementModel));
        this.nodeModel = nodeModelDelegate;
        this.index = 0;
    }

    public static synchronized DatabaseManagementModel getInstance(NodeModelDelegate nodeModelDelegate) {
        DatabaseManagementModel databaseManagementModel = null;
        if (dmModelSingletons == null) {
            dmModelSingletons = ModelSingletonCollection.getMSCInstanceByName("DatabaseManagementModel");
        }
        if ((databaseManagementModel = (DatabaseManagementModel)dmModelSingletons.get(nodeModelDelegate)) == null) {
            databaseManagementModel = new DatabaseManagementModel(nodeModelDelegate);
            dmModelSingletons.add(nodeModelDelegate, databaseManagementModel);
        }
        return databaseManagementModel;
    }

    public INodeModel getNodeModel() {
        return this.nodeModel;
    }

    public void init() {
        super.init0();
        if (this.db.on()) {
            this.db.println("Enter DatabaseManagementModel init()");
        }
        if (this.db.on()) {
            this.db.println("Leaving DatabaseManagementModel init()");
        }
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("Enter DatabaseManagementModel dispose()");
        }
        if (this.db.on()) {
            this.db.println("Leaving DatabaseManagementModel dispose()");
        }
        super.dispose();
    }

    public void destroy() {
        super.destroy();
        if (this.userChoice != null) {
            this.userChoice.clear();
        }
        this.userChoice = null;
        this.configIpAddr = null;
        this.dbDbVersion = null;
        this.dbIpAddress = null;
        this.dbSwVersion = null;
        this.restoreInfoSize = null;
        this.restoreInfoType = null;
        this.tmpFileName = null;
    }

    public void update(Observable observable, Object object) {
    }

    public void setUserSelection(int[] nArray) {
        if (this.userChoice == null) {
            this.userChoice = new ArrayList();
        } else {
            this.userChoice.clear();
        }
        if (this.db.on()) {
            this.db.finest("Adding " + nArray.length + " items as user selected.These are");
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(String.valueOf(nArray[i]) + " ");
            }
            this.db.println(stringBuffer.toString());
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.userChoice.add(new Integer(nArray[i]));
        }
        this.prettyDebugPrint();
    }

    public int[] getUserSelection() {
        int[] nArray = new int[this.userChoice.size()];
        for (int i = 0; i < this.userChoice.size(); ++i) {
            nArray[i] = (Integer)this.userChoice.get(i);
        }
        this.prettyDebugPrint();
        return nArray;
    }

    public void setConfigIpAddr(String string) {
        this.configIpAddr = string;
    }

    public String getConfigIpAddr() {
        return this.configIpAddr;
    }

    private void prettyDebugPrint() {
        if (this.db.on()) {
            StringBuffer stringBuffer = new StringBuffer("DatabaseManagementModel info: ");
            for (int i = 0; i < this.userChoice.size(); ++i) {
                stringBuffer.append(String.valueOf((Integer)this.userChoice.get(i)) + " ");
            }
            stringBuffer.append("Config IP address = " + this.configIpAddr);
            this.db.println(stringBuffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] validateDbBackupFile(String string) throws Exception {
        FilterInputStream filterInputStream = null;
        byte[] byArray = new byte[128];
        try {
            filterInputStream = new DataInputStream(new FileInputStream(string));
            ((DataInputStream)filterInputStream).read(byArray);
            String string2 = new String(byArray);
            this.db.fine("DB Header = " + string2);
            int n = string2.indexOf(59);
            if (n == -1) {
                this.isOlderDb = true;
                filterInputStream.close();
                int[] nArray = this.processOldDb(string);
                return nArray;
            }
            string2 = string2.substring(0, n);
            this.firstDbStarts = n + 1;
            this.db.fine("DB Header after stripping of ==" + string2 + "$$");
            String string3 = "|:,";
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
            this.configIpAddr = this.dbIpAddress = stringTokenizer.nextToken();
            this.dbSwVersion = stringTokenizer.nextToken();
            this.dbDbVersion = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            this.restoreInfoType = new int[n2];
            this.restoreInfoSize = new int[n2];
            for (int i = 0; i < n2; ++i) {
                this.restoreInfoType[i] = Integer.parseInt(stringTokenizer.nextToken());
                this.restoreInfoSize[i] = Integer.parseInt(stringTokenizer.nextToken());
                this.db.fine("i = " + i + ", dbtype = " + this.restoreInfoType[i] + ", fileSize = " + this.restoreInfoSize[i]);
            }
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
        return this.restoreInfoType;
    }

    int getFirstDbStarts() {
        return this.firstDbStarts;
    }

    boolean isFileFromOlderDB() {
        return this.isOlderDb;
    }

    public int[] getDbTypesFromFile() {
        return this.restoreInfoType;
    }

    int[] getDbSizesFromFile() {
        return this.restoreInfoSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] processOldDb(String string) throws Exception {
        ZipEntry zipEntry = null;
        ZipInputStream zipInputStream = null;
        ArrayList<ZipEntry> arrayList = new ArrayList<ZipEntry>();
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(string));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                arrayList.add(zipEntry);
                zipInputStream.closeEntry();
            }
            if (!arrayList.isEmpty()) {
                int n = arrayList.size();
                this.restoreInfoType = new int[n];
                this.restoreInfoSize = new int[n];
                zipEntry = (ZipEntry)arrayList.get(0);
                String string2 = this.getOldExtraInfo("NODE_ADDR", new String(zipEntry.getExtra()));
                this.configIpAddr = this.dbIpAddress = InetUtil.makeDottedString(Integer.parseInt(string2));
                this.dbSwVersion = this.getOldExtraInfo("SW_VERSION", new String(zipEntry.getExtra()));
                for (int i = 0; i < n; ++i) {
                    zipEntry = (ZipEntry)arrayList.get(i);
                    this.restoreInfoType[i] = Integer.parseInt(zipEntry.getName());
                    this.restoreInfoSize[i] = Integer.parseInt(this.getOldExtraInfo("DB_SIZE", new String(zipEntry.getExtra())));
                    this.db.fine("i = " + i + ", dbtype = " + this.restoreInfoType[i] + ", fileSize = " + this.restoreInfoSize[i]);
                }
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
        return this.restoreInfoType;
    }

    public String getDbSwVersion() {
        return this.dbSwVersion;
    }

    public String getDbIpAddress() {
        return this.dbIpAddress;
    }

    public String getDbVersion() {
        return this.dbDbVersion;
    }

    String getOldExtraInfo(String string, String string2) {
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "=");
            if (!stringTokenizer2.nextToken().equals(string)) continue;
            string3 = stringTokenizer2.nextToken();
        }
        return string3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

