/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.asap;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.PluggableCarrierModel;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SlotModel;
import cerent.cms.model.event.IAlarmStore;
import cerent.cms.model.event.StoreObservable;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.ChangeCardDialog;
import cerent.util.SDebug;
import com.cisco.ctc600.ui.asap.PimSlot;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class AsapCard
extends CardGraphic {
    private PimSlot[] pimSlots = null;
    private IAlarmStore eleAlarmStore = null;
    protected static final String CHANGE_CARD_TYPE = "Change Card...";

    public AsapCard(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug) {
        super(entityModel, abstractShelfLayout, sDebug);
        this.createChildren();
        if (sDebug.on()) {
            sDebug.println("Card: " + entityModel.getEqLabel() + "\tNum of children: " + this.entityM.getChildren().size());
        }
    }

    private void createChildren() {
        block7: {
            try {
                List list = this.entityM.getChildren();
                if (this.db.on()) {
                    this.db.println("Number of PIM slot is " + list.size());
                }
                this.pimSlots = new PimSlot[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    EntityModel entityModel = (EntityModel)list.get(i);
                    if (this.db.on()) {
                        this.db.println("Entity for PIM slot [" + i + "] is " + entityModel);
                    }
                    if (entityModel == null) {
                        if (!this.db.on()) continue;
                        this.db.println("Entity for PIM slot [" + i + "] is NULL");
                        continue;
                    }
                    PluggableSlotModel pluggableSlotModel = null;
                    if (entityModel instanceof PluggableSlotModel) {
                        pluggableSlotModel = (PluggableSlotModel)entityModel;
                        this.pimSlots[i] = new PimSlot(pluggableSlotModel, this.parent, this.db, this.getChildBounds(i));
                        continue;
                    }
                    if (!this.db.on()) continue;
                    this.db.println("Error: Entity for PIM slot [" + i + "] is " + entityModel);
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block7;
                this.db.println("Exception while creating PIM slots");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public PimSlot[] getChildren() {
        return this.pimSlots;
    }

    public String getTooltipText(MouseEvent mouseEvent) {
        try {
            for (int i = 0; i < this.pimSlots.length; ++i) {
                if (!this.pimSlots[i].contains(mouseEvent.getPoint())) continue;
                return this.pimSlots[i].getTooltipText(mouseEvent);
            }
            return super.getTooltipText(mouseEvent);
        }
        catch (Exception exception) {
            this.db.println("exception in getTooltipText: " + exception);
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void update(Observable observable, Object object) {
        Object[] objectArray;
        if (observable instanceof StoreObservable && object instanceof Object[] && (objectArray = (Object[])object)[0] == ModelUpdateType.DELETED) {
            return;
        }
        super.update(observable, object);
        if (observable instanceof StoreObservable && object instanceof ArrayList) {
            super.refreshCard();
        }
        if (this.db.on()) {
            this.db.println("AsapCard:update: END");
        }
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        super.paintIcon(component, graphics, n, n2);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.getLaserOnColor(this.getState()));
        graphics2D.fillOval(9, 20, 5, 6);
        graphics2D.setColor(Color.black);
        graphics2D.drawString("O", 9, 26);
        graphics2D.setFont(graphics2D.getFont().deriveFont(7.0f));
        graphics2D.drawString("LSR", 16, 26);
        if (this.pimSlots == null) {
            return;
        }
        for (int i = 0; i < this.pimSlots.length; ++i) {
            if (this.pimSlots[i] == null) continue;
            this.pimSlots[i].draw(graphics2D);
        }
    }

    protected void addCustomMenuItems(JPopupMenu jPopupMenu) {
        SlotModel slotModel;
        ModuleModel moduleModel;
        IEntityModel iEntityModel;
        super.addCustomMenuItems(jPopupMenu);
        IEntityModel iEntityModel2 = this.getModel();
        if (iEntityModel2 != null && iEntityModel2 instanceof ModuleModel && (iEntityModel = (moduleModel = (ModuleModel)iEntityModel2).getParent()) instanceof SlotModel && (slotModel = (SlotModel)iEntityModel).getListOfValidChangeType(eEqType.from_int(moduleModel.getEqType())).size() > 0) {
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.makeMenuAction(CHANGE_CARD_TYPE, AbstractPane.isUserAuthorized(moduleModel, SecurityLevel.PROVISIONING)));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            if (actionEvent.getActionCommand().equals(CHANGE_CARD_TYPE)) {
                new ChangeCardDialog(JOptionPane.getFrameForComponent(this.parent), (ModuleModel)this.getModel());
            } else {
                super.actionPerformed(actionEvent);
            }
        }
    }

    protected Rectangle getChildBounds(int n) {
        return new Rectangle(3, 35 + 49 * n, this.cardPainter.getCardWidth() - 7, 46);
    }

    public void dispose() {
        if (this.eleAlarmStore != null) {
            this.eleAlarmStore.deleteObserver((Observer)this);
            this.eleAlarmStore = null;
        }
        if (this.pimSlots != null) {
            for (int i = 0; i < this.pimSlots.length; ++i) {
                if (this.pimSlots[i] == null) continue;
                this.pimSlots[i].dispose();
                this.pimSlots[i] = null;
            }
        }
        this.pimSlots = null;
        super.dispose();
    }

    protected Color getLaserOnColor(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 6: {
                return ElementDefaults.OOS_DSBLD_COLOR.darker();
            }
        }
        if (!this.hasProvisionedPort()) {
            return ElementDefaults.OOS_DSBLD_COLOR.darker();
        }
        return ElementDefaults.IS_COLOR;
    }

    private boolean hasProvisionedPort() {
        boolean bl = false;
        PpmModel[] ppmModelArray = ((PluggableCarrierModel)this.entityM).getPpmModels();
        int n = -1;
        for (int i = 0; i < ppmModelArray.length; ++i) {
            n = ppmModelArray[i].getState().value();
            if (n != 5 && n != 4 && n != 3) continue;
            bl = ppmModelArray[i].getChildren().size() > 0;
            break;
        }
        return bl;
    }
}

