/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.asap;

import cerent.cms.idl.EtherMedia.eEncapCrcType;
import cerent.cms.idl.EtherMedia.ePosFramingType;
import cerent.cms.idl.EtherMedia.sAsapPosPortAdminInfo;
import cerent.cms.model.AsapModuleModel;
import cerent.cms.model.AsapPosLineModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.InvalidCardMode;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.enum.EtherEnumStrings;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class AsapPosPortTableModel
extends AbstractTableModel {
    private AsapModuleModel asapModuleModel = null;
    private AsapPosLineModel[] posLineModels = null;
    private boolean[][] rowDirty = null;
    private int numLines = 0;
    private sAsapPosPortAdminInfo[] asapPosPortAdminInfo = null;
    private TDMTerminology tdmTerm;
    protected String[] columnNames = new String[]{"Port", "Port Name", "Service State", "Framing Type", "Encap CRC"};
    protected static final int PORT_NUMBER_INDEX = 0;
    protected static final int PORT_NAME_INDEX = 1;
    protected static final int SERVICE_STATE_INDEX = 2;
    protected static final int FRAMING_TYPE_INDEX = 3;
    protected static final int CRC_TYPE_INDEX = 4;
    private static final SDebug db = new SDebug("AsapPosPortTableModel");
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$cerent$cms$idl$EtherMedia$ePosFramingType;
    static /* synthetic */ Class class$cerent$cms$idl$EtherMedia$eEncapCrcType;

    public AsapPosPortTableModel(AsapModuleModel asapModuleModel, AsapPosLineModel[] asapPosLineModelArray) {
        this.asapModuleModel = asapModuleModel;
        this.posLineModels = asapPosLineModelArray;
        this.tdmTerm = asapModuleModel.getNodeModel().getTDMTerminology();
        this.init();
        this.resetDirty();
    }

    private void init() {
        this.numLines = this.posLineModels.length;
        this.rowDirty = new boolean[this.numLines][this.getColumnCount()];
        this.asapPosPortAdminInfo = new sAsapPosPortAdminInfo[this.numLines];
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = false;
        if (n2 == 3 || n2 == 4 && this.asapPosPortAdminInfo[n].posFraming != ePosFramingType.X86) {
            bl = AbstractPane.isUserAuthorized(this.asapModuleModel, SecurityLevel.PROVISIONING);
        }
        return bl;
    }

    private sAsapPosPortAdminInfo getAsapPosPortAdminInfo(int n) throws NoSuchInterface, WrongInterfaceType, InvalidCardMode {
        if (this.asapPosPortAdminInfo[n] == null) {
            this.asapPosPortAdminInfo[n] = this.posLineModels[n].getAsapPosPortAdminInfo();
        }
        return this.asapPosPortAdminInfo[n];
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    private String getLineNumberFor(int n) {
        try {
            return PortHelper.getPortNumString((IPortModel)this.posLineModels[n].getPortModel());
        }
        catch (Exception exception) {
            if (AsapPosPortTableModel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return "unknown";
        }
    }

    public int getRowCount() {
        return this.numLines;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 1: {
                return class$java$lang$String == null ? (class$java$lang$String = AsapPosPortTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = AsapPosPortTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    private String getPortName(int n) {
        try {
            return this.posLineModels[n].getAlias();
        }
        catch (Exception exception) {
            db.fine("Exception caught accessing port name: " + exception);
            return exception.toString();
        }
    }

    private IServiceState getServiceState(int n) throws NoSuchInterface {
        return this.posLineModels[n].getServiceSt();
    }

    public Object getValueAt(int n, int n2) {
        String string = "";
        try {
            switch (n2) {
                case 0: {
                    return this.getLineNumberFor(n);
                }
                case 1: {
                    return this.getPortName(n);
                }
                case 2: {
                    return this.getServiceState(n).toString(this.tdmTerm);
                }
                case 3: {
                    return this.getFramingTypeFor(n);
                }
                case 4: {
                    return this.getEncapCrcTypeFor(n);
                }
            }
        }
        catch (Exception exception) {
            db.fine("Error in getValueAt in ASAPPosPortTableModel " + exception);
            SDebug.printStackTrace((Throwable)exception);
            string = exception.toString();
        }
        return string;
    }

    private Attribute getFramingTypeFor(int n) throws NoSuchInterface, WrongInterfaceType, InvalidCardMode {
        if (this.asapPosPortAdminInfo[n] == null) {
            this.getAsapPosPortAdminInfo(n);
        }
        return EtherEnumStrings.get(class$cerent$cms$idl$EtherMedia$ePosFramingType == null ? (class$cerent$cms$idl$EtherMedia$ePosFramingType = AsapPosPortTableModel.class$("cerent.cms.idl.EtherMedia.ePosFramingType")) : class$cerent$cms$idl$EtherMedia$ePosFramingType, this.asapPosPortAdminInfo[n].posFraming.value());
    }

    private Attribute getEncapCrcTypeFor(int n) throws NoSuchInterface, WrongInterfaceType, InvalidCardMode {
        if (this.asapPosPortAdminInfo[n] == null) {
            this.getAsapPosPortAdminInfo(n);
        }
        return EtherEnumStrings.get(class$cerent$cms$idl$EtherMedia$eEncapCrcType == null ? (class$cerent$cms$idl$EtherMedia$eEncapCrcType = AsapPosPortTableModel.class$("cerent.cms.idl.EtherMedia.eEncapCrcType")) : class$cerent$cms$idl$EtherMedia$eEncapCrcType, this.asapPosPortAdminInfo[n].payloadFCS.value());
    }

    protected Attribute getAttributeFor(TreeMap treeMap, int n) {
        return (Attribute)treeMap.get(new Integer(n));
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 3: {
                ePosFramingType ePosFramingType2;
                if (this.asapPosPortAdminInfo[n] == null) {
                    try {
                        this.getAsapPosPortAdminInfo(n);
                        ePosFramingType2 = this.asapPosPortAdminInfo[n].posFraming;
                    }
                    catch (Exception exception) {
                        ePosFramingType2 = null;
                    }
                } else {
                    ePosFramingType2 = this.asapPosPortAdminInfo[n].posFraming;
                }
                this.asapPosPortAdminInfo[n].posFraming = ePosFramingType.from_int(((Attribute)object).getIntValue());
                if (ePosFramingType2 != null && ePosFramingType2.value() == this.asapPosPortAdminInfo[n].posFraming.value()) break;
                this.asapPosPortAdminInfo[n].payloadFCS = eEncapCrcType.CRC_32;
                break;
            }
            case 4: {
                this.asapPosPortAdminInfo[n].payloadFCS = eEncapCrcType.from_int(((Attribute)object).getIntValue());
                break;
            }
            default: {
                return;
            }
        }
        this.rowDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    protected boolean isRowDirty(int n) {
        for (int i = 0; i < this.rowDirty[n].length; ++i) {
            if (!this.rowDirty[n][i]) continue;
            return true;
        }
        return false;
    }

    private void resetDirty() {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetRowDirty(i);
        }
    }

    protected void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            db.fine("Invalid lineNo for refresh " + n);
            return;
        }
        this.clearLineModel(n);
        this.resetRowDirty(n);
        this.fireTableRowsUpdated(n, n);
    }

    protected void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.clearLineModel(i);
        }
        this.resetDirty();
        this.fireTableDataChanged();
    }

    public void refreshMyLines(AsapPosLineModel[] asapPosLineModelArray) {
        this.posLineModels = asapPosLineModelArray;
        this.init();
        this.fireTableDataChanged();
    }

    private void clearLineModel(int n) {
        this.asapPosPortAdminInfo[n] = null;
    }

    private void resetRowDirty(int n) {
        for (int i = 0; i < this.rowDirty[n].length; ++i) {
            this.rowDirty[n][i] = false;
        }
    }

    protected void applyToModels() throws Exception {
        for (int i = 0; i < this.numLines; ++i) {
            if (!this.rowDirty[i][3] && !this.rowDirty[i][4]) continue;
            this.posLineModels[i].setAsapPosPortAdminInfo(this.getAsapPosPortAdminInfo(i));
        }
        this.resetDirty();
    }

    protected Attribute[] getPosFramingTypeAttrs() {
        return EtherEnumStrings.get(class$cerent$cms$idl$EtherMedia$ePosFramingType == null ? (class$cerent$cms$idl$EtherMedia$ePosFramingType = AsapPosPortTableModel.class$("cerent.cms.idl.EtherMedia.ePosFramingType")) : class$cerent$cms$idl$EtherMedia$ePosFramingType);
    }

    protected Attribute[] getEncapCrcTypeAttrs() {
        return EtherEnumStrings.get(class$cerent$cms$idl$EtherMedia$eEncapCrcType == null ? (class$cerent$cms$idl$EtherMedia$eEncapCrcType = AsapPosPortTableModel.class$("cerent.cms.idl.EtherMedia.eEncapCrcType")) : class$cerent$cms$idl$EtherMedia$eEncapCrcType);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

