/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.shelf;

import cerent.cms.idl.Node.eDbType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.PersistentFileChooserDialog;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobListener;
import cerent.util.job.IJobProgressControl;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobProgressDialog;
import cerent.util.job.JobStatus;
import com.cisco.ctc600.model.DatabaseManagementModel;
import com.cisco.ctc600.model.PlatformNodeModel;
import com.cisco.ctc600.ui.shelf.SmpSoftwarePane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;

public abstract class AbstractBRCNDialog
extends JDialog
implements ActionListener,
IJobListener {
    protected String fileName = null;
    protected int operation = 0;
    protected JButton okButton = null;
    private JButton cancelButton = null;
    protected JButton browseButton = null;
    protected JTextField fileField = null;
    protected PlatformNodeModel nodeModel = null;
    protected JobProgressDialog progressDlg;
    private String titleMessage = null;
    private static final String FILE_DIALOG_MSG = "Select file";
    protected static final String BACKUP_RESTORE_PROP = "ctc";
    protected static final String BACKUP_RESTORE_PATH = "backup-restore.file.path";
    protected static final SDebug db = new SDebug("AbstractBRCNDialog");
    protected DatabaseManagementModel dbModel;
    protected String confirmMessage;
    protected boolean swDowngradeDbRestore = false;

    public AbstractBRCNDialog(AbstractPane abstractPane, NodeModelDelegate nodeModelDelegate, int n, String string) {
        super(JOptionPane.getFrameForComponent((Component)((Object)abstractPane)), string, true);
        this.nodeModel = (PlatformNodeModel)nodeModelDelegate;
        this.operation = n;
        this.titleMessage = string;
        this.getContentPane().add((Component)this.createMainPanel(), "Center");
        this.getContentPane().add((Component)this.createCommandPanel(), "South");
        this.setLocationRelativeTo(JOptionPane.getFrameForComponent((Component)((Object)abstractPane)));
        this.dbModel = this.nodeModel.getDatabaseManagementModel();
        if (abstractPane instanceof SmpSoftwarePane) {
            this.swDowngradeDbRestore = true;
        }
    }

    private JPanel createMainPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(new BevelBorder(0));
        jPanel.add((Component)this.createFilePathPanel(), "North");
        jPanel.add((Component)this.createOptionPanel(), "Center");
        return jPanel;
    }

    private JPanel createFilePathPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.add((Component)new JLabel("File: "), "West");
        this.fileField = new JTextField();
        jPanel.add((Component)this.fileField, "Center");
        this.browseButton = new JButton("Browse");
        jPanel.add((Component)this.browseButton, "East");
        this.fileField.setPreferredSize(new Dimension(300, 20));
        this.fileField.setEnabled(false);
        this.browseButton.addActionListener(this);
        return jPanel;
    }

    protected abstract JPanel createOptionPanel();

    private JPanel createCommandPanel() {
        Dimension dimension = new Dimension(80, 25);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.okButton = new JButton("OK");
        this.okButton.setPreferredSize(dimension);
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setPreferredSize(dimension);
        this.cancelButton.addActionListener(this);
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    protected JPanel createOptionBox(JCheckBox jCheckBox, boolean bl) {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jCheckBox.setEnabled(bl);
        jPanel.add(jCheckBox);
        if (this.operation == 2) {
            jCheckBox.setEnabled(false);
        }
        return jPanel;
    }

    protected void showOpenDialog() {
        File file = PersistentFileChooserDialog.getFile((Component)this, (String)this.titleMessage, (Object)FILE_DIALOG_MSG, (byte)1, (String)BACKUP_RESTORE_PROP, (String)BACKUP_RESTORE_PATH, (int)20);
        if (file == null) {
            return;
        }
        this.fileName = file.getAbsolutePath();
        if (!file.exists() || !file.canRead()) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_FILE_NOT_EXIST_OR_READ_PARAM_1, (Object)this.fileName);
            return;
        }
        if (file.length() == 0L) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_FILE_SIZE_ZERO_PARAM_1, (Object)this.fileName);
            return;
        }
        this.fileField.setText(this.fileName);
        try {
            this.dbModel.validateDbBackupFile(this.fileName);
            this.setGuiFields();
        }
        catch (Exception exception) {
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_FILE_NOT_EXIST_OR_READ_PARAM_1, (Object)this.fileName);
            SDebug.printStackTrace((Throwable)exception);
            this.fileField.setText("");
            this.okButton.setEnabled(false);
        }
    }

    protected void restoreDB() {
        IJobControl iJobControl;
        if (!this.swDowngradeDbRestore && !this.nodeModel.isRestAllowed()) {
            String string = this.operation == 2 ? "Database restore" : "Configure Node";
            ErrorMsg.displayWarning((Component)this, (EID)EMC.WID_ACTION_FAILED_SWUPGRADE_PARAM_1, string);
            return;
        }
        if (!this.isUserConfirm()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        this.setDbTypes(arrayList);
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ((eDbType)arrayList.get(i)).value();
        }
        this.progressDlg = new JobProgressDialog(JOptionPane.getFrameForComponent(this), this.titleMessage, (this.operation == 2 ? "Restore" : "Node configuration") + " is in progress ....", false, true);
        JobController jobController = JobControllerFactory.createJC((int)1);
        try {
            iJobControl = this.nodeModel.createDataTransferJob(this.fileName, this.operation, (IJobProgressControl)this.progressDlg, nArray);
        }
        catch (Exception exception) {
            this.progressDlg.dispose();
            this.progressDlg = null;
            JobControllerFactory.disposeJC((JobController)jobController);
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_DB_RESTORE_EXCEPTION_PARAM_1, (Object)exception.getMessage());
            return;
        }
        this.progressDlg.setJob(iJobControl);
        this.progressDlg.setProgressText(this.nodeModel.getName() + ": Restoring ...");
        jobController.submitJob(new JobGroup(iJobControl, (IJobListener)this, (Object)jobController));
    }

    protected abstract void setGuiFields();

    protected abstract void setDbTypes(List var1);

    protected boolean isUserConfirm() {
        return CerentDialog.yesNoDialog((Component)this, (String)this.confirmMessage, (String)this.titleMessage);
    }

    protected boolean isUserConfirm(String string) {
        return CerentDialog.yesNoDialog((Component)this, (String)string, (String)this.titleMessage);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton == this.okButton) {
            if (this.operation != 1) {
                this.restoreDB();
            }
            this.dispose();
        } else if (jButton == this.browseButton) {
            if (this.operation != 1) {
                this.showOpenDialog();
            }
            if (this.fileField.getText().length() > 0) {
                this.okButton.setEnabled(true);
            }
        } else if (jButton == this.cancelButton) {
            this.dispose();
        }
    }

    public void jobWaiting(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobRunning(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
    }

    public void jobFinished(JobGroup jobGroup, IJobControl iJobControl, JobStatus jobStatus, Object object) {
        try {
            String string = this.progressDlg.getTitle();
            this.progressDlg.dispose();
            this.progressDlg = null;
            JobController jobController = (JobController)object;
            if (jobController.isIdle()) {
                JobControllerFactory.disposeJC((JobController)jobController);
            }
            if (jobStatus.value() == 3) {
                CerentDialog.infoDialog((Component)this, (String)(string + " aborted"), (String)string);
            } else if (jobStatus.value() == 2) {
                Exception exception = (Exception)jobStatus.getResult();
                if (exception != null) {
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)this, (EID)EMC.EID_JOB_FAIL_EXCEPTION_PARAM_1, (Object)exception.getMessage());
                }
            } else if (jobStatus.value() == 4 && this.operation == 1) {
                db.fine("JobStatus.COMPLETE FOR BACKUP");
                CerentDialog.infoDialog((Component)this, (String)(string + " complete"), (String)string);
            }
            this.cleanup();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    protected void cleanup() {
        this.fileName = null;
        this.fileField = null;
        this.progressDlg = null;
        this.titleMessage = null;
        this.nodeModel = null;
        this.dbModel = null;
        this.okButton.removeActionListener(this);
        this.cancelButton.removeActionListener(this);
        this.browseButton.removeActionListener(this);
        this.okButton = null;
        this.cancelButton = null;
        this.browseButton = null;
        this.confirmMessage = null;
        this.removeAll();
    }
}

