/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.shelf;

import cerent.cms.idl.Node.eDbType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.ui.AbstractPane;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.PersistentFileChooserDialog;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobListener;
import cerent.util.job.IJobProgressControl;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobProgressDialog;
import com.cisco.ctc600.ui.shelf.AbstractBRCNDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class BackupRestoreDialog
extends AbstractBRCNDialog {
    private static final String BACKUP_TITLE = "Database Backup";
    private static final String RESTORE_TITLE = "Database Restore";
    private static final String BACKUP_MSG = "Select file for saving backup";
    private JCheckBox provChkbox;
    private JCheckBox alarmChkbox;
    private JCheckBox pmChkbox;
    private final String restoreMessage = "Restoring a database from an earlier backup may\nresult in a loss of traffic.\n The node will reboot after restore completed.\n\nOK to Continue?";
    private final String swRevertMessage = "Reverting to an older version will result in loss\nof all existing provisioning, and will restore the\n provisioning made with the older software version.\n\nOK to Continue?";
    protected static final SDebug db = new SDebug("BackupRestoreDialog");

    public BackupRestoreDialog(AbstractPane abstractPane, NodeModelDelegate nodeModelDelegate, int n) {
        super(abstractPane, nodeModelDelegate, n, n == 1 ? BACKUP_TITLE : RESTORE_TITLE);
        this.confirmMessage = this.swDowngradeDbRestore ? "Reverting to an older version will result in loss\nof all existing provisioning, and will restore the\n provisioning made with the older software version.\n\nOK to Continue?" : "Restoring a database from an earlier backup may\nresult in a loss of traffic.\n The node will reboot after restore completed.\n\nOK to Continue?";
        this.setSize(new Dimension(455, 230));
    }

    protected JPanel createOptionPanel() {
        JPanel jPanel = new JPanel(new GridLayout(3, 2));
        String string = this.operation == 1 ? "Backup Options" : "Restore Options";
        jPanel.setBorder(new TitledBorder(new EtchedBorder(1), string, 1, 2));
        this.provChkbox = new JCheckBox("Provisioning", true);
        jPanel.add(this.createOptionBox(this.provChkbox, false));
        this.alarmChkbox = new JCheckBox("Alarms", false);
        jPanel.add(this.createOptionBox(this.alarmChkbox, true));
        this.pmChkbox = new JCheckBox("Performance", false);
        jPanel.add(this.createOptionBox(this.pmChkbox, true));
        return jPanel;
    }

    private void showSaveDialog() {
        File file = PersistentFileChooserDialog.getFile((Component)this, (String)BACKUP_TITLE, (Object)BACKUP_MSG, (byte)2, (String)"ctc", (String)"backup-restore.file.path", (int)20);
        if (file == null) {
            return;
        }
        this.fileName = file.getAbsolutePath();
        this.fileField.setText(this.fileName);
    }

    private void backupDB() {
        IJobControl iJobControl;
        this.progressDlg = new JobProgressDialog(JOptionPane.getFrameForComponent(this), BACKUP_TITLE, "Backup is in progress ....", false, true);
        JobController jobController = JobControllerFactory.createJC((int)1);
        try {
            this.dbModel.setUserSelection(this.buildBackupInfo());
            iJobControl = this.nodeModel.createDataTransferJob(this.fileName, 1, (IJobProgressControl)this.progressDlg);
        }
        catch (Exception exception) {
            this.progressDlg.dispose();
            this.progressDlg = null;
            JobControllerFactory.disposeJC((JobController)jobController);
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)this, (EID)EMC.EID_DB_BACKUP_EXCEPTION_PARAM_1, (Object)exception.getClass().getName());
            return;
        }
        this.progressDlg.setJob(iJobControl);
        this.progressDlg.setProgressText(this.nodeModel.getName() + ": Backing up ...");
        jobController.submitJob(new JobGroup(iJobControl, (IJobListener)this, (Object)jobController));
    }

    private int[] buildBackupInfo() {
        ArrayList<eDbType> arrayList = new ArrayList<eDbType>();
        arrayList.add(eDbType.RELEASE);
        if (this.pmChkbox.isSelected()) {
            arrayList.add(eDbType.PM15MIN);
            arrayList.add(eDbType.PM1DAY);
        }
        if (this.alarmChkbox.isSelected()) {
            arrayList.add(eDbType.ALARM);
        }
        arrayList.add(eDbType.PROV);
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ((eDbType)arrayList.get(i)).value();
        }
        return nArray;
    }

    protected void setDbTypes(List list) {
        list.add(eDbType.RELEASE);
        if (this.pmChkbox.isSelected()) {
            list.add(eDbType.PM15MIN);
            list.add(eDbType.PM1DAY);
        }
        if (this.alarmChkbox.isSelected()) {
            list.add(eDbType.ALARM);
        }
        list.add(eDbType.PROV);
    }

    protected void setGuiFields() {
        int[] nArray = this.dbModel.getDbTypesFromFile();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == eDbType.PROV.value()) {
                this.provChkbox.setSelected(true);
                this.provChkbox.setEnabled(false);
                continue;
            }
            if (nArray[i] == eDbType.ALARM.value()) {
                this.alarmChkbox.setSelected(true);
                this.alarmChkbox.setEnabled(true);
                continue;
            }
            if (nArray[i] != eDbType.PM15MIN.value() && nArray[i] != eDbType.PM1DAY.value()) continue;
            this.pmChkbox.setSelected(true);
            this.pmChkbox.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton == this.okButton) {
            if (this.operation == 1) {
                this.backupDB();
            }
        } else if (jButton == this.browseButton && this.operation == 1) {
            this.showSaveDialog();
        }
        super.actionPerformed(actionEvent);
    }

    protected void cleanup() {
        this.alarmChkbox = null;
        this.pmChkbox = null;
        this.provChkbox = null;
        this.removeAll();
        super.cleanup();
    }
}

