/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.shelf;

import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IServiceState;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.ICardPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;

public class CardPainter
implements ICardPainter {
    static final float CARD_H_TO_CARD_W_RATIO = 9.166667f;
    static final float PORT_H_TO_PORT_W_RATIO = 2.0f;
    static final float PORT_W_TO_CARD_W_RATIO = 0.41666666f;
    static final float OPTICON_Y_OFFSET_TO_CARD_H_RATIO = 0.3181818f;
    static final float OPTICON_Y_SPACING_TO_CARD_H_RATIO = 0.11363637f;
    static final float FONT_TO_CARD_W_RATIO = 0.33333334f;
    static final int CARD_WIDTH = 34;
    static final int CARD_HEIGHT = 264;
    static final int OPTICON_X_OFFSET = 4;
    static final int MULTIPORT_OPTICON_X_OFFSET = 7;
    static final int OPTICON_Y_OFFSET = 93;
    static final int OPTICON_X_SPACING = 0;
    static final int OPTICON_Y_SPACING = 25;
    static final int PORT_CONN1_X = 4;
    static final int PORT_CONN2_X = 11;
    static final int PORT_CONN1_Y = 2;
    static final int PORT_CONN2_Y = 2;
    static final int PORT_WIDTH = 4;
    static final int PORT_HEIGHT = 12;
    static final int SMALL_PORT_HEIGHT = 4;
    static final int PORT_LOOPBACK_DIST = 3;
    static final int SMALL_PORT_CONN1_Y = 1;
    static final int SMALL_PORT_CONN2_Y = 2;
    static final int MINI_PORT_WIDTH = Math.round(9.916666f);
    static final int MINI_PORT_HEIGHT = Math.round(16.291666f);
    static final int MINI_MULTIPORT_OPTICON_X_OFFSET = (34 - MINI_PORT_WIDTH) / 2;
    static final int MINI_OPTICON_Y_OFFSET = 89;
    static final int MINI_OPTICON_X_SPACING = 0;
    static final int MINI_OPTICON_Y_SPACING = MINI_PORT_HEIGHT + 3;
    protected final int WIDTH;
    protected static final int HEIGHT = 264;
    protected static final int SM_HEIGHT = 132;
    public static final int SLOT_WIDTH = 34;
    public static final int SLOT_HEIGHT = 264;
    protected final Dimension SLOT_DIM;
    protected final int RECT_WIDTH;
    protected final int RECT_HEIGHT = 6;
    protected final int RECT_OFFSET = 49;
    protected final int TOP_RECT_OFFSET = 49;
    protected final int TOP_RECT_HEIGHT = 6;
    protected final int BOTTOM_RECT_OFFSET = 179;
    protected final int BOTTOM_RECT_HEIGHT = 6;
    protected static final int EXTRACTOR_HEIGHT = 16;
    protected static final int EXTRACTOR_WIDTH = 7;
    protected static final int TAB_MARGIN = 2;
    protected static final int TAB_RADIUS = 13;
    protected static final int TAB_DIAMETER = 26;
    protected static final int TAB_ARC_WIDTH = 14;
    protected static final int TAB_ARC_HEIGHT = -10;
    protected static final int BOTTOM_EXTRACTOR_OFFSET = 247;
    protected static final int BOTTOM_EXTRACTOR_HEIGHT = 16;
    protected static final int TOP_EXTRACTOR_OFFSET = 0;
    protected static final int TOP_EXTRACTOR_HEIGHT = 16;
    protected static final int NAME_X_OFFSET = 10;
    protected static final int NAME_Y_OFFSET = 10;
    protected static final int ACTIVE_LIGHT_Y_OFFSET = 60;
    protected static final int ACTIVE_LIGHT_WIDTH = 6;
    protected static final int ACTIVE_LIGHT_HEIGHT = 4;
    public static final int LED_WIDTH = 5;
    public static final int LED_HEIGHT = 6;
    public static final int STATUS_LED_X_OFFSET = 9;
    public static final int STATUS_LED_Y_OFFSET = 19;
    protected static final float[] dash1 = new float[]{1.5f};
    public static final Rectangle topSerialRect = new Rectangle(2, 2, 3, 12);
    public static final Rectangle bottomSerialRect = new Rectangle(2, 249, 3, 12);
    public static final Rectangle topExtractorRect = new Rectangle(0, 0, 7, 32);
    public static final Rectangle bottomExtractorRect = new Rectangle(0, 231, 7, 247);
    protected final Rectangle mainRectangle;
    protected final Rectangle groupOneRect;
    protected final Rectangle groupTwoRect;
    protected final Rectangle groupThreeRect;
    protected final Rectangle groupFourRect;
    protected CardGraphic cg;
    protected int eqType = 95;

    public CardPainter(CardGraphic cardGraphic) {
        this.cg = cardGraphic;
        this.RECT_WIDTH = this.WIDTH = this.cg.getSlotsOccupied() * 34;
        this.SLOT_DIM = new Dimension(this.WIDTH, 264);
        this.eqType = this.cg.getModel().getEqType();
        this.groupOneRect = new Rectangle(0, 90, this.RECT_WIDTH, 18);
        this.groupTwoRect = new Rectangle(0, 110, this.RECT_WIDTH, 18);
        this.groupThreeRect = new Rectangle(0, 132, this.RECT_WIDTH, 18);
        this.groupFourRect = new Rectangle(0, 152, this.RECT_WIDTH, 18);
        this.mainRectangle = new Rectangle(0, 0, this.WIDTH, 264);
    }

    public void updateWidth() {
    }

    protected int getCardHeight(int n) {
        return 264;
    }

    protected int getCardWidth(int n) {
        return this.WIDTH;
    }

    protected int getRectHeight() {
        return 6;
    }

    protected int getRectOffset() {
        return 49;
    }

    protected int getExtractorHeight() {
        return 16;
    }

    protected int getExtractorWidth() {
        return 7;
    }

    protected int getTabMargin() {
        return 2;
    }

    protected int getExtractorOffset() {
        return 0;
    }

    protected int getNameXOffset() {
        return 10;
    }

    protected int getNameYOffset() {
        return 10;
    }

    public int getOpticonXOffset() {
        return 4;
    }

    public int getOpticonYOffset() {
        return 93;
    }

    public int getMultiPortOpticonXOffset() {
        return 7;
    }

    public int getOpticonXSpacing() {
        return 0;
    }

    public int getOpticonYSpacing() {
        return 25;
    }

    public int getMiniMultiPortOticonXOffset() {
        return MINI_MULTIPORT_OPTICON_X_OFFSET;
    }

    public int getCardWidth() {
        return 34;
    }

    public int getCardHeight() {
        return 264;
    }

    public Rectangle getMainRectangle() {
        return this.mainRectangle;
    }

    public int getPortWidth() {
        return 4;
    }

    public int getPortHeight() {
        return 12;
    }

    public int getMiniPortWidth() {
        return MINI_PORT_WIDTH;
    }

    public int getMiniPortHeight() {
        return MINI_PORT_HEIGHT;
    }

    public int getMiniOpticonXSpacing() {
        return 0;
    }

    public int getMiniOpticonYSpacing() {
        return MINI_OPTICON_Y_SPACING;
    }

    public int getMiniOpticonYOffset() {
        return 89;
    }

    public int getPortX(int n, int n2) {
        return 0;
    }

    public int getPortY(int n, int n2) {
        return 0;
    }

    public int getSmallPortWidth() {
        return 0;
    }

    public int getSmallPortHeight() {
        return 4;
    }

    public int getPortConn1X() {
        return 4;
    }

    public int getPortConn2X() {
        return 11;
    }

    public int getPortConn1Y() {
        return 2;
    }

    public int getPortConn2Y() {
        return 2;
    }

    public int getSmallPortConn1Y() {
        return 1;
    }

    public int getSmallPortConn2Y() {
        return 2;
    }

    public int getSmallPortConn1X() {
        return 0;
    }

    public int getSmallPortConn2X() {
        return 0;
    }

    public int getPortLoopbackDist() {
        return 3;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(graphics2D.getFont().deriveFont(1));
        graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        Font font = graphics2D.getFont();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(this.cg.getCurrentColor());
        graphics2D.fill(this.mainRectangle);
        graphics2D.setColor(Color.darkGray);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.draw(this.mainRectangle);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.setColor(Color.gray);
        graphics2D.fill(topExtractorRect);
        graphics2D.fill(bottomExtractorRect);
        graphics2D.setColor(Color.black);
        graphics2D.draw(topExtractorRect);
        graphics2D.draw(bottomExtractorRect);
        graphics2D.setColor(Color.lightGray);
        graphics2D.draw(topSerialRect);
        graphics2D.draw(bottomSerialRect);
        int n3 = this.cg.getState();
        String string = this.cg.getEqLabel();
        if (string == null) {
            string = "";
        }
        if (this.eqType != 95 && this.eqType != 125) {
            graphics2D.setColor(this.getStatusColor(n3));
            graphics2D.fillOval(9, 13, 5, 6);
            graphics2D.setColor(Color.black);
            graphics2D.drawString("O", 9, 19);
            graphics2D.setFont(font.deriveFont(7.0f));
            graphics2D.drawString("STA", 16, 19);
            int n4 = 19;
            if (this.eqType == 146) {
                n4 += 7;
            }
            graphics2D.setFont(font);
            graphics2D.setColor(this.getServiceColor(this.getServiceState()));
            graphics2D.fillOval(9, n4 + 1, 5, 6);
            graphics2D.setColor(Color.black);
            graphics2D.drawString("O", 9, n4 + 7);
            graphics2D.setFont(font.deriveFont(7.0f));
            graphics2D.drawString("SRV", 16, n4 + 7);
            graphics2D.setFont(font);
            graphics2D.setColor(Color.darkGray);
            BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 3.0f, dash1, 0.0f);
            graphics2D.setStroke(basicStroke);
            graphics2D.draw(this.groupOneRect);
            graphics2D.draw(this.groupTwoRect);
            graphics2D.draw(this.groupThreeRect);
            graphics2D.draw(this.groupFourRect);
        }
        graphics2D.setColor(Color.black);
        if (string.length() > 4) {
            String string2 = "";
            if (string.startsWith("OC")) {
                string2 = string.substring(2, string.length());
            } else if (string.startsWith("CXC")) {
                string2 = string.substring(2, string.length());
            } else if (string.startsWith("ASAP")) {
                string2 = string.substring(0, 4);
            }
            graphics2D.drawString(string2, n + 10, n2 + 10);
        } else {
            graphics2D.drawString(string, n + 10 - 1, n2 + 10);
        }
        graphics2D.setStroke(stroke);
    }

    protected boolean canOpenCard() {
        int n = this.cg.getModel().getEqType();
        int n2 = this.cg.getState();
        return n != 89 && n != 91 && n != 125 && n != 95 && n2 != 6;
    }

    protected boolean isControllerCard() {
        return this.cg.getModel().getEqType() == 89;
    }

    protected boolean isCrossConnect() {
        int n = this.cg.getModel().getEqType();
        return n == 91;
    }

    protected Dimension getSlotDim(int n) {
        return this.SLOT_DIM;
    }

    protected int initWidth() {
        return 34;
    }

    protected IServiceState getServiceState() {
        try {
            return ((MfgEntityModel)this.cg.getModel()).getServiceSt();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Color getServiceColor(IServiceState iServiceState) {
        if (iServiceState == null) {
            return ElementDefaults.OOS_DSBLD_COLOR.darker();
        }
        int n = this.cg.getState();
        if (n == 0 || n == 6 || n == 2) {
            return ElementDefaults.OOS_DSBLD_COLOR.darker();
        }
        switch (iServiceState.getPSTValue()) {
            case 0: {
                return ElementDefaults.IS_COLOR;
            }
        }
        return ElementDefaults.MAJOR_ALARM_COLOR;
    }

    protected Color getStatusColor(int n) {
        switch (n) {
            case 3: {
                return ElementDefaults.CRITICAL_ALARM_COLOR;
            }
        }
        return ElementDefaults.OOS_DSBLD_COLOR.darker();
    }
}

