/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.shelf;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SlotModel;
import cerent.cms.model.event.AlarmStatus;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.model.event.StoreObservable;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.shelf.AbstractOCNCard;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.OpticalPortGraphic;
import cerent.util.SDebug;
import com.cisco.ctc600.ui.shelf.OCNConnectorGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.swing.JPopupMenu;

public class OCNCard600
extends AbstractOCNCard {
    private static final int MAX_CONNECTORS = 4;
    private OCNConnectorGraphic[] connectorGraphics = null;
    private int numConnectors = 0;
    private int numPorts = 0;
    private int numPortsPerConnector = 0;
    private int remainingPorts = 0;
    private Map portConnMap = null;

    public OCNCard600(EntityModel entityModel, AbstractShelfLayout abstractShelfLayout, SDebug sDebug) {
        super(entityModel, abstractShelfLayout, sDebug);
        this.setupConnectors();
    }

    private void setupConnectors() {
        try {
            this.portConnMap = new HashMap();
            OpticalPortGraphic[] opticalPortGraphicArray = null;
            this.numPorts = this.portGraphics.length;
            this.numConnectors = 4;
            if (this.numPorts < this.numConnectors) {
                this.numConnectors = this.numPorts;
            }
            this.numPortsPerConnector = this.numPorts / this.numConnectors;
            this.remainingPorts = this.numPorts - this.numPortsPerConnector * this.numConnectors;
            this.connectorGraphics = new OCNConnectorGraphic[this.numConnectors];
            for (int i = 0; i < this.numConnectors; ++i) {
                opticalPortGraphicArray = this.getConnectorPortGraphics(i);
                if (opticalPortGraphicArray != null) {
                    this.connectorGraphics[i] = new OCNConnectorGraphic(this, this.cardPainter.getOpticonXOffset() - 4 + this.cardPainter.getOpticonXSpacing() * i, this.cardPainter.getOpticonYOffset() + 22 + (this.cardPainter.getOpticonYSpacing() - 11) * i, i, opticalPortGraphicArray);
                    continue;
                }
                if (!this.db.on()) continue;
                this.db.println("ocnPortGraphicArr[" + i + "] is null");
            }
            this.processPortAlarms();
        }
        catch (Exception exception) {
            this.db.println("Error creating connector graphics");
        }
    }

    public OpticalPortGraphic[] getConnectorPortGraphics(int n) {
        OpticalPortGraphic[] opticalPortGraphicArray = null;
        int n2 = 0;
        n2 = n == this.numConnectors - 1 ? this.numPortsPerConnector + this.remainingPorts : this.numPortsPerConnector;
        opticalPortGraphicArray = new OpticalPortGraphic[n2];
        for (int i = 0; i < n2; ++i) {
            int n3 = n * this.numPortsPerConnector + i;
            this.portConnMap.put(new Integer(n3), new Integer(n));
            opticalPortGraphicArray[i] = this.portGraphics[n3];
        }
        return opticalPortGraphicArray;
    }

    public void update(Observable observable, Object object) {
        Object[] objectArray;
        if (observable instanceof StoreObservable && object instanceof Object[] && (objectArray = (Object[])object)[0] == ModelUpdateType.DELETED) {
            return;
        }
        super.update(observable, object);
        if (object instanceof AlarmStatus) {
            this.processPortAlarms();
        }
        if (observable instanceof StoreObservable && object instanceof ArrayList) {
            super.refreshCard();
        }
        if (this.db.on()) {
            this.db.println("OCNCard:update: END");
        }
    }

    private void processPortAlarms() {
        List list = this.entityM.getChildren();
        for (int i = 0; i < this.portGraphics.length; ++i) {
            int n;
            PortModel portModel = (PortModel)list.get(i);
            IAlarmStatus iAlarmStatus = this.alarmStore.getEntityAlarmStatus(portModel);
            if (iAlarmStatus == null || this.portConnMap == null || (n = ((Integer)this.portConnMap.get(new Integer(i))).intValue()) < 0) continue;
            this.connectorGraphics[n].setAlarmState(iAlarmStatus.getHighestSeverity());
        }
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        super.paintIcon(component, graphics, n, n2);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Font font = graphics2D.getFont();
        Color color = graphics2D.getColor();
        graphics2D.setFont(font);
        graphics2D.setColor(this.getLaserOnColor(this.getState()));
        graphics2D.fillOval(9, 27, 5, 6);
        graphics2D.setColor(Color.black);
        graphics2D.drawString("O", 9, 33);
        graphics2D.setFont(font.deriveFont(7.0f));
        graphics2D.drawString("LSR", 16, 33);
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        for (int i = 0; i < this.numConnectors; ++i) {
            if (this.connectorGraphics[i] == null) continue;
            this.connectorGraphics[i].draw(graphics2D);
        }
    }

    protected void addCustomMenuItems(JPopupMenu jPopupMenu) {
        SlotModel slotModel;
        ModuleModel moduleModel;
        IEntityModel iEntityModel;
        super.addCustomMenuItems(jPopupMenu);
        IEntityModel iEntityModel2 = this.getModel();
        if (iEntityModel2 != null && iEntityModel2 instanceof ModuleModel && (iEntityModel = (moduleModel = (ModuleModel)iEntityModel2).getParent()) instanceof SlotModel && (slotModel = (SlotModel)iEntityModel).getListOfValidChangeType(eEqType.from_int(moduleModel.getEqType())).size() > 0) {
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.makeMenuAction("Change Card...", AbstractPane.isUserAuthorized(moduleModel, SecurityLevel.PROVISIONING)));
        }
    }

    protected Color getServiceColor(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return ElementDefaults.OOS_DSBLD_COLOR.darker();
            }
        }
        return Color.green;
    }

    protected Color getLaserOnColor(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 6: {
                return ElementDefaults.OOS_DSBLD_COLOR.darker();
            }
        }
        return ElementDefaults.IS_COLOR;
    }

    public void dispose() {
        if (this.connectorGraphics != null) {
            for (int i = 0; i < this.connectorGraphics.length; ++i) {
                if (this.connectorGraphics[i] == null) continue;
                this.connectorGraphics[i].dispose();
                this.connectorGraphics[i] = null;
            }
            this.connectorGraphics = null;
        }
        if (this.portConnMap != null) {
            this.portConnMap.clear();
        }
        super.dispose();
    }
}

