/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.shelf;

import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.CSHelpButtonPane;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.SmpDBPane;
import cerent.util.SDebug;
import com.cisco.ctc600.Platform;
import com.cisco.ctc600.ui.shelf.BackupRestoreDialog;
import com.cisco.ctc600.ui.shelf.ConfigureNodeDialog;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;

public class SmpDBPane600
extends SmpDBPane {
    private static final String CONFIGURE_TT = "Copies provisioning database from a file to the ";
    private JButton configureButton = null;

    public SmpDBPane600(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    protected void init() {
        if (db.on()) {
            db.println("init: start");
        }
        JPanel jPanel = SmpDBPane600.createVerticalPanel(null);
        this.setLayout(new BorderLayout());
        this.add(jPanel, "North");
        JPanel jPanel2 = SmpDBPane600.createHorizontalPanel("Database");
        this.backupButton = new JButton("Backup...");
        this.restoreButton = new JButton("Restore...");
        JPanel jPanel3 = SmpDBPane600.createHorizontalPanel("Configure Node");
        this.configureButton = new JButton("Configure...");
        if (this.isUserAuthorized(SecurityLevel.MAINTENANCE)) {
            this.backupButton.addActionListener(this);
        } else {
            this.backupButton.setEnabled(false);
        }
        if (this.isUserAuthorized(SecurityLevel.SUPERUSER)) {
            this.restoreButton.addActionListener(this);
            this.configureButton.addActionListener(this);
        } else {
            this.restoreButton.setEnabled(false);
            this.configureButton.setEnabled(false);
        }
        this.nodeModel = (NodeModelDelegate)this.getUiModel();
        String string = Platform.instance().getControlCardName();
        this.backupButton.setToolTipText("Copies database to a file from the " + string);
        this.restoreButton.setToolTipText("Copies database from a file to the " + string);
        jPanel2.add(this.backupButton);
        jPanel2.add(Box.createHorizontalStrut(20));
        jPanel2.add(this.restoreButton);
        jPanel2.setAlignmentX(0.5f);
        jPanel.add(jPanel2);
        jPanel3.add(this.configureButton);
        this.configureButton.setToolTipText(CONFIGURE_TT + string);
        jPanel.add(jPanel3);
        CSHelpButtonPane cSHelpButtonPane = new CSHelpButtonPane(CSHelpConst.SmpDBPane600);
        this.add(Box.createVerticalGlue(), "Center");
        this.add(cSHelpButtonPane, "South");
        if (db.on()) {
            db.println("init: finish");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        try {
            if (object == this.backupButton) {
                new BackupRestoreDialog(this, this.nodeModel, 1).show();
            } else if (object == this.restoreButton) {
                new BackupRestoreDialog(this, this.nodeModel, 2).show();
            } else if (object == this.configureButton) {
                new ConfigureNodeDialog(this, this.nodeModel, 7).show();
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }
}

