/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ANS;

import cerent.cms.idl.OpticsTopology.eOrigin;
import cerent.cms.idl.OpticsTopology.sParameterKey;
import cerent.cms.model.ANS.ANSNode;
import cerent.cms.model.ANS.ANSValue;
import cerent.cms.model.ProvisionError;
import cerent.util.SDebug;

public class ANSElement
extends ANSNode
implements Comparable<ANSElement> {
    private final String portName;
    private final String myKeyString;
    private final sParameterKey myElemKey;
    private final ANSValue myElemValue;
    private boolean reprovisions;
    private boolean destructive;
    private boolean readOnly = false;
    private eOrigin origin = eOrigin.ORI_DEFAULT;
    private static final String[] ansParamOrigin = new String[]{"DEFAULT", "AUTOMATIC", "PROVISIONED", "IMPORTED"};

    public ANSElement(String[] stringArray, sParameterKey sParameterKey2, ANSValue aNSValue, ANSNode aNSNode, boolean bl, boolean bl2) {
        super(ANSElement.makeNameFromPath(stringArray), aNSNode, stringArray);
        this.portName = ANSElement.makeFullName(stringArray, stringArray.length - 1);
        this.myElemKey = sParameterKey2;
        this.myKeyString = this.makeKeyString(sParameterKey2);
        this.myElemValue = aNSValue;
        this.reprovisions = bl;
        this.destructive = bl2;
        if (this.destructive) {
            this.reprovisions = true;
        }
    }

    public ANSElement(String[] stringArray, sParameterKey sParameterKey2, ANSValue aNSValue) {
        this(stringArray, sParameterKey2, aNSValue, null, false, false);
    }

    @Override
    public int compareTo(ANSElement aNSElement) {
        return this.myKeyString.compareTo(aNSElement.getKeyStr());
    }

    public void setValue(String string) throws ProvisionError {
        if (this.myElemValue.setValue(string)) {
            if (!string.equals("UNKNOWN")) {
                this.setDirty();
            } else {
                this.makeClean();
                this.recalcDirty();
            }
        }
    }

    public boolean reprovisions() {
        return this.reprovisions;
    }

    public boolean causesReboot() {
        return this.destructive;
    }

    public void resetValue() {
        this.myElemValue.resetValue();
        this.recalcDirty();
    }

    public String getPortName() {
        return this.portName;
    }

    public ANSValue getANSValue() {
        return this.myElemValue;
    }

    public sParameterKey getKey() {
        return this.myElemKey;
    }

    public String getKeyStr() {
        return this.myKeyString;
    }

    public void applyToNode() {
        this.makeClean();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public eOrigin getOrigin() {
        return this.origin;
    }

    public String getOriginString() {
        try {
            return ansParamOrigin[this.getOrigin().value()];
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return "";
        }
    }

    public void setOrigin(eOrigin eOrigin2) {
        this.origin = eOrigin2;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public String toString() {
        return "ELE: " + this.getName() + " [" + this.getKeyStr() + "] = " + this.myElemValue.getValue() + "/" + this.myElemValue.getActiveValue();
    }

    private static String makeNameFromPath(String[] stringArray) {
        if (stringArray.length > 0) {
            return stringArray[stringArray.length - 1];
        }
        return "INVALID";
    }

    private String makeKeyString(sParameterKey sParameterKey2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Integer.toHexString(sParameterKey2.paramLocation));
        stringBuffer.append('-');
        stringBuffer.append(Integer.toString(sParameterKey2.type.value()));
        stringBuffer.append('-');
        stringBuffer.append(Integer.toString(sParameterKey2.spectrum.value()));
        stringBuffer.append('-');
        stringBuffer.append(Integer.toString(sParameterKey2.spectrumIndex).toString());
        return stringBuffer.toString();
    }
}

