/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ANS;

import cerent.cms.idl.OpticsTopology.eNodeSetupPortAttr;
import cerent.cms.idl.OpticsTopology.eNodeSetupResult;
import cerent.cms.idl.OpticsTopology.sNodeSetupPort;
import cerent.cms.model.ANS.ANSElement;
import cerent.cms.model.ANS.ANSManager;
import cerent.cms.model.ANS.ANSNode;
import cerent.cms.model.ANS.ANSValue;
import cerent.cms.model.ANS.NodeANS;
import cerent.cms.model.AbstractOpticsLineModel;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InterfaceModels;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.List;

public class ANSResult
extends ANSNode {
    private static final String N_A = "N/A";
    private static final String UNKNOWN = "Unknown";
    private static final String SUCCESS = "Success";
    private static final String FAIL = "Fail";
    private static final String[] nodeSetupOldResult = new String[]{"Not Regulated", "Regulated"};
    private static final String[] nodeSetupResult = new String[]{"Success-Unchanged", "Success-Changed", "Fail-Out of Range", "Unchanged-Port in IS", "Not Applicable State", "Fail-Missing Input Parameter", "Fail-Missing Expected Input Power Parameter", "Fail-Missing Expected Output Power Parameter"};
    private static final String[] actors = new String[]{"ANS", "APC", "OCHNC", "RAMAN Wizard"};
    private final NodeModelDelegate nmd;
    private final ANSManager anm;
    private final InterfaceModels ifm;
    private final sNodeSetupPort nsp;
    private final String portName;
    private final NodeANS.ANSResultDetails detail;
    private final EventUtilities eventUtils;

    public ANSResult(INodeModel iNodeModel, sNodeSetupPort sNodeSetupPort2) {
        super(ANSResult.makeName(sNodeSetupPort2), ANSResult.makePath(iNodeModel, sNodeSetupPort2));
        this.nmd = (NodeModelDelegate)iNodeModel;
        this.anm = this.nmd.getANSManager();
        this.ifm = this.nmd.getIfModels();
        this.nsp = sNodeSetupPort2;
        this.portName = ANSResult.makePortName(iNodeModel, sNodeSetupPort2.port);
        this.detail = NodeANS.getANSResultDetails(sNodeSetupPort2.attr);
        this.eventUtils = EventUtilities.getInstance((NodeModelDelegate)iNodeModel);
        this.setFail(!this.getSuccess());
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public NodeModelDelegate getNmd() {
        return this.nmd;
    }

    public String getPortName() {
        return this.portName;
    }

    public int getPortIndex() {
        return this.nsp.port;
    }

    public AbstractOpticsLineModel getPortModel() {
        try {
            return (AbstractOpticsLineModel)this.ifm.getInterfaceModel(this.nsp.port);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
            return null;
        }
    }

    public String getParameter() {
        return this.getName();
    }

    public String getResult() {
        String string = UNKNOWN;
        try {
            string = nodeSetupResult[this.nsp.result.value()];
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    public boolean getSuccess() {
        return this.nsp.success || this.nsp.result == eNodeSetupResult.SR_INSERVICE;
    }

    public String getActor() {
        String string = UNKNOWN;
        try {
            string = actors[this.nsp.actor.value()];
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    public ANSValue getValue() {
        return this.detail.getANSValue(this.nsp.value);
    }

    public long getTimestamp() {
        return this.nsp.changedTime;
    }

    public String getTimestampString() {
        if (this.getTimestamp() != 0L) {
            return this.eventUtils.convertSecondsToFormattedTimeZoneString(this.getTimestamp());
        }
        return N_A;
    }

    public List<ANSElement> getPortRegulationPath() {
        return this.anm.getPortRegulationPath(this.nsp.port, this.nsp.attr, this.nsp.actor);
    }

    @Override
    public String toString() {
        return "RESULT: " + this.getName() + ", port " + this.getPortName();
    }

    private static String makeName(sNodeSetupPort sNodeSetupPort2) {
        String string = UNKNOWN;
        try {
            if (!sNodeSetupPort2.attr.equals(eNodeSetupPortAttr.PA_UNKNOWN)) {
                return NodeANS.getANSResultDetails(sNodeSetupPort2.attr).getCTCName();
            }
            string = nodeSetupOldResult[sNodeSetupPort2.success ? 1 : 0];
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return string;
    }

    private static String[] makePath(INodeModel iNodeModel, sNodeSetupPort sNodeSetupPort2) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            AbstractOpticsLineModel abstractOpticsLineModel = (AbstractOpticsLineModel)((NodeModelDelegate)iNodeModel).getIfModels().getInterfaceModel(sNodeSetupPort2.port);
            arrayList.addAll(abstractOpticsLineModel.getFullPortStringPath());
            arrayList.add(ANSResult.makeName(sNodeSetupPort2));
            return arrayList.toArray(new String[0]);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return new String[]{N_A};
        }
    }

    private static String makePortName(INodeModel iNodeModel, int n) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            AbstractOpticsLineModel abstractOpticsLineModel = (AbstractOpticsLineModel)((NodeModelDelegate)iNodeModel).getIfModels().getInterfaceModel(n);
            arrayList.addAll(abstractOpticsLineModel.getFullPortStringPath());
            if (abstractOpticsLineModel.isWavelengthSupported() && abstractOpticsLineModel.getActualWaveLength() != 174) {
                arrayList.add("WL " + abstractOpticsLineModel.getActualWaveLengthString());
            }
            return ANSNode.makeFullName(arrayList);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return N_A;
        }
    }
}

