/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ANS;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.Optics.sRange;
import cerent.cms.idl.Optics.xProvisioningError;
import cerent.cms.idl.OpticsTopology.DwdmOpticalSetup;
import cerent.cms.idl.OpticsTopology.eDwdmRingType;
import cerent.cms.idl.OpticsTopology.eNodeSetupActor;
import cerent.cms.idl.OpticsTopology.eNodeSetupPortAttr;
import cerent.cms.idl.OpticsTopology.eOrigin;
import cerent.cms.idl.OpticsTopology.eParamType;
import cerent.cms.idl.OpticsTopology.eSpectrumGranularity;
import cerent.cms.idl.OpticsTopology.sParameterInfo;
import cerent.cms.idl.OpticsTopology.sParameterKey;
import cerent.cms.idl.OpticsTopology.sParameterValue;
import cerent.cms.idl.OpticsTopology.xCannotPerform;
import cerent.cms.idl.OpticsTopology.xInvalidParameter;
import cerent.cms.idl.OpticsTopology.xNoSuchParameter;
import cerent.cms.idl.OpticsTopology.xParameterAlreadyPresent;
import cerent.cms.model.AnsParamModel;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InvalidParams;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchParameter;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ParameterAlreadyPresent;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;

public class NeANSModel
extends Model {
    protected NodeModelDelegate nmd;
    private final AnsParamList ansParamList;
    private final ImportParameter importParameter;
    private final AnsAddParam ansAddParam;
    private final AnsRemoveParam ansRemoveParam;
    private final AnsPortRegulationPath ansPortRegulationPath;
    private Map<String, AnsParamModel> ansParamsMap;
    private EventDispatcher dispatcher;
    private boolean isAnsParamsMapinit = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnsParamModel[] getAnsParamList() {
        Map<String, AnsParamModel> map = this.ansParamsMap;
        synchronized (map) {
            return this.ansParamsMap.values().toArray(new AnsParamModel[0]);
        }
    }

    public AnsParamModel getAnsParamByKey(sParameterKey sParameterKey2) {
        return this.getAnsParamByKey(this.mapParameterKey(sParameterKey2));
    }

    public AnsParamModel getAnsParam(int n, eParamType eParamType2, eSpectrumGranularity eSpectrumGranularity2, int n2) {
        return this.getAnsParamByKey(this.mapParameterKey(n, eParamType2, eSpectrumGranularity2, n2));
    }

    public AnsParamModel getAnsParam(eParamType eParamType2) {
        return this.getAnsParamByKey(this.mapParameterKey(0, eParamType2, eSpectrumGranularity.SP_UNKNOWN, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnsParamModel getAnsParamByKey(String string) {
        Map<String, AnsParamModel> map = this.ansParamsMap;
        synchronized (map) {
            return this.ansParamsMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnsParamModel[] getAnsParamsByType(eParamType eParamType2) {
        ArrayList<AnsParamModel> arrayList = new ArrayList<AnsParamModel>();
        Map<String, AnsParamModel> map = this.ansParamsMap;
        synchronized (map) {
            AnsParamModel ansParamModel2 = null;
            sParameterKey sParameterKey2 = null;
            for (AnsParamModel ansParamModel2 : this.ansParamsMap.values()) {
                sParameterKey2 = ansParamModel2.getParamKey();
                if (sParameterKey2.type != eParamType2) continue;
                arrayList.add(ansParamModel2);
            }
            return arrayList.toArray(new AnsParamModel[0]);
        }
    }

    private void printKey(String string, sParameterKey sParameterKey2) {
        this.db.println("--------------------------------------------------");
        this.db.println("call:" + string);
        this.db.print("sParameterKey= [");
        this.db.print(this.mapParameterKey(sParameterKey2));
        this.db.println("]");
    }

    private void printVal(sParameterValue sParameterValue2) {
        this.db.println("curr-val=" + sParameterValue2.currentValue + "act-val=" + sParameterValue2.activeValue);
    }

    private void printVal(int n) {
        this.db.println("val=" + n);
    }

    public void importParameter(sParameterKey sParameterKey2, int n) {
        sRange sRange2 = new sRange(-300, 500);
        sParameterValue sParameterValue2 = new sParameterValue(false, n, 0, eOrigin.ORI_IMPORTED, sRange2);
        sParameterInfo sParameterInfo2 = new sParameterInfo(0, sParameterKey2, sParameterValue2);
        if (this.db.on) {
            this.printKey("importParameter", sParameterKey2);
            this.printVal(sParameterValue2);
        }
        try {
            this.importParameter.set(sParameterInfo2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParam(Object object, int n) throws EMCProvisionError {
        AnsParamModel ansParamModel = null;
        if (object instanceof sParameterKey) {
            sParameterKey sParameterKey2 = (sParameterKey)object;
            if (this.db.on()) {
                this.printKey("setParam", sParameterKey2);
                this.printVal(n);
            }
            Map<String, AnsParamModel> map = this.ansParamsMap;
            synchronized (map) {
                ansParamModel = this.ansParamsMap.get(this.mapParameterKey(sParameterKey2));
                try {
                    ansParamModel.setParamValue(n);
                    if (this.db.on()) {
                        this.db.println("set param completed");
                    }
                }
                catch (xNoSuchParameter xNoSuchParameter2) {
                    this.db.println("set param exception NoSuchParameter");
                }
                catch (xProvisioningError xProvisioningError2) {
                    throw new EMCProvisionError(xProvisioningError2);
                }
                catch (UserException userException) {
                    this.db.println("set param exception UserException");
                }
            }
        }
    }

    public void addParameter(sParameterKey sParameterKey2, int n) throws NoSuchEquipment, ParameterAlreadyPresent, InvalidParams {
        try {
            Object[] objectArray = new Object[]{sParameterKey2, new Integer(n)};
            this.ansAddParam.set(objectArray);
        }
        catch (xParameterAlreadyPresent xParameterAlreadyPresent2) {
            throw new ParameterAlreadyPresent((UserException)xParameterAlreadyPresent2);
        }
        catch (xInvalidParameter xInvalidParameter2) {
            throw new InvalidParams((UserException)xInvalidParameter2);
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw new UNKNOWN("Caught unexpected exception in addParameter: " + (Object)((Object)userException));
        }
    }

    public void removeParameter(sParameterKey sParameterKey2) throws NoSuchParameter {
        try {
            this.ansRemoveParam.set(sParameterKey2);
        }
        catch (xNoSuchParameter xNoSuchParameter2) {
            throw new NoSuchParameter((UserException)xNoSuchParameter2);
        }
        catch (UserException userException) {
            throw new UNKNOWN("Caught unexpected exception in removeParameter: " + (Object)((Object)userException));
        }
    }

    public List<AnsParamModel> getPortRegulationPath(int n, eNodeSetupPortAttr eNodeSetupPortAttr2, eNodeSetupActor eNodeSetupActor2) throws CannotPerform {
        ArrayList<AnsParamModel> arrayList = new ArrayList<AnsParamModel>();
        try {
            Object[] objectArray = new Object[]{new Integer(n), eNodeSetupPortAttr2, eNodeSetupActor2};
            sParameterInfo[] sParameterInfoArray = (sParameterInfo[])this.ansPortRegulationPath.get(objectArray);
            for (int i = 0; i < sParameterInfoArray.length; ++i) {
                arrayList.add(new AnsParamModel(this.nmd, sParameterInfoArray[i]));
            }
        }
        catch (xCannotPerform xCannotPerform2) {
            throw new CannotPerform((UserException)xCannotPerform2);
        }
        catch (UserException userException) {
            throw new UNKNOWN("Caught unexpected exception in getPortRegulationPath: " + (Object)((Object)userException));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, AnsParamModel> getAnsParamMap() {
        Map<String, AnsParamModel> map = this.ansParamsMap;
        synchronized (map) {
            return this.ansParamsMap;
        }
    }

    private DwdmOpticalSetup getDwdmOpticalSetupRef() {
        return this.nmd.getIorRepository().getDwdmOpticalSetupRef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteParamByRef(AnsParamModel ansParamModel) {
        Map<String, AnsParamModel> map = this.ansParamsMap;
        synchronized (map) {
            ansParamModel.deleteObserver(this);
            this.ansParamsMap.remove(this.mapParameterKey(ansParamModel.getParamInfo().key));
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.DELETED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAnsParams() {
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectDwdmOpticalParamList, 0, (Observer)this);
            this.dispatcher.addObserver(ObjectType.ObjectDwdmOpticalSetup, (Observer)this);
        }
        Map<String, AnsParamModel> map = this.ansParamsMap;
        synchronized (map) {
            if (!this.isAnsParamsMapinit) {
                this.discoverAnsParamList(this.ansParamsMap, true);
            }
            this.isAnsParamsMapinit = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeAnsParams() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectDwdmOpticalParamList, 0, (Observer)this);
            this.dispatcher.deleteObserver(ObjectType.ObjectDwdmOpticalSetup, (Observer)this);
            this.dispatcher = null;
        }
        Map<String, AnsParamModel> map = this.ansParamsMap;
        synchronized (map) {
            for (AnsParamModel ansParamModel : this.ansParamsMap.values()) {
                ansParamModel.deleteObserver(this);
                ansParamModel.destroy();
            }
            this.ansParamsMap.clear();
            this.isAnsParamsMapinit = false;
        }
        this.ansAddParam.dispose();
        this.ansRemoveParam.dispose();
        this.ansParamList.dispose();
        this.importParameter.dispose();
        this.ansRemoveParam.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverAnsParamList(Map<String, AnsParamModel> map, boolean bl) {
        sParameterInfo[] sParameterInfoArray = null;
        try {
            sParameterInfoArray = (sParameterInfo[])this.ansParamList.get();
        }
        catch (xNoSuchParameter xNoSuchParameter2) {
        }
        catch (UserException userException) {
            // empty catch block
        }
        Map<String, AnsParamModel> map2 = map;
        synchronized (map2) {
            for (int i = 0; i < sParameterInfoArray.length; ++i) {
                if (this.db.on()) {
                    this.db.print(i + ") ");
                    this.printKey("discoverAnsParamList", sParameterInfoArray[i].key);
                    this.printVal(sParameterInfoArray[i].value);
                }
                AnsParamModel ansParamModel = new AnsParamModel(this.nmd, sParameterInfoArray[i]);
                if (bl) {
                    ansParamModel.init();
                }
                ansParamModel.addObserver(this);
                map.put(this.mapParameterKey(sParameterInfoArray[i].key), ansParamModel);
            }
        }
    }

    private String mapParameterKey(int n, eParamType eParamType2, eSpectrumGranularity eSpectrumGranularity2, int n2) {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(Integer.toHexString(n));
        stringBuffer.append("-");
        stringBuffer.append(eParamType2.value());
        stringBuffer.append("-");
        stringBuffer.append(eSpectrumGranularity2.value());
        stringBuffer.append("-");
        stringBuffer.append(n2);
        return stringBuffer.toString();
    }

    private String mapParameterKey(sParameterKey sParameterKey2) {
        return this.mapParameterKey(sParameterKey2.paramLocation, sParameterKey2.type, sParameterKey2.spectrum, sParameterKey2.spectrumIndex);
    }

    private void updateParamsLocal() {
        this.setChanged();
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    public void updateLocalStructure() {
        if (this.db.on) {
            this.db.println("Sending UpdateStructure");
        }
        this.updateParamsStructure();
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateParamsStructure() {
        HashMap<String, AnsParamModel> hashMap = new HashMap<String, AnsParamModel>();
        boolean bl = false;
        Map<String, AnsParamModel> map = this.ansParamsMap;
        synchronized (map) {
            AnsParamModel ansParamModel;
            this.discoverAnsParamList(hashMap, false);
            Collection collection = this.getAddedObjects(this.ansParamsMap.keySet(), hashMap.keySet());
            Collection collection2 = this.getDeletedObjects(this.ansParamsMap.keySet(), hashMap.keySet());
            Collection collection3 = this.getModifiedObjects(this.ansParamsMap.keySet(), hashMap.keySet());
            for (String string : collection) {
                ansParamModel = hashMap.get(string);
                ansParamModel.init();
                this.ansParamsMap.put(string, ansParamModel);
                bl = true;
                this.db.info("Added " + string);
            }
            for (String string : collection2) {
                ansParamModel = this.ansParamsMap.get(string);
                this.ansParamsMap.remove(string);
                ansParamModel.deleteObserver(this);
                ansParamModel.destroy();
                bl = true;
                this.db.info("Removed " + string);
            }
            for (String string : collection3) {
                ansParamModel = this.ansParamsMap.get(string);
                AnsParamModel ansParamModel2 = hashMap.get(string);
                sParameterInfo sParameterInfo2 = ansParamModel.getParamInfo();
                sParameterInfo sParameterInfo3 = ansParamModel2.getParamInfo();
                if (sParameterInfo2 != null && (sParameterInfo3 == null || this.equals(sParameterInfo2.value, sParameterInfo3.value))) continue;
                this.ansParamsMap.remove(string);
                ansParamModel.deleteObserver(this);
                ansParamModel.destroy();
                ansParamModel2.init();
                this.ansParamsMap.put(string, ansParamModel2);
                bl = true;
                this.db.info("Replaced " + string);
            }
        }
        return bl;
    }

    private boolean equals(sParameterValue sParameterValue2, sParameterValue sParameterValue3) {
        return sParameterValue2.origin.equals(sParameterValue3.origin) && sParameterValue2.isReadOnly == sParameterValue3.isReadOnly && sParameterValue2.currentValue == sParameterValue3.currentValue && sParameterValue2.activeValue == sParameterValue3.activeValue;
    }

    private Collection getModifiedObjects(Set set, Set set2) {
        HashSet hashSet = null;
        hashSet = new HashSet(set2);
        hashSet.retainAll(set);
        return hashSet;
    }

    private Collection getAddedObjects(Set set, Set set2) {
        return this.getUpdateObjects(set, set2, true);
    }

    private Collection getDeletedObjects(Set set, Set set2) {
        return this.getUpdateObjects(set, set2, false);
    }

    private Collection getUpdateObjects(Set set, Set set2, boolean bl) {
        HashSet hashSet = null;
        if (bl) {
            hashSet = new HashSet(set2);
            hashSet.removeAll(set);
        } else {
            hashSet = new HashSet(set);
            hashSet.removeAll(set2);
        }
        return hashSet;
    }

    public eDwdmRingType getDwdmRingType() {
        AnsParamModel ansParamModel = this.getAnsParam(eParamType.TY_NETWORKTYPE);
        return eDwdmRingType.from_int(ansParamModel.getParamInfo().value.currentValue);
    }

    public NeANSModel(NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.setDebug(nodeModelDelegate.getChildDebug(NeANSModel.class, NeANSModelDebug.class, this));
        this.db.info("Index = " + Integer.toString(this.index));
        this.nmd = nodeModelDelegate;
        this.ansParamsMap = new HashMap<String, AnsParamModel>();
        this.ansParamList = new AnsParamList(this.nmd, "NeANSModel::ansParamList");
        this.importParameter = new ImportParameter(this.nmd, "NeANSModel:importParameter");
        this.ansAddParam = new AnsAddParam(this.nmd, "NeANSModel::ansAddParam");
        this.ansRemoveParam = new AnsRemoveParam(this.nmd, "NeANSModel::ansRemoveParam");
        this.ansPortRegulationPath = new AnsPortRegulationPath(this.nmd, "NeANSModel::ansPortRegulationPath");
    }

    public void init() {
        this.db.info("Initing NeANSModel " + this.toString());
        super.init0();
        this.initAnsParams();
    }

    public void delete() {
        this.db.info("Deleting NeANSModel " + this.toString());
        this.dispose();
    }

    @Override
    public void destroy() {
        this.db.info("Destroying NeANSModel " + this.toString());
        super.destroy();
    }

    @Override
    public void dispose() {
        this.db.info("Disposing NeANSModel " + this.toString());
        this.disposeAnsParams();
        super.dispose();
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nmd;
    }

    @Override
    public void updateLocal() {
        this.updateParamsLocal();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.db.on) {
            this.db.println("AnsParamModel::update");
        }
        if (!(observable instanceof AnsParamModel)) {
            int n = ((ObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 1: 
                case 2: {
                    if (this.db.on) {
                        this.db.println("Making structural changes.");
                    }
                    this.updateLocalStructure();
                    break;
                }
                case 0: {
                    break;
                }
            }
        } else if (observable instanceof AnsParamModel) {
            if (this.db.on) {
                this.db.println("update(): from AnsParamModel.");
            }
            this.updateLocal();
        } else if (this.db.on) {
            this.db.println("update(): Observable = " + observable + ", arg = " + object);
        }
    }

    class AnsAddParam
    extends NonCachedValue {
        public AnsAddParam(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xParameterAlreadyPresent, xInvalidParameter, xNoSuchEquipment {
            Object[] objectArray = (Object[])object;
            sParameterKey sParameterKey2 = (sParameterKey)objectArray[0];
            int n = (Integer)objectArray[1];
            NeANSModel.this.getDwdmOpticalSetupRef().addParameter(sParameterKey2, n);
        }
    }

    class AnsParamList
    extends NonCachedValue {
        public AnsParamList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return NeANSModel.this.getDwdmOpticalSetupRef().getParamList();
        }

        @Override
        protected void setValue(Object object) throws UserException {
            NeANSModel.this.getDwdmOpticalSetupRef().setParamList((sParameterInfo[])object);
        }
    }

    class AnsPortRegulationPath
    extends NonCachedValue {
        public AnsPortRegulationPath(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xCannotPerform {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            eNodeSetupPortAttr eNodeSetupPortAttr2 = (eNodeSetupPortAttr)objectArray[1];
            eNodeSetupActor eNodeSetupActor2 = (eNodeSetupActor)objectArray[2];
            return NeANSModel.this.getDwdmOpticalSetupRef().getPortRegulationPath(n, eNodeSetupPortAttr2, eNodeSetupActor2);
        }
    }

    class AnsRemoveParam
    extends NonCachedValue {
        public AnsRemoveParam(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xNoSuchParameter {
            sParameterKey sParameterKey2 = (sParameterKey)object;
            NeANSModel.this.getDwdmOpticalSetupRef().removeParam(sParameterKey2);
        }
    }

    class ImportParameter
    extends NonCachedValue {
        public ImportParameter(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            NeANSModel.this.getDwdmOpticalSetupRef().importParameter((sParameterInfo)object);
        }
    }

    public class NeANSModelDebug
    extends SDebug {
        public NeANSModelDebug(KDebug kDebug, String string) {
            super(kDebug, string);
        }

        public final void dump() {
            AnsParamModel[] ansParamModelArray;
            NeANSModel.this.db.println("NE ANS Model Param List :");
            for (AnsParamModel ansParamModel : ansParamModelArray = NeANSModel.this.getAnsParamList()) {
                sParameterInfo sParameterInfo2 = ansParamModel.getParamInfo();
                NeANSModel.this.db.println("key=[" + NeANSModel.this.mapParameterKey(sParameterInfo2.key) + "] value=<" + sParameterInfo2.value.currentValue + ">");
            }
            NeANSModel.this.db.println("");
        }
    }
}

