/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ANS;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.OpticsTopology.DwdmOpticalSetup;
import cerent.cms.idl.OpticsTopology.eObjectType;
import cerent.cms.idl.OpticsTopology.xNodeSetupError;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSetupError;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.EMC;
import cerent.util.SDebug;
import cerent.util.ZipUtils;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;

public class NodeSetupModel
extends Model {
    private final NodeModelDelegate nmd;
    private final RemoteFile rf;
    private final LocalFile lf;
    private static NodeSingletonFactory<NodeSetupModel> sfactory = new NodeSingletonFactory<NodeSetupModel>(NodeSetupModel.class);
    private EventDispatcher dispatcher;

    public static NodeSetupModel getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private DwdmOpticalSetup getDwdmOpticalSetupRef() {
        return this.nmd.getIorRepository().getDwdmOpticalSetupRef();
    }

    private NodeSetupModel(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(NodeSetupModel.class));
        this.nmd = nodeModelDelegate;
        this.rf = new RemoteFile(nodeModelDelegate);
        this.lf = new LocalFile(nodeModelDelegate);
    }

    public void init() {
        super.init0();
        if (this.db.on()) {
            this.db.println("NodeSetupModel::init()");
        }
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectDwdmOpticalSetup, eObjectType.NODESETUPFTPEND.value(), (Observer)this);
        }
    }

    @Override
    public void dispose() {
        this.db.info("Disposing NodeSetupModel");
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectDwdmOpticalSetup, eObjectType.NODESETUPFTPEND.value(), (Observer)this);
            this.dispatcher = null;
        }
        this.rf.dispose();
        this.lf.dispose();
        super.dispose();
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nmd;
    }

    @Override
    public void update(Observable observable, Object object) {
        int n;
        if (this.db.on) {
            this.db.println("NodeSetupModel::update");
        }
        if ((n = ((IObjectMessageInfo)object).getUpdateType()) == 1) {
            this.setChanged();
            this.updateLocal();
        }
    }

    public void ftpRemoteFile(String string, String string2, String string3, String string4, String string5, short s) throws NodeSetupError {
        try {
            Object[] objectArray = new Object[]{new Boolean(true), string, string2, string3, string4, string5, new Short(s)};
            this.rf.set(objectArray);
        }
        catch (xNodeSetupError xNodeSetupError2) {
            throw new NodeSetupError(xNodeSetupError2);
        }
        catch (UserException userException) {
            throw new UNKNOWN("Caught unexpected exception in readInstFiles: " + (Object)((Object)userException));
        }
    }

    public void cancelFtp() throws NodeSetupError {
        try {
            Object[] objectArray = new Object[]{new Boolean(false)};
            this.rf.set(objectArray);
        }
        catch (xNodeSetupError xNodeSetupError2) {
            throw new NodeSetupError(xNodeSetupError2);
        }
        catch (UserException userException) {
            throw new UNKNOWN("Caught unexpected exception in readInstFiles: " + (Object)((Object)userException));
        }
    }

    public String readRemoteXMLFile() throws NodeSetupError {
        block11: {
            try {
                byte[] byArray = (byte[])this.rf.get();
                if (byArray.length > 0) {
                    try {
                        return ZipUtils.gunzipStringFromBytes((byte[])byArray);
                    }
                    catch (IOException iOException) {
                        try {
                            return ZipUtils.unzipStringFromBytes((byte[])byArray);
                        }
                        catch (IOException iOException2) {
                            try {
                                return ZipUtils.inflateStringFromBytes((byte[])byArray);
                            }
                            catch (IOException iOException3) {
                                String string = new String(byArray);
                                if (string.startsWith("<?xml")) {
                                    return string;
                                }
                                this.db.info("unknown file format");
                            }
                        }
                    }
                }
            }
            catch (xNodeSetupError xNodeSetupError2) {
                throw new NodeSetupError(xNodeSetupError2);
            }
            catch (Exception exception) {
                if (!this.db.on) break block11;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return "";
    }

    public String readInstXMLFile() {
        block3: {
            try {
                byte[] byArray = (byte[])this.lf.get(new Boolean(true));
                if (byArray.length > 0) {
                    return ZipUtils.inflateStringFromBytes((byte[])byArray);
                }
            }
            catch (Exception exception) {
                if (!this.db.on) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return "";
    }

    public String readInstLogFile() {
        block3: {
            try {
                byte[] byArray = (byte[])this.lf.get(new Boolean(false));
                if (byArray.length > 0) {
                    return ZipUtils.inflateStringFromBytes((byte[])byArray);
                }
            }
            catch (Exception exception) {
                if (!this.db.on) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return "";
    }

    public void writeInstFiles(String string, String string2) throws ProvisionError, NodeSetupError {
        try {
            byte[] byArray = ZipUtils.deflateStringToBytes((String)string);
            byte[] byArray2 = ZipUtils.deflateStringToBytes((String)string2);
            Object[] objectArray = new Object[]{byArray, byArray2};
            this.lf.set(objectArray);
        }
        catch (IOException iOException) {
            throw new ProvisionError(EMC.EID_GENERIC_PROV_ERROR, new Object[]{iOException.getMessage()});
        }
        catch (xNodeSetupError xNodeSetupError2) {
            throw new NodeSetupError(xNodeSetupError2);
        }
        catch (UserException userException) {
            throw new UNKNOWN("Caught unexpected exception in readInstFiles: " + (Object)((Object)userException));
        }
    }

    class LocalFile
    extends NonCachedValue {
        public LocalFile(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        @Override
        protected Object getValue(Object object) throws xNodeSetupError {
            if (((Boolean)object).booleanValue()) {
                return NodeSetupModel.this.getDwdmOpticalSetupRef().readLocalNodeSetupXMLFile();
            }
            return NodeSetupModel.this.getDwdmOpticalSetupRef().readLocalNodeSetupLogFile();
        }

        @Override
        protected void setValue(Object object) throws xNodeSetupError {
            Object[] objectArray = (Object[])object;
            byte[] byArray = (byte[])objectArray[0];
            byte[] byArray2 = (byte[])objectArray[1];
            NodeSetupModel.this.getDwdmOpticalSetupRef().writeLocalNodeSetupXMLFile(byArray, byArray2);
        }
    }

    class RemoteFile
    extends NonCachedValue {
        public RemoteFile(NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate);
        }

        @Override
        protected Object getValue() throws xNodeSetupError {
            return NodeSetupModel.this.getDwdmOpticalSetupRef().readRemoteNodeSetupXMLFile();
        }

        @Override
        protected void setValue(Object object) throws xNodeSetupError {
            Object[] objectArray = (Object[])object;
            Boolean bl = (Boolean)objectArray[0];
            if (!bl.booleanValue()) {
                NodeSetupModel.this.getDwdmOpticalSetupRef().cancelFtpNodeSetup();
                return;
            }
            String string = (String)objectArray[1];
            String string2 = (String)objectArray[2];
            String string3 = (String)objectArray[3];
            String string4 = (String)objectArray[4];
            String string5 = (String)objectArray[5];
            short s = (Short)objectArray[6];
            NodeSetupModel.this.getDwdmOpticalSetupRef().ftpNodeSetupXMLFile(string, string2, string3, string4, string5, s);
        }
    }
}

