/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.fv.IFvCardModel;
import cerent.cms.fv.IFvInterfaceModel;
import cerent.cms.fv.IFvOpticsLineModel;
import cerent.cms.fv.IFvPortModel;
import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.eWavelength;
import cerent.cms.idl.Common.eWavelengthHolder;
import cerent.cms.idl.If.eIfType;
import cerent.cms.idl.If.eOSRIStatus;
import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.Optics.General;
import cerent.cms.idl.Optics.eSwitchablePortState;
import cerent.cms.idl.Optics.eVOAControlMode;
import cerent.cms.idl.Optics.sActualOpticsAttributes;
import cerent.cms.idl.Optics.sAlarmThresholds;
import cerent.cms.idl.Optics.sApcEstimationInfo;
import cerent.cms.idl.Optics.sGeneralOpticsAttributes;
import cerent.cms.idl.Optics.sOChPowerAttributes;
import cerent.cms.idl.Optics.sOpticsAlmThresholds;
import cerent.cms.idl.Optics.sOpticsPmStats;
import cerent.cms.idl.Optics.sOpticsTCAThresholds;
import cerent.cms.idl.Optics.sValThresholds;
import cerent.cms.idl.Optics.xFeatureUnsupported;
import cerent.cms.idl.Optics.xNotReady;
import cerent.cms.idl.Optics.xProvisioningError;
import cerent.cms.idl.OpticsTopology.eParamType;
import cerent.cms.idl.OpticsTopology.eSpectrumGranularity;
import cerent.cms.model.ANS.ANSManager;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AnsParamModel;
import cerent.cms.model.Attribute;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IAdminLineAccess;
import cerent.cms.model.IOpticsModel;
import cerent.cms.model.IOpticsPortModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.NotReady;
import cerent.cms.model.OpticalPortType;
import cerent.cms.model.OpticsOchTermModel;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.OpticsProvExtModel;
import cerent.cms.model.PassiveModuleModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ProvisionExceptionData;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.WrongPortType;
import cerent.cms.ui.ConvertPwrToDb;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.Wavelength;
import cerent.util.EMC;
import cerent.util.SDebug;
import cerent.util.view.fv.helper.ApcEstimationInfo;
import cerent.util.view.fv.helper.FunctDebug;
import java.util.ArrayList;
import java.util.List;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.UserException;

public abstract class AbstractOpticsLineModel
extends InterfaceModel
implements IOpticsModel,
IAdminLineAccess,
IFvOpticsLineModel {
    protected AlmThresholds almTh;
    protected TCAThresholds tcaTh15Min;
    protected TCAThresholds tcaThDay;
    protected General ifReference;
    private OpticsStats opticsStats;
    private ActualOpticsAttributes actualOpticsAttr;
    protected GeneralAttributes genAttr;
    private VOAAttenuation voaAtt;
    private VOAPower voaPower;
    private CalibratedPower calPower;
    private AddPTPortState addptPortStatus;
    private AddPTPowerThreshold addptTh;
    private EnaMaintenanceChannel enaMaintChan;
    private SetMaintenanceChannel setMaintChan;
    private DisaMaintenanceChannel disaMaintChan;
    private GetMaintenanceChannel getMaintChan;
    private WorkingChannel workingChannels;
    private OpticsProvExtModel opticsProvExtModel;
    private WlPower wlPower;
    public static final int OPTICS_PORT_NONE = 0;
    private static final double DEFAULT_P_TARGET = -14.0;
    private static final double VOA_ATT_20 = 20.0;
    private static final double VOA_ATT_22 = 22.0;
    private static final double VOA_ATT_16 = 16.0;
    private ChannelPowerInfo channelPowerInfo;

    public AbstractOpticsLineModel(NodeModelDelegate nodeModelDelegate, int n, sInterface sInterface2, General general) {
        super(nodeModelDelegate, n, sInterface2, nodeModelDelegate.getChildDebug(AbstractOpticsLineModel.class));
        this.ifReference = general;
        this.tcaTh15Min = new TCAThresholds("TCAThresholds15Min", nodeModelDelegate);
        this.tcaThDay = new TCAThresholds("TCAThresholdsDay", nodeModelDelegate);
        this.almTh = new AlmThresholds("AlarmThresholds", nodeModelDelegate);
        this.opticsStats = new OpticsStats("opticsStats", nodeModelDelegate);
        this.actualOpticsAttr = new ActualOpticsAttributes("ActualOpticsAttributes", nodeModelDelegate);
        this.genAttr = new GeneralAttributes(nodeModelDelegate, "GeneralAttributes");
        this.voaAtt = new VOAAttenuation(nodeModelDelegate, "VOAAttenuation");
        this.voaPower = new VOAPower(nodeModelDelegate, "VOAPower");
        this.calPower = new CalibratedPower(nodeModelDelegate, "PowerReference");
        this.addptPortStatus = new AddPTPortState(nodeModelDelegate, "AddPtPortState");
        this.addptTh = new AddPTPowerThreshold("AddPTPowerThreshold", nodeModelDelegate);
        this.getMaintChan = new GetMaintenanceChannel(nodeModelDelegate, "GetMaintenanceChannel");
        this.enaMaintChan = new EnaMaintenanceChannel(nodeModelDelegate, "EnaMaintenanceChannel");
        this.setMaintChan = new SetMaintenanceChannel(nodeModelDelegate, "SetMaintenanceChannel");
        this.disaMaintChan = new DisaMaintenanceChannel(nodeModelDelegate, "DisaMaintenanceChannel");
        this.workingChannels = new WorkingChannel(nodeModelDelegate, "WorkingChannel");
        this.channelPowerInfo = new ChannelPowerInfo(nodeModelDelegate, "channelPowerInfo");
        this.opticsProvExtModel = new OpticsProvExtModel(this);
        this.wlPower = new WlPower(nodeModelDelegate, "WlPower");
    }

    @Override
    public void destroy() {
        this.opticsProvExtModel.destroy();
        super.destroy();
    }

    @Override
    public void dispose() {
        this.genAttr.dispose();
        this.addptPortStatus.dispose();
        this.almTh.dispose();
        this.tcaTh15Min.dispose();
        this.tcaThDay.dispose();
        this.addptTh.dispose();
        this.opticsProvExtModel.dispose();
        super.dispose();
    }

    @Override
    protected void updateLocal(long l) {
        this.genAttr.update();
        this.addptPortStatus.update();
        this.almTh.update();
        this.tcaTh15Min.update();
        this.tcaThDay.update();
        this.addptTh.update();
        super.updateLocal(l);
    }

    protected ProvisionExceptionData getProvisioningExceptionInfo(xProvisioningError xProvisioningError2) {
        ProvisionExceptionData provisionExceptionData = new ProvisionExceptionData();
        provisionExceptionData.discriminator = xProvisioningError2.errorExtraInfo.discriminator().value();
        switch (provisionExceptionData.discriminator) {
            case 3: {
                provisionExceptionData.lowValue = xProvisioningError2.errorExtraInfo.range().lowValue;
                provisionExceptionData.hiValue = xProvisioningError2.errorExtraInfo.range().hiValue;
                break;
            }
            case 6: {
                provisionExceptionData.lowValue = xProvisioningError2.errorExtraInfo.ThRange().lowValue;
                provisionExceptionData.hiValue = xProvisioningError2.errorExtraInfo.ThRange().hiValue;
                break;
            }
            case 7: {
                provisionExceptionData.hiValue = provisionExceptionData.lowValue = xProvisioningError2.errorExtraInfo.provisionedCircuits();
            }
        }
        provisionExceptionData.discriminator = xProvisioningError2.errorCode.value();
        return provisionExceptionData;
    }

    private OpticsPortModel getOpticsPort() throws AbstractCmsNoSuchEntityException {
        return (OpticsPortModel)this.getPortModel();
    }

    public int getPortNumber() throws NoSuchInterface {
        return this.getInfo().portNumber;
    }

    public String getPortName() throws NoSuchInterface {
        return this.getInfo().descr;
    }

    public int getSide() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            return this.getOpticsPort().getSide();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            throw new InternalCommError(abstractCmsNoSuchEntityException.getMessage());
        }
    }

    public int getRole() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        return DwdmSide.getSideRole(this.getSide());
    }

    public void enaMaintenanceChanelPower(int[] nArray) throws NoSuchInterface, WrongInterfaceType, InternalCommError, ProvisionError, FeatureUnsupported {
        try {
            this.enaMaintChan.set(nArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xProvisioningError xProvisioningError2) {
            throw new ProvisionError(EMC.EID_GENERIC_PROV_ERROR, (Object[])new String[]{xProvisioningError2.errorExtraInfo.message()});
        }
        catch (UserException userException) {
            throw this.doUnknown("enaMaintenanceChanelPower", userException);
        }
    }

    public void setMaintenanceChanelPower(int[] nArray) throws NoSuchInterface, WrongInterfaceType, InternalCommError, FeatureUnsupported, ProvisionError {
        try {
            this.setMaintChan.set(nArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xProvisioningError xProvisioningError2) {
            throw new ProvisionError(EMC.EID_GENERIC_PROV_ERROR, (Object[])new String[]{xProvisioningError2.errorExtraInfo.message()});
        }
        catch (UserException userException) {
            throw this.doUnknown("setMaintenanceChanelPower", userException);
        }
    }

    public void disaMaintenanceChanelPower(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError, FeatureUnsupported {
        try {
            this.disaMaintChan.set(n);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (UserException userException) {
            throw this.doUnknown("disaMaintenanceChanelPower", userException);
        }
    }

    public int[] getMaintenanceChanelPower(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError, FeatureUnsupported {
        try {
            return (int[])this.getMaintChan.get(n);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getMaintenanceChanelPower", userException);
        }
    }

    public int getWorkingChannel() throws NoSuchInterface, WrongInterfaceType, InternalCommError, FeatureUnsupported, NotReady {
        try {
            return (Integer)this.workingChannels.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xNotReady xNotReady2) {
            throw new NotReady((UserException)xNotReady2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getWorkingChannel", userException);
        }
    }

    public final String getOptPortTypeString() throws NoSuchInterface, WrongInterfaceType {
        try {
            IPortModel iPortModel = this.getPortModel();
            if (iPortModel instanceof IOpticsPortModel) {
                try {
                    return ((IOpticsPortModel)iPortModel).getOptPortTypeString();
                }
                catch (NoSuchEquipment noSuchEquipment) {
                    throw new NoSuchInterface(noSuchEquipment.getMessage());
                }
                catch (WrongPortType wrongPortType) {
                    throw new WrongInterfaceType(wrongPortType.getMessage());
                }
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
        }
        return "N/A";
    }

    public List<String> getFullPortStringPath() {
        try {
            return this.getOpticsPort().getFullPortStringPath();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return new ArrayList<String>();
        }
    }

    public String getPortTypeString() throws NoSuchInterface, WrongInterfaceType {
        return this.getOptPortTypeString();
    }

    public boolean isPortTypeTX() {
        try {
            return this.getOpticsPort().isOptPortTypeTX();
        }
        catch (Exception exception) {
            try {
                return this.getOptPortType().isPortTypeTX();
            }
            catch (Exception exception2) {
                SDebug.printStackTrace((Throwable)exception);
                return false;
            }
        }
    }

    public boolean isPortTypeRX() {
        try {
            return this.getOpticsPort().isOptPortTypeRX();
        }
        catch (Exception exception) {
            try {
                return this.getOptPortType().isPortTypeRX();
            }
            catch (Exception exception2) {
                SDebug.printStackTrace((Throwable)exception);
                return false;
            }
        }
    }

    public boolean isPortTypePT() {
        try {
            return this.getOpticsPort().isOptPortTypePT();
        }
        catch (Exception exception) {
            try {
                return this.getOptPortType().isPortTypePT();
            }
            catch (Exception exception2) {
                SDebug.printStackTrace((Throwable)exception);
                return false;
            }
        }
    }

    public eIfType getOptIfType() throws NoSuchInterface {
        return this.getInfo().ifType;
    }

    public int getFeatures() throws NoSuchInterface, WrongInterfaceType {
        try {
            sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
            return sGeneralOpticsAttributes2.features;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getFeatures", userException);
        }
    }

    public sOChPowerAttributes[] getAllWlPower() throws NoSuchInterface, FeatureUnsupported {
        try {
            return (sOChPowerAttributes[])this.wlPower.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported("getAllWlPower");
        }
        catch (UserException userException) {
            throw this.doUnknown("getAllWlPower", userException);
        }
    }

    public OpticalPortType getOptPortType() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((OpticsPortModel)this.getPortModel()).getOptPortType();
        }
        catch (NoSuchEquipment noSuchEquipment) {
            throw new NoSuchInterface(noSuchEquipment.getMessage());
        }
        catch (WrongPortType wrongPortType) {
            throw new WrongInterfaceType(wrongPortType.getMessage());
        }
        catch (Exception exception) {
            throw new WrongInterfaceType(exception.getMessage());
        }
    }

    @Override
    public int getActualPower() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            sActualOpticsAttributes sActualOpticsAttributes2 = (sActualOpticsAttributes)this.actualOpticsAttr.get();
            return sActualOpticsAttributes2.power;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getActualPower", userException);
        }
    }

    public String getActualPowerString() {
        try {
            return ConvertPwrToDb.convertPwrToDb(this.getActualPower());
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    public int getOSCPower() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if ((this.getFeatures() & 0x40000) == 262144) {
            try {
                sActualOpticsAttributes sActualOpticsAttributes2 = (sActualOpticsAttributes)this.actualOpticsAttr.get();
                return sActualOpticsAttributes2.oscPower;
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (xInternalCommError xInternalCommError2) {
                throw new InternalCommError((UserException)xInternalCommError2);
            }
            catch (UserException userException) {
                throw this.doUnknown("getOSCPower", userException);
            }
        }
        throw new WrongInterfaceType("getOSCPower");
    }

    public String getOSCPowerString() {
        try {
            return ConvertPwrToDb.convertPwrToDb(this.getOSCPower());
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    public int getAddPower() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if ((this.getFeatures() & 0x10) == 16) {
            try {
                sActualOpticsAttributes sActualOpticsAttributes2 = (sActualOpticsAttributes)this.actualOpticsAttr.get();
                return sActualOpticsAttributes2.addPower;
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (xInternalCommError xInternalCommError2) {
                throw new InternalCommError((UserException)xInternalCommError2);
            }
            catch (UserException userException) {
                throw this.doUnknown("getAddPower", userException);
            }
        }
        throw new WrongInterfaceType("getAddPower");
    }

    public String getAddPowerString() {
        try {
            return ConvertPwrToDb.convertPwrToDb(this.getAddPower());
        }
        catch (Exception exception) {
            return "N/A";
        }
    }

    public int getInsertionLoss() throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType {
        if ((this.getFeatures() & 4) == 4) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.insertionLoss;
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (UserException userException) {
                throw this.doUnknown("getInsertionLoss", userException);
            }
        }
        throw new FeatureUnsupported("getInsertionLoss");
    }

    public boolean isPMSupported() {
        try {
            return (this.getFeatures() & 8) == 8;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isOppositePortSupported() {
        try {
            return (this.getFeatures() & 0x200) == 512;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isOCHTERMSupported() {
        try {
            return (this.getFeatures() & 0x20000) == 131072;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public eVOAControlMode getVoaMode() throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType {
        if ((this.getFeatures() & 1) == 1) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.voa.mode;
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (UserException userException) {
                throw this.doUnknown("getVoaMode", userException);
            }
        }
        throw new FeatureUnsupported("getVoaMode");
    }

    public int getVoaRefPower() throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType {
        if ((this.getFeatures() & 1) == 1) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.voa.referencePower;
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (UserException userException) {
                throw this.doUnknown("getVoaRefPower", userException);
            }
        }
        throw new FeatureUnsupported("getVoaRefPower");
    }

    public eOSRIStatus getOSRIStatus() throws NoSuchInterface, WrongInterfaceType, FeatureUnsupported {
        if ((this.getFeatures() & 2) == 2) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.osriState;
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (UserException userException) {
                throw this.doUnknown("getOSRIStatus", userException);
            }
        }
        throw new FeatureUnsupported("getOSRIStatus");
    }

    public sOpticsTCAThresholds getOpticsTCAThresholds(eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType {
        Object object = null;
        try {
            object = eIntervalType2 == eIntervalType.INTERVAL_15_MIN ? this.tcaTh15Min.get(eIntervalType2) : this.tcaThDay.get(eIntervalType2);
            return (sOpticsTCAThresholds)object;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsTCAThresholds", userException);
        }
    }

    public void setOpticsTCAThresholds(sOpticsTCAThresholds sOpticsTCAThresholds2, eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, FeatureUnsupported, ProvisionError {
        try {
            Object[] objectArray = new Object[]{sOpticsTCAThresholds2, eIntervalType2};
            if (eIntervalType2 == eIntervalType.INTERVAL_15_MIN) {
                this.tcaTh15Min.set(objectArray);
            } else {
                this.tcaThDay.set(objectArray);
            }
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xProvisioningError xProvisioningError2) {
            throw new ProvisionError((UserException)xProvisioningError2, this.getProvisioningExceptionInfo(xProvisioningError2));
        }
        catch (UserException userException) {
            throw this.doUnknown("setOpticsTCAThresholds", userException);
        }
    }

    public int getOpticsAlm(TCAAlmType tCAAlmType, LevelType levelType, ThType thType) throws NoSuchInterface, WrongInterfaceType {
        sOpticsAlmThresholds sOpticsAlmThresholds2;
        int n = 0;
        try {
            sOpticsAlmThresholds2 = (sOpticsAlmThresholds)this.almTh.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsAlmThresholds", userException);
        }
        block1 : switch (tCAAlmType) {
            case POWER: {
                block7 : switch (levelType) {
                    case DEGRADE: {
                        switch (thType) {
                            case LOWIDX: {
                                n = sOpticsAlmThresholds2.opticalPowerAlmTh.degrade.low;
                                break;
                            }
                            case HIGHIDX: {
                                n = sOpticsAlmThresholds2.opticalPowerAlmTh.degrade.high;
                            }
                        }
                        break;
                    }
                    case FAIL: {
                        switch (thType) {
                            case LOWIDX: {
                                n = sOpticsAlmThresholds2.opticalPowerAlmTh.fail.low;
                                break block7;
                            }
                            case HIGHIDX: {
                                n = sOpticsAlmThresholds2.opticalPowerAlmTh.fail.high;
                            }
                        }
                    }
                }
                break;
            }
            case OSC: {
                block19 : switch (levelType) {
                    case DEGRADE: {
                        switch (thType) {
                            case LOWIDX: {
                                n = sOpticsAlmThresholds2.oscPowerAlmTh.degrade.low;
                                break;
                            }
                            case HIGHIDX: {
                                n = sOpticsAlmThresholds2.oscPowerAlmTh.degrade.high;
                            }
                        }
                        break;
                    }
                    case FAIL: {
                        switch (thType) {
                            case LOWIDX: {
                                n = sOpticsAlmThresholds2.oscPowerAlmTh.fail.low;
                                break block19;
                            }
                            case HIGHIDX: {
                                n = sOpticsAlmThresholds2.oscPowerAlmTh.fail.high;
                            }
                        }
                    }
                }
                break;
            }
            case VOA: {
                block31 : switch (levelType) {
                    case DEGRADE: {
                        switch (thType) {
                            case LOWIDX: {
                                n = sOpticsAlmThresholds2.voaAlmTh.degrade.low;
                                break;
                            }
                            case HIGHIDX: {
                                n = sOpticsAlmThresholds2.voaAlmTh.degrade.high;
                            }
                        }
                        break;
                    }
                    case FAIL: {
                        switch (thType) {
                            case LOWIDX: {
                                n = sOpticsAlmThresholds2.voaAlmTh.fail.low;
                                break block31;
                            }
                            case HIGHIDX: {
                                n = sOpticsAlmThresholds2.voaAlmTh.fail.high;
                            }
                        }
                    }
                }
                break;
            }
            case GAIN: {
                switch (levelType) {
                    case DEGRADE: {
                        switch (thType) {
                            case LOWIDX: {
                                n = sOpticsAlmThresholds2.gainAlmTh.degrade.low;
                                break block1;
                            }
                            case HIGHIDX: {
                                n = sOpticsAlmThresholds2.gainAlmTh.degrade.high;
                            }
                        }
                        break block1;
                    }
                    case FAIL: {
                        switch (thType) {
                            case LOWIDX: {
                                n = sOpticsAlmThresholds2.gainAlmTh.fail.low;
                                break block1;
                            }
                            case HIGHIDX: {
                                n = sOpticsAlmThresholds2.gainAlmTh.fail.high;
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    public int getOpticsTCAPower(eIntervalType eIntervalType2, TCAAlmType tCAAlmType, ThType thType) throws NoSuchInterface, WrongInterfaceType {
        sOpticsTCAThresholds sOpticsTCAThresholds2;
        int n = 0;
        try {
            sOpticsTCAThresholds2 = eIntervalType2 == eIntervalType.INTERVAL_15_MIN ? (sOpticsTCAThresholds)this.tcaTh15Min.get(eIntervalType2) : (sOpticsTCAThresholds)this.tcaThDay.get(eIntervalType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsTCAPower", userException);
        }
        switch (tCAAlmType) {
            case OSC: {
                if (thType == ThType.LOWIDX) {
                    n = sOpticsTCAThresholds2.oscPowerPMTh.low;
                    break;
                }
                n = sOpticsTCAThresholds2.oscPowerPMTh.high;
                break;
            }
            case POWER: {
                n = thType == ThType.LOWIDX ? sOpticsTCAThresholds2.opticalPowerPMTh.low : sOpticsTCAThresholds2.opticalPowerPMTh.high;
            }
        }
        return n;
    }

    public sOpticsAlmThresholds getOpticsAlmThresholds() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sOpticsAlmThresholds)this.almTh.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsAlmThresholds", userException);
        }
    }

    public void setOpticsAlmThresholds(sOpticsAlmThresholds sOpticsAlmThresholds2) throws NoSuchInterface, WrongInterfaceType, ProvisionError, ConfigError {
        try {
            this.almTh.set(sOpticsAlmThresholds2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisioningError xProvisioningError2) {
            throw new ProvisionError((UserException)xProvisioningError2, this.getProvisioningExceptionInfo(xProvisioningError2));
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setOpticsAlmThresholds", userException);
        }
    }

    public int getAddPTThresholdFailHigh() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sAlarmThresholds)this.addptTh.get()).fail.high;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getAddPTThresholdFailHigh", userException);
        }
    }

    public int getAddPTThresholdFailLow() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sAlarmThresholds)this.addptTh.get()).fail.low;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getAddPTThresholdFailLow", userException);
        }
    }

    public int getAddPTThresholdDegradeHigh() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sAlarmThresholds)this.addptTh.get()).degrade.high;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getAddPTThresholdDegradeHigh", userException);
        }
    }

    public int getAddPTThresholdDegradeLow() throws NoSuchInterface, WrongInterfaceType {
        try {
            return ((sAlarmThresholds)this.addptTh.get()).degrade.low;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getAddPTThresholdDegradeLow", userException);
        }
    }

    public void setAddPTThresholds(sAlarmThresholds sAlarmThresholds2) throws NoSuchInterface, WrongInterfaceType, ProvisionError, ConfigError {
        try {
            this.addptTh.set(sAlarmThresholds2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xProvisioningError xProvisioningError2) {
            throw new ProvisionError((UserException)xProvisioningError2, this.getProvisioningExceptionInfo(xProvisioningError2));
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setAddPTThresholds", userException);
        }
    }

    public sAlarmThresholds getAddPTThresholds() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sAlarmThresholds)this.addptTh.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getAddPTThresholds", userException);
        }
    }

    public sOpticsPmStats getOpticsStats(eIntervalType eIntervalType2, short s) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[3];
            objectArray[0] = eIntervalType2;
            objectArray[1] = new Short(s);
            sOpticsPmStats sOpticsPmStats2 = (sOpticsPmStats)this.opticsStats.get(objectArray);
            return sOpticsPmStats2;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getOpticsStats", userException);
        }
    }

    public void clearOpticsStats(eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            this.opticsStats.set(eIntervalType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearStats", userException);
        }
    }

    public int getVoaCalibrationAttenuation() throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType {
        if ((this.getFeatures() & 1) == 1) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.voa.calibrationAttenuation;
            }
            catch (UserException userException) {
                throw this.doUnknown("getVoaCalibrationAttenuation", userException);
            }
        }
        throw new FeatureUnsupported("getVoaCalibrationAttenuation");
    }

    public void setVoaCalibrationAttenuation(int n) throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, ProvisionError {
        if ((this.getFeatures() & 1) == 1) {
            try {
                this.voaAtt.set(new Integer(n));
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (xInternalCommError xInternalCommError2) {
                throw new InternalCommError((UserException)xInternalCommError2);
            }
            catch (xConfigError xConfigError2) {
                throw new ConfigError((UserException)xConfigError2);
            }
            catch (xFeatureUnsupported xFeatureUnsupported2) {
                throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
            }
            catch (xProvisioningError xProvisioningError2) {
                throw new ProvisionError((UserException)xProvisioningError2, this.getProvisioningExceptionInfo(xProvisioningError2));
            }
            catch (UserException userException) {
                throw this.doUnknown("setVoaCalibrationAttenuation", userException);
            }
        } else {
            throw new FeatureUnsupported("setVoaCalibrationAttenuation");
        }
    }

    public void setVOAAttenuation(int n) throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, ProvisionError {
        try {
            this.voaAtt.set(new Integer(n));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xFeatureUnsupported xFeatureUnsupported2) {
            throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
        }
        catch (xProvisioningError xProvisioningError2) {
            throw new ProvisionError((UserException)xProvisioningError2, this.getProvisioningExceptionInfo(xProvisioningError2));
        }
        catch (UserException userException) {
            throw this.doUnknown("setVOAAttenuation", userException);
        }
    }

    public int getVoaReferenceAttenuation() throws NoSuchInterface, FeatureUnsupported, WrongInterfaceType {
        if ((this.getFeatures() & 1) == 1) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.voa.referenceAttenuation;
            }
            catch (UserException userException) {
                throw this.doUnknown("getVoaReferenceAttenuation", userException);
            }
        }
        throw new FeatureUnsupported("getVoaReferenceAttenuation");
    }

    public int getVoaCalibrationPower() throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType {
        if ((this.getFeatures() & 0x20) != 32 && (this.getFeatures() & 1) == 1) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.voa.calibrationPower;
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (UserException userException) {
                throw this.doUnknown("getVoaCalibrationPower", userException);
            }
        }
        throw new FeatureUnsupported("getVoaCalibrationPower");
    }

    public void setVOACalibrationPower(int n) throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, ProvisionError {
        if ((this.getFeatures() & 0x20) != 32 && (this.getFeatures() & 1) == 1) {
            try {
                this.voaPower.set(new Integer(n));
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (xInternalCommError xInternalCommError2) {
                throw new InternalCommError((UserException)xInternalCommError2);
            }
            catch (xConfigError xConfigError2) {
                throw new ConfigError((UserException)xConfigError2);
            }
            catch (xFeatureUnsupported xFeatureUnsupported2) {
                throw new FeatureUnsupported((UserException)xFeatureUnsupported2);
            }
            catch (xProvisioningError xProvisioningError2) {
                throw new ProvisionError((UserException)xProvisioningError2, this.getProvisioningExceptionInfo(xProvisioningError2));
            }
            catch (UserException userException) {
                throw this.doUnknown("setVOACalibrationPower", userException);
            }
        } else {
            throw new FeatureUnsupported("setVOACalibrationPower");
        }
    }

    public int getVoaReferencePower() throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType {
        if ((this.getFeatures() & 0x20) != 32 && (this.getFeatures() & 1) == 1) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.voa.referencePower;
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (UserException userException) {
                throw this.doUnknown("getVoaReferencePower", userException);
            }
        }
        throw new FeatureUnsupported("getVoaReferencePower");
    }

    public int getCalibratedPower() throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType {
        if ((this.getFeatures() & 0x20) == 32) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.calibratedPower;
            }
            catch (xNoSuchInterface xNoSuchInterface2) {
                throw new NoSuchInterface((UserException)xNoSuchInterface2);
            }
            catch (xWrongInterfaceType xWrongInterfaceType2) {
                throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
            }
            catch (UserException userException) {
                throw this.doUnknown("getCalibratedPower", userException);
            }
        }
        throw new FeatureUnsupported("getCalibratedPower");
    }

    public void setCalibratedPower(int n) throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType, ProvisionError {
        if ((this.getFeatures() & 0x20) == 32) {
            try {
                this.calPower.set(new Integer(n));
            }
            catch (xProvisioningError xProvisioningError2) {
                throw new ProvisionError((UserException)xProvisioningError2, this.getProvisioningExceptionInfo(xProvisioningError2));
            }
            catch (UserException userException) {
                throw this.doUnknown("setCalibratedPower", userException);
            }
        } else {
            throw new FeatureUnsupported("FeatureUnsupported");
        }
    }

    public int getReferencePower() throws NoSuchInterface, FeatureUnsupported, WrongInterfaceType {
        if ((this.getFeatures() & 0x20) == 32) {
            try {
                sGeneralOpticsAttributes sGeneralOpticsAttributes2 = (sGeneralOpticsAttributes)this.genAttr.get();
                return sGeneralOpticsAttributes2.referencePower;
            }
            catch (UserException userException) {
                throw this.doUnknown("getReferencePower", userException);
            }
        }
        throw new FeatureUnsupported("getReferencePower");
    }

    public void setAddPTPortState(eSwitchablePortState eSwitchablePortState2) throws FeatureUnsupported, NoSuchInterface, WrongInterfaceType, ProvisionError {
        try {
            this.addptPortStatus.set(eSwitchablePortState2);
        }
        catch (xProvisioningError xProvisioningError2) {
            throw new ProvisionError(xProvisioningError2.errorExtraInfo.message());
        }
        catch (UserException userException) {
            throw this.doUnknown("setAddPTPortState", userException);
        }
    }

    public int getAddPTPortState() throws NoSuchInterface, FeatureUnsupported, WrongInterfaceType {
        try {
            eSwitchablePortState eSwitchablePortState2 = (eSwitchablePortState)this.addptPortStatus.get();
            return eSwitchablePortState2.value();
        }
        catch (UserException userException) {
            throw this.doUnknown("getAddPTPortState", userException);
        }
    }

    public void setAttributes(sGeneralOpticsAttributes sGeneralOpticsAttributes2, long l) {
        super.setAttributes(sGeneralOpticsAttributes2.base, l);
        this.genAttr.setValueExternally(sGeneralOpticsAttributes2);
    }

    public int getLoopbackAsInt() {
        return 0;
    }

    public boolean isWavelengthSupported() throws NoSuchInterface, WrongInterfaceType {
        try {
            eWavelength eWavelength2 = this.opticsProvExtModel.getLineWavelength();
            return !eWavelength2.equals(eWavelength.WV_UNKNOWN);
        }
        catch (UnsupportedOperation unsupportedOperation) {
            if (this.db.on()) {
                this.db.println("Non-optical channel models do not support wavelength attributes.");
            }
            return false;
        }
    }

    public int getActualWaveLength() throws WrongInterfaceType, NoSuchInterface {
        try {
            return this.opticsProvExtModel.getLineWavelength().value();
        }
        catch (UnsupportedOperation unsupportedOperation) {
            throw new WrongInterfaceType("Non-optical channel models do not support wavelength attributes.");
        }
    }

    public String getActualWaveLengthString() {
        int n;
        try {
            n = this.getActualWaveLength();
        }
        catch (Exception exception) {
            n = 174;
        }
        return Wavelength.getWavelengthStringFromWavelength(n);
    }

    @Override
    public int getExpectedWaveLength() throws WrongInterfaceType, NoSuchInterface {
        try {
            return this.opticsProvExtModel.getLineWavelength().value();
        }
        catch (UnsupportedOperation unsupportedOperation) {
            throw new WrongInterfaceType("Non-optical channel models do not support wavelength attributes.");
        }
    }

    public String getExpectedWaveLengthString() {
        int n;
        try {
            n = this.getExpectedWaveLength();
        }
        catch (Exception exception) {
            n = 174;
        }
        return Wavelength.getWavelengthStringFromWavelength(n);
    }

    public void setWaveLength(int n) throws NoSuchInterface, WrongInterfaceType, DetailedConfigError {
        throw new WrongInterfaceType("Non-optical channel models do not support wavelength attributes.");
    }

    public boolean isChannelPort() throws NoSuchInterface {
        eIfType eIfType2 = this.getOptIfType();
        try {
            return eIfType2.equals(eIfType.OCH) || eIfType2.equals(eIfType.OTS) && this.isWavelengthSupported();
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            return false;
        }
    }

    public boolean isOtsPort() throws NoSuchInterface {
        eIfType eIfType2 = this.getOptIfType();
        return eIfType2.equals(eIfType.OTS) || eIfType2.equals(eIfType.AOTS);
    }

    public boolean isOmsPort() throws NoSuchInterface {
        eIfType eIfType2 = this.getOptIfType();
        return eIfType2.equals(eIfType.OMS);
    }

    public String defaultPTargetMaintenance() {
        AnsParamModel ansParamModel = ANSManager.getInstance(this.getNodeModelDelegate()).getNeANSModel().getAnsParam(this.getIndex(), eParamType.TY_CHPWR, eSpectrumGranularity.SP_OTS, 0);
        double d = -14.0;
        if (ansParamModel != null) {
            d = (double)ansParamModel.getParamInfo().value.currentValue / 10.0;
        }
        return String.valueOf(d);
    }

    public String defaultVOAAttenuationMaintenance() throws NoSuchInterface, WrongInterfaceType {
        double d = 20.0;
        try {
            if (this.getOptPortType() == OpticalPortType.IN_EXPRESS) {
                PassiveModuleModel[] passiveModuleModelArray = PassiveModuleModel.getPassiveUnitByType(this.getNodeModelDelegate(), 313);
                if (passiveModuleModelArray.length > 0) {
                    d = 20.0;
                } else {
                    passiveModuleModelArray = PassiveModuleModel.getPassiveUnitByType(this.getNodeModelDelegate(), 314);
                    if (passiveModuleModelArray.length > 0) {
                        d = 16.0;
                    }
                }
            } else if (this.getOptPortType() == OpticalPortType.ADD) {
                d = 22.0;
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return String.valueOf(d);
    }

    public int getReversePort() throws NoSuchInterface, WrongInterfaceType {
        return this.getReversePortList()[0];
    }

    public int[] getReversePortList() throws NoSuchInterface, WrongInterfaceType {
        try {
            return this.node.getOpticalPatchCordModel().getReversePort(this.getIndex());
        }
        catch (WrongPortType wrongPortType) {
            if (this.db.on()) {
                this.db.println("Unsupported port for 0x" + Integer.toHexString(this.getIndex()));
            }
            throw new WrongInterfaceType(wrongPortType.getPrettyMessage());
        }
        catch (NoSuchEquipment noSuchEquipment) {
            throw new NoSuchInterface(noSuchEquipment.getPrettyMessage());
        }
    }

    public IFvInterfaceModel getReversePortModel() throws NoSuchInterface, WrongInterfaceType {
        int n = this.getReversePort();
        try {
            List list = this.getModuleModel().getChildren();
            for (IFvPortModel iFvPortModel : list) {
                if (iFvPortModel.getIFvInterfaceModel().getIndex() != n) continue;
                return iFvPortModel.getIFvInterfaceModel();
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            return null;
        }
        return null;
    }

    public String[] getUsedWavelength(IFvOpticsLineModel[] iFvOpticsLineModelArray, IFvCardModel iFvCardModel) {
        return this.getUsedWavelength();
    }

    public Integer[] getUsedWavelengthAsInt() {
        InterfaceModel[] interfaceModelArray = this.getHigherLayerModels();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < interfaceModelArray.length; ++i) {
            InterfaceModel interfaceModel = interfaceModelArray[i];
            if (!(interfaceModel instanceof OpticsOchTermModel)) continue;
            OpticsOchTermModel opticsOchTermModel = (OpticsOchTermModel)interfaceModel;
            try {
                int n = opticsOchTermModel.getActualWaveLength();
                arrayList.add(new Integer(opticsOchTermModel.getActualWaveLength()));
                continue;
            }
            catch (NoSuchInterface noSuchInterface) {
                FunctDebug.printStackTrace((Throwable)noSuchInterface);
                continue;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                FunctDebug.printStackTrace((Throwable)wrongInterfaceType);
            }
        }
        return arrayList.toArray(new Integer[0]);
    }

    public String[] getUsedWavelength() {
        Integer[] integerArray = this.getUsedWavelengthAsInt();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < integerArray.length; ++i) {
            arrayList.add(Wavelength.getWavelengthStringFromWavelength(integerArray[i]) + "<BR>");
        }
        return arrayList.toArray(new String[0]);
    }

    public ApcEstimationInfo[] getPerChannelPower(int[] nArray, int n) throws UserException {
        ApcEstimationInfo[] apcEstimationInfoArray = null;
        Object[] objectArray = new Object[2];
        try {
            objectArray[0] = nArray;
            objectArray[1] = new Integer(n);
            sApcEstimationInfo[] sApcEstimationInfoArray = (sApcEstimationInfo[])this.channelPowerInfo.get(objectArray);
            apcEstimationInfoArray = new ApcEstimationInfo[sApcEstimationInfoArray.length];
            for (int i = 0; i < sApcEstimationInfoArray.length; ++i) {
                apcEstimationInfoArray[i] = new ApcEstimationInfo(sApcEstimationInfoArray[i].portIndex, sApcEstimationInfoArray[i].perChannelPower, sApcEstimationInfoArray[i].numberOfChannels);
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            abstractCmsIOException.printStackTrace();
        }
        catch (UserException userException) {
            throw this.doUnknown("getPerChannelPower", userException);
        }
        return apcEstimationInfoArray;
    }

    public boolean isFeatureSupported(int n) {
        boolean bl = false;
        try {
            if ((this.getFeatures() & n) == n) {
                bl = true;
            }
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            SDebug.printStackTrace((Throwable)wrongInterfaceType);
        }
        catch (NoSuchInterface noSuchInterface) {
            SDebug.printStackTrace((Throwable)noSuchInterface);
        }
        return bl;
    }

    public Attribute[] getSupportedWavelengths() throws AbstractCmsNoSuchEntityException {
        return this.getOpticsPort().getSupportedWavelengths();
    }

    private class ActualOpticsAttributes
    extends NonCachedValue {
        public ActualOpticsAttributes(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return AbstractOpticsLineModel.this.ifReference.getActualOpticsAttributes(AbstractOpticsLineModel.this.getIndex());
        }
    }

    private class AddPTPortState
    extends CachedValue {
        private AddPTPortState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return AbstractOpticsLineModel.this.ifReference.getPortState(AbstractOpticsLineModel.this.getIndex());
        }

        @Override
        protected void setValue(Object object) throws UserException {
            AbstractOpticsLineModel.this.ifReference.setPortState(AbstractOpticsLineModel.this.getIndex(), (eSwitchablePortState)object);
        }
    }

    private class AddPTPowerThreshold
    extends CachedValue {
        public AddPTPowerThreshold(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            sAlarmThresholds sAlarmThresholds2 = AbstractOpticsLineModel.this.ifReference.getAddPowerThreshold(AbstractOpticsLineModel.this.getIndex());
            return sAlarmThresholds2;
        }

        @Override
        protected void setValue(Object object) throws UserException {
            AbstractOpticsLineModel.this.ifReference.setAddPowerThreshold(AbstractOpticsLineModel.this.getIndex(), (sAlarmThresholds)object);
        }

        public Object outer() {
            return this;
        }

        @Override
        protected Object cloneValue() {
            sAlarmThresholds sAlarmThresholds2 = (sAlarmThresholds)this.value;
            sValThresholds sValThresholds2 = new sValThresholds(sAlarmThresholds2.fail.high, sAlarmThresholds2.fail.low);
            sValThresholds sValThresholds3 = new sValThresholds(sAlarmThresholds2.degrade.high, sAlarmThresholds2.degrade.low);
            sAlarmThresholds sAlarmThresholds3 = new sAlarmThresholds(sValThresholds2, sValThresholds3);
            return sAlarmThresholds3;
        }
    }

    private class AlmThresholds
    extends CachedValue {
        public AlmThresholds(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            sOpticsAlmThresholds sOpticsAlmThresholds2 = AbstractOpticsLineModel.this.ifReference.getOpticsAlmThresholds(AbstractOpticsLineModel.this.getIndex());
            return sOpticsAlmThresholds2;
        }

        @Override
        protected void setValue(Object object) throws UserException {
            AbstractOpticsLineModel.this.ifReference.setOpticsAlmThresholds(AbstractOpticsLineModel.this.getIndex(), (sOpticsAlmThresholds)object);
        }

        public Object outer() {
            return this;
        }

        @Override
        protected Object cloneValue() {
            sOpticsAlmThresholds sOpticsAlmThresholds2 = (sOpticsAlmThresholds)this.value;
            sValThresholds sValThresholds2 = new sValThresholds(sOpticsAlmThresholds2.opticalPowerAlmTh.fail.high, sOpticsAlmThresholds2.opticalPowerAlmTh.fail.low);
            sValThresholds sValThresholds3 = new sValThresholds(sOpticsAlmThresholds2.opticalPowerAlmTh.degrade.high, sOpticsAlmThresholds2.opticalPowerAlmTh.degrade.low);
            sAlarmThresholds sAlarmThresholds2 = new sAlarmThresholds(sValThresholds2, sValThresholds3);
            sValThresholds2 = new sValThresholds(sOpticsAlmThresholds2.oscPowerAlmTh.fail.high, sOpticsAlmThresholds2.oscPowerAlmTh.fail.low);
            sValThresholds3 = new sValThresholds(sOpticsAlmThresholds2.oscPowerAlmTh.degrade.high, sOpticsAlmThresholds2.oscPowerAlmTh.degrade.low);
            sAlarmThresholds sAlarmThresholds3 = new sAlarmThresholds(sValThresholds2, sValThresholds3);
            sValThresholds sValThresholds4 = new sValThresholds(sOpticsAlmThresholds2.voaAlmTh.fail.high, sOpticsAlmThresholds2.voaAlmTh.fail.low);
            sValThresholds sValThresholds5 = new sValThresholds(sOpticsAlmThresholds2.voaAlmTh.degrade.high, sOpticsAlmThresholds2.voaAlmTh.degrade.low);
            sAlarmThresholds sAlarmThresholds4 = new sAlarmThresholds(sValThresholds4, sValThresholds5);
            sValThresholds sValThresholds6 = new sValThresholds(sOpticsAlmThresholds2.gainAlmTh.fail.high, sOpticsAlmThresholds2.gainAlmTh.fail.low);
            sValThresholds sValThresholds7 = new sValThresholds(sOpticsAlmThresholds2.gainAlmTh.degrade.high, sOpticsAlmThresholds2.gainAlmTh.degrade.low);
            sAlarmThresholds sAlarmThresholds5 = new sAlarmThresholds(sValThresholds6, sValThresholds7);
            sOpticsAlmThresholds sOpticsAlmThresholds3 = new sOpticsAlmThresholds(sOpticsAlmThresholds2.ifIndex, sAlarmThresholds2, sAlarmThresholds3, sAlarmThresholds4, sAlarmThresholds5);
            return sOpticsAlmThresholds3;
        }
    }

    private class CalibratedPower
    extends NonCachedValue {
        public CalibratedPower(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            AbstractOpticsLineModel.this.ifReference.setPowerCalibration(AbstractOpticsLineModel.this.getIndex(), (Integer)object);
        }

        public Object outer() {
            return this;
        }
    }

    private class ChannelPowerInfo
    extends NonCachedValue {
        public ChannelPowerInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            int[] nArray = (int[])objectArray[0];
            eWavelength eWavelength2 = eWavelength.from_int((Integer)objectArray[1]);
            return AbstractOpticsLineModel.this.ifReference.getApcEstimationInfo(nArray, eWavelength2);
        }
    }

    private class DisaMaintenanceChannel
    extends NonCachedValue {
        private DisaMaintenanceChannel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xFeatureUnsupported, xProvisioningError, xNoSuchInterface {
            int n = (Integer)object;
            AbstractOpticsLineModel.this.ifReference.disableMaintenanceChannel(n);
        }
    }

    private class EnaMaintenanceChannel
    extends NonCachedValue {
        private EnaMaintenanceChannel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xFeatureUnsupported, xProvisioningError, xNoSuchInterface {
            int[] nArray = (int[])object;
            eWavelength eWavelength2 = eWavelength.from_int(nArray[2]);
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = nArray[3];
            int n4 = nArray[4];
            AbstractOpticsLineModel.this.ifReference.enableMaintenanceChannel(n, n2, eWavelength2, n3, n4);
        }
    }

    protected class GeneralAttributes
    extends CachedValue {
        private GeneralAttributes(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return AbstractOpticsLineModel.this.ifReference.getGeneralOpticsAttributes(AbstractOpticsLineModel.this.getIndex());
        }
    }

    private class GetMaintenanceChannel
    extends NonCachedValue {
        private GetMaintenanceChannel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws xWrongInterfaceType, xInternalCommError, xFeatureUnsupported, xNoSuchInterface {
            int[] nArray = new int[6];
            int n = (Integer)object;
            eWavelengthHolder eWavelengthHolder2 = new eWavelengthHolder();
            IntHolder intHolder = new IntHolder();
            IntHolder intHolder2 = new IntHolder();
            IntHolder intHolder3 = new IntHolder();
            IntHolder intHolder4 = new IntHolder();
            AbstractOpticsLineModel.this.ifReference.getMaintenanceChannelPower(n, intHolder, eWavelengthHolder2, intHolder2, intHolder4, intHolder3);
            nArray[0] = n;
            nArray[1] = intHolder.value;
            nArray[2] = eWavelengthHolder2.value.value();
            nArray[3] = intHolder2.value;
            nArray[4] = intHolder4.value;
            nArray[5] = intHolder3.value;
            return nArray;
        }
    }

    public static enum LevelType {
        DEGRADE,
        FAIL;

    }

    private class OpticsStats
    extends NonCachedValue {
        public OpticsStats(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            AbstractOpticsLineModel.this.ifReference.clearOpticsStats(AbstractOpticsLineModel.this.getIndex(), (eIntervalType)object);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            short s = (Short)objectArray[1];
            sOpticsPmStats sOpticsPmStats2 = AbstractOpticsLineModel.this.ifReference.getOpticsStats(AbstractOpticsLineModel.this.getIndex(), (eIntervalType)objectArray[0], s);
            return sOpticsPmStats2;
        }
    }

    private class SetMaintenanceChannel
    extends NonCachedValue {
        private SetMaintenanceChannel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws xWrongInterfaceType, xFeatureUnsupported, xProvisioningError, xNoSuchInterface {
            int[] nArray = (int[])object;
            eWavelength eWavelength2 = eWavelength.from_int(nArray[2]);
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = nArray[3];
            int n4 = nArray[4];
            AbstractOpticsLineModel.this.ifReference.setMaintenanceChannelPower(n, n2, eWavelength2, n3, n4);
        }
    }

    public static enum TCAAlmType {
        POWER,
        OSC,
        VOA,
        GAIN;

    }

    private class TCAThresholds
    extends CachedValue {
        public TCAThresholds(String string, NodeModelDelegate nodeModelDelegate) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue(Object object) throws UserException {
            sOpticsTCAThresholds sOpticsTCAThresholds2 = AbstractOpticsLineModel.this.ifReference.getOpticsTCAThresholds(AbstractOpticsLineModel.this.getIndex(), (eIntervalType)object);
            return sOpticsTCAThresholds2;
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            AbstractOpticsLineModel.this.ifReference.setOpticsTCAThresholds(AbstractOpticsLineModel.this.getIndex(), (sOpticsTCAThresholds)objectArray[0], (eIntervalType)objectArray[1]);
        }

        @Override
        protected Object cloneValue() {
            sOpticsTCAThresholds sOpticsTCAThresholds2 = (sOpticsTCAThresholds)this.value;
            sValThresholds sValThresholds2 = new sValThresholds(sOpticsTCAThresholds2.opticalPowerPMTh.high, sOpticsTCAThresholds2.opticalPowerPMTh.low);
            sValThresholds sValThresholds3 = new sValThresholds(sOpticsTCAThresholds2.oscPowerPMTh.high, sOpticsTCAThresholds2.oscPowerPMTh.low);
            sOpticsTCAThresholds sOpticsTCAThresholds3 = new sOpticsTCAThresholds(sOpticsTCAThresholds2.ifIndex, sValThresholds2, sValThresholds3);
            return sOpticsTCAThresholds3;
        }

        public Object outer() {
            return this;
        }
    }

    public static enum ThType {
        LOWIDX,
        HIGHIDX;

    }

    private class VOAAttenuation
    extends NonCachedValue {
        public VOAAttenuation(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            AbstractOpticsLineModel.this.ifReference.setVOAAttenuation(AbstractOpticsLineModel.this.getIndex(), (Integer)object);
        }
    }

    private class VOAPower
    extends NonCachedValue {
        public VOAPower(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            AbstractOpticsLineModel.this.ifReference.setVOAPower(AbstractOpticsLineModel.this.getIndex(), (Integer)object);
        }
    }

    private class WlPower
    extends NonCachedValue {
        private WlPower(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return AbstractOpticsLineModel.this.ifReference.getAllWLPowerOnPort(AbstractOpticsLineModel.this.getIndex());
        }
    }

    private class WorkingChannel
    extends NonCachedValue {
        private WorkingChannel(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws xWrongInterfaceType, xInternalCommError, xFeatureUnsupported, xNoSuchInterface, xNotReady {
            return new Integer(AbstractOpticsLineModel.this.ifReference.getWorkingChannel(AbstractOpticsLineModel.this.getIndex()));
        }
    }
}

