/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.SonetTopology.SonetFactory;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.VcatTermModel;
import cerent.cms.model.VcatTermModelsDelegate;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public abstract class AbstractVcatTermsMap
extends CmsObservable
implements Observer {
    protected VcatTermModelsDelegate container;
    protected NodeModelDelegate node;
    protected HashMap vcatTermModels;
    protected boolean isInitedRealState;
    private EventDispatcher dispatcher;
    protected SDebug db;

    public AbstractVcatTermsMap(VcatTermModelsDelegate vcatTermModelsDelegate) {
        this.container = vcatTermModelsDelegate;
        this.node = vcatTermModelsDelegate.node;
        this.vcatTermModels = new HashMap();
    }

    protected synchronized void initReal() {
        this.isInitedRealState = true;
        this.discover(this.vcatTermModels);
        Iterator iterator = this.vcatTermModels.values().iterator();
        while (iterator.hasNext()) {
            ((VcatTermModel)iterator.next()).init();
        }
    }

    public void init() {
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(this.getObjectType(), 0, (Observer)this);
        }
    }

    protected abstract ObjectType getObjectType();

    protected SonetFactory getSonetFactoryRef() {
        return this.container.getSonetFactoryRef();
    }

    public Collection getVcatTermModels() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        return this.vcatTermModels.values();
    }

    protected abstract void discover(Map var1);

    public static Collection getAddedObjects(Collection collection, Collection collection2) {
        HashSet hashSet = new HashSet(collection);
        HashSet hashSet2 = new HashSet(collection2);
        hashSet.removeAll(hashSet2);
        return hashSet;
    }

    public static Collection getDeletedObjects(Collection collection, Collection collection2) {
        HashSet hashSet = new HashSet(collection);
        HashSet hashSet2 = new HashSet(collection2);
        hashSet2.removeAll(hashSet);
        return hashSet2;
    }

    public synchronized void remove(int n) {
        this.vcatTermModels.remove(new Integer(n));
    }

    public synchronized void remove(VcatTermModel vcatTermModel) {
        this.remove(vcatTermModel.getIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VcatTermModel findVcatTermModelInCache(int n) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        Object var2_2 = null;
        AbstractVcatTermsMap abstractVcatTermsMap = this;
        synchronized (abstractVcatTermsMap) {
            var2_2 = this.vcatTermModels.get(new Integer(n));
        }
        if (var2_2 == null && this.db.on()) {
            this.db.println("Could not find the VcatTermModel in the cache ");
        }
        return var2_2;
    }

    public VcatTermModel get(int n) {
        return this.findVcatTermModelInCache(n);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        int n = ((IObjectMessageInfo)object).getUpdateType();
        switch (n) {
            case 1: {
                if (this.db.on) {
                    this.db.println("Got a Changed Message for VcatTerms");
                }
                this.container.updateLocal();
                break;
            }
            case 2: {
                if (this.db.on) {
                    this.db.println("Got an UpdateStructure Message for VcatTerms");
                }
                if (!this.updateStructure()) break;
                if (this.db.on) {
                    this.db.println("Going to notify about update");
                }
                this.setChanged();
                this.notifyObservers(ModelUpdateType.ADDED);
                break;
            }
            case 0: {
                break;
            }
            default: {
                String string = "Unknown update message (" + n + ") on VcatTerms";
                this.db.println(string);
                SDebug.printStackTrace((Throwable)new IllegalArgumentException(string));
            }
        }
    }

    protected abstract boolean updateStructure();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ArrayList arrayList;
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(this.getObjectType(), 0, (Observer)this);
        }
        this.isInitedRealState = false;
        AbstractVcatTermsMap abstractVcatTermsMap = this;
        synchronized (abstractVcatTermsMap) {
            arrayList = new ArrayList(this.vcatTermModels.values());
            this.vcatTermModels.clear();
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                ((VcatTermModel)iterator.next()).destroy();
            }
            catch (Exception exception) {
                this.db.println("Exception caught while deleting circuit " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected void printVcatTermsMapString(SDebug sDebug) {
        if (this.vcatTermModels == null || this.vcatTermModels.size() == 0) {
            sDebug.println("No VcatTerm Models ..");
            return;
        }
        Iterator iterator = this.vcatTermModels.values().iterator();
        while (iterator.hasNext()) {
            try {
                VcatTermModel vcatTermModel = (VcatTermModel)iterator.next();
                sDebug.println("=============================\n");
                sDebug.println("VcatTerm Class is " + vcatTermModel.getClass().getName());
                vcatTermModel.printString(sDebug);
            }
            catch (Exception exception) {
                sDebug.println("Got Exception " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }
}

