/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.BbeSlot;
import cerent.cms.model.CmsNoSuchEntityException;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds123ModuleModel;
import cerent.cms.model.Ds123PortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.util.SDebug;
import java.util.List;

public class BbeModuleModel
extends Ds123ModuleModel {
    public BbeModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2);
    }

    @Override
    protected InterfaceModel[] getLineModels(eEqType eEqType2) {
        InterfaceModel[] interfaceModelArray = null;
        if (eEqType2 == null) {
            interfaceModelArray = super.getLineModels(eEqType2);
        } else {
            PortModel[] portModelArray = this.getPortModels(eEqType2);
            if (this.db.on()) {
                this.db.println("Found " + portModelArray.length + " ports");
            }
            switch (eEqType2.value()) {
                case 32: 
                case 33: {
                    if (this.db.on()) {
                        this.db.println("Finding lines for Ds123 ports...");
                    }
                    interfaceModelArray = new Ds123LineModel[portModelArray.length];
                    for (int i = 0; i < portModelArray.length; ++i) {
                        interfaceModelArray[i] = (Ds123LineModel)portModelArray[i].getInterfaceModel();
                    }
                    break;
                }
                case 31: {
                    if (this.db.on()) {
                        this.db.println("Finding lines for Tdm ports...");
                    }
                    interfaceModelArray = new TdmLineModel[portModelArray.length];
                    for (int i = 0; i < portModelArray.length; ++i) {
                        interfaceModelArray[i] = (TdmLineModel)portModelArray[i].getInterfaceModel();
                    }
                    break;
                }
                default: {
                    this.db.println("Could not get lines for BBE Card!");
                    if (!this.db.on()) break;
                    SDebug.printStackTrace((Throwable)new Exception());
                }
            }
        }
        return interfaceModelArray == null ? new InterfaceModel[]{} : interfaceModelArray;
    }

    @Override
    protected PortModel[] getPortModels(eEqType eEqType2) {
        PortModel[] portModelArray = null;
        if (eEqType2 == null) {
            portModelArray = super.getPortModels(eEqType2);
        } else {
            switch (eEqType2.value()) {
                case 32: 
                case 33: {
                    portModelArray = this.getDescendantsOfType(eEqType2).toArray(new Ds123PortModel[0]);
                    break;
                }
                case 31: {
                    portModelArray = this.getDescendantsOfType(eEqType2).toArray(new TdmPortModel[0]);
                    break;
                }
                default: {
                    this.db.println("Could not get ports for BBE Card!");
                    if (!this.db.on()) break;
                    SDebug.printStackTrace((Throwable)new Exception());
                }
            }
        }
        return portModelArray == null ? new PortModel[]{} : portModelArray;
    }

    public Ds123LineModel[] getDs3Lines() {
        return (Ds123LineModel[])this.getLineModels(eEqType.DS3);
    }

    public Ds123LineModel[] getDs3xmLines() {
        return (Ds123LineModel[])this.getLineModels(eEqType.DS3_TRANS_MUX);
    }

    public TdmLineModel[] getEc1Lines() {
        return (TdmLineModel[])this.getLineModels(eEqType.EC1_PORT);
    }

    public BbeSlot getBbeSlot() throws CmsNoSuchEntityException {
        List list = this.getChildrenOfType(eEqType.BBE_SLOT);
        if (list.size() != 1) {
            this.db.println("Found " + list.size() + " Slots!");
            throw new CmsNoSuchEntityException("The wrong number of slots was returned.");
        }
        return (BbeSlot)list.get(0);
    }

    @Override
    public String toString() {
        return "DS3_EC1_6" + super.toString();
    }
}

