/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.sRevertiveBehavior;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.SonetMedia.Pool;
import cerent.cms.idl.SonetMedia.sPathInfo;
import cerent.cms.idl.SonetTopology.Blsr;
import cerent.cms.idl.SonetTopology.BlsrHelper;
import cerent.cms.idl.SonetTopology.eBlsrChannelState;
import cerent.cms.idl.SonetTopology.eBlsrProtectionOp;
import cerent.cms.idl.SonetTopology.eElementType;
import cerent.cms.idl.SonetTopology.eProtectionOp;
import cerent.cms.idl.SonetTopology.sBlsrItem;
import cerent.cms.idl.SonetTopology.sBlsrProtectionOp;
import cerent.cms.idl.SonetTopology.sBlsrProvision;
import cerent.cms.idl.SonetTopology.sRingMapEntry;
import cerent.cms.idl.SonetTopology.sRipTblEntry;
import cerent.cms.idl.SonetTopology.sSquelchTblEntry;
import cerent.cms.idl.SonetTopology.xBlsrSpanSwitched;
import cerent.cms.idl.SonetTopology.xBusy;
import cerent.cms.idl.SonetTopology.xDuplicateNodeId;
import cerent.cms.idl.SonetTopology.xDuplicateRingId;
import cerent.cms.idl.SonetTopology.xInvalidProtectionOp;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.BlsrProtectionOpFactory;
import cerent.cms.model.BlsrProvisionFactory;
import cerent.cms.model.BlsrSpanSwitched;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsNodeUpgradingException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.DuplicateNodeId;
import cerent.cms.model.DuplicateRingId;
import cerent.cms.model.ElementModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IBlsrModel;
import cerent.cms.model.IBlsrProtectionOp;
import cerent.cms.model.IBlsrProvision;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPathInfo;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.IRipTblEntry;
import cerent.cms.model.ISquelchTblEntry;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidProtectionOp;
import cerent.cms.model.NoSuchPoolException;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PathInfoFactory;
import cerent.cms.model.PoolModel;
import cerent.cms.model.PoolModelsDelegate;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.RevertiveBehaviorFactory;
import cerent.cms.model.RipTblEntryFactory;
import cerent.cms.model.SquelchTblEntryFactory;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.UserValue;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.List;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;

public class BlsrModel
extends ElementModel
implements IBlsrModel {
    private Blsr blsrRef = null;
    private QuerySugRingMapChanged querySugRingMapChanged;
    private Provision provision;
    private RingReversion ringReversion;
    private SpanReversion spanReversion;
    private EastMainState eastMainState;
    private EastMainType eastMainType;
    private EastProtState eastProtState;
    private EastProtectType eastProtectType;
    private WestMainState westMainState;
    private WestMainType westMainType;
    private WestProtState westProtState;
    private WestProtectType westProtectType;
    private EastProtection eastProtection;
    private WestProtection westProtection;
    private EastMainPool eastMainPool;
    private WestMainPool westMainPool;
    private EastProtectPool eastProtectPool;
    private WestProtectPool westProtectPool;
    private WestProtectStsPaths westProtectStsPaths;
    private EastProtectStsPaths eastProtectStsPaths;
    private RingMap ringMap;
    private SuggestedRingMap suggestedRingMap;
    private SquelchTbl squelchTbl;
    private RipTbl ripTbl;
    private ExtendedRing extendedRing;
    private NodeId nodeId;
    private RingName ringName;
    private Delete delete;
    private Upgrade2FiberTo4Fiber upgrade2FiberTo4Fiber;
    private NeAcceptNewTables neAcceptNewTables;
    private String myString;

    public BlsrModel(NodeModelDelegate nodeModelDelegate, int n, sBlsrItem sBlsrItem2) {
        super(nodeModelDelegate, n, sBlsrItem2.element, nodeModelDelegate.getChildDebug(BlsrModel.class));
        if (this.db.on) {
            this.db.println("<init>: entry");
        }
        this.lclInit();
        this.setAttributes(sBlsrItem2);
        this.myString = null;
        if (this.db.on) {
            this.db.println("<init>: exit");
        }
    }

    public static String CreateBLSRRingName(TDMTerminology tDMTerminology) {
        return tDMTerminology.getRingTerms(1) + " Ring";
    }

    private void lclInit() {
        this.provision = new Provision("BlsrModel.provision");
        this.querySugRingMapChanged = new QuerySugRingMapChanged("BlsrModel.querySugRingMapChanged");
        this.ringReversion = new RingReversion("BlsrModel.ringReversion");
        this.spanReversion = new SpanReversion("BlsrModel.spanReversion");
        this.eastProtection = new EastProtection("BlsrModel.eastProtection");
        this.westProtection = new WestProtection("BlsrModel.westProtection");
        this.eastMainPool = new EastMainPool("BlsrModel.eastMainPool");
        this.westMainPool = new WestMainPool("BlsrModel.westMainPool");
        this.eastProtectPool = new EastProtectPool("BlsrModel.eastProtectPool");
        this.westProtectPool = new WestProtectPool("BlsrModel.westProtectPool");
        this.eastMainState = new EastMainState("BlsrModel.eastMainState");
        this.eastMainType = new EastMainType(this.node, "BlsrModel.eastMainType");
        this.eastProtState = new EastProtState("BlsrModel.eastProtState");
        this.eastProtectType = new EastProtectType(this.node, "BlsrModel.eastProtState");
        this.westMainState = new WestMainState("BlsrModel.westMainState");
        this.westMainType = new WestMainType(this.node, "BlsrModel.westMainType");
        this.westProtState = new WestProtState("BlsrModel.westProtState");
        this.westProtectType = new WestProtectType(this.node, "BlsrModel.westProtState");
        this.westProtectStsPaths = new WestProtectStsPaths(this.node, "BlsrModel.WestProtectStsPaths");
        this.eastProtectStsPaths = new EastProtectStsPaths(this.node, "BlsrModel.EastProtectStsPaths");
        this.ringMap = new RingMap("BlsrModel.ringMap");
        this.suggestedRingMap = new SuggestedRingMap("BlsrModel.suggestedRingMap");
        this.squelchTbl = new SquelchTbl("BlsrModel.squelchTbl");
        this.ripTbl = new RipTbl("BlsrModel.ripTbl");
        this.extendedRing = new ExtendedRing("BlsrModel.extendedRing");
        this.nodeId = new NodeId("BlsrModel.nodeId");
        this.ringName = new RingName("BlsrModel.ringName");
        this.delete = new Delete("BlsrModel.delete");
        this.upgrade2FiberTo4Fiber = new Upgrade2FiberTo4Fiber("BlsrModel.upgrade2FiberTo4Fiber");
        this.neAcceptNewTables = new NeAcceptNewTables("BlsrModel.neAcceptNewTables");
    }

    @Override
    public void init() {
        super.init();
        this.setIndex(this.getEastEntityIndex());
    }

    private Blsr getBlsrRef() {
        if (this.blsrRef == null) {
            this.blsrRef = BlsrHelper.narrow(this.getElementRef());
            if (this.db.on) {
                this.db.println("getBlsrRef() = " + this.blsrRef);
            }
        }
        return this.blsrRef;
    }

    private PoolModelsDelegate getPoolModels() {
        return (PoolModelsDelegate)this.node.getPoolModels();
    }

    @Override
    public boolean referencesEntityIndex(int n) {
        return n == this.getEastEntityIndex() || n == this.getEastProtectEntityIndex() || n == this.getWestEntityIndex() || n == this.getWestProtectEntityIndex();
    }

    @Override
    int[] getIndices() {
        return new int[]{this.getEastEntityIndex(), this.getEastProtectEntityIndex(), this.getWestEntityIndex(), this.getWestProtectEntityIndex()};
    }

    public void setAttributes(sBlsrItem sBlsrItem2) {
        super.setAttributes(sBlsrItem2.elementData);
        this.provision.setValueExternally(sBlsrItem2.provision);
        this.eastMainState.setValueExternally(sBlsrItem2.eastMainState);
        this.eastProtState.setValueExternally(sBlsrItem2.eastProtState);
        this.westMainState.setValueExternally(sBlsrItem2.westMainState);
        this.westProtState.setValueExternally(sBlsrItem2.westProtState);
        this.eastMainPool.setValueExternally(new Integer(sBlsrItem2.eastMainPoolIndex));
        this.eastProtectPool.setValueExternally(new Integer(sBlsrItem2.eastProtectPoolIndex));
        this.westMainPool.setValueExternally(new Integer(sBlsrItem2.westMainPoolIndex));
        this.westProtectPool.setValueExternally(new Integer(sBlsrItem2.westProtectPoolIndex));
        this.eastProtection.setValueExternally(sBlsrItem2.eastProtectionOp);
        this.westProtection.setValueExternally(sBlsrItem2.westProtectionOp);
    }

    public void neAcceptNewTables() throws xDuplicateNodeId {
        try {
            this.neAcceptNewTables.set();
        }
        catch (xDuplicateNodeId xDuplicateNodeId2) {
            String string = xDuplicateNodeId2.getMessage();
            string = string + "\nBlsrModel neAcceptNewTables(); duplicated node ID";
            if (this.db.on()) {
                this.db.println(this.node.dbName() + string);
            }
            throw xDuplicateNodeId2;
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean hasPCAConnections() {
        IPoolModel iPoolModel = this.getWestProtectPoolModel();
        IPoolModel iPoolModel2 = this.getEastProtectPoolModel();
        return iPoolModel != null && iPoolModel.connectedPaths().length > 0 || iPoolModel2 != null && iPoolModel2.connectedPaths().length > 0;
    }

    public boolean hasDriConnections() {
        TdmLineModel tdmLineModel;
        TdmLineModel tdmLineModel2;
        TdmLineModel tdmLineModel3;
        TdmLineModel tdmLineModel4;
        IEntityModel iEntityModel;
        block16: {
            block15: {
                block14: {
                    block13: {
                        iEntityModel = null;
                        tdmLineModel4 = null;
                        tdmLineModel3 = null;
                        tdmLineModel2 = null;
                        tdmLineModel = null;
                        try {
                            iEntityModel = this.getEastEntityModel();
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            if (!this.db.on()) break block13;
                            this.db.println("AbstractCmsNoSuchEntityException caught.");
                        }
                    }
                    if (iEntityModel != null && iEntityModel instanceof TdmPortModel) {
                        tdmLineModel4 = ((TdmPortModel)iEntityModel).getTdmLineModel();
                    }
                    try {
                        iEntityModel = this.getWestEntityModel();
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (!this.db.on()) break block14;
                        this.db.println("AbstractCmsNoSuchEntityException caught.");
                    }
                }
                if (iEntityModel != null && iEntityModel instanceof TdmPortModel) {
                    tdmLineModel3 = ((TdmPortModel)iEntityModel).getTdmLineModel();
                }
                try {
                    iEntityModel = this.getEastProtectEntityModel();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.db.on()) break block15;
                    this.db.println("AbstractCmsNoSuchEntityException caught.");
                }
            }
            if (iEntityModel != null && iEntityModel instanceof TdmPortModel) {
                tdmLineModel2 = ((TdmPortModel)iEntityModel).getTdmLineModel();
            }
            try {
                iEntityModel = this.getWestProtectEntityModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block16;
                this.db.println("AbstractCmsNoSuchEntityException caught.");
            }
        }
        if (iEntityModel != null && iEntityModel instanceof TdmPortModel) {
            tdmLineModel = ((TdmPortModel)iEntityModel).getTdmLineModel();
        }
        if (this.db.on()) {
            this.db.println("Checking lines for Dri connections:");
            this.db.println("E = " + this.hasDriConnections(tdmLineModel4));
            this.db.println("W = " + this.hasDriConnections(tdmLineModel3));
            this.db.println("EP= " + this.hasDriConnections(tdmLineModel2));
            this.db.println("WP= " + this.hasDriConnections(tdmLineModel));
        }
        return this.hasDriConnections(tdmLineModel4) || this.hasDriConnections(tdmLineModel3) || this.hasDriConnections(tdmLineModel2) || this.hasDriConnections(tdmLineModel);
    }

    private boolean hasDriConnections(TdmLineModel tdmLineModel) {
        boolean bl;
        block7: {
            bl = false;
            if (tdmLineModel != null) {
                try {
                    List list = tdmLineModel.getConnectionsList();
                    if (list == null) break block7;
                    for (int i = 0; i < list.size(); ++i) {
                        int n;
                        Object e = list.get(i);
                        if (!(e instanceof IHoConnectionModel) && !(e instanceof ILoConnectionModel)) continue;
                        IHoConnectionModel iHoConnectionModel = null;
                        ILoConnectionModel iLoConnectionModel = null;
                        if (e instanceof IHoConnectionModel) {
                            iHoConnectionModel = (IHoConnectionModel)e;
                        } else {
                            iLoConnectionModel = (ILoConnectionModel)e;
                        }
                        int n2 = n = iHoConnectionModel != null ? iHoConnectionModel.getDriNodeType() : iLoConnectionModel.getDriNodeType();
                        if (this.db.on()) {
                            this.db.println("determined driNodeType of " + n);
                        }
                        if (n == 0) continue;
                        bl = true;
                        break;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!this.db.on) break block7;
                    this.db.println("IllegalArgumentException caught checking for connections on TdmLineModel: " + tdmLineModel);
                    SDebug.printStackTrace((Throwable)illegalArgumentException);
                }
            }
        }
        return bl;
    }

    public boolean querySugRingMapChanged() {
        try {
            boolean bl = (Boolean)this.querySugRingMapChanged.get();
            if (this.db.on) {
                this.db.println("querySugRingMapChanged: returning " + bl);
            }
            return bl;
        }
        catch (CmsObjectNotExistException cmsObjectNotExistException) {
            if (this.db.on) {
                this.db.println("caught a CmsObjectNotExistException, OK");
            }
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return false;
    }

    public sBlsrProvision getProvision() {
        try {
            return (sBlsrProvision)this.provision.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IBlsrProvision getBlsrProvision() {
        sBlsrProvision sBlsrProvision2 = this.getProvision();
        if (null == sBlsrProvision2) {
            return null;
        }
        return BlsrProvisionFactory.getIBlsrProvision(sBlsrProvision2);
    }

    public IRevertiveBehavior getRingReversion() {
        return RevertiveBehaviorFactory.getIRevertiveBehavior(this.getProvision().ringReversion);
    }

    public void setRingReversion(IRevertiveBehavior iRevertiveBehavior) throws Busy {
        if (this.db.on()) {
            this.db.println("In setRingReversion");
        }
        try {
            this.ringReversion.set(RevertiveBehaviorFactory.getRevertiveBehavior(iRevertiveBehavior));
        }
        catch (xBusy xBusy2) {
            this.db.println("setRingReversion FAILED, as ring switch is active");
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)xBusy2));
            }
            throw new Busy("A ring or span switch is active.");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public IRevertiveBehavior getSpanReversion() {
        return RevertiveBehaviorFactory.getIRevertiveBehavior(this.getProvision().spanReversion);
    }

    public void setSpanReversion(IRevertiveBehavior iRevertiveBehavior) throws Busy {
        if (this.db.on()) {
            this.db.println("in setSpanReversion");
        }
        try {
            this.spanReversion.set(RevertiveBehaviorFactory.getRevertiveBehavior(iRevertiveBehavior));
        }
        catch (xBusy xBusy2) {
            this.db.println("setSpanReversion FAILED, as span switch is active");
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)xBusy2));
            }
            throw new Busy("A ring or span switch is active.");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public Integer getEastMainState() {
        try {
            return new Integer(((eBlsrChannelState)this.eastMainState.get()).value());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public Integer getEastProtState() {
        try {
            return new Integer(((eBlsrChannelState)this.eastProtState.get()).value());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public Integer getWestMainState() {
        try {
            return new Integer(((eBlsrChannelState)this.westMainState.get()).value());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public Integer getWestProtState() {
        try {
            return new Integer(((eBlsrChannelState)this.westProtState.get()).value());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public sBlsrProtectionOp getEastProtectionOp() {
        try {
            return (sBlsrProtectionOp)this.eastProtection.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IBlsrProtectionOp getBlsrEastProtectionOp() {
        return BlsrProtectionOpFactory.getIBlsrProtectionOp(this.getEastProtectionOp());
    }

    public sBlsrProtectionOp getWestProtectionOp() {
        try {
            return (sBlsrProtectionOp)this.westProtection.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public IBlsrProtectionOp getBlsrWestProtectionOp() {
        return BlsrProtectionOpFactory.getIBlsrProtectionOp(this.getWestProtectionOp());
    }

    public void setEastProtectionOp(sBlsrProtectionOp sBlsrProtectionOp2) throws InvalidProtectionOp, InternalCommError {
        try {
            this.eastProtection.set(sBlsrProtectionOp2);
        }
        catch (xInvalidProtectionOp xInvalidProtectionOp2) {
            if (this.db.on()) {
                this.db.println("Caught xInvalidProtectionOp:" + (Object)((Object)xInvalidProtectionOp2));
            }
            throw new InvalidProtectionOp((UserException)xInvalidProtectionOp2);
        }
        catch (xInternalCommError xInternalCommError2) {
            if (this.db.on()) {
                this.db.println("Caught xInternalCommError:" + (Object)((Object)xInternalCommError2));
            }
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setBlsrEastProtectionOp(IBlsrProtectionOp iBlsrProtectionOp) throws InvalidProtectionOp, InternalCommError {
        this.setEastProtectionOp(BlsrProtectionOpFactory.getBlsrProtectionOp(iBlsrProtectionOp));
    }

    public void setWestProtectionOp(sBlsrProtectionOp sBlsrProtectionOp2) throws InvalidProtectionOp, InternalCommError {
        try {
            this.westProtection.set(sBlsrProtectionOp2);
        }
        catch (xInvalidProtectionOp xInvalidProtectionOp2) {
            if (this.db.on()) {
                this.db.println("Caught xInvalidProtectionOp:" + (Object)((Object)xInvalidProtectionOp2));
            }
            throw new InvalidProtectionOp((UserException)xInvalidProtectionOp2);
        }
        catch (xInternalCommError xInternalCommError2) {
            if (this.db.on()) {
                this.db.println("Caught xInternalCommError:" + (Object)((Object)xInternalCommError2));
            }
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setBlsrWestProtectionOp(IBlsrProtectionOp iBlsrProtectionOp) throws InvalidProtectionOp, InternalCommError {
        this.setWestProtectionOp(BlsrProtectionOpFactory.getBlsrProtectionOp(iBlsrProtectionOp));
    }

    private Integer getEastMainPoolIndex() {
        try {
            return (Integer)this.eastMainPool.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    @Override
    protected boolean containsPool(PoolModel poolModel) {
        return poolModel.getObjIndex() == this.getEastMainPoolIndex().intValue() || poolModel.getObjIndex() == this.getEastProtectPoolIndex().intValue() || poolModel.getObjIndex() == this.getWestMainPoolIndex().intValue() || poolModel.getObjIndex() == this.getWestProtectPoolIndex().intValue();
    }

    public IPoolModel getEastMainPoolModel() {
        return this.getPoolModels().find(this.getEastMainPoolIndex());
    }

    public IPoolModel getWestMainPoolModel() {
        return this.getPoolModels().find(this.getWestMainPoolIndex());
    }

    public IPoolModel getWestProtectPoolModel() {
        return this.getPoolModels().find(this.getWestProtectPoolIndex());
    }

    public IPoolModel getEastProtectPoolModel() {
        return this.getPoolModels().find(this.getEastProtectPoolIndex());
    }

    @Override
    public IPoolModel getPoolModel(int n) {
        if (this.getWestMainPoolModel().getEntityIndex() == n) {
            return this.getWestMainPoolModel();
        }
        if (this.getEastMainPoolModel().getEntityIndex() == n) {
            return this.getEastMainPoolModel();
        }
        if (this.getEastProtectPoolModel().getEntityIndex() == n) {
            return this.getEastProtectPoolModel();
        }
        if (this.getWestProtectPoolModel().getEntityIndex() == n) {
            return this.getWestProtectPoolModel();
        }
        return null;
    }

    private Integer getWestMainPoolIndex() {
        try {
            return (Integer)this.westMainPool.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    private Integer getEastProtectPoolIndex() {
        try {
            return (Integer)this.eastProtectPool.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    private Integer getWestProtectPoolIndex() {
        try {
            return (Integer)this.westProtectPool.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public int getEastEntityIndex() {
        return this.getProvision().eastPort;
    }

    public int getWestEntityIndex() {
        return this.getProvision().westPort;
    }

    public int getEastProtectEntityIndex() {
        return this.getTypeEnum() == eElementType.BLSR_4_WIRE ? this.getProvision().eastProtectPort : this.getEastEntityIndex();
    }

    public int getWestProtectEntityIndex() {
        return this.getTypeEnum() == eElementType.BLSR_4_WIRE ? this.getProvision().westProtectPort : this.getWestEntityIndex();
    }

    public IEntityModel getEastEntityModel() throws AbstractCmsNoSuchEntityException {
        return this.getNodeModel().getEntityTable().getEntityModelByIndex(this.getEastEntityIndex());
    }

    public IEntityModel getWestEntityModel() throws AbstractCmsNoSuchEntityException {
        return this.getNodeModel().getEntityTable().getEntityModelByIndex(this.getWestEntityIndex());
    }

    public IEntityModel getEastProtectEntityModel() throws AbstractCmsNoSuchEntityException {
        int n = this.getEastProtectEntityIndex();
        return n != 0 ? this.getNodeModel().getEntityTable().getEntityModelByIndex(this.getEastProtectEntityIndex()) : null;
    }

    public IEntityModel getWestProtectEntityModel() throws AbstractCmsNoSuchEntityException {
        int n = this.getWestProtectEntityIndex();
        return n != 0 ? this.getNodeModel().getEntityTable().getEntityModelByIndex(this.getWestProtectEntityIndex()) : null;
    }

    @Override
    public INodeModel getNodeModel() {
        return super.getNodeModel();
    }

    protected EntityModel getEntityModelForPool(PoolModel poolModel) throws AbstractCmsNoSuchEntityException {
        if (!this.containsPool(poolModel)) {
            return null;
        }
        if (poolModel.getObjIndex() == this.getEastMainPoolIndex().intValue()) {
            return (EntityModel)this.getEastEntityModel();
        }
        if (poolModel.getObjIndex() == this.getEastProtectPoolIndex().intValue()) {
            return (EntityModel)this.getEastProtectEntityModel();
        }
        if (poolModel.getObjIndex() == this.getWestMainPoolIndex().intValue()) {
            return (EntityModel)this.getWestEntityModel();
        }
        if (poolModel.getObjIndex() == this.getWestProtectPoolIndex().intValue()) {
            return (EntityModel)this.getWestProtectEntityModel();
        }
        return null;
    }

    public sRingMapEntry[] getRingMap() {
        if (this.db.on) {
            this.db.println(this.node.dbName() + "About to get ringMap");
        }
        try {
            return (sRingMapEntry[])this.ringMap.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public sRingMapEntry[] getSuggestedRingMap() {
        if (this.db.on) {
            this.db.println(this.node.dbName() + "About to get suggestedRingMap");
        }
        try {
            return (sRingMapEntry[])this.suggestedRingMap.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public sSquelchTblEntry[] getSquelchTbl() {
        try {
            return (sSquelchTblEntry[])this.squelchTbl.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public sRipTblEntry[] getRipTbl() {
        try {
            return (sRipTblEntry[])this.ripTbl.get();
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public ISquelchTblEntry[] getISquelchTbl() {
        return SquelchTblEntryFactory.getSquelchTblEntryArray(this.getSquelchTbl());
    }

    public IRipTblEntry[] getIRipTbl() {
        return RipTblEntryFactory.getRipTblEntryArray(this.getRipTbl());
    }

    public int getProtectEntityIndex(int n) {
        int n2 = -1;
        if (n == this.getEastEntityIndex()) {
            n2 = this.getEastProtectEntityIndex();
        } else if (n == this.getWestEntityIndex()) {
            n2 = this.getWestProtectEntityIndex();
        } else if (n == this.getEastProtectEntityIndex() || n == this.getWestProtectEntityIndex()) {
            n2 = n;
        }
        if (this.db.on()) {
            this.db.println("getProtectEntityIndex for " + Integer.toHexString(n) + " returning " + Integer.toHexString(n2));
        }
        return n2;
    }

    @Override
    public int getProtectEntityIndex() throws AbstractCmsIOException {
        int n = -1;
        if (this.getWestProtState() == 0) {
            n = this.getWestProtectEntityIndex();
        } else if (this.getEastProtState() == 0) {
            n = this.getEastProtectEntityIndex();
        }
        if (this.db.on()) {
            this.db.println("getProtectEntityIndex returning " + Integer.toHexString(n));
        }
        return n;
    }

    @Override
    public int getMainEntityIndex() throws AbstractCmsIOException {
        int n = -1;
        if (this.getWestMainState() == 0) {
            n = this.getWestEntityIndex();
        } else if (this.getWestProtState() == 0) {
            n = this.getWestProtectEntityIndex();
        } else if (this.getEastMainState() == 0) {
            n = this.getEastEntityIndex();
        } else if (this.getEastProtState() == 0) {
            n = this.getEastProtectEntityIndex();
        }
        if (this.db.on()) {
            this.db.println("getMainEntityIndex returning " + Integer.toHexString(n));
        }
        return n;
    }

    public boolean isClear(int n) {
        if (n == this.getEastEntityIndex() || n == this.getEastProtectEntityIndex()) {
            return this.getEastProtectionOp().kOp == eBlsrProtectionOp.BLSR_CMD_CLEAR || this.getEastProtectionOp().kOp == eBlsrProtectionOp.BLSR_CMD_APS_CLEAR;
        }
        if (n == this.getWestEntityIndex() || n == this.getWestProtectEntityIndex()) {
            return this.getWestProtectionOp().kOp == eBlsrProtectionOp.BLSR_CMD_CLEAR || this.getWestProtectionOp().kOp == eBlsrProtectionOp.BLSR_CMD_APS_CLEAR;
        }
        this.db.warning("Unknown entity");
        return false;
    }

    public void setForceSpan(int n) throws InvalidProtectionOp, InternalCommError {
        if (n == this.getEastEntityIndex() || n == this.getEastProtectEntityIndex()) {
            this.setEastProtectionOp(new sBlsrProtectionOp(eBlsrProtectionOp.BLSR_CMD_FORCE_SPAN, false, false, false));
        } else if (n == this.getWestEntityIndex() || n == this.getWestProtectEntityIndex()) {
            this.setWestProtectionOp(new sBlsrProtectionOp(eBlsrProtectionOp.BLSR_CMD_FORCE_SPAN, false, false, false));
        } else {
            this.db.severe("Cannot force span since no matching entity idx");
        }
    }

    public void setForceRing(int n) throws InvalidProtectionOp, InternalCommError {
        if (n == this.getEastEntityIndex() || n == this.getEastProtectEntityIndex()) {
            this.setEastProtectionOp(new sBlsrProtectionOp(eBlsrProtectionOp.BLSR_CMD_FORCE_RING, false, false, false));
        } else if (n == this.getWestEntityIndex() || n == this.getWestProtectEntityIndex()) {
            this.setWestProtectionOp(new sBlsrProtectionOp(eBlsrProtectionOp.BLSR_CMD_FORCE_RING, false, false, false));
        } else {
            this.db.severe("Cannot force span since no matching entity idx");
        }
    }

    public void setClear(int n) throws InvalidProtectionOp, InternalCommError {
        if (n == this.getEastEntityIndex() || n == this.getEastProtectEntityIndex()) {
            this.setEastProtectionOp(new sBlsrProtectionOp(eBlsrProtectionOp.BLSR_CMD_CLEAR, false, false, false));
        } else if (n == this.getWestEntityIndex() || n == this.getWestProtectEntityIndex()) {
            this.setWestProtectionOp(new sBlsrProtectionOp(eBlsrProtectionOp.BLSR_CMD_CLEAR, false, false, false));
        } else {
            this.db.severe("Cannot force clear since no matching entity idx");
        }
    }

    public void setRingReversion(sRevertiveBehavior sRevertiveBehavior2) throws Busy {
        if (this.db.on()) {
            this.db.println("In setRingReversion");
        }
        try {
            this.ringReversion.set(sRevertiveBehavior2);
        }
        catch (xBusy xBusy2) {
            this.db.println("setRingReversion FAILED, as ring switch is active");
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)xBusy2));
            }
            throw new Busy("A ring or span switch is active.");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setSpanReversion(sRevertiveBehavior sRevertiveBehavior2) throws Busy {
        if (this.db.on()) {
            this.db.println("in setSpanReversion");
        }
        try {
            this.spanReversion.set(sRevertiveBehavior2);
        }
        catch (xBusy xBusy2) {
            this.db.println("setSpanReversion FAILED, as span switch is active");
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)xBusy2));
            }
            throw new Busy("A ring or span switch is active.");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setNodeId(short s) throws DuplicateNodeId, BlsrSpanSwitched {
        try {
            this.nodeId.set(new Short(s));
        }
        catch (xDuplicateNodeId xDuplicateNodeId2) {
            String string = xDuplicateNodeId2.getMessage();
            string = string + "\nBlsrModel setNodeId(); id " + s + " already in use.";
            if (this.db.on()) {
                this.db.println(this.node.dbName() + string);
            }
            throw new DuplicateNodeId((UserException)xDuplicateNodeId2);
        }
        catch (xBlsrSpanSwitched xBlsrSpanSwitched2) {
            throw new BlsrSpanSwitched((UserException)xBlsrSpanSwitched2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            throw this.doUnknown("setNodeId", userException);
        }
    }

    public void setExtendedRing(boolean bl) {
        try {
            this.extendedRing.set(new Boolean(bl));
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void setRingId(short s) throws UnsupportedOperation {
        throw new UnsupportedOperation("setRingId(short id) is no longer valid.  Use setRingName(String name).");
    }

    public void setRingName(String string) throws DuplicateRingId, BlsrSpanSwitched {
        try {
            this.ringName.set(string);
        }
        catch (xDuplicateRingId xDuplicateRingId2) {
            throw new DuplicateRingId((UserException)xDuplicateRingId2);
        }
        catch (xBlsrSpanSwitched xBlsrSpanSwitched2) {
            throw new BlsrSpanSwitched((UserException)xBlsrSpanSwitched2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            throw this.doUnknown("setRingName", userException);
        }
    }

    protected UNKNOWN doUnknown(String string, UserException userException) {
        this.db.println("Caught unexpected exception in " + string);
        return new UNKNOWN("Caught unexpected exception in " + string + " : " + (Object)((Object)userException));
    }

    public void delete() throws Busy, CmsNodeUpgradingException {
        block7: {
            if (this.db.on) {
                this.db.println(this.node.dbName() + "delete(): entry");
            }
            try {
                this.delete.set();
            }
            catch (xBusy xBusy2) {
                String string = xBusy2.getMessage();
                string = string + "\nBlsrModel.delete();  The Topology Element is in use,\nand can't be deleted as requested (#" + Integer.toHexString(this.getIndex()) + ").";
                if (this.db.on()) {
                    this.db.println(this.node.dbName() + string);
                }
                throw new Busy((UserException)xBusy2);
            }
            catch (UserException userException) {
                SDebug.printStackTrace((Throwable)userException);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                if (!(exception instanceof CmsNodeUpgradingException)) break block7;
                this.db.println("CmsNodeUpgradingException caught in delete(): " + exception);
                throw (CmsNodeUpgradingException)exception;
            }
        }
        if (this.db.on) {
            this.db.println(this.node.dbName() + "delete(): exit");
        }
    }

    public void upgrade2FiberTo4Fiber(int n, int n2, sRevertiveBehavior sRevertiveBehavior2) throws Busy, ProvisionError {
        if (this.db.on) {
            this.db.println(this.node.dbName() + "upgrade2FiberTo4Fiber():entry");
        }
        try {
            Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), sRevertiveBehavior2};
            this.upgrade2FiberTo4Fiber.set(objectArray);
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            NodeModelDelegate.doUnknown(this.db, "upgrade2FiberTo4Fiber", userException);
        }
    }

    public void upgrade2FiberTo4Fiber(int n, int n2, IRevertiveBehavior iRevertiveBehavior) throws Busy, ProvisionError {
        this.upgrade2FiberTo4Fiber(n, n2, RevertiveBehaviorFactory.getRevertiveBehavior(iRevertiveBehavior));
    }

    public IPathInfo[] getWestProtectHoPaths() {
        sPathInfo[] sPathInfoArray;
        IPathInfo[] iPathInfoArray = null;
        if (this.db.on()) {
            try {
                sPathInfoArray = this.getWestProtectEntityModel();
                if (sPathInfoArray instanceof TdmPortModel) {
                    TdmPortModel tdmPortModel = (TdmPortModel)sPathInfoArray;
                    this.db.println("W Ent Model(P): " + tdmPortModel);
                    this.db.println("LM = " + tdmPortModel.getTdmLineModel());
                } else {
                    this.db.println("west protect entity not a TdmPortModel; it's: " + sPathInfoArray);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.println("Error getting west protect entity model");
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        try {
            sPathInfoArray = (sPathInfo[])this.westProtectStsPaths.get();
            if (this.db.on()) {
                for (int i = 0; i < sPathInfoArray.length; ++i) {
                    sPathInfo sPathInfo2 = sPathInfoArray[i];
                    short s = sPathInfo2.startingSts;
                    short s2 = sPathInfo2.pathWidth;
                    this.db.println(i + "West\t" + s + "\t" + s2);
                }
            }
            iPathInfoArray = PathInfoFactory.getIPathInfoArray(sPathInfoArray, this.getNodeModel());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return iPathInfoArray;
    }

    public IPathInfo[] getEastProtectHoPaths() {
        sPathInfo[] sPathInfoArray;
        IPathInfo[] iPathInfoArray = null;
        if (this.db.on()) {
            try {
                sPathInfoArray = this.getEastProtectEntityModel();
                if (sPathInfoArray instanceof TdmPortModel) {
                    TdmPortModel tdmPortModel = (TdmPortModel)sPathInfoArray;
                    this.db.println("E Ent Model(P): " + tdmPortModel);
                    this.db.println("LM = " + tdmPortModel.getTdmLineModel());
                } else {
                    this.db.println("east protect entity not a TdmPortModel; it's: " + sPathInfoArray);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.db.println("Error getting east protect entity model");
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        try {
            sPathInfoArray = (sPathInfo[])this.eastProtectStsPaths.get();
            if (this.db.on()) {
                for (int i = 0; i < sPathInfoArray.length; ++i) {
                    sPathInfo sPathInfo2 = sPathInfoArray[i];
                    short s = sPathInfo2.startingSts;
                    short s2 = sPathInfo2.pathWidth;
                    this.db.println(i + "East\t" + s + "\t" + s2);
                }
            }
            iPathInfoArray = PathInfoFactory.getIPathInfoArray(sPathInfoArray, this.getNodeModel());
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
        return iPathInfoArray;
    }

    @Override
    protected void updateLocal() {
        if (this.db.on) {
            this.db.println(this.node.dbName() + "updateLocal(): entry");
        }
        this.myString = null;
        this.provision.update();
        this.eastProtection.update();
        this.westProtection.update();
        this.eastMainPool.update();
        this.westMainPool.update();
        this.eastMainState.update();
        this.eastProtState.update();
        this.westMainState.update();
        this.westProtState.update();
        this.eastProtectPool.update();
        this.westProtectPool.update();
        this.setChanged();
        super.updateLocal();
    }

    @Override
    public void dispose() {
        if (this.db.on) {
            this.db.println(this.node.dbName() + "dispose(): entry");
        }
        this.provision.dispose();
        this.eastProtection.dispose();
        this.westProtection.dispose();
        this.eastMainPool.dispose();
        this.westMainPool.dispose();
        this.eastProtectPool.dispose();
        this.westProtectPool.dispose();
        this.eastMainState.dispose();
        this.eastProtState.dispose();
        this.westMainState.dispose();
        this.westProtState.dispose();
        this.myString = null;
        super.dispose();
        if (this.db.on) {
            this.db.println(this.node.dbName() + "dispose(): exit");
        }
    }

    @Override
    public String toString() {
        if (this.myString == null) {
            try {
                this.myString = "Blsr:" + Integer.toHexString(this.getIndex()) + "[" + this.node.dbName() + this.getName() + "/e" + Integer.toHexString(this.getEastEntityIndex()) + "+w" + Integer.toHexString(this.getWestEntityIndex()) + (this.getTypeEnum() == eElementType.BLSR_4_WIRE ? "+ep" + Integer.toHexString(this.getEastProtectEntityIndex()) + "+wp" + Integer.toHexString(this.getWestProtectEntityIndex()) : "") + "/" + EnumStrings.getStrings(eElementType.class)[this.getType()] + "]";
            }
            catch (Exception exception) {
                return "Blsr[deleted/inaccessible]";
            }
        }
        return this.myString;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof BlsrModel)) {
            return false;
        }
        return super.equals(object);
    }

    public static sBlsrProtectionOp convertProtectionOp(eProtectionOp eProtectionOp2) {
        sBlsrProtectionOp sBlsrProtectionOp2 = new sBlsrProtectionOp();
        switch (eProtectionOp2.value()) {
            case 0: {
                sBlsrProtectionOp2.kOp = eBlsrProtectionOp.BLSR_CMD_CLEAR;
                break;
            }
            case 1: 
            case 2: {
                sBlsrProtectionOp2.kOp = eBlsrProtectionOp.BLSR_CMD_LOCK_SPAN;
                break;
            }
            case 3: 
            case 4: {
                sBlsrProtectionOp2.kOp = eBlsrProtectionOp.BLSR_CMD_FORCE_RING;
                break;
            }
            case 5: 
            case 6: {
                sBlsrProtectionOp2.kOp = eBlsrProtectionOp.BLSR_CMD_MANUAL_RING;
                break;
            }
            case 7: {
                sBlsrProtectionOp2.kOp = eBlsrProtectionOp.BLSR_CMD_EXERCISE_RING;
                break;
            }
            default: {
                sBlsrProtectionOp2.kOp = eBlsrProtectionOp.BLSR_CMD_CLEAR;
            }
        }
        sBlsrProtectionOp2.lowRingOp = false;
        sBlsrProtectionOp2.lowSpanOp = false;
        sBlsrProtectionOp2.lopAllSpansOp = false;
        return sBlsrProtectionOp2;
    }

    public static eProtectionOp convertProtectionOpTo_2_1(sBlsrProtectionOp sBlsrProtectionOp2) {
        switch (sBlsrProtectionOp2.kOp.value()) {
            case 0: {
                return eProtectionOp.CLEAR;
            }
            case 1: {
                return eProtectionOp.LOCKOUT_OF_PROTECTION;
            }
            case 3: {
                return eProtectionOp.FORCE_SWITCH_TO_WORKING;
            }
            case 5: {
                return eProtectionOp.MANUAL_SWITCH_TO_WORKING;
            }
            case 7: {
                return eProtectionOp.EXERCISE;
            }
        }
        return eProtectionOp.CLEAR;
    }

    class Delete
    extends NonCachedValue {
        public Delete(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected void setValue() throws UserException {
            BlsrModel.this.getBlsrRef().destroy();
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class EastMainPool
    extends CachedValue {
        public EastMainPool(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }

        @Override
        protected Object getValue() throws UserException {
            Pool pool = BlsrModel.this.getBlsrRef().eastWorkingPool();
            try {
                return BlsrModel.this.getPoolModels().getObjIndexFromPool(pool);
            }
            catch (NoSuchPoolException noSuchPoolException) {
                if (BlsrModel.this.db.on()) {
                    BlsrModel.this.db.println("Couldn't find EastMainPool in cache. Getting it from the Node");
                }
                return new Integer(pool.objIndex());
            }
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class EastMainState
    extends CachedValue {
        public EastMainState(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }

        @Override
        protected Object getValue() throws UserException {
            return BlsrModel.this.getBlsrRef().eastMainState();
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class EastMainType
    extends UserValue {
        public EastMainType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        public Object get() throws CTCUserException {
            if (BlsrModel.this.db.on()) {
                BlsrModel.this.db.println(this.getClass().getName() + " Inside get()");
            }
            try {
                return BlsrModel.this.getEastEntityModel().getEqTypeName();
            }
            catch (Exception exception) {
                throw new CTCUserException("The east main entity type cannot be retrieved.\n" + exception.getMessage());
            }
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class EastProtState
    extends CachedValue {
        public EastProtState(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }

        @Override
        protected Object getValue() throws UserException {
            return BlsrModel.this.getBlsrRef().eastProtState();
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class EastProtectPool
    extends CachedValue {
        public EastProtectPool(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }

        @Override
        protected Object getValue() throws UserException {
            Pool pool = BlsrModel.this.getBlsrRef().eastProtectPool();
            try {
                return BlsrModel.this.getPoolModels().getObjIndexFromPool(pool);
            }
            catch (NoSuchPoolException noSuchPoolException) {
                if (BlsrModel.this.db.on()) {
                    BlsrModel.this.db.println("Couldn't find EastProtectPool in cache. Getting it from the Node");
                }
                return new Integer(pool.objIndex());
            }
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class EastProtectStsPaths
    extends NonCachedValue {
        public EastProtectStsPaths(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return BlsrModel.this.getBlsrRef().getEastProtectStsPaths();
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class EastProtectType
    extends UserValue {
        public EastProtectType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        public Object get() throws CTCUserException {
            if (BlsrModel.this.db.on()) {
                BlsrModel.this.db.println(this.getClass().getName() + " Inside get()");
            }
            try {
                return BlsrModel.this.getTypeEnum() == eElementType.BLSR_4_WIRE ? BlsrModel.this.getEastProtectEntityModel().getEqTypeName() : null;
            }
            catch (Exception exception) {
                throw new CTCUserException("The east protect entity type cannot be retrieved.\n " + exception.getMessage());
            }
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class EastProtection
    extends CachedValue {
        public EastProtection(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws UserException, xInvalidProtectionOp, xInternalCommError {
            BlsrModel.this.getBlsrRef().setEastProtectionOp((sBlsrProtectionOp)object);
        }

        @Override
        protected Object getValue() throws UserException {
            return BlsrModel.this.getBlsrRef().eastProtectionOp();
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class ExtendedRing
    extends NonCachedValue {
        public ExtendedRing(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            BlsrModel.this.getBlsrRef().setExtendedRing((Boolean)object);
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class NeAcceptNewTables
    extends NonCachedValue {
        public NeAcceptNewTables(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected void setValue() throws UserException {
            BlsrModel.this.getBlsrRef().neAcceptNewTables();
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class NodeId
    extends NonCachedValue {
        public NodeId(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws UserException, xDuplicateNodeId {
            BlsrModel.this.getBlsrRef().setNodeId((Short)object);
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class Provision
    extends CachedValue {
        public Provision(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }

        @Override
        protected Object getValue() throws UserException {
            return BlsrModel.this.getBlsrRef().provision();
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class QuerySugRingMapChanged
    extends NonCachedValue {
        public QuerySugRingMapChanged(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return new Boolean(BlsrModel.this.getBlsrRef().querySugRingMapChanged());
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class RingMap
    extends NonCachedValue {
        public RingMap(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return BlsrModel.this.getBlsrRef().ringMap();
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class RingName
    extends NonCachedValue {
        public RingName(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws UserException, xDuplicateRingId {
            BlsrModel.this.getBlsrRef().setRingName((String)object);
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class RingReversion
    extends NonCachedValue {
        public RingReversion(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            BlsrModel.this.getBlsrRef().setRingReversion((sRevertiveBehavior)object);
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class RipTbl
    extends NonCachedValue {
        public RipTbl(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return BlsrModel.this.getBlsrRef().getRipTbl();
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class SpanReversion
    extends NonCachedValue {
        public SpanReversion(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            BlsrModel.this.getBlsrRef().setSpanReversion((sRevertiveBehavior)object);
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class SquelchTbl
    extends NonCachedValue {
        public SquelchTbl(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return BlsrModel.this.getBlsrRef().squelchTbl();
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class SuggestedRingMap
    extends NonCachedValue {
        public SuggestedRingMap(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return BlsrModel.this.getBlsrRef().suggestedRingMap();
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class Upgrade2FiberTo4Fiber
    extends NonCachedValue {
        public Upgrade2FiberTo4Fiber(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            BlsrModel.this.getBlsrRef().upgrade2FiberTo4Fiber((Integer)objectArray[0], (Integer)objectArray[1], (sRevertiveBehavior)objectArray[2]);
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class WestMainPool
    extends CachedValue {
        public WestMainPool(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }

        @Override
        protected Object getValue() throws UserException {
            Pool pool = BlsrModel.this.getBlsrRef().westWorkingPool();
            try {
                return BlsrModel.this.getPoolModels().getObjIndexFromPool(pool);
            }
            catch (NoSuchPoolException noSuchPoolException) {
                if (BlsrModel.this.db.on()) {
                    BlsrModel.this.db.println("Couldn't find WestMainPool in cache. Getting it from the Node");
                }
                return new Integer(pool.objIndex());
            }
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class WestMainState
    extends CachedValue {
        public WestMainState(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }

        @Override
        protected Object getValue() throws UserException {
            return BlsrModel.this.getBlsrRef().westMainState();
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class WestMainType
    extends UserValue {
        public WestMainType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        public Object get() throws CTCUserException {
            if (BlsrModel.this.db.on()) {
                BlsrModel.this.db.println(this.getClass().getName() + " Inside get()");
            }
            try {
                return BlsrModel.this.getWestEntityModel().getEqTypeName();
            }
            catch (Exception exception) {
                throw new CTCUserException("The west main entity type cannot be retrieved.\n" + exception.getMessage());
            }
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class WestProtState
    extends CachedValue {
        public WestProtState(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }

        @Override
        protected Object getValue() throws UserException {
            return BlsrModel.this.getBlsrRef().westProtState();
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class WestProtectPool
    extends CachedValue {
        public WestProtectPool(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws UserException {
        }

        @Override
        protected Object getValue() throws UserException {
            Pool pool = BlsrModel.this.getBlsrRef().westProtectPool();
            try {
                return BlsrModel.this.getPoolModels().getObjIndexFromPool(pool);
            }
            catch (NoSuchPoolException noSuchPoolException) {
                if (BlsrModel.this.db.on()) {
                    BlsrModel.this.db.println("Couldn't find WestProtectPool in cache. Getting it from the Node");
                }
                return new Integer(pool.objIndex());
            }
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class WestProtectStsPaths
    extends NonCachedValue {
        public WestProtectStsPaths(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        protected Object getValue() throws UserException {
            return BlsrModel.this.getBlsrRef().getWestProtectStsPaths();
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class WestProtectType
    extends UserValue {
        public WestProtectType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        @Override
        public Object get() throws CTCUserException {
            if (BlsrModel.this.db.on()) {
                BlsrModel.this.db.println(this.getClass().getName() + " Inside get()");
            }
            try {
                return BlsrModel.this.getTypeEnum() == eElementType.BLSR_4_WIRE ? BlsrModel.this.getWestProtectEntityModel().getEqTypeName() : null;
            }
            catch (Exception exception) {
                throw new CTCUserException("The west main entity type cannot be retrieved.\n" + exception.getMessage());
            }
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }

    class WestProtection
    extends CachedValue {
        public WestProtection(String string) {
            super(BlsrModel.this.node, string);
        }

        @Override
        protected void setValue(Object object) throws UserException, xInvalidProtectionOp, xInternalCommError {
            BlsrModel.this.getBlsrRef().setWestProtectionOp((sBlsrProtectionOp)object);
        }

        @Override
        protected Object getValue() throws UserException {
            return BlsrModel.this.getBlsrRef().westProtectionOp();
        }

        public Object outer() {
            return BlsrModel.this;
        }
    }
}

