/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.EtherL2Media.SvlanProfile;
import cerent.cms.idl.EtherL2Media.sSvlanProfile;
import cerent.cms.idl.EtherL2Media.sVlanProfileMapping;
import cerent.cms.idl.Event.eUpdateType;
import cerent.cms.idl.OnsError.eProvDataError;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.Vlan.eVlanType;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.DwdmPortModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.ErrorMsgFormatter;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IROSVlanProfile;
import cerent.cms.model.ISVlanProfile;
import cerent.cms.model.ISVlanProfileModel;
import cerent.cms.model.ISVlanProfileModels;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.PortModel;
import cerent.cms.model.SVlanProfile;
import cerent.cms.model.SVlanProfileMapping;
import cerent.cms.model.SVlanProfileModel;
import cerent.cms.model.SVlanProfileWithEnum;
import cerent.cms.model.XPL2Layer2LineModel;
import cerent.cms.model.XPL2LineModel;
import cerent.cms.model.XPL2ModuleModel;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.DetailedLog;
import cerent.util.EnumStrings;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeSet;

public class CVlanProfileModels
extends Model
implements ISVlanProfileModels {
    public static final String DETACH_PHRASE = "Detach Current";
    private static Integer[] INTEGER_ARRAY_TEMPLATE = new Integer[0];
    private static ISVlanProfileModel[] CVLAN_ARRAY_TEMPLATE = new ISVlanProfileModel[0];
    private static NodeSingletonFactory<CVlanProfileModels> sfactory = new NodeSingletonFactory<CVlanProfileModels>(CVlanProfileModels.class);
    private boolean isLazyInited;
    private NodeModelDelegate nmd;
    private SvlanProfile ref;
    private HashMap<Integer, ISVlanProfileModel> models;
    private HashMap<String, ISVlanProfileModel> modelsByName;
    private long nameSequenceNum;

    private static CTCUserException toUserException(xProvisionError xProvisionError2) {
        return ErrorMsgFormatter.getEquipmentProvisionError(xProvisionError2, null);
    }

    public static CVlanProfileModels getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private CVlanProfileModels(NodeModelDelegate nodeModelDelegate) {
        super(null);
        this.setDebug(nodeModelDelegate.getChildDebug(CVlanProfileModels.class, Debug.class, this));
        this.index = 0;
        this.nmd = nodeModelDelegate;
        this.models = new HashMap();
        this.modelsByName = new HashMap();
    }

    public ISVlanProfileModel getProfileByName(String string) {
        return this.modelsByName.get(string);
    }

    synchronized void rename(String string, String string2) {
        ISVlanProfileModel iSVlanProfileModel = this.modelsByName.remove(string);
        if (iSVlanProfileModel != null) {
            if (this.db.on()) {
                this.db.println("renaming model: " + iSVlanProfileModel + " to name: " + string2);
            }
            ++this.nameSequenceNum;
            this.modelsByName.put(string2, iSVlanProfileModel);
        }
    }

    synchronized void remove(int n) {
        ISVlanProfileModel iSVlanProfileModel;
        if (this.db.on()) {
            this.db.println("removing profile: " + n);
        }
        if ((iSVlanProfileModel = this.models.remove(n)) != null) {
            ++this.nameSequenceNum;
            this.modelsByName.remove(iSVlanProfileModel.getName());
        }
    }

    @Override
    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public void init() {
        super.init0();
        this.index = 0;
        this.ref = this.nmd.getIorRepository().getSvlanProfileRef();
    }

    private void unsubscribe() {
        EventDispatcher eventDispatcher = this.nmd.getDispatcher();
        if (eventDispatcher != null) {
            if (this.db.on()) {
                this.db.println("removing dispatcher observing for: CVlanProfileModels(" + this.getIndex() + ")");
            }
            eventDispatcher.deleteObserver(ObjectType.ObjectSvlanProfileDb, this.getIndex(), (Observer)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        CVlanProfileModels cVlanProfileModels = this;
        synchronized (cVlanProfileModels) {
            this.isLazyInited = false;
            this.unsubscribe();
        }
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpopulate() {
        CVlanProfileModels cVlanProfileModels = this;
        synchronized (cVlanProfileModels) {
            this.isLazyInited = false;
            this.models.clear();
            ++this.nameSequenceNum;
            this.modelsByName.clear();
        }
    }

    @Override
    public void destroy() {
        this.unpopulate();
        super.destroy();
        this.nmd = null;
    }

    public synchronized void getSVlanProfileModels(Collection<? super ISVlanProfileModel> collection) throws CTCUserException {
        if (collection == null) {
            return;
        }
        try {
            this.populate();
        }
        catch (xProvisionError xProvisionError2) {
            throw CVlanProfileModels.toUserException(xProvisionError2);
        }
        if (this.db.on()) {
            this.db.println("cvlan profile models currently loaded: " + this.models.size());
        }
        collection.addAll(this.models.values());
    }

    public synchronized ISVlanProfileModel[] getCVlanProfileModels() throws CTCUserException {
        try {
            this.populate();
        }
        catch (xProvisionError xProvisionError2) {
            throw CVlanProfileModels.toUserException(xProvisionError2);
        }
        if (this.db.on()) {
            this.db.println("cvlan profile models currently loaded: " + this.models.size());
        }
        ISVlanProfileModel[] iSVlanProfileModelArray = this.models.values().toArray(CVLAN_ARRAY_TEMPLATE);
        return iSVlanProfileModelArray;
    }

    public synchronized ISVlanProfileModel[] getSVlanProfileModelsByName() throws CTCUserException {
        try {
            this.populate();
        }
        catch (xProvisionError xProvisionError2) {
            throw CVlanProfileModels.toUserException(xProvisionError2);
        }
        ISVlanProfileModel[] iSVlanProfileModelArray = this.modelsByName.values().toArray(CVLAN_ARRAY_TEMPLATE);
        return iSVlanProfileModelArray;
    }

    private Collection<String> getSVlanProfileModelNames() throws CTCUserException {
        try {
            this.populate();
        }
        catch (xProvisionError xProvisionError2) {
            throw CVlanProfileModels.toUserException(xProvisionError2);
        }
        return this.modelsByName.keySet();
    }

    public synchronized ISVlanProfileModel getSVlanProfileModel(int n) {
        try {
            this.populate();
        }
        catch (xProvisionError xProvisionError2) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)((Object)xProvisionError2));
            }
            return null;
        }
        return this.models.get(n);
    }

    private sSvlanProfile[] getProfilesFromNE() throws xProvisionError {
        return this.ref.getAllProfiles();
    }

    private short[] getProfileIndiciesFromNE() throws xProvisionError {
        return this.ref.getAllProfilesUID();
    }

    private boolean populate() throws xProvisionError {
        if (this.isLazyInited) {
            return false;
        }
        if (this.db.on()) {
            this.db.println("re-populate starting");
        }
        this.models.clear();
        this.modelsByName.clear();
        EventDispatcher eventDispatcher = this.nmd.getDispatcher();
        if (eventDispatcher != null) {
            if (this.db.on()) {
                this.db.println("adding dispatcher observing for: " + this);
            }
            eventDispatcher.addObserver(ObjectType.ObjectSvlanProfileDb, this.getIndex(), (Observer)this);
        }
        sSvlanProfile[] sSvlanProfileArray = this.getProfilesFromNE();
        boolean bl = false;
        for (sSvlanProfile sSvlanProfile2 : sSvlanProfileArray) {
            SVlanProfileModel sVlanProfileModel;
            if (this.db.isFinerEnabled()) {
                this.db.finer("about to load profile: " + sSvlanProfile2.UniqueID);
            }
            try {
                sVlanProfileModel = new SVlanProfileModel(this.nmd, sSvlanProfile2, this.ref, this.nmd.getChildDebug(SVlanProfileModel.class));
            }
            catch (RuntimeException runtimeException) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)runtimeException);
                }
                throw runtimeException;
            }
            sVlanProfileModel.init();
            if (this.db.on()) {
                this.db.println("loading profile: " + sVlanProfileModel);
            }
            bl |= this.add(sVlanProfileModel);
        }
        this.isLazyInited = true;
        return true;
    }

    private boolean add(ISVlanProfileModel iSVlanProfileModel) {
        String string = iSVlanProfileModel.getName();
        int n = iSVlanProfileModel.getIndex();
        if (string.equals(SVlanProfileModel.DEFAULT_NAME) && n != 0) {
            if (this.db.on()) {
                this.db.println("Skipping attempt to create Default w/ non-zero index: " + n);
            }
            return false;
        }
        ISVlanProfileModel iSVlanProfileModel2 = this.models.put(iSVlanProfileModel.getIndex(), iSVlanProfileModel);
        ++this.nameSequenceNum;
        this.modelsByName.put(string, iSVlanProfileModel);
        boolean bl = iSVlanProfileModel2 == null || iSVlanProfileModel2 != iSVlanProfileModel;
        return bl;
    }

    public void apply(Collection<? extends IROSVlanProfile> collection, DetailedLog detailedLog) throws CTCUserException {
        if (this.db.on()) {
            this.db.println("apply called with: " + collection.size() + " profiles");
        }
        CTCUserException cTCUserException = null;
        for (IROSVlanProfile iROSVlanProfile : collection) {
            Throwable throwable;
            Throwable throwable2 = null;
            try {
                this.apply(iROSVlanProfile);
            }
            catch (RuntimeException runtimeException) {
                throwable2 = runtimeException;
            }
            catch (CTCUserException cTCUserException2) {
                throwable2 = cTCUserException2;
            }
            if (throwable2 == null) continue;
            if (cTCUserException == null) {
                if (throwable2 instanceof RuntimeException && (throwable = throwable2.getCause()) instanceof CTCUserException) {
                    cTCUserException = (CTCUserException)throwable;
                }
                if (throwable2 instanceof CTCUserException) {
                    cTCUserException = (CTCUserException)throwable2;
                }
            }
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)throwable2);
            }
            if (detailedLog == null) continue;
            throwable = new DetailedLog(3, "An error occurred while storing CVLAN profile: '" + iROSVlanProfile.getName() + "' to node: " + this.nmd.getName(), throwable2);
            detailedLog.addChild((DetailedLog)throwable);
            detailedLog.updateTime();
        }
        if (cTCUserException != null) {
            throw cTCUserException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(IROSVlanProfile iROSVlanProfile) throws CTCUserException {
        String string = null;
        String string2 = iROSVlanProfile.getName();
        if (iROSVlanProfile instanceof ISVlanProfile) {
            string = ((ISVlanProfile)iROSVlanProfile).getOrigName();
        }
        SVlanProfileModel sVlanProfileModel = null;
        SVlanProfileModel sVlanProfileModel2 = null;
        CVlanProfileModels cVlanProfileModels = this;
        synchronized (cVlanProfileModels) {
            try {
                this.populate();
            }
            catch (xProvisionError xProvisionError2) {
                throw CVlanProfileModels.toUserException(xProvisionError2);
            }
            sVlanProfileModel = (SVlanProfileModel)this.modelsByName.get(string2);
            if (this.db.on() && sVlanProfileModel != null) {
                this.db.println("model " + sVlanProfileModel.getIndex() + " found for profile by name: " + string2);
            }
            if (string != null) {
                sVlanProfileModel2 = (SVlanProfileModel)this.modelsByName.get(string);
            }
            if (this.db.on() && sVlanProfileModel2 != null) {
                this.db.println("old model " + sVlanProfileModel2.getIndex() + " found for profile by orig name: " + string);
            }
        }
        if (sVlanProfileModel == null && sVlanProfileModel2 != null) {
            sVlanProfileModel = sVlanProfileModel2;
        } else if (sVlanProfileModel != null && sVlanProfileModel2 != null && sVlanProfileModel2 != sVlanProfileModel) {
            sVlanProfileModel.delete();
            sVlanProfileModel = sVlanProfileModel2;
        }
        if (sVlanProfileModel == null) {
            if (this.db.on()) {
                this.db.println("creating new model for profile: " + iROSVlanProfile);
            }
            sVlanProfileModel = new SVlanProfileModel(this.nmd, iROSVlanProfile, this.ref, this.nmd.getChildDebug(SVlanProfileModel.class));
            sVlanProfileModel.apply();
            boolean bl = false;
            CVlanProfileModels cVlanProfileModels2 = this;
            synchronized (cVlanProfileModels2) {
                bl = this.add(sVlanProfileModel);
            }
            if (bl) {
                this.changed();
                this.notifyObservers(ModelUpdateType.ADDED);
            }
        } else {
            int n = sVlanProfileModel.getIndex();
            if (!SVlanProfileModel.canProfileBeModifiedOrDeleted(n)) {
                throw new CTCUserException("Warning: the Default profile cannot be edited");
            }
            if (this.db.on()) {
                this.db.println("modifying existing model " + n + " for profile: " + iROSVlanProfile);
            }
            sVlanProfileModel.set(iROSVlanProfile);
        }
    }

    public void apply(SVlanProfileWithEnum sVlanProfileWithEnum) throws CTCUserException {
        this.apply((IROSVlanProfile)sVlanProfileWithEnum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyNameChange(String string, String string2) throws CTCUserException {
        SVlanProfileModel sVlanProfileModel = null;
        Object object = this;
        synchronized (object) {
            sVlanProfileModel = (SVlanProfileModel)this.modelsByName.get(string);
        }
        if (sVlanProfileModel != null) {
            object = (SVlanProfile)sVlanProfileModel.clone();
            ((SVlanProfile)object).setName(string2);
            sVlanProfileModel.set((IROSVlanProfile)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Collection<? extends IROSVlanProfile> collection) throws CTCUserException {
        if (this.db.on()) {
            this.db.println("delete called with: " + collection.size() + " profiles");
        }
        for (IROSVlanProfile iROSVlanProfile : collection) {
            String string = null;
            if (iROSVlanProfile instanceof ISVlanProfile) {
                string = ((ISVlanProfile)iROSVlanProfile).getOrigName();
            }
            String string2 = iROSVlanProfile.getName();
            SVlanProfileModel sVlanProfileModel = null;
            CVlanProfileModels cVlanProfileModels = this;
            synchronized (cVlanProfileModels) {
                sVlanProfileModel = (SVlanProfileModel)this.modelsByName.get(string2);
                if (sVlanProfileModel == null && string != null) {
                    sVlanProfileModel = (SVlanProfileModel)this.modelsByName.get(string);
                }
            }
            if (sVlanProfileModel != null) {
                if (!SVlanProfileModel.canProfileBeModifiedOrDeleted(sVlanProfileModel.getIndex())) {
                    this.db.println("Cannot delete immutable model: " + sVlanProfileModel);
                    continue;
                }
                if (this.db.on()) {
                    this.db.println("deleting existing model for profile: " + iROSVlanProfile);
                }
                this.delete(sVlanProfileModel);
                continue;
            }
            if (!this.db.on()) continue;
            this.db.println("model not found for profile: " + iROSVlanProfile);
        }
    }

    public void delete(SVlanProfileModel sVlanProfileModel) throws CTCUserException {
        sVlanProfileModel.delete();
    }

    public String toString() {
        return "SVlanProfileModels(" + this.getIndex() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void xmlInit(NodeModelDelegate nodeModelDelegate, Class clazz, int n) throws xProvisionError {
        CVlanProfileModels cVlanProfileModels;
        CVlanProfileModels cVlanProfileModels2 = cVlanProfileModels = CVlanProfileModels.getInstance(nodeModelDelegate);
        synchronized (cVlanProfileModels2) {
            cVlanProfileModels.populate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void diff(int[] nArray) {
        SVlanProfileModel sVlanProfileModel;
        int n;
        Integer[] integerArray = this.models.keySet().toArray(INTEGER_ARRAY_TEMPLATE);
        int[] nArray2 = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            nArray2[i] = integerArray[i];
        }
        Arrays.sort(nArray);
        Arrays.sort(nArray2);
        int[] nArray3 = new int[nArray.length];
        int[] nArray4 = new int[nArray2.length];
        int n2 = this.diff(nArray, nArray2, nArray3);
        if (this.db.on()) {
            this.db.println("adds diffs - lhs: " + CVlanProfileModels.printInts(nArray) + " rhs: " + CVlanProfileModels.printInts(nArray2) + " results: " + CVlanProfileModels.printInts(nArray3, n2));
        }
        int n3 = this.diff(nArray2, nArray, nArray4);
        if (this.db.on()) {
            this.db.println("dels diffs - lhs: " + CVlanProfileModels.printInts(nArray2) + " rhs: " + CVlanProfileModels.printInts(nArray) + " results: " + CVlanProfileModels.printInts(nArray4, n3));
        }
        for (int i = 0; i < n3; ++i) {
            n = nArray4[i];
            SVlanProfileModel sVlanProfileModel2 = (SVlanProfileModel)this.models.get(n);
            if (sVlanProfileModel2 == null || !sVlanProfileModel2.isModifiable()) continue;
            sVlanProfileModel2.destroy();
        }
        SVlanProfileModel[] sVlanProfileModelArray = new SVlanProfileModel[n2];
        for (n = 0; n < n2; ++n) {
            int n4 = nArray3[n];
            sVlanProfileModel = new SVlanProfileModel(this.nmd, n4, this.ref, this.nmd.getChildDebug(SVlanProfileModel.class));
            sVlanProfileModel.init();
            if (this.db.on()) {
                this.db.println("inferring new profile: " + sVlanProfileModel);
            }
            sVlanProfileModelArray[n] = sVlanProfileModel;
        }
        CVlanProfileModels cVlanProfileModels = this;
        synchronized (cVlanProfileModels) {
            for (int i = 0; i < n2; ++i) {
                sVlanProfileModel = sVlanProfileModelArray[i];
                this.add(sVlanProfileModel);
            }
        }
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
    }

    public int getProfileMapping(PortModel portModel, short s) throws CTCUserException {
        short s2 = CVlanProfileModels.getPortId(portModel);
        IModuleModel iModuleModel = portModel.getModuleModel();
        return this.getProfileMapping(iModuleModel.getIndex(), s2, s);
    }

    public int getProfileMapping(int n, int n2, short s) throws CTCUserException {
        if (n == 0) {
            throw new IllegalArgumentException("card index must be non-zero");
        }
        if (n2 == 0) {
            throw new IllegalArgumentException("port id must be non-zero");
        }
        int n3 = 0;
        sSvlanProfile[] sSvlanProfileArray = null;
        try {
            sSvlanProfileArray = this.ref.getProfiles(n, (short)n2, s, eVlanType.CUSTOMER_TYPE);
            if (sSvlanProfileArray != null && sSvlanProfileArray.length > 0) {
                if (sSvlanProfileArray.length > 0) {
                    this.db.println("# of profiles mappings returned > 1 for (port/cvlan): " + n2 + "/" + s);
                }
                n3 = sSvlanProfileArray[0].UniqueID;
            }
        }
        catch (xProvisionError xProvisionError2) {
            throw CVlanProfileModels.toUserException(xProvisionError2);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Map<Integer, Map<Short, ISVlanProfileModel>> getProfileMappings(IModuleModel iModuleModel) throws CTCUserException {
        void var2_6;
        void var2_4;
        block6: {
            Object var2_2 = null;
            int n = iModuleModel.getIndex();
            try {
                sVlanProfileMapping[] sVlanProfileMappingArray = this;
                // MONITORENTER : this
                this.populate();
                HashMap<Integer, ISVlanProfileModel> hashMap = new HashMap<Integer, ISVlanProfileModel>(this.models);
                // MONITOREXIT : sVlanProfileMappingArray
                sVlanProfileMappingArray = this.ref.getProfileMapping(n, eVlanType.CUSTOMER_TYPE);
                if (this.db.on()) {
                    this.db.println("EtherL2Media::SvlanProfile::getProfileMapping(" + n + ") returned:");
                    for (int i = 0; i < sVlanProfileMappingArray.length; ++i) {
                        sVlanProfileMapping sVlanProfileMapping2 = sVlanProfileMappingArray[i];
                        this.db.println("  port: " + sVlanProfileMapping2.port + "; vlan: " + sVlanProfileMapping2.vlan + "; UniqueID: " + sVlanProfileMapping2.UniqueID);
                    }
                }
                HashMap<Integer, Map<Short, ISVlanProfileModel>> hashMap2 = super.getProfileMappings(hashMap, sVlanProfileMappingArray, (IEntityModel)iModuleModel);
            }
            catch (xProvisionError xProvisionError2) {
                CTCUserException cTCUserException = CVlanProfileModels.toUserException(xProvisionError2);
                int n2 = xProvisionError2.dataError.value();
                if (n2 == eProvDataError.FAILED_OR_MISSING.value()) break block6;
                if (!this.db.on()) throw cTCUserException;
                this.db.println("got CORBA error when calling: EtherL2Media::SvlanProfile::getProfileMapping(" + n + ") got dataError: " + n2);
                SDebug.printStackTrace((Throwable)cTCUserException);
                throw cTCUserException;
            }
        }
        if (var2_4 != null) return var2_6;
        HashMap hashMap = new HashMap();
        return var2_6;
    }

    private static short getPortId(IPortModel iPortModel) {
        int[] nArray = iPortModel.getPortNum();
        short s = (short)nArray[0];
        return s;
    }

    private HashMap<Integer, Map<Short, ISVlanProfileModel>> getProfileMappings(HashMap<Integer, ISVlanProfileModel> hashMap, sVlanProfileMapping[] sVlanProfileMappingArray, IEntityModel iEntityModel) {
        short s;
        Object object;
        Object object22;
        Object object3;
        HashMap<Short, IPortModel> hashMap2 = null;
        boolean bl = iEntityModel instanceof IModuleModel;
        if (bl) {
            object3 = ((EntityModel)iEntityModel).getDescendantsOfClassType(eClass.PORT.value());
            hashMap2 = new HashMap<Short, IPortModel>(object3.size());
            Iterator<Object> iterator = object3.iterator();
            while (iterator.hasNext()) {
                object22 = iterator.next();
                object = (IPortModel)object22;
                if (object instanceof DwdmPortModel) continue;
                s = CVlanProfileModels.getPortId((IPortModel)object);
                hashMap2.put(s, (IPortModel)object);
            }
            if (this.db.on()) {
                this.db.println("GE port # -> GE port mapping for card: " + iEntityModel);
                for (Object object22 : hashMap2.keySet()) {
                    this.db.println("portId: " + object22 + " -> " + hashMap2.get(object22));
                }
            }
        }
        object3 = new HashMap();
        if (this.db.on()) {
            this.db.println((bl ? "card" : "port") + " context for " + sVlanProfileMappingArray.length + " mappings");
        }
        for (int i = 0; i < sVlanProfileMappingArray.length; ++i) {
            IEntityModel iEntityModel2;
            object22 = sVlanProfileMappingArray[i];
            object = null;
            s = ((sVlanProfileMapping)object22).port;
            int n = -1;
            if (bl) {
                iEntityModel2 = (IEntityModel)hashMap2.get(s);
                if (iEntityModel2 == null) {
                    if (!this.db.on()) continue;
                    this.db.println("port model was null for index: " + s);
                    continue;
                }
                n = iEntityModel2.getIndex();
            } else {
                n = iEntityModel.getIndex();
            }
            object = (Map)((HashMap)object3).get(n);
            if (object == null) {
                object = new HashMap();
                ((HashMap)object3).put(n, object);
            }
            iEntityModel2 = null;
            short s2 = ((sVlanProfileMapping)object22).UniqueID;
            iEntityModel2 = hashMap.get(s2);
            if (iEntityModel2 != null) {
                object.put(((sVlanProfileMapping)object22).vlan, iEntityModel2);
                continue;
            }
            if (!this.db.isFinerEnabled()) continue;
            this.db.finer("warning: (possible race condition) could not lookup a the profile model for profile (id'ed in a mapping as):" + s2);
        }
        return object3;
    }

    public SVlanProfileMapping[] getProfileMappingAsRecords(XPL2ModuleModel xPL2ModuleModel) throws CTCUserException, AbstractCmsNoSuchEntityException {
        Map<Integer, Map<Short, ISVlanProfileModel>> map = this.getProfileMappings(xPL2ModuleModel);
        return this.getProfileMappingAsRecords(map);
    }

    private SVlanProfileMapping[] getProfileMappingAsRecords(Map<Integer, Map<Short, ISVlanProfileModel>> map) throws AbstractCmsNoSuchEntityException {
        int n = 0;
        for (Integer serializable2 : map.keySet()) {
            n += map.get(serializable2).size();
        }
        SVlanProfileMapping[] sVlanProfileMappingArray = new SVlanProfileMapping[n];
        EntityTableModel entityTableModel = this.nmd.getEntityTableModel();
        int n2 = 0;
        TreeSet<Integer> treeSet = new TreeSet<Integer>(map.keySet());
        for (Integer n3 : treeSet) {
            Map<Short, ISVlanProfileModel> map2 = map.get(n3);
            TreeSet<Short> treeSet2 = new TreeSet<Short>(map2.keySet());
            for (Short s : treeSet2) {
                sVlanProfileMappingArray[n2++] = new SVlanProfileMapping(entityTableModel.getEntityModelByIndex(n3), s.shortValue(), map2.get(s));
            }
        }
        return sVlanProfileMappingArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Map<Short, ISVlanProfileModel>> getProfileMappings(IPortModel iPortModel) throws CTCUserException {
        HashMap<Integer, Map<Short, ISVlanProfileModel>> hashMap = null;
        int n = iPortModel.getIndex();
        try {
            sVlanProfileMapping[] sVlanProfileMappingArray = this;
            synchronized (this) {
                this.populate();
                HashMap<Integer, ISVlanProfileModel> hashMap2 = new HashMap<Integer, ISVlanProfileModel>(this.models);
                // ** MonitorExit[var5_4] (shouldn't be in output)
                sVlanProfileMappingArray = this.ref.getProfileMappingOnPort(n, eVlanType.CUSTOMER_TYPE);
                if (this.db.on()) {
                    this.db.println("called EtherL2Media::SvlanProfile::getProfileMappingOnPort(" + n + ")" + " - it returned: " + sVlanProfileMappingArray.length + " mappings");
                }
                hashMap = super.getProfileMappings(hashMap2, sVlanProfileMappingArray, (IEntityModel)iPortModel);
            }
        }
        catch (xProvisionError xProvisionError2) {
            if (this.db.on()) {
                this.db.println("got CORBA error when calling: EtherL2Media::SvlanProfile::getProfileMappingOnPort(" + n + ")");
                SDebug.printStackTrace((Throwable)((Object)xProvisionError2));
            }
            throw CVlanProfileModels.toUserException(xProvisionError2);
        }
        return hashMap;
    }

    public SVlanProfileMapping[] getProfileMappingAsRecords(IPortModel iPortModel) throws CTCUserException, AbstractCmsNoSuchEntityException {
        Map<Integer, Map<Short, ISVlanProfileModel>> map = this.getProfileMappings(iPortModel);
        return this.getProfileMappingAsRecords(map);
    }

    public boolean applyProfileMapping(int n, short s, int n2) throws CTCUserException {
        boolean bl;
        if (n2 == 0) {
            bl = false;
            if (this.db.on()) {
                this.db.println("calling: EtherL2Media::SvlanProfile::detachProfile(" + n + ", " + s + ")");
            }
            this.ref.detachProfile(n, s, eVlanType.CUSTOMER_TYPE);
        } else {
            bl = true;
            try {
                if (this.db.on()) {
                    this.db.println("calling: EtherL2Media::SvlanProfile::attachProfileByID(" + n2 + ", " + n + ", " + s + ")");
                }
                this.ref.attachProfileByID((short)n2, n, s, eVlanType.CUSTOMER_TYPE);
            }
            catch (xProvisionError xProvisionError2) {
                if (this.db.on()) {
                    int n3 = xProvisionError2.dataError.value();
                    this.db.println("got CORBA error when calling: EtherL2Media::SvlanProfile::attachProfileByID(" + n2 + ", " + n + ", " + s + ")" + " prov error code was: " + n3);
                    SDebug.printStackTrace((Throwable)((Object)xProvisionError2));
                }
                throw CVlanProfileModels.toUserException(xProvisionError2);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyProfileMapping(XPL2LineModel xPL2LineModel, short s, String string) throws CTCUserException {
        ISVlanProfileModel iSVlanProfileModel = null;
        XPL2Layer2LineModel xPL2Layer2LineModel = xPL2LineModel.getLayer2LineModel();
        if (xPL2Layer2LineModel == null) {
            throw new CTCUserException("No XPL2 layer model found for line: " + xPL2LineModel);
        }
        if (string.equals(DETACH_PHRASE) || string.equals(SVlanProfileModel.DEFAULT_NAME)) {
            return this.applyProfileMapping(xPL2Layer2LineModel.getIndex(), s, 0);
        }
        CVlanProfileModels cVlanProfileModels = this;
        synchronized (cVlanProfileModels) {
            iSVlanProfileModel = this.modelsByName.get(string);
        }
        return this.applyProfileMapping(xPL2Layer2LineModel.getIndex(), s, iSVlanProfileModel.getIndex());
    }

    public long getNameSequenceNum() {
        return this.nameSequenceNum;
    }

    public void addAllObservers(Observer observer) throws CTCUserException {
        ISVlanProfileModel[] iSVlanProfileModelArray;
        this.addObserver(observer);
        for (ISVlanProfileModel iSVlanProfileModel : iSVlanProfileModelArray = this.getCVlanProfileModels()) {
            iSVlanProfileModel.addObserver(observer);
        }
    }

    public void deleteAllObservers(Observer observer) throws CTCUserException {
        ISVlanProfileModel[] iSVlanProfileModelArray;
        this.deleteObserver(observer);
        for (ISVlanProfileModel iSVlanProfileModel : iSVlanProfileModelArray = this.getCVlanProfileModels()) {
            iSVlanProfileModel.deleteObserver(observer);
        }
    }

    private int diff(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int n2 = nArray.length;
        int n3 = nArray2.length;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n4 < n2 && n5 < n3) {
            n = nArray[n4];
            int n7 = nArray2[n5];
            if (n < n7) {
                ++n4;
                nArray3[n6++] = n;
                continue;
            }
            if (n > n7) {
                ++n5;
                continue;
            }
            ++n4;
            ++n5;
        }
        while (n4 < n2) {
            n = nArray[n4];
            nArray3[n6++] = n;
            ++n4;
        }
        return n6;
    }

    private static String printInts(int[] nArray) {
        return CVlanProfileModels.printInts(nArray, 0);
    }

    private static String printInts(int[] nArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n > 0 ? n : (nArray == null ? 0 : nArray.length);
        for (int i = 0; i < n2; ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(Integer.toString(nArray[i]));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAdded() {
        int[] nArray = null;
        Object var2_2 = null;
        try {
            short[] sArray = this.getProfileIndiciesFromNE();
            nArray = new int[sArray.length];
            int n = 0;
            for (int n2 : sArray) {
                nArray[n++] = n2;
            }
        }
        catch (xProvisionError xProvisionError2) {
            SDebug.printStackTrace((Throwable)((Object)xProvisionError2));
            CVlanProfileModels cVlanProfileModels = this;
            synchronized (cVlanProfileModels) {
                this.isLazyInited = false;
                this.unsubscribe();
            }
            this.setChanged();
            this.notifyObservers(ModelUpdateType.ADDED);
            return;
        }
        this.diff(nArray);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            CmsObservable cmsObservable = (CmsObservable)((Object)observable);
            ObjectMessageInfo objectMessageInfo = (ObjectMessageInfo)object;
            int n = objectMessageInfo.getUpdateType();
            if (this.db.on()) {
                this.db.println("update(): this=" + this + ", From=" + observable + ", arg=" + EnumStrings.getStrings(eUpdateType.class)[n]);
            }
            switch (n) {
                case 2: {
                    if (this.db.isFineEnabled()) {
                        this.db.fine("update(): " + this + " ADDED");
                    }
                    this.handleAdded();
                    break;
                }
                default: {
                    this.db.warning("update(): unhandled UpdateType: " + n);
                }
            }
        }
    }

    public class Debug
    extends SDebug {
        public Debug(KDebug kDebug, String string) {
            super(kDebug, string);
        }

        public final void dump() throws Exception {
            Object[] objectArray = CVlanProfileModels.this.getCVlanProfileModels();
            Arrays.sort(objectArray);
            for (Object object : objectArray) {
                this.println("-> " + object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpByName() throws Exception {
            CVlanProfileModels cVlanProfileModels = CVlanProfileModels.this;
            synchronized (cVlanProfileModels) {
                Collection collection = CVlanProfileModels.this.getSVlanProfileModelNames();
                CVlanProfileModels.this.db.println("cvlan profile models by name currently loaded: " + CVlanProfileModels.this.modelsByName.size());
                for (String string : collection) {
                    CVlanProfileModels.this.db.println("  " + string + "->" + CVlanProfileModels.this.modelsByName.get(string));
                }
            }
        }

        public final void unpopulate() throws Exception {
            CVlanProfileModels.this.unpopulate();
        }

        public final void remove(int n) {
            CVlanProfileModels.this.remove(n);
        }

        public final void lowDelete(int n) throws xProvisionError {
            CVlanProfileModels.this.ref.removeProfileByID((short)n);
        }

        public final void getProfileMappings(int n) throws CTCUserException {
            EntityTableModel entityTableModel = CVlanProfileModels.this.nmd.getEntityTableModel();
            List list = entityTableModel.getModuleEntities();
            for (Object e : list) {
                IModuleModel iModuleModel;
                if (!(e instanceof IModuleModel) || n != (iModuleModel = (IModuleModel)e).getParent().getPositionInParent()) continue;
                this.println("profile mappings for card: " + iModuleModel);
                Map<Integer, Map<Short, ISVlanProfileModel>> map = CVlanProfileModels.this.getProfileMappings(iModuleModel);
                TreeSet<Integer> treeSet = new TreeSet<Integer>(map.keySet());
                for (Integer n2 : treeSet) {
                    this.println("  port: " + n2);
                    Map<Short, ISVlanProfileModel> map2 = map.get(n2);
                    TreeSet<Short> treeSet2 = new TreeSet<Short>(map2.keySet());
                    for (Short s : treeSet2) {
                        this.println("    cvlan: " + s + ", profile: " + map2.get(s));
                    }
                }
                return;
            }
        }
    }
}

