/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.EntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PassiveUnitPolicy;
import cerent.util.TDMTerminology;
import java.util.HashMap;
import java.util.Map;

public class ChassisPolicy {
    private ChassisPolicy() {
    }

    public static short getMaxRUs(ChassisModels chassisModels) {
        INodeModel iNodeModel = chassisModels.getNodeModel();
        boolean bl = ((NodeModelDelegate)iNodeModel).isSdh();
        return (short)(bl ? 40 : 44);
    }

    public static short getChassisHeight(eEqType eEqType2) {
        if (eEqType2 == eEqType.CHASSIS_454) {
            return 11;
        }
        if (eEqType2 == eEqType.CHASSIS_454SDH) {
            return 13;
        }
        if (eEqType2 == eEqType.CHASSIS_M6_ANSI || eEqType2 == eEqType.CHASSIS_M6_ETSI) {
            return 6;
        }
        if (eEqType2 == eEqType.CHASSIS_M2_ANSI || eEqType2 == eEqType.CHASSIS_M2_ETSI) {
            return 2;
        }
        return 0;
    }

    public static Map<String, Object> getMapOfValidChassis(ChassisModels chassisModels, short s) {
        INodeModel iNodeModel = chassisModels.getNodeModel();
        TDMTerminology tDMTerminology = iNodeModel.getTDMTerminology();
        boolean bl = ((NodeModelDelegate)iNodeModel).isSdh();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (bl) {
            ChassisPolicy.checkNadd(tDMTerminology, eEqType.CHASSIS_454SDH, s, hashMap);
            ChassisPolicy.checkNadd(tDMTerminology, eEqType.CHASSIS_M6_ETSI, s, hashMap);
        } else {
            ChassisPolicy.checkNadd(tDMTerminology, eEqType.CHASSIS_454, s, hashMap);
            ChassisPolicy.checkNadd(tDMTerminology, eEqType.CHASSIS_M6_ANSI, s, hashMap);
        }
        Map<String, Object> map = PassiveUnitPolicy.getMapOfValidUnits(iNodeModel, s);
        if (map != null && map.size() > 0) {
            String string = EntityModel.eqType2Name(tDMTerminology, eEqType.PASSIVE_CHASSIS);
            hashMap.put(string, map);
        }
        return hashMap;
    }

    private static void checkNadd(TDMTerminology tDMTerminology, eEqType eEqType2, short s, Map<String, Object> map) {
        if (ChassisPolicy.getChassisHeight(eEqType2) <= s) {
            String string = EntityModel.eqType2Name(tDMTerminology, eEqType2);
            map.put(string, eEqType2);
        }
    }
}

