/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.ModelUpdateType;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public abstract class Connections
extends CmsObservable {
    private static final SDebug db = new SDebug("Connections");
    protected HashMap connectionModels = new HashMap();

    protected IConnectionModel findConnectionModel(Collection collection, sCircuitId sCircuitId2) {
        for (ConnectionModel connectionModel : collection) {
            if (sCircuitId2.uniquePart.uniqueId != connectionModel.getCircuitId().getUniquePart().getUniqueId() || sCircuitId2.nodeId != connectionModel.getCircuitId().getNodeId()) continue;
            return connectionModel;
        }
        return null;
    }

    public static Collection getAddedObjects(Collection collection, Collection collection2) {
        HashSet hashSet = new HashSet(collection);
        HashSet hashSet2 = new HashSet(collection2);
        hashSet.removeAll(hashSet2);
        return hashSet;
    }

    public static Collection getDeletedObjects(Collection collection, Collection collection2) {
        HashSet hashSet = new HashSet(collection);
        HashSet hashSet2 = new HashSet(collection2);
        hashSet2.removeAll(hashSet);
        return hashSet2;
    }

    public synchronized void remove(int n) {
        this.connectionModels.remove(new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionModel get(int n) {
        boolean bl = false;
        ConnectionModel connectionModel = null;
        Connections connections = this;
        synchronized (connections) {
            connectionModel = (ConnectionModel)this.connectionModels.get(new Integer(n));
            if (connectionModel == null) {
                if (db.on()) {
                    db.println("Unable to find ConnectionModel " + n + " in local cache of " + (Object)((Object)this));
                }
                if (db.on()) {
                    db.println("Forcing an updateStructure");
                }
                bl = this.updateStructure();
                connectionModel = (ConnectionModel)this.connectionModels.get(new Integer(n));
                if (db.on()) {
                    if (connectionModel == null) {
                        db.println("Sorry! Still cannot find ConnectionModel");
                    } else {
                        db.println("Success! Found ConnectionModel on the node");
                    }
                }
            }
        }
        if (bl) {
            if (Connections.db.on) {
                db.println("Going to notify about update");
            }
            this.notifyObservers(ModelUpdateType.ADDED);
        }
        return connectionModel;
    }

    protected abstract boolean updateStructure();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ArrayList arrayList;
        Connections connections = this;
        synchronized (connections) {
            arrayList = new ArrayList(this.connectionModels.values());
            this.connectionModels.clear();
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                ((ConnectionModel)iterator.next()).destroy();
            }
            catch (Exception exception) {
                db.println("Exception caught while deleting circuit " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected Collection toCollection(int[] nArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (nArray == null) {
            return arrayList;
        }
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(new Integer(nArray[i]));
        }
        return arrayList;
    }

    protected void printConnectionString(SDebug sDebug) {
        sDebug.println("Connections in " + ((Object)((Object)this)).getClass().getName());
        if (this.connectionModels == null || this.connectionModels.size() == 0) {
            sDebug.println("No Connection Models ..");
            return;
        }
        Iterator iterator = this.connectionModels.values().iterator();
        while (iterator.hasNext()) {
            try {
                ConnectionModel connectionModel = (ConnectionModel)iterator.next();
                sDebug.println("=============================\n");
                sDebug.println("Connection Class is " + connectionModel.getClass().getName());
                connectionModel.printString(sDebug);
            }
            catch (Exception exception) {
                sDebug.println("Got Exception " + exception);
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap cloneConnectionModels() {
        HashMap hashMap = this.connectionModels;
        synchronized (hashMap) {
            return (HashMap)this.connectionModels.clone();
        }
    }
}

